/*****************************************************************************
 * 08/10/97 MVE  Modified for ExeLoader object
 *
 *$Log:	frontend.c,v $
 * Revision 2.12  94/02/22  15:16:17  cifuente
 * Code generation is done.
 * ,.
 * 
 * Revision 2.11  93/12/08  16:58:34  cifuente
 * FrontEnd is a void function now.
 * 
 * Revision 2.10  93/11/18  11:39:32  emmerik
 * Extra parameter to interactDis()
 * 
 * Revision 2.9  93/11/17  16:28:38  cifuente
 * Call graph references
 * 
 * Revision 2.8  93/10/20  14:39:09  cifuente
 * New level of indirection for icode array (Icode.icode[])
 * 
 * Revision 2.7  93/10/11  11:37:33  cifuente
 * First walk of HIGH_LEVEL icodes.
 * 
 * Revision 2.6  93/10/01  08:59:28  cifuente
 * boolT type - for compilation under unix SVR4.2
 * 
 * Revision 2.5  93/09/29  10:46:38  cifuente
 * LOW_LEVEL and HIGH_LEVEL icode definitions.  Increases llIcode indirection
 * by 2 levels.
 * 
 * Revision 2.3  93/08/23  12:15:26  cifuente
 * Interactive mode with curses
 * 
 * Revision 2.1  93/03/30  14:51:09  cifuente
 * Compiled with gcc.
 * 
 *			RevComp project Front End module
 * Loads a program into simulated main memory and builds the procedure list.
 ****************************************************************************/

#include "dcc.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __BORLAND__
#include <alloc.h>
#else
#include <malloc.h>			/* For malloc, free, realloc */
#endif
#include "ExeLoader.h"		// Loader object


static void LoadImage(char *filename);
static void displayLoadInfo(void);
static void displayMemMap(void);


static ExeLoader L;			// An instance of class ExeLoader


/*****************************************************************************
 * FrontEnd - invokes the loader, parser, disassembler (if asm1), icode
 * rewritter, and displays any useful information.
 ****************************************************************************/
void FrontEnd (char *filename, PCALL_GRAPH *pcallGraph)
{
	PPROC pProc;
	PSYM psym;
	Int	i, c;
	
	/* Load program into memory */
	LoadImage(filename);

	if (option.verbose)
	{
		displayLoadInfo();
	}
	
	/* Do depth first flow analysis building call graph and procedure list,
	 * and attaching the I-code to each procedure          */
	parse (pcallGraph);

	if (option.asm1)
	{
		printf("dcc: writing assembler file %s\n", asm1_name);
	}

	/* Search through code looking for impure references and flag them */
	for (pProc = pProcList; pProc; pProc = pProc->next)
	{
		for (i = 0; i < pProc->Icode.GetNumIcodes(); i++)
		{
			if (pProc->Icode.GetLlFlag(i) & (SYM_USE | SYM_DEF))
			{
				psym = &symtab.sym[pProc->Icode.GetIcode(i)->ic.ll.caseTbl.numEntries];
				for (c = (Int)psym->label; c < (Int)psym->label+psym->size; c++)
				{
					if (BITMAP(c, BM_CODE))
					{
						pProc->Icode.SetLlFlag(i, IMPURE);
						pProc->flg |= IMPURE;
						break;
					}
				}
			}
		}
		/* Print assembler listing */
		if (option.asm1)
			disassem(1, pProc);
	}

	if (option.Interact)
	{
		interactDis(pProcList, 0);			/* Interactive disassembler */
	}

	/* Converts jump target addresses to icode offsets */
	for (pProc = pProcList; pProc; pProc = pProc->next)
		bindIcodeOff (pProc); 

	/* Print memory bitmap */
	if (option.Map)
		displayMemMap();
}


/****************************************************************************
 * displayLoadInfo - Displays low level loader type info.
 ***************************************************************************/
static void displayLoadInfo()
{
	Int	i;
	PSECTIONINFO pHdrScn = L.GetSectionInfoByName("$HEADER");
	HEADER* pHeader = (HEADER*) pHdrScn->uHostAddr;

	printf("File type is %s\n", (prog.fCOM)?"COM":"EXE");
	if (! prog.fCOM) {
	    printf("Signature            = %02X%02X\n", pHeader->sigLo, pHeader->sigHi);
	    printf("File size %% 512      = %04X\n", LH(&pHeader->lastPageSize));
	    printf("File size / 512      = %04X pages\n", LH(&pHeader->numPages));
	    printf("# relocation items   = %04X\n", LH(&pHeader->numReloc));
	    printf("Offset to load image = %04X paras\n", LH(&pHeader->numParaHeader));
		printf("Minimum allocation   = %04X paras\n", LH(&pHeader->minAlloc));
		printf("Maximum allocation   = %04X paras\n", LH(&pHeader->maxAlloc));
	}
	printf("Load image size      = %04X\n", prog.cbImage - sizeof(PSP));
	printf("Initial SS:SP        = %04X:%04X\n", prog.initSS, prog.initSP);
	printf("Initial CS:IP        = %04X:%04X\n", prog.initCS, prog.initIP);

	if (option.VeryVerbose && prog.cReloc)
	{
		printf("\nRelocation Table\n");
		for (i = 0; i < prog.cReloc; i++)
		{
			printf("%06X -> [%04X]\n", prog.relocTable[i],
					LH(prog.Image + prog.relocTable[i]));
		}
	}
	printf("\n");
}


/*****************************************************************************
 * fill - Fills line for displayMemMap()
 ****************************************************************************/
static void fill(Int ip, char *bf)
{
	static byte type[4] = {'.', 'd', 'c', 'x'};
	byte	i;

	for (i = 0; i < 16; i++, ip++)
	{
		*bf++ = ' ';
		*bf++ = (ip < prog.cbImage)? 
			type[(prog.map[ip >> 2] >> ((ip & 3) * 2)) & 3]: ' ';
	}
	*bf = '\0';
}


/*****************************************************************************
 * displayMemMap - Displays the memory bitmap
 ****************************************************************************/
static void displayMemMap(void)
{
	char	c, b1[33], b2[33], b3[33];
	byte i;
	Int ip = 0;

	printf("\nMemory Map\n");
	while (ip < prog.cbImage)
	{
		fill(ip, b1);
		printf("%06X %s\n", ip, b1);
		ip += 16;
		for (i = 3, c = b1[1]; i < 32 && c == b1[i]; i += 2)
			;		/* Check if all same */
		if (i > 32)
		{
			fill(ip, b2);	/* Skip until next two are not same */
			fill(ip+16, b3);
			if (! (strcmp(b1, b2) || strcmp(b1, b3)))
			{
				printf("                   :\n");
				do
				{
					ip += 16;
					fill(ip+16, b1);
				} while (! strcmp(b1, b2));
			}
		}
	}
	printf("\n");
}


/*****************************************************************************
 * LoadImage
 ****************************************************************************/
static void LoadImage(char *filename)
{

	/* Open the input file */
	if (L.Load(filename) == 0)
	{
		fatalError(CANNOT_OPEN, filename);
	}

	PSECTIONINFO pSectHdr   = L.GetSectionInfoByName("$HEADER");
	PSECTIONINFO pSectImage = L.GetSectionInfoByName(".text");
	PSECTIONINFO pSectReloc = L.GetSectionInfoByName("$RELOC");
	prog.Image = (byte*) pSectImage->uHostAddr;
	prog.cbImage  = pSectImage->uSectionSize;

	char* pHeader = (char*)pSectHdr->uHostAddr;
	if (prog.fCOM = (boolT)((pHeader[0] == 'M') && (pHeader[1] == 'Z')))
	{
		unsigned initPC = L.GetInitPC();
		unsigned initSP = L.GetInitSP();
		prog.initCS = initPC >> 16;
		prog.initIP = initPC & 0xFFFF;
		prog.initSS = initSP >> 16;
		prog.initSP = initSP & 0xFFFF;

		// Relocation table
		prog.cReloc = pSectReloc->uSectionSize / sizeof(dword);

		/* Allocate the relocation table */
		if (prog.cReloc)
		{
			prog.relocTable = (dword*) pSectReloc->uHostAddr;
		}
	}
	else
	{	/* COM file

		/* COM programs start off with an ORG 100H (to leave room for a PSP)
		 * This is also the implied start address so if we load the image
		 * at offset 100H addresses should all line up properly again.
		*/
		prog.initCS = 0;
		prog.initIP = 0x100;
		prog.initSS = 0;
		prog.initSP = 0xFFFE;
		prog.cReloc = 0;

	}

	/* Set up memory map */
	int cb = (prog.cbImage + 3) / 4;
	prog.map = (byte *)memset(allocMem(cb), BM_UNKNOWN, (size_t)cb);

	/* Note that relocation of the segment constants is done in the
		ExeLoader object */

	// Don't UnLoad here, since prog.Image (etc) point to the loaded
	// image in the ExeLoader object.	
}

void UnLoadImage()
{
	L.UnLoad();
}



/*****************************************************************************
 * allocMem - malloc with failure test
 ****************************************************************************/
void *allocMem(Int cb)
{
	byte *p;

//printf("Attempt to allocMem %5ld bytes\n", cb);

#if 0		/* Microsoft specific heap debugging code */
switch (_heapset('Z'))
{
	case _HEAPBADBEGIN: printf("aM: Bad heap begin\n"); break;
	case _HEAPBADNODE:	printf("aM: Bad heap node\n");
	printf("Attempt to allocMem %5d bytes\n", cb);
	{
		_HEAPINFO hinfo;
		int heapstatus;
		boolT cont = TRUE;

		hinfo._pentry = NULL;

		while (cont)
		{
			switch (heapstatus = _heapwalk(&hinfo))
			{
				case _HEAPOK:
					printf("%6s block at %Fp of size %4.4X\n",
						(hinfo._useflag == _USEDENTRY ? "USED" : "FREE"),
						hinfo._pentry, hinfo._size);
					break;
				case _HEAPBADBEGIN:
					printf("Heap bad begin\n");
					break;
				case _HEAPBADNODE:
					printf("BAD NODE %6s block at %Fp of size %4.4X\n",
						(hinfo._useflag == _USEDENTRY ? "USED" : "FREE"),
						hinfo._pentry, hinfo._size);
					break;
				case _HEAPEND:
					cont = FALSE;
					break;
				case _HEAPBADPTR:
					printf("INFO BAD %6s block at %Fp of size %4.4X\n",
						(hinfo._useflag == _USEDENTRY ? "USED" : "FREE"),
						hinfo._pentry, hinfo._size);
					cont=FALSE;

			}
		}
	}
	getchar();
	exit(1);

	case _HEAPEMPTY:	printf("aM: Heap empty\n");		getchar(); break;
	case _HEAPOK:putchar('.');break;
}
#endif

	if (! (p = (byte*)malloc((size_t)cb)))
/*	if (! (p = (byte*)calloc((size_t)cb, 1)))	*/
	{
		fatalError(MALLOC_FAILED, cb);
	}
/*printf("allocMem: %p\n", p);/**/
	return p;
}


/*****************************************************************************
 * reallocVar - reallocs extra variable space
 ****************************************************************************/
void *reallocVar(void *p, Int newsize)
{
/*printf("Attempt to reallocVar %5d bytes\n", newsize);/**/
#if 0
switch (_heapset('Z'))
{
	case _HEAPBADBEGIN: printf("aV: Bad heap begin\n"); /*getchar()*/; break;
	case _HEAPBADNODE:	printf("aV: Bad heap node\n");
	printf("Attempt to reallocVar %5d bytes at %p\n", newsize, p);/**/
	{
		_HEAPINFO hinfo;
		int heapstatus;
		boolT cont = TRUE;

		hinfo._pentry = NULL;

		while (cont)
		{
			switch (heapstatus = _heapwalk(&hinfo))
			{
				case _HEAPOK:
					printf("%6s block at %Fp of size %4.4X\n",
						(hinfo._useflag == _USEDENTRY ? "USED" : "FREE"),
						hinfo._pentry, hinfo._size);
					break;
				case _HEAPBADBEGIN:
					printf("Heap bad begin\n");
					break;
				case _HEAPBADNODE:
					printf("BAD NODE %6s block at %Fp of size %4.4X\n",
						(hinfo._useflag == _USEDENTRY ? "USED" : "FREE"),
						hinfo._pentry, hinfo._size);
					break;
				case _HEAPEND:
					cont = FALSE;
					break;
				case _HEAPBADPTR:
					printf("INFO BAD %6s block at %Fp of size %4.4X\n",
						(hinfo._useflag == _USEDENTRY ? "USED" : "FREE"),
						hinfo._pentry, hinfo._size);
					cont=FALSE;

			}
		}
	}
	getchar();
	break;

	case _HEAPEMPTY:	printf("aV: Heap empty\n");		getchar(); break;
	case _HEAPOK:putchar('!');break;
}
#endif

	void* newp;
	if (! (newp = realloc((byte *)p, (size_t)newsize)))
	{
		fatalError(MALLOC_FAILED, newsize);
	}
	if (p && (newp != p) && option.verbose)
	{
		printf("Warning! realloc of %d bytes moved from %p to %p\n",
			newsize, p, newp);
	}

/*printf("reallocVar: %p\n", newp);/**/
	return newp;
}

#if 0
void free(void *p)
{
	_ffree(p);
switch (_heapset('Z'))
{
	case _HEAPBADBEGIN: printf("f: Bad heap begin\n"); getchar(); break;
	case _HEAPBADNODE:	printf("f: Bad heap node\n");  getchar(); break;
	case _HEAPEMPTY:	printf("f: Heap empty\n");		getchar(); break;
	case _HEAPOK:putchar('!');break;
}/**/
}
#endif

