/* This file implements the abstract Loader class.
	All classes derived from this class must implement the Load()
	function.

	MVE 30/9/97
*/

#include "Loader.h"

Loader::Loader()
{
	m_iNumSections = 0;			// No sections yet
	m_pSections = 0;			// No section data yet
	m_iNumSymbols = 0;			// No symbols
	m_pSymbols = 0;				// No symbol table
}

int Loader::GetNumSections() const
{
	return m_iNumSections;
}

PSECTIONINFO Loader::GetSectionInfo() const
{
	return m_pSections;
}

int Loader::GetNumSyms() const
{
	return m_iNumSymbols;
}

PLD_SYMTAB Loader::GetSymTable() const
{
	return m_pSymbols;
}

int	Loader::GetSectionIndexByName(const char* sName)
{
	for (int i=0; i < m_iNumSections; i++)
	{
		if (strcmp(m_pSections[i].pSectionName, sName) == 0)
		{
			return i;
		}
	}
	return -1;
}

PSECTIONINFO Loader::GetSectionInfoByName(const char* sName)
{
	int i = GetSectionIndexByName(sName);
	if (i == -1) return 0;
	return &m_pSections[i];
}

unsigned Loader::GetInitPC() const
{
	return m_uInitPC;
}

unsigned Loader::GetInitSP() const
{
	return m_uInitSP;
}


