/* This file contains the definition of the ExeLoader class, and some other
	definitions specific to the exe version of the Loader object */

#include "Loader.h"		/* Abstract base class definitions */
#include <stdio.h>		/* printf, etc */
#include <assert.h>		/* assert() */
#include <fcntl.h>		/* O_RDONLY */
#ifdef __UNIX__
#include <unistd.h>		/* lseek(), read() */
#include <sys/types.h>	/* lseek(), read() */
#else
#include <io.h>
#endif
#include <stdlib.h>		/* malloc(), free() */
#include <errno.h>		/* error numbers */

#define EXE_RELOCATION 0x10	// Exe relocated by 0x10 paragraphs
#ifdef __MSDOS
#define dword unsigned long
#else
#define dword unsigned int
#endif
#define word unsigned short
#define byte unsigned char
#define int16 short int
#ifndef LH					// Might be defined in dcc.h already
#define LH(p)  ((int)((byte *)(p))[0] + ((int)((byte *)(p))[1] << 8))
#endif

typedef struct {			/*        PSP structure					*/
	word int20h;			/* interrupt 20h						*/
	word eof;				/* segment, end of allocation block		*/
	byte res1;				/* reserved                         	*/
	byte dosDisp[5];		/* far call to DOS function dispatcher	*/
	byte int22h[4];			/* vector for terminate routine			*/
	byte int23h[4];			/* vector for ctrl+break routine		*/
	byte int24h[4];			/* vector for error routine				*/
	byte res2[22];			/* reserved								*/
	word segEnv;			/* segment address of environment block	*/
	byte res3[34];			/* reserved								*/
	byte int21h[6];			/* opcode for int21h and far return		*/
	byte res4[6];			/* reserved								*/
	byte fcb1[16];			/* default file control block 1			*/
	byte fcb2[16];      	/* default file control block 2			*/
	byte res5[4];			/* reserved								*/
	byte cmdTail[0x80];		/* command tail and disk transfer area	*/
} PSP;

typedef struct {			/*      EXE file header		 	 */
	 byte	sigLo;			/* .EXE signature: 0x4D 0x5A	 */
	 byte	sigHi;
	 word	lastPageSize;	/* Size of the last page		 */
	 word	numPages;		/* Number of pages in the file	 */
	 word	numReloc;		/* Number of relocation items	 */
	 word	numParaHeader;	/* # of paragraphs in the header */
	 word	minAlloc;		/* Minimum number of paragraphs	 */
	 word	maxAlloc;		/* Maximum number of paragraphs	 */
	 word	initSS;			/* Segment displacement of stack */
	 word	initSP;			/* Contents of SP at entry       */
	 word	checkSum;		/* Complemented checksum         */
	 word	initIP;			/* Contents of IP at entry       */
	 word	initCS;			/* Segment displacement of code  */
	 word	relocTabOffset;	/* Relocation table offset       */
	 word	overlayNum;		/* Overlay number                */
} HEADER;

class ExeLoader : public Loader
{
public:
				ExeLoader();					// Default constructor
  virtual int	Load(const char* sName);		// Load the file; pure virtual
  virtual int	GetNextPart();					// Load next part of archive
  virtual void	UnLoad();						// Unload the image

private:

	HEADER*	m_pHeader;					// Pointer to header
	byte*	m_pImage;					// Pointer to image
	int		m_cbImage;					// Size of image
	int		m_cReloc;					// Number of relocation entries
	dword*	m_pRelocTable;				// The relocation table
};
