#pragma title("Do_MCI $Revision$")
#pragma subtitle("$Date$")
/* $Header$ */
/******************************************************************************
*   $CONFIG$="/T8 /L*"
*++
*   $NAME$
*	     Do_MCI.C
*
*   $PATHS$
*	     Modules
*   $/F3$
*
*   PRODUCT:	MIDI
*   COMPONENT:	Do_MCI
*   FILE NAME:	$Workfile$
*   CREATED:	28-Nov-1993 - 12:13:48
*
*   IDENT:	$Revision$ $Modtime$
*
*	$Author$
*	John J. McDonough
*
*   $1$
*   PROGRAM DESCRIPTION:
*
*	This little program reads a script containing MCI commands and
*	passes them on to the MCI API.	This allows any combination of
*	WAV's, MIDI's, AVI's, etc. to be scripted.  For some reason, this
*	turns out to be substantially faster than the same thing in REXX.
*
*   $/F4$
*   MODIFICATION HISTORY:
*	$Log$
*
*   ROUTINES CALLED:
*
*	       Local			    System
*
*					    feof
*					    fgets
*					    fopen
*					    fprintf
*					    mciGetErrorString
*					    mciSendString
*					    memset
*					    perror
*					    printf
*					    strcpy
*					    strnicmp
*
*   FILE:
*
*	Script file specified in commmand.
*
*   EFFECTS:
*
*   RESTRICTIONS:
*
*   $END$
*	
******************************************************************************/

/*
*
*  INCLUDE FILES
*
*/
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <process.h>

/* MCI API entries */

ULONG APIENTRY mciSendString (
	    PSZ 			/* pszCommand */,
	    PSZ 			/* pszReturnString */,
	    USHORT			/* usReturnLength */,
	    HWND			/* hwndCallback */,
	    USHORT			/* usUserParm */);

ULONG APIENTRY mciGetErrorString (
	    ULONG			/* ulError */,
	    PSZ 			/* pszBuffer */,
	    USHORT			/* usLength */);

ULONG APIENTRY mciGetDeviceID (
	    PSZ 			/* pszName */);


void main( int argc, char *argv[] )
{
    int i;
    ULONG ulReturn;
    char szReturnString[80];
    char szErrorString[80];
    char szBuffer[80];
    char szFileName[80];
    FILE *F;

    /* Check that a file name was entered on command line */
    if ( argc != 2 )
        {
	fprintf(stderr,"Usage Do_MCI <filename>\n\n");
        exit(2);
	}

    /* Go ahead and open the file */
    strcpy(szFileName,argv[1]);
    F = fopen(szFileName,"ra");
    if ( !F )
        {
        perror("opening file");
        exit(8);
        }

    /* Read through the entire script */
    while ( !feof(F) )
        {
        fgets(szBuffer,80,F);
        if ( !feof(F) )
            {
            if ( szBuffer[strlen(szBuffer)-1] < ' ' )
                szBuffer[strlen(szBuffer)-1] = '\0';
	    printf("\033[0;36m%s\n",szBuffer);
	    /* If it's not an exit, assume it's an MCI string */
            if ( strnicmp(szBuffer,"exit",4) )
                {
                memset(szReturnString,0,sizeof(szReturnString));
                ulReturn = mciSendString(   szBuffer,
                                            szReturnString,
                                            79,
                                            0,
					    0);
		/* Possible Problem? (some strings will return data) */
                if ( ulReturn )
                    {
                    mciGetErrorString(ulReturn,szErrorString,79);
                    printf("\t\033[37;41;1m%% %s\033[0;36m\n",szErrorString);
                    }
		if ( szReturnString[0] )
                    printf("\t\033[0;33;1m+ %s\033[0;36m\n",szReturnString);
                }
	    }
	/* If we're all done, we're all done */
        if ( !strnicmp(szBuffer,"exit",4) )
            break;
	}

    printf("\n");
}
