                     line.

     MAKETARGETS     Contains the name(s) of the target(s), if
                     any, that were specified on the command
                     line.

     MAXPROCESSLIMIT Is a numeric string representing the maximum
                     number of processes that dmake can use when
                     making targets using parallel mode.

     NULL            Is permanently defined to be the NULL
                     string.  This is useful when comparing a
                     conditional expression to an NULL value.

     PWD             Is the full path to the current directory in
                     which make is executing.

     TMPFILE         Is set to the name of the most recent tem-
                     porary file opened by dmake.  Temporary
                     files are used for text diversions and for
                     group recipe processing.

     TMD             Stands for "To Make Dir", and is the path
                     from the present directory (value of $(PWD))
                     to the directory that dmake was started up
                     in (value of $(MAKEDIR)).  This macro is
                     modified when .SETDIR attributes are pro-
                     cessed.

     USESHELL        The value of this macro is set to "yes" if
                     the current recipe is forced to use a shell
                     for its execution via the .USESHELL or '+'
                     directives, its value is "no" otherwise.


     The second group of string valued macros control dmake
     behavior and may be set by the user.

     .DIRCACHE       If set to "yes" enables the directory cache
                     (this is the default).  If set to "no" dis-
                     ables the directory cache (equivalent to -d
                     commandline flag).

     .NAMEMAX        Defines the maximum length of a filename
                     component.  The value of the variable is
                     initialized at startup to the value of the
                     compiled macro NAME_MAX.  On some systems
                     the value of NAME_MAX is too short by
                     default.  Setting a new value for .NAMEMAX
                     will override the compiled value.





Version 3.9 PL0                 UW                             29




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     .NOTABS         When set to non-NULL enables the use of
                     spaces as well as <tabs> to begin recipe
                     lines.  By default a non-group recipe is
                     terminated by a line without any leading
                     white-space or by a line not beggining with
                     a <tab> character.  Enabling this mode modi-
                     fies the first condition of the above termi-
                     nation rule to terminate a non-group recipe
                     with a line that contains only white-space.
                     This mode does not effect the parsing of
                     group recipes bracketed by [].

     AUGMAKE         If set to a non NULL value will enable the
                     transformation of special meta targets to
                     support special AUGMAKE inferences (See the
                     COMPATIBILITY section).

     DIRBRKSTR       Contains the string of chars used to ter-
                     minate the name of a directory in a path-
                     name.  Under UNIX its value is "/", under
                     MSDOS its value is "/\:".

     DIRSEPSTR       Contains the string that is used to separate
                     directory components when path names are
                     constructed.  It is defined with a default
                     value at startup.

     DIVFILE         Is defined in the startup file and gives the
                     name that should be returned for the diver-
                     sion file name when used in $(mktmp ...)
                     expansions, see the TEXT DIVERSION section
                     for details.

     DYNAMICNESTINGLEVEL
                     Specifies the maximum number of recursive
                     dynamic macro expansions.  Its initial value
                     is 100.

     .KEEP_STATE     Assigning this macro a value tells dmake the
                     name of the state file to use and turns on
                     the keeping of state information for any
                     targets that are brought up to date by the
                     make.

     GROUPFLAGS      This macro gives the set of flags to pass to
                     the shell when invoking it to execute a
                     group recipe.  The value of the macro is the
                     list of flags with a leading switch indica-
                     tor.  (ie. `-' under UNIX)

     GROUPSHELL      This macro defines the full path to the exe-
                     cutable image to be used as the shell when



Version 3.9 PL0                 UW                             30




DMAKE(p)             Unsupported Free Software            DMAKE(p)



                     processing group recipes.  This macro must
                     be defined if group recipes are used.  It is
                     assigned a default value in the startup
                     makefile.  Under UNIX this value is /bin/sh.

     GROUPSUFFIX     If defined, this macro gives the string to
                     use as a suffix when creating group recipe
                     files to be handed to the command inter-
                     preter.  For example, if it is defined as
                     .sh, then all temporary files created by
                     dmake will end in the suffix .sh.  Under
                     MSDOS if you are using command.com as your
                     GROUPSHELL, then this suffix must be set to
                     .bat in order for group recipes to function
                     correctly.  The setting of GROUPSUFFIX and
                     GROUPSHELL is done automatically for
                     command.com in the startup.mk files.

     MAKE            Is defined in the startup file by default.
                     The string $(MAKE) is recognized when using
                     the -n option for single line recipes.  Ini-
                     tially this macro is defined to have the
                     value "$(MAKECMD) $(MFLAGS)".

     MAKESTARTUP     This macro defines the full path to the ini-
                     tial startup makefile.  Use the -V command
                     line option to discover its initial value.

     MAXLINELENGTH   This macro defines the maximum size of a
                     single line of makefile input text.  The
                     size is specified as a number, the default
                     value is defined internally and is shown via
                     the -V option.  A buffer of this size plus 2
                     is allocated for reading makefile text.  The
                     buffer is freed before any targets are made,
                     thereby allowing files containing long input
                     lines to be processed without consuming
                     memory during the actual make.  This macro
                     can only be used to extend the line length
                     beyond it's default minimum value.

     MAXPROCESS      Specify the maximum number of child
                     processes to use when making targets.  The
                     default value of this macro is "1" and its
                     value cannot exceed the value of the macro
                     MAXPROCESSLIMIT.  Setting the value of MAX-
                     PROCESS on the command line or in the
                     makefile is equivalent to supplying a
                     corresponding value to the -P flag on the
                     command line.





Version 3.9 PL0                 UW                             31




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     PREP            This macro defines the number of iterations
                     to be expanded automatically when processing
                     % rule definitions of the form:

                     % : %.suff

                     See the sections on PERCENT(%) RULES for
                     details on how PREP is used.

     SHELL           This macro defines the full path to the exe-
                     cutable image to be used as the shell when
                     processing single line recipes.  This macro
                     must be defined if recipes requiring the
                     shell for execution are to be used.  It is
                     assigned a default value in the startup
                     makefile.  Under UNIX this value is /bin/sh.

     SHELLFLAGS      This macro gives the set of flags to pass to
                     the shell when invoking it to execute a sin-
                     gle line recipe.  The value of the macro is
                     the list of flags with a leading switch
                     indicator.  (ie. `-' under UNIX)

     SHELLMETAS      Each time dmake executes a single recipe
                     line (not a group recipe) the line is
                     searched for any occurrence of a character
                     defined in the value of SHELLMETAS.  If such
                     a character is found the recipe line is
                     defined to require a shell to ensure its
                     correct execution.  In such instances a
                     shell is used to invoke the recipe line.  If
                     no match is found the recipe line is exe-
                     cuted without the use of a shell.


     There is only one character valued macro defined by dmake:
     SWITCHAR contains the switch character used to introduce
     options on command lines.  For UNIX its value is `-', and
     for MSDOS its value may be `/' or `-'.  The macro is inter-
     nally defined and is not user setable.  The MSDOS version of
     dmake attempts to first extract SWITCHAR from an environment
     variable of the same name.  If that fails it then attempts
     to use the undocumented getswitchar system call, and returns
     the result of that.  Under MSDOS version 4.0 you must set
     the value of the environment macro SWITCHAR to '/' to obtain
     predictable behavior.

     All boolean macros currently understood by dmake correspond
     directly to the previously defined attributes.  These macros
     provide a second way to apply global attributes, and
     represent the preferred method of doing so.  They are used
     by assigning them a value.  If the value is not a NULL



Version 3.9 PL0                 UW                             32




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     string then the boolean condition is set to on.  If the
     value is a NULL string then the condition is set to off.
     There are five conditions defined and they correspond
     directly to the attributes of the same name.  Their meanings
     are defined in the ATTRIBUTES section above.  The macros
     are: .EPILOG, .IGNORE, .MKSARGS, .NOINFER, .PRECIOUS, .PRO-
     LOG, .SEQUENTIAL, .SILENT, .SWAP, and .USESHELL.  Assigning
     any of these a non NULL value will globally set the
     corresponding attribute to on.

RUN_TIME MACROS
     These macros are defined when dmake is making targets, and
     may take on different values for each target.  $@ is defined
     to be the full target name, $? is the list of all out of
     date prerequisites, $& is the list of all prerequisites, $>
     is the name of the library if the current target is a
     library member, and $< is the list of prerequisites speci-
     fied in the current rule.  If the current target had a
     recipe inferred then $< is the name of the inferred prere-
     quisite even if the target had a list of prerequisites sup-
     plied using an explicit rule that did not provide a recipe.
     In such situations $& gives the full list of prerequisites.

     $* is defined as $(@:db) when making targets with explicit
     recipes and is defined as the value of % when making targets
     whose recipe is the result of an inference.  In the first
     case $* is the target name with no suffix, and in the second
     case, is the value of the matched % pattern from the associ-
     ated %-rule.  $^ expands to the set of out of date prere-
     quisites taken from the current value of $<.  In addition to
     these, $$ expands to $, {{ expands to {, }} expands to },
     and the strings <+ and +> are recognized as respectively
     starting and terminating a text diversion when they appear
     literally together in the same input line.

     The difference between $? and $^ can best be illustrated by
     an example, consider:

          fred.out : joe amy hello
               rules for making fred

          fred.out : my.c your.h his.h her.h   # more prerequisites

     Assume joe, amy, and my.c are newer then fred.out.  When
     dmake executes the recipe for making fred.out the values of
     the following macros will be:

          $@ --> fred.out
          $* --> fred
          $? --> joe amy my.c  # note the difference between $? and $^
          $^ --> joe amy
          $< --> joe amy hello



Version 3.9 PL0                 UW                             33




DMAKE(p)             Unsupported Free Software            DMAKE(p)



          $& --> joe amy hello my.c your.h his.h her.h


FUNCTION MACROS
     dmake supports a full set of functional macros.  One of
     these, the $(mktmp ...) macro, is discussed in detail in the
     TEXT DIVERSION section and is not covered here.


          $(assign expression)
               Causes expression to be parsed as a macro assign-
               ment expression and results in the specified
               assignment being made.  An error is issued if the
               assignment is not syntatically correct.  expres-
               sion may contain white space.  This is in effect a
               dynamic macro assignment facility and may appear
               anywhere any other macro may appear.  The result
               of the expanding a dynamic macro assignment
               expression is the name of the macro that was
               assigned and $(NULL) if the expression is not a
               valid macro assignment expression.  Some examples
               are:

               $(assign foo := fred)
               $(assign $(indirect_macro_name) +:= $(morejunk))

          $(null,text true false)
               expands the value of text. If it is NULL then the
               macro returns the value of the expansion of true
               and the expansion of false otherwise.  The terms
               true, and false must be strings containing no
               white-space.

          $(!null,text true false)
               Behaves identically to the previous macro except
               that the true string is chosen if the expansion of
               text is not NULL.

          $(eq,text_a,text_b true false)
               expands text_a and text_b and compares their
               results.  If equal it returns the result of the
               expansion of the true term, otherwise it returns
               the expansion of the false term.

          $(!eq,text_a,text_b true false)
               Behaves identically to the previous macro except
               that the true string is chosen if the expansions
               of the two strings are not equal

          $(nil expression)
               Always returns the value of $(NULL) regardless of
               what expression is.  This function macro can be



Version 3.9 PL0                 UW                             34




DMAKE(p)             Unsupported Free Software            DMAKE(p)



               used to discard results of expanding macro expres-
               sions.

          $(shell command)
               Runs command as if it were part of a recipe and
               returns, separated by a single space, all the
               non-white space terms written to stdout by the
               command.  For example:

                    $(shell ls *.c)

               will return "a.c b.c c.c d.c" if the files exist
               in the current directory.  The recipe modification
               flags [+@%-] are honored if they appear as the
               first characters in the command.  For example:

                    $(shell +ls *.c)

               will run the command using the current shell.

          $(shell,expand command)
               Is an extension to the $(shell... function macro
               that expands the result of running command.

          $(sort list)
               Will take all white-space separated tokens in list
               and will return their sorted equivalent list.

          $(strip data)
               Will replace all strings of white-space in data by
               a single space.

          $(subst,pat,replacement data)
               Will search for pat in data and will replace any
               occurrence of pat with the replacement string.
               The expansion

               $(subst,.o,.c $(OBJECTS))

          is equivalent to:

               $(OBJECTS:s/.o/.c/)


CONDITIONAL MACROS
     dmake supports conditional macros.  These allow the defini-
     tion of target specific macro values.  You can now say the
     following:

          target ?= MacroName MacroOp Value

     This creates a definition for MacroName whose value is Value



Version 3.9 PL0                 UW                             35




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     only when target is being made.  You may use a conditional
     macro assignment anywhere that a regular macro assignment
     may appear, including as the value of a $(assign ...) macro.

     The new definition is associated with the most recent cell
     definition for target.  If no prior definition exists then
     one is created.  The implications of this are immediately
     evident in the following example:

          foo := hello

          all : cond;@echo "all done, foo=[$(foo)] bar=[$(bar)]"

          cond ?= bar := global decl

          cond .SETDIR=unix::;@echo $(foo) $(bar)
          cond ?= foo := hi

          cond .SETDIR=msdos::;@echo $(foo) $(bar)
               cond ?= foo := hihi

     The first conditional assignment creates a binding for 'bar'
     that is activated when 'cond' is made.  The bindings follow-
     ing the :: definitions are activated when their respective
     recipe rules are used.  Thus the first binding serves to
     provide a global value for 'bar' while any of the cond ::
     rules are processed, and the local bindings for 'foo' come
     into effect when their associated :: rule is processed.

     Conditionals for targets of .UPDATEALL are all activated
     before the target group is made.  Assignments are processed
     in order.  Note that the value of a conditional macro
     assignment is NOT AVAILABLE until the associated target is
     made, thus the construct

          mytarget ?= bar := hello
          mytarget ?= foo := $(bar)

     results in $(foo) expanding to "", if you want the result to
     be "hello" you must use:

          mytarget ?= bar := hello
          mytarget ?= foo  = $(bar)

     Once a target is made any associated conditional macros are
     deactivated and their values are no longer available.
     Activation occurrs after all inference, and .SETDIR direc-
     tives have been processed and after $@ is assigned, but
     before prerequisites are processed; thereby making the
     values of conditional macro definitions available during
     construction of prerequisites.




Version 3.9 PL0                 UW                             36




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     If a %-meta rule target has associated conditional macro
     assignments, and the rule is chosen by the inference algo-
     rithm then the conditional macro assignments are inferred
     together with the associated recipe.

DYNAMIC PREREQUISITES
     dmake looks for prerequisites whose names contain macro
     expansions during target processing.  Any such prerequisites
     are expanded and the result of the expansion is used as the
     prerequisite name.  As an example the line:

          fred : $$@.c

     causes the $$@ to be expanded when dmake is making fred, and
     it resolves to the target fred.  This enables dynamic prere-
     quisites to be generated.  The value of @ may be modified by
     any of the valid macro modifiers.  So you can say for exam-
     ple:

          fred.out : $$(@:b).c

     where the $$(@:b) expands to fred.  Note the use of $$
     instead of $ to indicate the dynamic expansion, this is due
     to the fact that the rule line is expanded when it is ini-
     tially parsed, and $$ then returns $ which later triggers
     the dynamic prerequisite expansion.  If you really want a $
     to be part of a prerequisite name you must use $$$$.
     Dynamic macro expansion is performed in all user defined
     rules, and the special targets .SOURCE*, and .INCLUDEDIRS.

     If dynamic macro expansion results in multiple white space
     separated tokens then these are inserted into the prere-
     quisite list inplace of the dynamic prerequisite.  If the
     new list contains additional dynamic prerequisites they will
     be expanded when they are processed.  The level of recursion
     in this expansion is controlled by the value of the variable
     DYNAMICNESTINGLEVEL and is set to 100 by default.

BINDING TARGETS
     This operation takes a target name and binds it to an exist-
     ing file, if possible.  dmake makes a distinction between
     the internal target name of a target and its associated
     external file name.  Thus it is possible for a target's
     internal name and its external file name to differ.  To per-
     form the binding, the following set of rules is used.
     Assume that we are trying to bind a target whose name is of
     the form X.suff, where .suff is the suffix and X is the stem
     portion (ie. that part which contains the directory and the
     basename).  dmake takes this target name and performs a
     series of search operations that try to find a suitably
     named file in the external file system.  The search opera-
     tion is user controlled via the settings of the various



Version 3.9 PL0                 UW                             37




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     .SOURCE targets.

          1.   If target has the .SYMBOL attribute set then look
               for it in the library.  If found, replace the tar-
               get name with the library member name and continue
               with step 2.  If the name is not found then
               return.

          2.   Extract the suffix portion (that following the
               `.') of the target name.  If the suffix is not
               null, look up the special target .SOURCE.<suff>
               (<suff> is the suffix). If the special target
               exists then search each directory given in the
               .SOURCE.<suff> prerequisite list for the target.
               If the target's suffix was null (ie. .suff was
               empty) then perform the above search but use the
               special target .SOURCE.NULL instead.  If at any
               point a match is found then terminate the search.
               If a directory in the prerequisite list is the
               special name `.NULL ' perform a search for the
               full target name without prepending any directory
               portion (ie. prepend the NULL directory).

          3.   The search in step 2. failed.  Repeat the same
               search but this time use the special target
               .SOURCE.  (a default target of '.SOURCE : .NULL'
               is defined by dmake at startup, and is user rede-
               finable)

          4.   The search in step 3. failed.  If the target has
               the library member attribute (.LIBMEMBER) set then
               try to find the target in the library which was
               passed along with the .LIBMEMBER attribute (see
               the MAKING LIBRARIES section).  The bound file
               name assigned to a target which is successfully
               located in a library is the same name that would
               be assigned had the search failed (see 5.).

          5.   The search failed.  Either the target was not
               found in any of the search directories or no
               applicable .SOURCE special targets exist.  If
               applicable .SOURCE special targets exist, but the
               target was not found, then dmake assigns the first
               name searched as the bound file name.  If no
               applicable .SOURCE special targets exist, then the
               full original target name becomes the bound file
               name.

     There is potential here for a lot of search operations.  The
     trick is to define .SOURCE.x special targets with short
     search lists and leave .SOURCE as short as possible.  The
     search algorithm has the following useful side effect.  When



Version 3.9 PL0                 UW                             38




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     a target having the .LIBMEMBER (library member) attribute is
     searched for, it is first searched for as an ordinary file.
     When a number of library members require updating it is
     desirable to compile all of them first and to update the
     library at the end in a single operation.  If one of the
     members does not compile and dmake stops, then the user may
     fix the error and make again.  dmake will not remake any of
     the targets whose object files have already been generated
     as long as none of their prerequisite files have been modi-
     fied as a result of the fix.

     When dmake constructs target pathnames './' substrings are
     removed and substrings of the form 'foo/..' are eliminated.
     This may result in somewhat unexpected values of the macro
     expansion $@, but is infact the corect result.

     When defining .SOURCE and .SOURCE.x targets the construct

          .SOURCE :
          .SOURCE : fred gery

     is equivalent to

          .SOURCE :- fred gery

     dmake correctly handles the UNIX Make variable VPATH.  By
     definition VPATH contains a list of ':' separated direc-
     tories to search when looking for a target.  dmake maps
     VPATH to the following special rule:

          .SOURCE :^ $(VPATH:s/:/ /)

     Which takes the value of VPATH and sets .SOURCE to the same
     set of directories as specified in VPATH.

PERCENT(%) RULES AND MAKING INFERENCES
     When dmake makes a target, the target's set of prerequisites
     (if any) must exist and the target must have a recipe which
     dmake can use to make it.  If the makefile does not specify
     an explicit recipe for the target then dmake uses special
     rules to try to infer a recipe which it can use to make the
     target.  Previous versions of Make perform this task by
     using rules that are defined by targets of the form
     .<suffix>.<suffix> and by using the .SUFFIXES list of suf-
     fixes.  The exact workings of this mechanism were sometimes
     difficult to understand and often limiting in their useful-
     ness.  Instead, dmake supports the concept of %-meta rules.
     The syntax and semantics of these rules differ from standard
     rule lines as follows:

          <%-target> [<attributes>] <ruleop> [<%-prerequisites>] [;<recipe>]




Version 3.9 PL0                 UW                             39




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     where %-target is a target containing exactly a single `%'
     sign, attributes is a list (possibly empty) of attributes,
     ruleop is the standard set of rule operators, %-prere-
     quisites , if present, is a list of prerequisites containing
     zero or more `%' signs, and recipe, if present, is the first
     line of the recipe.

     The %-target defines a pattern against which a target whose
     recipe is being inferred gets matched.  The pattern match
     goes as follows:  all chars are matched exactly from left to
     right up to but not including the % sign in the pattern, %
     then matches the longest string from the actual target name
     not ending in the suffix given after the % sign in the pat-
     tern.  Consider the following examples:

          %.c       matches fred.c but not joe.c.Z
          dir/%.c   matches dir/fred.c but not dd/fred.c
          fred/%    matches fred/joe.c but not f/joe.c
          %         matches anything

     In each case the part of the target name that matched the %
     sign is retained and is substituted for any % signs in the
     prerequisite list of the %-meta rule when the rule is
     selected during inference and dmake constructs the new
     dependency.  As an example the following %-meta rules
     describe the following:

          %.c : %.y ; recipe...

     describes how to make any file ending in .c if a correspond-
     ing file ending in .y can be found.

          foo%.o : fee%.k ; recipe...

     is used to describe how to make fooxxxx.o from feexxxx.k.

          %.a :; recipe...

     describes how to make a file whose suffix is .a without
     inferring any prerequisites.

          %.c : %.y yaccsrc/%.y ; recipe...

     is a short form for the construct:

          %.c : %.y ; recipe...
          %.c : yaccsrc/%.y ; recipe...

     ie. It is possible to specify the same recipe for two
     %-rules by giving more than one prerequisite in the prere-
     quisite list.  A more interesting example is:




Version 3.9 PL0                 UW                             40




DMAKE(p)             Unsupported Free Software            DMAKE(p)



          % : RCS/%,v ; co $<

     which describes how to take any target and check it out of
     the RCS directory if the corresponding file exists in the
     RCS directory.  The equivalent SCCS rule would be:

          % : s.% ; get $<


     The previous RCS example defines an infinite rule, because
     it says how to make anything from RCS/%,v, and anything also
     includes RCS/fred.c,v.  To limit the size of the graph that
     results from such rules dmake uses the macro variable PREP
     (stands for % repetition).  By default the value of this
     variable is 0, which says that no repetitions of a %-rule
     are to be generated.  If it is set to something greater than
     0, then that many repetitions of any infinite %-rule are
     allowed.  If in the above example PREP was set to 1, then
     dmake would generate the dependency graph:

          % --> RCS/%,v --> RCS/RCS/%,v,v

     Where each link is assigned the same recipe as the first
     link.  PREP should be used only in special cases, since it
     may result in a large increase in the number of possible
     prerequisites tested.  dmake further assumes that any target
     that has no suffix can be made from a prerequisite that has
     at least one suffix.

     dmake supports dynamic prerequisite generation for prere-
     quisites of %-meta rules.  This is best illustrated by an
     example.  The RCS rule shown above can infer how to check
     out a file from a corresponding RCS file only if the target
     is a simple file name with no directory information.  That
     is, the above rule can infer how to find RCS/fred.c,v from
     the target fred.c, but cannot infer how to find
     srcdir/RCS/fred.c,v from srcdir/fred.c because the above
     rule will cause dmake to look for RCS/srcdir/fred.c,v; which
     does not exist (assume that srcdir has its own RCS directory
     as is the common case).

     A more versatile formulation of the above RCS check out rule
     is the following:

          % :  $$(@:d)RCS/$$(@:f),v : co $@

     This rule uses the dynamic macro $@ to specify the prere-
     quisite to try to infer.  During inference of this rule the
     macro $@ is set to the value of the target of the %-meta
     rule and the appropriate prerequisite is generated by
     extracting the directory portion of the target name (if
     any), appending the string RCS/ to it, and appending the



Version 3.9 PL0                 UW                             41




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     target file name with a trailing ,v attached to the previous
     result.

     dmake can also infer indirect prerequisites.  An inferred
     target can have a list of prerequisites added that will not
     show up in the value of $< but will show up in the value of
     $? and $&.  Indirect prerequisites are specified in an
     inference rule by quoting the prerequisite with single
     quotes.  For example, if you had the explicit dependency:

          fred.o : fred.c ; rule to make fred.o
          fred.o : local.h

     then this can be inferred for fred.o from the following
     inference rule:

          %.o : %.c 'local.h' ; rule to make a .o from a .c

     You may infer indirect prerequisites that are a function of
     the value of '%' in the current rule.  The meta-rule:

          %.o : %.c '$(INC)/%.h' ; rule to make a .o from a .c

     infers an indirect prerequisite found in the INC directory
     whose name is the same as the expansion of $(INC), and the
     prerequisite name depends on the base name of the current
     target.  The set of indirect prerequisites is attached to
     the meta rule in which they are specified and are inferred
     only if the rule is used to infer a recipe for a target.
     They do not play an active role in driving the inference
     algorithm.  The construct:

          %.o : %.c %.f 'local.h'; recipe

     is equivalent to:

          %.o : %.c 'local.h' : recipe

     while:

          %.o :| %.c %.f 'local.h'; recipe

     is equivalent to:

          %.o : %.c 'local.h' : recipe
          %.o : %.f 'local.h' : recipe


     If any of the attributes .SETDIR, .EPILOG, .PROLOG, .SILENT,
     .USESHELL, .SWAP, .PRECIOUS, .LIBRARY, .NOSTATE and .IGNORE
     are given for a %-rule then when that rule is bound to a
     target as the result of an inference, the target's set of



Version 3.9 PL0                 UW                             42




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     attributes is augmented by the attributes from the above set
     that are specified in the bound %-rule.  Other attributes
     specified for %-meta rules are not inherited by the target.
     The .SETDIR attribute is treated in a special way.  If the
     target already had a .SETDIR attribute set then dmake
     changes to that directory prior to performing the inference.
     During inference any .SETDIR attributes for the inferred
     prerequisite are honored.  The directories must exist for a
     %-meta rule to be selected as a possible inference path.  If
     the directories do not exist no error message is issued,
     instead the corresponding path in the inference graph is
     rejected.

     dmake also supports the old format special target
     .<suffix>.<suffix> by identifying any rules of this form and
     mapping them to the appropriate %-rule.  So for example if
     an old makefile contains the construct:

          .c.o :; cc -c $< -o $@

     dmake maps this into the following %-rule:

          %.o : %.c; cc -c $< -o $@

     Furthermore, dmake understands several SYSV AUGMAKE special
     targets and maps them into corresponding %-meta rules.
     These transformation must be enabled by providing the -A
     flag on the command line or by setting the value of AUGMAKE
     to non-NULL.  The construct

          .suff :; recipe

     gets mapped into:

          % : %.suff; recipe

     and the construct

          .c~.o :; recipe

     gets mapped into:

          %.o : s.%.c ; recipe

     In general, a special target of the form .<str>~ is replaced
     by the %-rule construct s.%.<str>, thereby providing support
     for the syntax used by SYSV AUGMAKE for providing SCCS sup-
     port.  When enabled, these mappings allow processing of
     existing SYSV makefiles without modifications.

     dmake bases all of its inferences on the inference graph
     constructed from the %-rules defined in the makefile.  It



Version 3.9 PL0                 UW                             43




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     knows exactly which targets can be made from which prere-
     quisites by making queries on the inference graph.  For this
     reason .SUFFIXES is not needed and is completely ignored.

     For a %-meta rule to be inferred as the rule whose recipe
     will be used to make a target, the target's name must match
     the %-target pattern, and any inferred %-prerequisite must
     already exist or have an explicit recipe so that the prere-
     quisite can be made.  Without transitive closure on the
     inference graph the above rule describes precisely when an
     inference match terminates the search.  If transitive clo-
     sure is enabled (the usual case), and a prerequisite does
     not exist or cannot be made, then dmake invokes the infer-
     ence algorithm recursively on the prerequisite to see if
     there is some way the prerequisite can be manufactured.
     For, if the prerequisite can be made then the current target
     can also be made using the current %-meta rule.  This means
     that there is no longer a need to give a rule for making a
     .o from a .y if you have already given a rule for making a
     .o from a .c and a .c from a .y.  In such cases dmake can
     infer how to make the .o from the .y via the intermediary .c
     and will remove the .c when the .o is made.  Transitive clo-
     sure can be disabled by giving the -T switch on the command
     line.

     A word of caution.  dmake bases its transitive closure on
     the %-meta rule targets.  When it performs transitive clo-
     sure it infers how to make a target from a prerequisite by
     performing a pattern match as if the potential prerequisite
     were a new target.  The set of rules:

          %.o : %.c :; rule for making .o from .c
          %.c : %.y :; rule for making .c from .y
          % : RCS/%,v :; check out of RCS file

     will, by performing transitive closure, allow dmake to infer
     how to make a .o from a .y using a .c as an intermediate
     temporary file.  Additionally it will be able to infer how
     to make a .y from an RCS file, as long as that RCS file is
     in the RCS directory and has a name which ends in .y,v.  The
     transitivity computation is performed dynamically for each
     target that does not have a recipe.  This has potential to
     be costly if the %-meta rules are not carefully specified.
     The .NOINFER attribute is used to mark a %-meta node as
     being a final target during inference.  Any node with this
     attribute set will not be used for subsequent inferences.
     As an example the node RCS/%,v is marked as a final node
     since we know that if the RCS file does not exist there
     likely is no other way to make it.  Thus the standard
     startup makefile contains an entry similar to:
          .NOINFER : RCS/%,v
     Thereby indicating that the RCS file is the end of the



Version 3.9 PL0                 UW                             44




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     inference chain.  Whenever the inference algorithm deter-
     mines that a target can be made from more than one prere-
     quisite and the inference chains for the two methods are the
     same length the algorithm reports an ambiguity and prints
     the ambiguous inference chains.

     dmake tries to remove intermediate files resulting from
     transitive closure if the file is not marked as being PRE-
     CIOUS, or the -u flag was not given on the command line, and
     if the inferred intermediate did not previously exist.
     Intermediate targets that existed prior to being made are
     never removed.  This is in keeping with the philosophy that
     dmake should never remove things from the file system that
     it did not add.  If the special target .REMOVE is defined
     and has a recipe then dmake constructs a list of the inter-
     mediate files to be removed and makes them prerequisites of
     .REMOVE.  It then makes .REMOVE thereby removing the prere-
     quisites if the recipe of .REMOVE says to.  Typically
     .REMOVE is defined in the startup file as:

          .REMOVE :; $(RM) $<

MAKING TARGETS
     In order to update a target dmake must execute a recipe.
     When a recipe needs to be executed it is first expanded so
     that any macros in the recipe text are expanded, and it is
     then either executed directly or passed to a shell.  dmake
     supports two types of recipes.  The regular recipes and
     group recipes.

     When a regular recipe is invoked dmake executes each line of
     the recipe separately using a new copy of a shell if a shell
     is required.  Thus effects of commands do not generally per-
     sist across recipe lines (e.g. cd requests in a recipe line
     do not carry over to the next recipe line).  This is true
     even in environments such as MSDOS, where dmake internally
     sets the current working director to match the directory it
     was in before the command was executed.

     The decision on whether a shell is required to execute a
     command is based on the value of the macro SHELLMETAS or on
     the specification of '+' or .USESHELL for the current recipe
     or target respectively.  If any character in the value of
     SHELLMETAS is found in the expanded recipe text-line or the
     use of a shell is requested explicitly via '+' or .USESHELL
     then the command is executed using a shell, otherwise the
     command is executed directly.  The shell that is used for
     execution is given by the value of the macro SHELL.  The
     flags that are passed to the shell are given by the value of
     SHELLFLAGS.  Thus dmake constructs the command line:

          $(SHELL) $(SHELLFLAGS) $(expanded_recipe_command)



Version 3.9 PL0                 UW                             45




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     Normally dmake writes the command line that it is about to
     invoke to standard output.  If the .SILENT attribute is set
     for the target or for the recipe line (via @), then the
     recipe line is not echoed.

     Group recipe processing is similar to that of regular
     recipes, except that a shell is always invoked.  The shell
     that is invoked is given by the value of the macro GROUP-
     SHELL, and its flags are taken from the value of the macro
     GROUPFLAGS.  If a target has the .PROLOG attribute set then
     dmake prepends to the shell script the recipe associated
     with the special target .GROUPPROLOG, and if the attribute
     .EPILOG is set as well, then the recipe associated with the
     special target .GROUPEPILOG is appended to the script file.
     This facility can be used to always prepend a common header
     and common trailer to group recipes.  Group recipes are
     echoed to standard output just like standard recipes, but
     are enclosed by lines beginning with [ and ].

     The recipe flags [+,-,%,@] are recognized at the start of a
     recipe line even if they appear in a macro.  For example:

          SH = +
          all:
               $(SH)echo hi

     is completely equivalent to writing

          SH = +
          all:
               +echo hi


     The last step performed by dmake prior to running a recipe
     is to set the macro CMNDNAME to the name of the command to
     execute (determined by finding the first white-space ending
     token in the command line).  It then sets the macro CMNDARGS
     to be the remainder of the line.  dmake then expands the
     macro COMMAND which by default is set to

          COMMAND = $(CMNDNAME) $(CMNDARGS)

     The result of this final expansion is the command that will
     be executed.  The reason for this expansion is to allow for
     a different interface to the argument passing facilities
     (esp. under DOS) than that provided by dmake. You can for
     example define COMMAND to be

          COMMAND = $(CMNDNAME) @$(mktmp $(CMNDARGS))

     which dumps the arguments into a temporary file and runs the
     command



Version 3.9 PL0                 UW                             46




DMAKE(p)             Unsupported Free Software            DMAKE(p)



          $(CMNDNAME) @/tmp/ASAD23043

     which has a much shorter argument list.  It is now up to the
     command to use the supplied argument as the source for all
     other arguments.  As an optimization, if COMMAND is not
     defined dmake does not perform the above expansion.  On sys-
     tems, such as UNIX, that handle long command lines this pro-
     vides a slight saving in processing the makefiles.

MAKING LIBRARIES
     Libraries are easy to maintain using dmake.  A library is a
     file containing a collection of object files.  Thus to make
     a library you simply specify it as a target with the
     .LIBRARY attribute set and specify its list of prere-
     quisites.  The prerequisites should be the object members
     that are to go into the library.  When dmake makes the
     library target it uses the .LIBRARY attribute to pass to the
     prerequisites the .LIBMEMBER attribute and the name of the
     library.  This enables the file binding mechanism to look
     for the member in the library if an appropriate object file
     cannot be found. A small example best illustrates this.

          mylib.a .LIBRARY : mem1.o mem2.o mem3.o
               rules for making library...
               # remember to remove .o's when lib is made

          # equivalent to:  '%.o : %.c ; ...'
          .c.o :; rules for making .o from .c say

     dmake will use the .c.o rule for making the library members
     if appropriate .c files can be found using the search rules.
     NOTE:  this is not specific in any way to C programs, they
     are simply used as an example.

     dmake tries to handle the old library construct format in a
     sensible way.  The construct lib(member.o) is separated and
     the lib portion is declared as a library target.  The new
     target is defined with the .LIBRARY attribute set and the
     member.o portion of the construct is declared as a prere-
     quisite of the lib target.  If the construct lib(member.o)
     appears as a prerequisite of a target in the makefile, that
     target has the new name of the lib assigned as its prere-
     quisite.  Thus the following example:

          a.out : ml.a(a.o) ml.a(b.o); $(CC) -o $@  $<

          .c.o :; $(CC) -c $(CFLAGS) -o $@  $<
          %.a:
               ar rv $@ $?
               ranlib $@
               rm -rf $?




Version 3.9 PL0                 UW                             47




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     constructs the following dependency graph.

          a.out : ml.a; $(CC) -o $@  $<
          ml.a .LIBRARY : a.o b.o

          %.o : %.c ; $(CC) -c $(CFLAGS) -o $@  $<
          %.a :
               ar rv $@ $?
               ranlib $@
               rm -rf $?

     and making a.out then works as expected.

     The same thing happens for any target of the form
     lib((entry)).  These targets have an additional feature in
     that the entry target has the .SYMBOL attribute set automat-
     ically.

     NOTE:  If the notion of entry points is supported by the
     archive and by dmake (currently not the case) then dmake
     will search the archive for the entry point and return not
     only the modification time of the member which defines the
     entry but also the name of the member file.  This name will
     then replace entry and will be used for making the member
     file.  Once bound to an archive member the .SYMBOL attribute
     is removed from the target.  This feature is presently dis-
     abled as there is little standardization among archive for-
     mats, and we have yet to find a makefile utilizing this
     feature (possibly due to the fact that it is unimplemented
     in most versions of UNIX Make).

     Finally, when dmake looks for a library member it must first
     locate the library file.  It does so by first looking for
     the library relative to the current directory and if it is
     not found it then looks relative to the current value of
     $(TMD).  This allows commonly used libraries to be kept near
     the root of a source tree and to be easily found by dmake.

KEEP STATE
     dmake supports the keeping of state information for targets
     that it makes whenever the macro .KEEP_STATE is assigned a
     value.  The value of the macro should be the name of a state
     file that will contain the state information.  If state
     keeping is enabled then each target that does not poses the
     .NOSTATE attribute will have a record written into the state
     file indicating the target's name, the current directory,
     the command used to update the target, and which, if any, ::
     rule is being used.  When you make this target again if any
     of this information does not match the previous settings and
     the target is not out dated it will still be re-made.  The
     assumption is that one of the conditions above has changed
     and that we wish to remake the target.  For example, state



Version 3.9 PL0                 UW                             48




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     keeping is used in the maintenance of dmake to test compile
     different versions of the source using different compilers.
     Changing the compiler causes the compilation flags to be
     modified and hence all sources to be recompiled.

     The state file is an ascii file and is portable, however it
     is not in human readable form as the entries represent hash
     keys of the above information.

     The Sun Microsystem's Make construct

          .KEEP_STATE :

     is recognized and is mapped to .KEEP_STATE:=_state.mk.  The
     dmake version of state keeping does not include scanning C
     source files for dependencies like Sun Make.  This is
     specific to C programs and it was felt that it does not
     belong in make.  dmake instead provides the tool, cdepend,
     to scan C source files and to produce depedency information.
     Users are free to modify cdepend to produce other dependency
     files.  (NOTE: cdepend does not come with the distribution
     at this time, but will be available in a patch in the near
     future)

MULTI PROCESSING
     If the architecture supports it then dmake is capable of
     making a target's prerequisites in parallel.  dmake will
     make as much in parallel as it can and use a number of child
     processes up to the maximum specified by MAXPROCESS or by
     the value supplied to the -P command line flag.  A parallel
     make is enabled by setting the value of MAXPROCESS (either
     directly or via -P option) to a value which is > 1.  dmake
     guarantees that all dependencies as specified in the
     makefile are honored.  A target will not be made until all
     of its prerequisites have been made.  Note that when you
     specify -P 4 then four child processes are run concurrently
     but dmake actually displays the fifth command it will run
     immediately upon a child process becomming free.  This is an
     artifact of the method used to traverse the dependency graph
     and cannot be removed.  If a parallel make is being per-
     formed then the following restrictions on parallelism are
     enforced.

          1.   Individual recipe lines in a non-group recipe are
               performed sequentially in the order in which they
               are specified within the makefile and in parallel
               with the recipes of other targets.

          2.   If a target contains multiple recipe definitions
               (cf. :: rules) then these are performed sequen-
               tially in the order in which the :: rules are
               specified within the makefile and in parallel with



Version 3.9 PL0                 UW                             49




DMAKE(p)             Unsupported Free Software            DMAKE(p)



               the recipes of other targets.

          3.   If a target rule contains the `!' modifier, then
               the recipe is performed sequentially for the list
               of outdated prerequisites and in parallel with the
               recipes of other targets.

          4.   If a target has the .SEQUENTIAL attribute set then
               all of its prerequisites are made sequentially
               relative to one another (as if MAXPROCESS=1), but
               in parallel with other targets in the makefile.

     Note:  If you specify a parallel make then the order of tar-
     get update and the order in which the associated recipes are
     invoked will not correspond to that displayed by the -n
     flag.

CONDITIONALS
     dmake supports a makefile construct called a conditional.
     It allows the user to conditionally select portions of
     makefile text for input processing and to discard other por-
     tions.  This becomes useful for writing makefiles that are
     intended to function for more than one target host and
     environment.  The conditional expression is specified as
     follows:

          .IF  expression
             ... if text ...
          .ELIF  expression
             ... if text ...
          .ELSE
             ... else text ...
          .END

     The .ELSE and .ELIF portions are optional, and the condi-
     tionals may be nested (ie.  the text may contain another
     conditional).  .IF, .ELSE, and .END may appear anywhere in
     the makefile, but a single conditional expression may not
     span multiple makefiles.

     expression can be one of the following three forms:

          <text> | <text> == <text> | <text> != <text>

     where text is either text or a macro expression.  In any
     case, before the comparison is made, the expression is
     expanded.  The text portions are then selected and compared.
     White space at the start and end of the text portion is dis-
     carded before the comparison.  This means that a macro that
     evaluates to nothing but white space is considered a NULL
     value for the purpose of the comparison.  In the first case
     the expression evaluates TRUE if the text is not NULL



Version 3.9 PL0                 UW                             50




DMAKE(p)             Unsupported Free Software            DMAKE(p)



     otherwise it evaluates FALSE.  The remaining two cases both
     evaluate the expression on the basis of a string comparison.
     If a macro expression needs to be equated to a NULL string
     then compare it to the value of the macro $(NULL).  You can
     use the $(shell ...) macro to construct more complex test
     expressions.

EXAMPLES
          # A simple example showing how to use make
          #
          prgm : a.o b.o
               cc a.o b.o -o prgm
          a.o : a.c g.h
               cc a.c -o $@
          b.o : b.c g.h
               cc b.c -o $@

     In the previous example prgm is remade only if a.o and/or
     b.o is out of date with respect to prgm.  These dependencies
     can be stated more concisely by using the inference rules
     defined in the standard startup file.  The default rule for
     making .o's from .c's looks something like this:

          %.o : %.c; cc -c $(CFLAGS) -o $@ $<

     Since there exists a rule (defined in the startup file) for
     making .o's from .c's dmake will use that rule for manufac-
     turing a .o from a .c and we can specify our dependencies
     more concisely.

          prgm : a.o b.o
               cc -o prgm $<
          a.o b.o : g.h

     A more general way to say the above using the new macro
     expansions would be:

          SRC = a b
          OBJ = {$(SRC)}.o

          prgm : $(OBJ)
               cc -o $@ $<

          $(OBJ) : g.h

     If we want to keep the objects in a separate directory,
     called objdir, then we would write something like this.

          SRC = a b
          OBJ = {$(SRC)}.o

          prgm : $(OBJ)



Version 3.9 PL0                 UW                             51




DMAKE(p)             Unsupported Free Software            DMAKE(p)



               cc $< -o $@

          $(OBJ) : g.h
          %.o : %.c
               $(CC) -c $(CFLAGS) -o $(@:f) $<
               mv $(@:f) objdir

          .SOURCE.o : objdir       # tell make to look here for .o's

     An example of building library members would go something
     like this: (NOTE:  The same rules as above will be used to
     produce .o's from .c's)

          SRC  = a b
          LIB  = lib
          LIBm = { $(SRC) }.o

          prgm: $(LIB)
               cc -o $@ $(LIB)

          $(LIB) .LIBRARY : $(LIBm)
               ar rv $@ $<
               rm $<

     Finally, suppose that each of the source files in the previ-
     ous example had the `:' character in their target name.
     Then we would write the above example as:

          SRC  = f:a f:b
          LIB  = lib
          LIBm = "{ $(SRC) }.o"         # put quotes around each token

          prgm: $(LIB)
               cc -o $@ $(LIB)

          $(LIB) .LIBRARY : $(LIBm)
               ar rv $@ $<
               rm $<

COMPATIBILITY
     There are two notable differences between dmake and the
     standard version of BSD UNIX 4.2/4.3 Make.

          1. BSD UNIX 4.2/4.3 Make supports wild card filename
             expansion for prerequisite names.  Thus if a direc-
             tory contains a.h, b.h and c.h, then a line like

                  target: *.h

             will cause UNIX make to expand the *.h into "a.h b.h
             c.h".  dmake does not support this type of filename
             expansion.



Version 3.9 PL0                 UW                             52




DMAKE(p)             Unsupported Free Software            DMAKE(p)



          2. Unlike UNIX make, touching a library member causes
             dmake to search the library for the member name and
             to update the library time stamp.  This is only
             implemented in the UNIX version.  MSDOS and other
             versions may not have librarians that keep file time
             stamps, as a result dmake touches the library file
             itself, and prints a warning.

     dmake is not compatible with GNU Make.  In particular it
     does not understand GNU Make's macro expansions that query
     the file system.

     dmake is fully compatible with SYSV AUGMAKE, and supports
     the following AUGMAKE features:

          1. The word include appearing at the start of a line
             can be used instead of the ".INCLUDE :" construct
             understood by dmake.

          2. The macro modifier expression $(macro:str=sub) is
             understood and is equivalent to the expression
             $(macro:s/str/sub), with the restriction that str
             must match the following regular expression:

                  str[ |\t][ |\t]*

             (ie. str only matches at the end of a token where
             str is a suffix and is terminated by a space, a tab,
             or end of line) Normally sub is expanded before the
             substitution is made, if you specify -A on the com-
             mand line then sub is not expanded.

          3. The macro % is defined to be $@ (ie. $% expands to
             the same value as $@).

          4. The AUGMAKE notion of libraries is handled
             correctly.

          5. When defining special targets for the inference
             rules and the AUGMAKE special target handling is
             enabled then the special target .X is equivalent to
             the %-rule "% : %.X".

          6. Directories are always made if you specify -A.  This
             is consistent with other UNIX versions of Make.

          7. Makefiles that utilize virtual targets to force mak-
             ing of other targets work as expected if AUGMAKE
             special target handling is enabled.  For example:

                  FRC:
                  myprog.o : myprog.c $(FRC) ; ...



Version 3.9 PL0                 UW                             53




DMAKE(p)             Unsupported Free Software            DMAKE(p)



             Works as expected if you issue the command

                  'dmake -A FRC=FRC'

             but fails with a 'don't know how to make FRC' error
             message if you do not specify AUGMAKE special target
             handling via the -A flag (or by setting AUGMAKE:=yes
             internally).

LIMITS
     In some environments the length of an argument string is
     restricted.  (e.g. MSDOS command line arguments cannot be
     longer than 128 bytes if you are using the standard
     command.com command interpreter as your shell, dmake text
     diversions may help in these situations.)

PORTABILITY
     To write makefiles that can be moved from one environment to
     another requires some forethought.  In particular you must
     define as macros all those things that may be different in
     the new environment.  dmake has two facilities that help to
     support writing portable makefiles, recursive macros and
     conditional expressions.  The recursive macros, allow one to
     define environment configurations that allow different
     environments for similar types of operating systems.  For
     example the same make script can be used for SYSV and BSD
     but with different macro definitions.

     To write a makefile that is portable between UNIX and MSDOS
     requires both features since in almost all cases you will
     need to define new recipes for making targets.  The recipes
     will probably be quite different since the capabilities of
     the tools on each machine are different.  Different macros
     will be needed to help handle the smaller differences in the
     two environments.

FILES
     Makefile, makefile, startup.mk (use dmake -V to tell you
     where the startup file is)

SEE ALSO
     sh(1), csh(1), touch(1), f77(1), pc(1), cc(1)
     S.I. Feldman  Make - A Program for Maintaining Computer Pro-
     grams

AUTHOR
     Dennis Vadura, CS Dept. University of Waterloo.
     dvadura@watdragon.uwaterloo.ca
     Many thanks to Carl Seger for his helpful suggestions, and
     to Trevor John Thompson for his many excellent ideas and
     informative bug reports.




Version 3.9 PL0                 UW                             54




DMAKE(p)             Unsupported Free Software            DMAKE(p)



BUGS
     Some system commands return non-zero status inappropriately.
     Use -i (`-' within the makefile) to overcome the difficulty.

     Some systems do not have easily accessible time stamps for
     library members (MSDOS, AMIGA, etc) for these dmake uses the
     time stamp of the library instead and prints a warning the
     first time it does so.  This is almost always ok, except
     when multiple makefiles update a single library file.  In
     these instances it is possible to miss an update if one is
     not careful.

     This man page is way too long.

WARNINGS
     Rules supported by make(1) may not work if transitive clo-
     sure is turned off (-T, .NOINFER).

     PWD from csh/ksh will cause problems if a cd operation is
     performed and -e or -E option is used.

     Using internal macros such as COMMAND, may wreak havoc if
     you don't understand their functionality.
































Version 3.9 PL0                 UW                             55
