//*****************************************************************************
//* Demonstration of DIVE                         - February 1996 - D.A.Braun *
//*****************************************************************************

//**************************** General Includes *******************************
#define INCL_WIN	// Include windowing and queue functions
#define INCL_DOS	// Include "DOS" functions - for threads

#include <os2.h>	// Include for OS/2 functions
#include "diveobj.h"	// Include for DIVE Class

//************************* GLOBAL VARIABLES **********************************
HWND	ghMainWinFrame,ghMainWinClient;	// Window handles for the app. window

TID	gtDrawThread;			// Thread handle for Draw Thread
HMQ	gqDrawQueue;			// Queue for the Draw Thread
INT	gDrawReady;			// Flag to verify setup of Draw Thread

//************************* DRAW THREAD ***************************************
// Message Command Definitions
#define UM_EXIT		WM_USER
#define UM_PAINT	WM_USER + 1
#define UM_VRNDIS	WM_USER + 10
#define UM_VRNENA	WM_USER + 11
#define UM_RELPAL	WM_USER + 12

void APIENTRY fDrawProc (char *ImageFileName)
{
HAB		hab;
QMSG		Message;
DIVEOBJ		*MyDiveObject;

hab = WinInitialize( 0 );			// Initialize this thread to PM
gqDrawQueue = WinCreateMsgQueue( hab, 0 );	// Get a message queue
WinCancelShutdown( gqDrawQueue, TRUE );		// Cancel WM_QUIT message

gDrawReady = TRUE;				// Ready to receive messages

MyDiveObject = new DIVEOBJ (ImageFileName);
MyDiveObject->Location (0,0,1,1);

// Message Loop begins here
do	{
	WinGetMsg( hab, &Message, 0L, 0L, 0L );

	switch( Message.msg )
		{
		case UM_VRNDIS:
			MyDiveObject->VRN_Disable ();
			break;
		case UM_VRNENA:
			MyDiveObject->VRN_Enable (ghMainWinClient,ghMainWinFrame);
			break;
		case UM_RELPAL:
			MyDiveObject->Realize_Palette ();
			break;
		case UM_PAINT:
			MyDiveObject->Blit ();
			break;
		}
	} while( Message.msg != UM_EXIT );

delete (MyDiveObject);

WinDestroyMsgQueue(gqDrawQueue);	// Eliminate the message queue
WinTerminate(hab);			// Proper exit of PM
DosExit( EXIT_THREAD, 0L );    		// Proper thread exit
}



//**************************** Window Proc For MAIN Window ********************
MRESULT EXPENTRY main_window (HWND handle,ULONG mess,MPARAM parm1,MPARAM parm2)
{
static HPS p_space;

switch (mess)
	{
	case WM_CREATE:
		// Ensure that the DIVE blitter will be set up
		WinPostMsg (handle,WM_VRNENABLED,0L,0L);
		break;
	case WM_PAINT:
		// We must open a presentation space even though we aren't
		// going to use it because otherwise OS/2 will complain
		p_space=WinBeginPaint (handle, 0, 0);
		WinEndPaint (p_space);
		// Post a message to the draw thread to paint the DIVE region
		WinPostQueueMsg( gqDrawQueue, UM_PAINT, 0L, 0L );
		break;
	case WM_VRNDISABLED:
		// Turn the blitter off for now
		WinPostQueueMsg( gqDrawQueue, UM_VRNDIS, 0L, 0L );
		break;
	case WM_VRNENABLED:
		// Turn the blitter on now
		WinPostQueueMsg( gqDrawQueue, UM_VRNENA, (MPARAM)handle, 0L );
		break;
	case WM_REALIZEPALETTE:
		// The system's palette has changed, make the DIVE region
		// adjust accordingly.
		WinPostQueueMsg( gqDrawQueue, UM_RELPAL, 0L, 0L );
		break;
	case WM_CLOSE:
		WinPostQueueMsg( gqDrawQueue, UM_VRNDIS, 0L, 0L );
	default:
		return WinDefWindowProc (handle,mess,parm1,parm2);
	}
return (MRESULT) FALSE;
}

//****************************** MAIN FUNCTION ********************************
void main (int argc, char * argv[])
{
QMSG	q_message;  			// Use this to hold a message
HAB	h_anchor;			// Anchor block for out program
HMQ	h_mqueue;			// Main thread's message queue
ULONG	nwin_flags;			// Holds the window flags
unsigned char mclass[] = "DemoClass";	// Name of out window class

// Initialize or program into the window system
if (!(h_anchor=WinInitialize (0)))
	DosExit( EXIT_PROCESS, 0L );			// Proper process exit

// Get a message queue
if (!(h_mqueue=WinCreateMsgQueue (h_anchor,0)))
	{
	WinTerminate (h_anchor);
	DosExit( EXIT_PROCESS, 0L );			// Proper process exit
	}

// See if the system can handle DIVE
if (!QueryDive ())	// If it can't - show the error message...
	{
	WinMessageBox 	(HWND_DESKTOP,HWND_DESKTOP,"ERROR: No DIVE Support",
		"DIVE Example Error",0, MB_OK | MB_MOVEABLE | MB_ICONEXCLAMATION);
	WinDestroyMsgQueue (h_mqueue);
	WinTerminate (h_anchor);
	DosExit( EXIT_PROCESS, 0L );			// Proper process exit
	}

// Check if we received a filename parameter
if (argc < 2)		// If we didn't - show the error message
	{
	WinMessageBox 	(HWND_DESKTOP,HWND_DESKTOP,"ERROR: No Targa Specified",
		"DIVE Example Error",0, MB_OK | MB_MOVEABLE | MB_ICONEXCLAMATION);
	WinDestroyMsgQueue (h_mqueue);
	WinTerminate (h_anchor);
	DosExit( EXIT_PROCESS, 0L );			// Proper process exit
	}

// Start up our draw thread - wait for queue to be ready
gDrawReady = FALSE;
DosCreateThread (&gtDrawThread, (PFNTHREAD) fDrawProc, (ULONG)argv[1],0,4096);
while (!gDrawReady) DosSleep (10);

// Now Initialize a window class
if (!WinRegisterClass (h_anchor,(PSZ) mclass,main_window,CS_SIZEREDRAW,0))
	{
	WinDestroyMsgQueue (h_mqueue);
	WinTerminate (h_anchor);
	DosExit( EXIT_PROCESS, 0L );			// Proper process exit
	}

// Create the main application window

// Some setup information
nwin_flags = FCF_STANDARD&(~FCF_ACCELTABLE)&(~FCF_SHELLPOSITION)
		&(~FCF_MENU)&(~FCF_ICON);
if (!(ghMainWinFrame = WinCreateStdWindow (HWND_DESKTOP,WS_VISIBLE,&nwin_flags,
    (PSZ) mclass,(PSZ) "Dive Demo App - February 1996",    0L,0,0,&ghMainWinClient)))
	{
	WinDestroyMsgQueue (h_mqueue);
	WinTerminate (h_anchor);
	DosExit( EXIT_PROCESS, 0L );			// Proper process exit
	}

// Move and resize the application window (and raise to top)
WinSetWindowPos (ghMainWinFrame, HWND_TOP, 10, 10, 600, 450,
	SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ACTIVATE );

// Enable visible region notification - Necessary for DIVE - this
// tells OS/2 to send the window the VRN_ENABLED and VRN_DISABLED messages
WinSetVisibleRegionNotify (ghMainWinFrame,TRUE);

//  Message loop - the program runs here
while (WinGetMsg (h_anchor,&q_message,0L,0,0))
	WinDispatchMsg (h_anchor, &q_message);

// Stop the drawing thread
WinPostQueueMsg( gqDrawQueue, UM_EXIT, (MPARAM)FALSE, (MPARAM)0L );
DosWaitThread (&gtDrawThread,(ULONG)0);

// Disable visible region notification
WinSetVisibleRegionNotify (ghMainWinFrame,FALSE);

// The user has requested closing the program - now shutdown
WinDestroyWindow (ghMainWinFrame);		// Destroy our window
WinDestroyMsgQueue (h_mqueue);			// Donw w/message queue
WinTerminate (h_anchor);		    	// Done w/window system
DosExit( EXIT_PROCESS, 0L );			// Proper process exit
}

//********************************* END ***************************************
