//****************************************************************************
//* DIVE Class Header                         - D.A.Braun - February 1996    *
//****************************************************************************

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <dive.h>

int QueryDive ();				// Does system supports DIVE?

class DIVEOBJ
{
private:
	HDIVE H_Dive;			        // Handle for instance of DIVE
	SETUP_BLITTER	D_BlitSetup;		// DIVE Blitter setup structure
	ULONG		DH_Buffer;		// Handle for our DIVE buffer
	ULONG		Width,Height;		// Width and height of buffer
	float		X,Y,W,H;		// Location of region in window
	int		bDepth;			// Byte depth of image buffer

public:
	DIVEOBJ (char *fname);        		// Constructor
	~DIVEOBJ ();                    	// Destructor
	char*	OpenBuffer ();			// Open access to the buffer
	void	CloseBuffer ();			// Close access to the buffer
	void	Realize_Palette  ();		// Realize system palette
	void	VRN_Disable ();			// Disable visible region
	void	VRN_Enable (HWND client,
			HWND frame);		// Enable visible region
	void	Location (float xl,float yb,
			float xr,float yt);	// Set location in window
	int	Blit ();			// Blit the buffer to screen
};

//******************************** END ****************************************
