//****************************************************************************
//* DIVE Class for Application use           - D.A.Braun - February 1996     *
//****************************************************************************

#include "diveobj.h"
#include <mem.h>
#include <fourcc.h>
#include <stdlib.h>
#include <mmioos2.h>

//*****************************************************************************
//* QueryDive function - used to check if the system supports DIVE
int QueryDive ()
{
DIVE_CAPS DiveCaps;
FOURCC    fccFormats[100] = {0};

DiveCaps.pFormatData = fccFormats;
DiveCaps.ulFormatLength = 120;
DiveCaps.ulStructLen = sizeof(DIVE_CAPS);

if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN ))
	return FALSE;
if ( DiveCaps.ulDepth < 8 )
	return FALSE;

return TRUE;
}

//*************** CONSTRUCTOR : Set up DIVE and our Image buffer **************
//* Loads an image and sets up DIVE with that image
DIVEOBJ::DIVEOBJ (char *fname)
{
ULONG IMGHAND,IMGACT,IMGCOUNT;
unsigned char TgaHeader [18];
RGB2 *sourcepal;
PBYTE pbBuffer;
int BitDepth;

DosOpen (fname,		// Open up the image file specified
	&IMGHAND,
	&IMGACT,
	0,
	FILE_NORMAL,
	OPEN_ACTION_OPEN_IF_EXISTS,
	OPEN_SHARE_DENYWRITE | OPEN_ACCESS_READONLY |
	OPEN_FLAGS_SEQUENTIAL,
	0);

// Get image information from the targa header - This supports most
// uncompressed targas, it's behavior is not predictable if given the
// wrong type of file.
DosRead (IMGHAND,TgaHeader,18,&IMGCOUNT);

Width = TgaHeader[12] + (TgaHeader[13] << 8);
Height = TgaHeader[14] + (TgaHeader[15] << 8);
BitDepth = TgaHeader[16];

// Now open up a dive instance with the necessary settings
// Initialize DIVE
DiveOpen (&H_Dive,FALSE,0);

// Setup information for the DIVE blitter
D_BlitSetup.ulStructLen = sizeof ( SETUP_BLITTER );
D_BlitSetup.ulSrcWidth = Width;
D_BlitSetup.ulSrcHeight = Height;
D_BlitSetup.ulSrcPosX = 0;
D_BlitSetup.ulSrcPosY = 0;
D_BlitSetup.fInvert = TRUE;
D_BlitSetup.ulDitherType = 0;
D_BlitSetup.fccDstColorFormat = FOURCC_SCRN;

// Color depth specific setup information and creation of buffer

if (BitDepth == 24) // Color Depth 24, BGR3 format.
	{
	D_BlitSetup.fccSrcColorFormat = FOURCC_BGR3;
	DiveAllocImageBuffer (H_Dive,
		&DH_Buffer,
		FOURCC_BGR3,
		D_BlitSetup.ulSrcWidth,
		D_BlitSetup.ulSrcHeight,
		0, 0);
	}
else if (BitDepth == 16) // Color Depth 16, R565 format.
	{
	D_BlitSetup.fccSrcColorFormat = FOURCC_R565;
	DiveAllocImageBuffer (H_Dive,
		&DH_Buffer,
		FOURCC_R565,
		D_BlitSetup.ulSrcWidth,
		D_BlitSetup.ulSrcHeight,
		0, 0);
	}
else	{ // Color Depth 8, Palette format.
	D_BlitSetup.fccSrcColorFormat = FOURCC_LUT8;
	DiveAllocImageBuffer (H_Dive,
		&DH_Buffer,
		FOURCC_LUT8,
		D_BlitSetup.ulSrcWidth,
		D_BlitSetup.ulSrcHeight,
		0, 0);
	}

bDepth = BitDepth/8; // Byte Depth is BitDepth/8.

// If 8bit/palette mode then read in the image palette
if (bDepth == 1)
	{
	sourcepal = (RGB2*) malloc (256 * sizeof(RGB2));
	for (int cntr = 0;cntr < 256;cntr++)
		{
		DosRead (IMGHAND,&sourcepal[cntr],3,&IMGCOUNT);
		sourcepal[cntr].fcOptions = 0;
		}
	DiveSetSourcePalette (H_Dive,0,256,(char*)sourcepal);
	free (sourcepal);
	}

DiveBeginImageBufferAccess	// Open access to the image buffer
	(H_Dive,DH_Buffer,&pbBuffer,&Width,&Height);
DosRead				// Read in the image data
	(IMGHAND,pbBuffer,Width * Height * bDepth,&IMGCOUNT);
DiveEndImageBufferAccess	// Close access to the image buffer
	(H_Dive,DH_Buffer);
DosClose (IMGHAND);		// Close the image file
}

//******************* DESTRUCTOR : Close DIVE if it was opened ****************
DIVEOBJ::~DIVEOBJ ()
{
// Free up the image buffer
DiveFreeImageBuffer (H_Dive,DH_Buffer);
// Close DIVE
DiveClose (H_Dive);
}

//******************** Handler for DIVE Realize Palette ***********************
//* This tells DIVE that the physical palette may have changed.
void DIVEOBJ::Realize_Palette  ()
{ DiveSetDestinationPalette ( H_Dive, 0, 256, 0 ); }

//********************** Handler for DIVE VRN Disable *************************
//* This disables the DIVE blitter because the draw region is currently unknown
void DIVEOBJ::VRN_Disable ()
{ DiveSetupBlitter ( H_Dive, 0 ); }

//********************** Handler for DIVE VRN Enable **************************
//* Much of this function was taken from IBM's demo dive code - I made some
//* changes to allow the image to be scaled to a percentage location in it's
//* parent window - see DIVEOBJ::Location function below.
void DIVEOBJ::VRN_Enable (HWND client,HWND frame)
{
POINTL	pointl;
HPS	hps;
HRGN	hrgn;
RECTL	rcls [50];
RGNRECT	rgnCtl;
SWP	swp;

hps = WinGetPS ( client);
hrgn = GpiCreateRegion ( hps, 0L, NULL );
if ( hrgn )
	{
	// NOTE: If mp1 is zero, then this was just a move message.
	// Illustrate the visible region on a WM_VRNENABLE.

	WinQueryVisibleRegion ( client, hrgn );
	rgnCtl.ircStart     = 0;
	rgnCtl.crc          = 50;
	rgnCtl.ulDirection  = RECTDIR_LFRT_TOPBOT;

	// Get the all ORed rectangles
	if ( GpiQueryRegionRects ( hps, hrgn, NULL, &rgnCtl, rcls) )
		{
		// Now find the window position and size, relative to parent.
		WinQueryWindowPos (client, &swp );

		// Convert the point to offset from desktop lower left.
		pointl.x = swp.x;
		pointl.y = swp.y;
		WinMapWindowPoints (frame,
			HWND_DESKTOP, (POINTL*)&pointl, 1 );

		// Tell DIVE about the new settings.

		D_BlitSetup.ulDstWidth = swp.cx * W;
		D_BlitSetup.ulDstHeight = swp.cy * H;
		D_BlitSetup.lDstPosX = swp.cx * X;
		D_BlitSetup.lDstPosY = swp.cy * Y;

		D_BlitSetup.lScreenPosX = pointl.x;
		D_BlitSetup.lScreenPosY = pointl.y;
		D_BlitSetup.ulNumDstRects = rgnCtl.crcReturned;
		D_BlitSetup.pVisDstRects = rcls;
		DiveSetupBlitter (H_Dive, &D_BlitSetup );
		}
	else DiveSetupBlitter (H_Dive, 0 );

	GpiDestroyRegion( hps, hrgn );
	}
WinReleasePS( hps );
}

//************************ Set Location of DIVE region ************************
//* Sets the location of this dive object to be at a certain place in the
//* window - values are from 0 (left/bottom) to 1 (right/top) - DIVE wants
//* left,bottom,width,height in screen coordinates, but I want to think of
//* things as left,bottom,right,top percentages so I converted it here.
void DIVEOBJ::Location (float xl,float yb,float xr,float yt)
{
X = xl;
Y = yb;
W = xr - xl;
H = yt - yb;
}

//************************* Open DIVE Buffer **********************************
//* Opens the dive buffer and returns a pointer into the buffer - don't
//* forget to close the buffer!
char* DIVEOBJ::OpenBuffer ()
{
PBYTE pbBuffer;

DiveBeginImageBufferAccess (H_Dive,DH_Buffer,&pbBuffer,&Width,&Height);
return pbBuffer;
}

//************************ Close DIVE Buffer **********************************
//* Closes the buffer - simple.
void DIVEOBJ::CloseBuffer ()
{ DiveEndImageBufferAccess (H_Dive,DH_Buffer); }

//**************************** Blit the image *********************************
//* Blits the image onto the screen - simple.
int DIVEOBJ::Blit ()
{ return DiveBlitImage (H_Dive,DH_Buffer,DIVE_BUFFER_SCREEN); }

//********************************** END **************************************
