/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Jan. 1994.
**
** Revisions:  Barkha J. Herman, 05/11/94, added comments, headers.
**                Adam Loving, 12/30/94, overloaded ddtOStream::operator<< to handle
**                      CHAR*, INT, and ULONG.
**                Adam Loving, 01/23/95, overloaded BaseStream::operator<< to handle
**                      FormattedList
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#ifndef THREADIO_H
#define THREADIO_H

#include "buffer.h"
#include "ddtoutf.h"
#include <stdio.h>
#include <string.h>

// export function declarations
BOOL 	_export TestSet(BOOL&);

//
// Base Stream - used in FileInfo & OutputStream classes.
//
class BaseStream
{
public:
  BaseStream(const IString &filename, IString mode = "w");
  virtual ~BaseStream();

  virtual void ref();
  int unref();
  void operator<<(IString&);
  void operator<<(Buffer&);
  void operator<<(FormattedList&);
  virtual IString filename(){return _filename;};
  virtual IString mode() {return _mode;};
  virtual void Lock(){_locked = TRUE;};
  virtual void UnLock(){_locked = FALSE;};
  virtual BOOL isLocked(){return _locked ;};
  virtual HEV  hev_lock() {return _lock;};
protected:
  HMTX _mutex;
  HEV  _lock;
  BOOL _locked;
  int _nRef;
  IString _filename;
  FILE * _stream;
  IString _mode;
};

//
// BaseStreamNode - Node for link list of BaseStreams in OutputStream.
//
struct BaseStreamNode
{
  BaseStream * data;
  BaseStreamNode * next;
};


//
// Export class OutputStream
//
class _export OutputStream
{
public:
  OutputStream(const IString &filename, IString mode = "w");
  virtual ~OutputStream();
  virtual void changeFile(const IString &filename, IString mode = "w");
  virtual void operator<<(IString&);
  virtual void operator<<(Buffer&);
  virtual void operator<<(FormattedList&);
  virtual void flush() {};
  virtual void age(){_fresh = FALSE; _logbuffer = "";};
  virtual BOOL fresh() {return _fresh;};
  virtual IString buffer() {return _logbuffer;};
  virtual void  BeginExclusiveAccess();
  virtual void  EndExclusiveAccess();
protected:
  void closeStream();
  void openStream(const IString &filename, IString &mode);
  BOOL _fresh;	
  BOOL _exclusive;
  BaseStream * _stream;
  IString _logbuffer;
  static  BaseStreamNode * listOfStreams;
  static  HMTX   listmutex;
  static  APIRET mutexrc;
};
//
//  DdtOStream - derived from OutputStream.
//  adds TID to the all log strings.
//
class _export DdtOStream: public OutputStream
{
public:
  DdtOStream(const IString &filename, IString mode = "w");
  virtual ~DdtOStream();
  virtual void operator<<(IString&);
  virtual void operator<<(const CHAR*);             //AL
  virtual void operator<<(const INT);                //AL
  virtual void operator<<(const ULONG);                 //AL
  virtual void operator<<(Buffer& buf) {OutputStream::operator<<(buf);};
  virtual void operator<<(FormattedList& FList) {OutputStream::operator<<(FList);};
  virtual void settid(const IString& pch){tid = pch;};
private:
  IString tid;
};
//
// Contains two OutputStreams.
//
class _export FileInfo
{
public:
  FileInfo(const IString &out1FileName, IString &errFileName);
  virtual ~FileInfo(){};
  DdtOStream errOut;
  DdtOStream out1;
};

#endif
