/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: 
**
** Revisions:
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**                             and replacing key() with setkey or getkey method
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#ifndef thread_h
#define thread_h
#include "ddtparse.h"
#include "buffer.h"
#include "ddtlist.h"

class _export DdtCounter:public DdtObject<unsigned short>
{
  public:
    DdtCounter (){};
    virtual ~DdtCounter (){};
    virtual unsigned short getcounter(){return counter;};
    virtual unsigned short getref(){return ref;};
    virtual void operator++(){counter++;};
    virtual void operator--(){counter--;};
    virtual void setcount(unsigned short c){counter = c;};
    virtual void setref(unsigned short r){ref = r;};
  private:
    unsigned short counter;
    unsigned short ref;
};
class _export DdtIStream:public DdtObject<IString>
{
  public:
    DdtIStream(IString fn = "");
    DdtIStream(DdtIStream &);
    ~DdtIStream();
    virtual void reopen(IString fn = "");
    virtual Pars_Buffer &parsbuf(){return buffer_;};
    virtual FILE *fp(){return fp_;};
  private:
    Pars_Buffer buffer_;
    FILE       *fp_;
 }; 

class _export DdtInstance:public DdtObject<IString>
{
  public:
    DdtInstance(IString& fn):buffer(),device(fn), callFrame()
       {callFrame.kwd_list().set(BUFFER_LIST, (long)&buffer);};
    virtual ~DdtInstance(){};
    virtual unsigned long execute(){return device.execute(callFrame);};
//    virtual void setalias(IString& s){key() = s;};
    virtual void setalias(const IString& s){setkey(s);};
    virtual Call_Frame &call(){return callFrame;};                     //@01
    virtual Cmd_Syntax_List &slist(){return device.syntax();};
  protected:
    Device          device;
    Call_Frame      callFrame;
    BufferList	    buffer;      
};

class _export DdtThread:public DdtObject<TID>
{
  public:
    DdtThread(IString pch1 = "stdout", IString pch2 = "stderr");
    virtual ~DdtThread();
    virtual Pars_Buffer   &threadbuffer(){return buffer;};
    virtual unsigned long create(unsigned long stk = 12288);
    virtual void dispatch();
    virtual void wait();
    virtual void ExecThread();
    virtual APIRET doline(USHORT &);
    virtual Kwd_List &kwd(){return kl;};
    virtual IString userIO(IString&, int);
    friend void APIENTRY _export ExecuteThread(ULONG);
  protected:
    virtual FileInfo *files(){return &fileinfo;};
  private:
    FileInfo                   fileinfo;
    Pars_Buffer                buffer;
    DdtList<IString>           inst;
    DdtList<unsigned short>    count;
    DdtList<unsigned short>    stack;
    Kwd_List                   kl;
    void                       openinstance();
    void                       flushinstance();
    void                       log();
    void                       pause();
    APIRET                     private_execute();
};

#endif







