/*
**************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification:              IBM Test Tool
**
** Original Author and Date:    Kishan Kasety     July 1994
**
** Revisions:	12/12/94 Adam Loving: - added temporary IStrings,
**					- slightly edited calls to strncpy: changed  
**					  paramblock->DrvNam to (char*)&(paramblock->DrvNam[0])
**					- changed (__far16 *) qualifiers to (* _Seg16)
**					- changed casting of pBitsStatus in CheckStatus function
**
** Comments:
**
** Public Class/ Functions:
**
**************************************************************************
*/

#include "kwdlist.h"
#include "apicover.h"
#include "dasdadd.h"
#include "scsiadd.h"
#include "clsiorb.h"
#include "scatgat.h"
#include "bit.h"

// global stuff

CHAR    OutBuff[256];
APIRET  ulRc;
IString printdevicetable(PARAMS *);
IString print_inquiry_data( Kwd_List & );
IString hex(IString);
ULONG swaplong(ULONG swap);
APIRET SetControlByte( Kwd_List & );


/*
*************************************************************************
** Name:         APIRET _export scsiadd_open( Kwd_List& )
**
** Description:  Opens DASDADD$, returns drivehandle
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_open( Kwd_List& param )
{
  ULONG   ulAction  = 0;
  ULONG   ulOpenFlag;
  ULONG   ulOpenMode;
  HFILE   drvhndle;

  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE;
  ulRc = ddtDosOpen( "DASDADD$", &drvhndle, &ulAction, 0L, 0L,
                     ulOpenFlag, ulOpenMode, NULL,
                     "scsiadd_open", "only call",
                     param.files()->out1);
  param.set("DRIVEHANDLE", (long)drvhndle );
  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_close( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_close( Kwd_List& param )
{
  HFILE   drvhndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosClose( drvhndle,
                      "scsiadd_close", "only call",
                      param.files()->out1 );
  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_GetDrivers( Kwd_List& )
**
** Description:  prints the names of the drivers loaded
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_GetDrivers( Kwd_List& param )
{
  HFILE         drvHndle = param.getInt("DRIVEHANDLE");
  PARAMS        paramblock;
  ULONG         paramlen = sizeof(paramblock);
  UCHAR         aDrvNam[32][16];
  ULONG         datalen = 16*32;

  paramblock.nDrivers = 0;
  paramblock.DevClass = 1; // for disks.
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x00,
                         &paramblock, paramlen, &paramlen,
                         aDrvNam, datalen, &datalen,
                         "scsiadd_GetDrivers", "only call",
                         param.files()->out1 );
  if (ulRc == 0)
  {
    IString s1("Drivers Names:");
    param.set("DRIVERS", (IString)(long)paramblock.nDrivers);
    for (int i = 0; i < paramblock.nDrivers; i++)
     {
       s1 = s1 + "\n     " +(IString)(const char *)aDrvNam[i];
     }
     param.files()->out1<<s1;
  }
  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_GetDeviceTable( Kwd_List& )
**
** Description:  prints the device table for the specified driver
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_GetDeviceTable( Kwd_List& param )
{
  HFILE                  drvHndle = param.getInt("DRIVEHANDLE");
  DEVICETABLE  * _Seg16 pdevicetable;		//AL
  ULONG                  datalen = MAX_DT_SIZE;
  PARAMS                *paramblock = new PARAMS;
  BYTE                  *buffer = new BYTE[MAX_DT_SIZE];
  CHAR*	     tmp;

  pdevicetable         = (DEVICETABLE * _Seg16 )buffer;
  paramblock->DevClass = 1; // for disks.
  paramblock->flag     = param.getInt("MODE");

  strncpy((char*)&(paramblock->DrvNam[0]), param["DRVNAME"], 16);	//AL
  paramblock->iorb.iorb_configuration.iorbh.Length
                         = sizeof(paramblock->iorb.iorb_configuration);
  paramblock->iorb.iorb_configuration.iorbh.UnitHandle     = 0;
  paramblock->iorb.iorb_configuration.iorbh.CommandCode    = IOCC_CONFIGURATION;
  paramblock->iorb.iorb_configuration.iorbh.CommandModifier= IOCM_GET_DEVICE_TABLE;
  paramblock->iorb.iorb_configuration.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_configuration.iorbh.Status         = 0;
  paramblock->iorb.iorb_configuration.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_configuration.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_configuration.pDeviceTable         = pdevicetable;
  paramblock->iorb.iorb_configuration.DeviceTableLen       = MAX_DT_SIZE;
  ULONG paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x01,
                         paramblock, paramlen, &paramlen,
                       pdevicetable, datalen, &datalen,
                         "scsiadd_GetDeviceTable", "only call",
                         param.files()->out1 );
  if (ulRc == 0)
    if (paramblock->flag == 1)
    {
      IString s1;
      s1 = printdevicetable(paramblock);
      param.files()->out1<<s1;
    }
    else
     param.set(param["LABEL"], (LONG)paramblock);
  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_ReadCapacity( Kwd_List & )
**
** Description:  Reads and prints the capacity of the logical unit.
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_ReadCapacity( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         last_logical_block_addr;
  ULONG         logical_block_size;
  IString       s1, s2;
  ULONG         temp;

  param.set("MEMSIZE", 8);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x25);

// RelAdr bit
  param.set("CDB_BYTE1", 0);
  if( param.getInt("ADDR_MODE") != 0 )
     param.set("CDB_BYTE1", 1);

  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// Reserved
// Bit 0 of CDB_BYTE8 is the PMI bit
// 0 = indicates that the returned logical block address and the block length
//     in bytes are those of the last logical block on the logical unit.
// 1 = indicates that the returned logical block address and the block length
//     in bytes are those of the logical block address after which a
//     substantial delay in data transfer will occur.
  param.set("CDB_BYTE6", 0);
  param.set("CDB_BYTE7", 0);
  param.set("CDB_BYTE8", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Read Capacity");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 )
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
     if( Sglist->GetByte( &last_logical_block_addr, 0, 4 ) )
     {
        s2 = "ScatGat :: GetByte Failed ";
        s2 += "\n";
        param.files()->out1<<s2;
        return FALSE;
     }

     if( Sglist->GetByte( &logical_block_size, 4, 4 ) )
     {
        s2 = "ScatGat :: GetByte Failed ";
        s2 += "\n";
        param.files()->out1<<s2;
        return FALSE;
     }

// swaplong reverses the bytes in a ULONG
     last_logical_block_addr = swaplong(last_logical_block_addr);
     logical_block_size = swaplong(logical_block_size);

     param.set("LAST_LOGICAL_BLOCK_ADDR", (LONG)last_logical_block_addr);
     param.set("LOGICAL_BLOCK_SIZE", (LONG)logical_block_size);

     s1 = "No. of Blocks = ";
     s1 += (LONG)(param.getInt("LAST_LOGICAL_BLOCK_ADDR") + 1 );
     s1 += "\n";
     s1 += "\tSize of each logical Block = ";
     s1 += param.getInt("LOGICAL_BLOCK_SIZE");
     s1 += "\n\tApprox. Total Capacity = ";
     s1 += (logical_block_size * (last_logical_block_addr + 1))/1000000;
     s1 += "MB";
     param.files()->out1<<s1;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_LockUnlockCache( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_LockUnlockCache( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         last_logical_block_addr = 0;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  last_logical_block_addr = param.getInt("LAST_LOGICAL_BLOCK_ADDR");
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  Sglist_size = NBlocks * logical_block_size;

// If the no. of blocks specified is 0 the CDB defaults to a range that
// includes all the remaining logical blocks
// Therefore making the Sglist_size equal to the remaining blocks
  if (NBlocks == 0)
     Sglist_size = logical_block_size * (last_logical_block_addr+1 - param.getInt("LOGICAL_BLOCK_ADDR"));

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x36);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// Cache Lock/Unlock  bit
  if( param.getInt("LOCK_CACHE") != 0 )
     temp |= 0x2;

  param.set("CDB_BYTE1", temp);

  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// Reserved
  param.set("CDB_BYTE6", 0);

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_LockUnlockCache");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP") )
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();		//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Read6( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Read6( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  BYTE          NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");

// if the no. of blocks specified is 0 the CDB defaults to 256
  if (NBlocks == 0)
     NBlocks = 256;

  Sglist_size = NBlocks * logical_block_size;

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x08);
  param.set("CDB_BYTE1", 0);

// 21 bit logical block address
// MSB - bit 4 of CDB_BYTE1
// LSB - bit 0 of CDB_BYTE3
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE3", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE2", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE1", (LONG)((temp>>16)&0xff ));

// No of Blocks
  param.set("CDB_BYTE4", (LONG)NBlocks );

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Read6");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out(); //AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Read10( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Read10( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  Sglist_size = NBlocks * logical_block_size;

  if( NBlocks == 0 )
     Sglist_size = 8;

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }


  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
  param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x28);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// FUA bit
  if( param.getInt("FORCE_MEDIA_ACCESS") != 0 )
     temp |= 0x8;

// DPO bit
  if( param.getInt("CACHE_IF_POSSIBLE") == 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Read10");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	 //AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Seek6( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Seek6( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         temp = 0;
  IString       s1, s2;


// Size for the ScatGat list and No of Buffers
  param.set("MEMSIZE", 8);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x0B);
  param.set("CDB_BYTE1", 0);

  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE3", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE2", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE1", (LONG)((temp>>16)&0xff ));

// Reserved
  param.set("CDB_BYTE4", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Seek6");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");


  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_RezeroUnit( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_RezeroUnit( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         temp = 0;
  IString       s1, s2;

// Size for the ScatGat list and No of Buffers
  param.set("MEMSIZE", 8);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x01);

// Reserved
  param.set("CDB_BYTE1", 0);
  param.set("CDB_BYTE2", 0);
  param.set("CDB_BYTE3", 0);
  param.set("CDB_BYTE4", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_RezeroUnit");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_PreFetch( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_PreFetch( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         last_logical_block_addr = 0;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  last_logical_block_addr = param.getInt("LAST_LOGICAL_BLOCK_ADDR");
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  Sglist_size = NBlocks * logical_block_size;

// if the no. of blocks specified is 0 the CDB defaults to a range that
// includes all the remaining logical blocks
// Therefore making the Sglist_size equal to the remaining blocks
  if (NBlocks == 0)
     Sglist_size = logical_block_size * (last_logical_block_addr+1 - param.getInt("LOGICAL_BLOCK_ADDR"));

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x34);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// IMMED bit
  if( param.getInt("STATUS_RETURN_IMMED") != 0 )
     temp |= 0x2;

  param.set("CDB_BYTE1", temp);

  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// Reserved
  param.set("CDB_BYTE6", 0);

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Prefetch");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();		//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_LockUnlockMedia( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_LockUnlockMedia( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         temp = 0;
  IString       s1;

// Size for the ScatGat list and No of Buffers
  param.set("MEMSIZE", 8);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x1E);

// Reserved
  param.set("CDB_BYTE1", 0);
  param.set("CDB_BYTE2", 0);
  param.set("CDB_BYTE3", 0);

// Lock/Unlock  bit 0 : (1 = Lock Media,  0 = Unlock Media)
  param.set("CDB_BYTE4", 0);
  if( param.getInt("LOCK_UNLOCK") != 0 )
     param.set("CDB_BYTE4", 1);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_LockUnlockMedia");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_StartStopUnit( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_StartStopUnit( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         temp = 0;
  IString       s1;

// Size for the ScatGat list and No of Buffers
  param.set("MEMSIZE", 8);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x1B);

// IMMED bit
  param.set("CDB_BYTE1", 0);
  if( param.getInt("STATUS_RETURN_IMMED") != 0 )
     param.set("CDB_BYTE1", 1);

// Reserved
  param.set("CDB_BYTE2", 0);
  param.set("CDB_BYTE3", 0);

  param.set("CDB_BYTE4", 0);
  temp = 0;

// Start/Stop bit 1 : Unit made ready for use,
//                0 : Stops the logical unit
  if( param.getInt("START_STOP") != 0 )
     temp |= 0x1;

// Load/Eject bit 0 : No (load/unload) action is taken,
//                1 : Medium is unloaded if the start bit(bit 0) is zero.
//                    Medium is loaded if the start bit(bit 0) is one
  if( param.getInt("LOAD_EJECT") !=0 )
     temp |= 0x2;

  param.set("CDB_BYTE4", temp);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_StartStopUnit");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  return ulRc;
}


/*
*************************************************************************
** Name:         APIRET _export scsiadd_Sync_Cache( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Sync_Cache( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         last_logical_block_addr = 0;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  last_logical_block_addr = param.getInt("LAST_LOGICAL_BLOCK_ADDR");
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");

  Sglist_size = NBlocks * logical_block_size;

// if the no. of blocks specified is 0 the CDB defaults to a range that
// includes all the remaining logical blocks
// Therefore making the Sglist_size equal to the remaining blocks
  if (NBlocks == 0)
     Sglist_size =  logical_block_size * (last_logical_block_addr+1 - param.getInt("LOGICAL_BLOCK_ADDR"));

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x35);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// IMMED bit
  if( param.getInt("STATUS_RETURN_IMMED") != 0 )
     temp |= 0x2;

  param.set("CDB_BYTE1", temp);

  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// Reserved
  param.set("CDB_BYTE6", 0);

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_SyncCache");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP") )
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out(); 	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}


/*
*************************************************************************
** Name:         APIRET _export scsiadd_Write6( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Write6( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         requested_size, write_size;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  BYTE          NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  //
  // Determine the number of bytes to write.  Write the
  // minimum of:
  //   1) number of bytes requested
  //   2) size of current SCATGAT buffer
  //
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");

// if the no. of blocks specified is 0 the CDB defaults to 256
  if (NBlocks == 0)
     NBlocks = 256;

     requested_size = NBlocks * logical_block_size;

  Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
  Sglist_size = Sglist->size();

  write_size = (requested_size > Sglist_size) ? Sglist_size : requested_size;
  NBlocks = write_size/logical_block_size;
  NBlocks += (write_size % logical_block_size) ? 1 : 0;

// op code
  param.set("CDB_BYTE0", 0x0A);
  param.set("CDB_BYTE1", 0);

// 21 bit logical block address
// MSB - bit 4 of CDB_BYTE1
// LSB - bit 0 of CDB_BYTE3
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE3", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE2", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE1", (LONG)((temp>>16)&0xff ));

// No of Blocks
  param.set("CDB_BYTE4", (LONG)NBlocks );

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Write6");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Write10( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Write10( Kwd_List &param )
{
  ScatGat       *psg;

  ScatGat       *Sglist;
  ULONG         write_size, requested_size;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  //
  // Determine the number of bytes to write.  Write the
  // minimum of:
  //   1) number of bytes requested
  //   2) size of current SCATGAT buffer
  //
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  if( NBlocks == 0 )
     requested_size = 8;
  else
     requested_size = NBlocks * logical_block_size;

  Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
  Sglist_size = Sglist->size();

  write_size = (requested_size > Sglist_size) ? Sglist_size : requested_size;
  NBlocks = write_size/logical_block_size;
  NBlocks += (write_size % logical_block_size) ? 1 : 0;

// op code
  param.set("CDB_BYTE0", 0x2A);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// FUA bit
  if( param.getInt("FORCE_MEDIA_ACCESS") != 0 )
     temp |= 0x8;

// DPO bit
  if( param.getInt("CACHE_IF_POSSIBLE") == 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Write10");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	//AL
    param.files()->out1<<temp;
  }

  return ulRc;

}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_WriteAndVerify( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_WriteAndVerify( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         write_size, requested_size;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  //
  // Determine the number of bytes to write.  Write the
  // minimum of:
  //   1) number of bytes requested
  //   2) size of current SCATGAT buffer
  //
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  if( NBlocks == 0 )
     requested_size = 8;
  else
     requested_size = NBlocks * logical_block_size;

  Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
  Sglist_size = Sglist->size();

  write_size = (requested_size > Sglist_size) ? Sglist_size : requested_size;
  NBlocks = write_size/logical_block_size;
  NBlocks += (write_size % logical_block_size) ? 1 : 0;

// op code
  param.set("CDB_BYTE0", 0x2E);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// BytChk bit
  if( param.getInt("BYTE_CHECK") != 0 )
     temp |= 0x2;

// DPO bit
  if( param.getInt("CACHE_IF_POSSIBLE") == 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_WriteAndVerify");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out(); 	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_WriteSame( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_WriteSame( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         write_size, requested_size;
  ULONG         last_logical_block_addr = 0;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  //
  // Determine the number of bytes to write.  Write the
  // minimum of:
  //   1) number of bytes requested
  //   2) size of current SCATGAT buffer
  //
  last_logical_block_addr = param.getInt("LAST_LOGICAL_BLOCK_ADDR");
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");

// if the no. of blocks specified is 0 the CDB defaults to 256
  if( NBlocks == 0 )
     requested_size = logical_block_size * (last_logical_block_addr+1 - param.getInt("LOGICAL_BLOCK_ADDR"));
  else
     requested_size = NBlocks * logical_block_size;

  Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
  Sglist_size = Sglist->size();

  write_size = (requested_size > Sglist_size) ? Sglist_size : requested_size;
  NBlocks = write_size/logical_block_size;
  NBlocks += (write_size % logical_block_size) ? 1 : 0;

// op code
  param.set("CDB_BYTE0", 0x41);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// LBdata bit
  if( param.getInt("LOGICAL_BLOCK_DATA") != 0 )
     temp |= 0x2;

// PBdata bit
  if( param.getInt("PHYSICAL_BLOCK_DATA") != 0 )
     temp |= 0x4;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_WriteSame");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_ReadLong( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_ReadLong( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;
  ULONG         ECCsize = 288;        // ECC size in bytes

  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBytes = param.getInt("NUM_BYTES");

  Sglist_size = logical_block_size + ECCsize;

  param.set("MEMSIZE", (LONG)Sglist_size);

  if (!(param.isKeyword("NBUFF")))
      param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x3E);


  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// ECC Correct bit
  if(param.getInt("ECC_CORRECT") != 0 )
     temp |= 0x2;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Bytes
  param.set("CDB_BYTE8", (NBytes & 0xff));
  param.set("CDB_BYTE7", ((NBytes>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_ReadLong");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_WriteLong( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_WriteLong( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;
  ULONG         ECCsize = 288;        // ECC size in bytes

  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBytes = param.getInt("NUM_BYTES");

  Sglist_size = logical_block_size + ECCsize;

  param.set("MEMSIZE", (LONG)Sglist_size);

  if (!(param.isKeyword("NBUFF")))
      param.set("NBUFF", 1);

// op code
  param.set("CDB_BYTE0", 0x3F);

// RelAdr
  param.set("CDB_BYTE1", 0);
  if( param.getInt("ADDR_MODE") != 0 )
     param.set("CDB_BYTE1", 1);


// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Bytes
  param.set("CDB_BYTE8", (NBytes & 0xff));
  param.set("CDB_BYTE7", ((NBytes>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_WriteLong");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_SetLimits( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_SetLimits( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         last_logical_block_addr = 0;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  last_logical_block_addr = param.getInt("LAST_LOGICAL_BLOCK_ADDR");
  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  Sglist_size = NBlocks * logical_block_size;

// if the no. of blocks specified is 0 the CDB defaults to a range that
// includes all the remaining logical blocks
// Therefore making the Sglist_size equal to the remaining blocks
  if (NBlocks == 0)
     Sglist_size = logical_block_size * (last_logical_block_addr+1 - param.getInt("LOGICAL_BLOCK_ADDR"));

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x33);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// Write Inhibit bit
  if( param.getInt("WRITE_INHIBIT") != 0 )
     temp |= 0x1;

// Read Inhibit bit
  if( param.getInt("READ_INHIBIT") != 0 )
     temp |= 0x2;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_SetLimits");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Verify( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_Verify( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         logical_block_size = 0;
  ULONG         Sglist_size = 0;
  USHORT        NBlocks = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  logical_block_size = param.getInt("LOGICAL_BLOCK_SIZE");
  NBlocks = param.getInt("NUM_BLOCKS");
  Sglist_size = NBlocks * logical_block_size;

  if( NBlocks == 0 )
     Sglist_size = 8;

  param.set("MEMSIZE", (LONG)Sglist_size);
  if (!(param.isKeyword("BUF_CLUSTER_SIZE")))
      param.set("NBUFF", 1);
  else
     {
      temp = NBlocks/param.getInt("BUF_CLUSTER_SIZE");
      if (NBlocks % param.getInt("BUF_CLUSTER_SIZE") != 0)
         temp = temp + 1;
      param.set("NBUFF", temp);
      }

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x2F);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// RelAdr bit
  if( param.getInt("ADDR_MODE") != 0 )
     temp |= 0x1;

// BytChk bit
  if( param.getInt("BYTE_CHECK") != 0 )
     temp |= 0x2;

// DPO bit
  if( param.getInt("CACHE_IF_POSSIBLE") == 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// 32 bit logical block address
  temp = param.getInt("LOGICAL_BLOCK_ADDR");
  param.set("CDB_BYTE5", (LONG)(temp & 0xff ));
  param.set("CDB_BYTE4", (LONG)((temp>>8)&0xff ));
  param.set("CDB_BYTE3", (LONG)((temp>>16)&0xff ));
  param.set("CDB_BYTE2", (LONG)(temp>>24 ));

// No of Blocks
  param.set("CDB_BYTE8", (NBlocks & 0xff));
  param.set("CDB_BYTE7", ((NBlocks>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Verify");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_ReadDefectData( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:    Output to be formatted
**
**
**************************************************************************
*/
APIRET _export scsiadd_ReadDefectData( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  NBytes = param.getInt("NUM_BYTES");
  Sglist_size = NBytes ;

  if( NBytes == 0 )
     Sglist_size = 8;

  param.set("MEMSIZE", (LONG)Sglist_size);

  if (!(param.isKeyword("NBUFF")))
      param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x37);

  param.set("CDB_BYTE1", 0);
  param.set("CDB_BYTE2", 0);
  temp = 0;

// Defect List format bits
  if( param.getInt("DEFECT_LIST_FORMAT") !=0 )
     temp |= 0x1;

// Glist bit
  if( param.getInt("GROWN_DEFECT_LIST") != 0 )
     temp |= 0x8;

// Plist bit
  if( param.getInt("PRIMARY_DEFECT_LIST") == 0 )
     temp |= 0x10;

  param.set("CDB_BYTE2", temp);

// Reserved
  param.set("CDB_BYTE3", 0);
  param.set("CDB_BYTE4", 0);
  param.set("CDB_BYTE5", 0);
  param.set("CDB_BYTE6", 0);

// No of Bytes
  param.set("CDB_BYTE8", (NBytes & 0xff));
  param.set("CDB_BYTE7", ((NBytes>>8)&0xff));

// Reserved
  param.set("CDB_BYTE6", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE9", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_ReadDefectData");
  ulRc = scsiadd_CDB10(param);
  param.unset("CALLED_FROM");

//  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  if( param.getInt("IORB_ERROR_CODE") == 0 )
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out();	//AL
    param.files()->out1<<temp;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Inquiry( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:    The vital product data inquiry has not been implemented
**
**
**************************************************************************
*/
APIRET _export scsiadd_Inquiry( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  NBytes = param.getInt("NUM_BYTES");
  Sglist_size = NBytes ;

  if( NBytes == 0 )
     Sglist_size = 8;

  param.set("MEMSIZE", (LONG)Sglist_size);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x12);

// EVPD bit
  param.set("CDB_BYTE1", 0);
  if ( param.getInt("ENABLE_VITAL_PRODUCT_DATA") != 0 )
     param.set("CDB_BYTE1", 1);

// Page code
  param.set("CDB_BYTE2", param.getInt("CODE_PAGE"));

// Reserved
  param.set("CDB_BYTE3", 0);

// No of Bytes
  param.set("CDB_BYTE4", NBytes);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Inquiry");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");


  if( param.getInt("IORB_ERROR_CODE") == 0 )
  {
   s1 = print_inquiry_data(param);
   param.files()->out1<<s1;
  }

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_TestUnitReady( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_TestUnitReady( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         Sglist_size = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  Sglist_size = 8;
  param.set("MEMSIZE", (LONG)Sglist_size);
  param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0);

// Reserved
  param.set("CDB_BYTE1", 0);
  param.set("CDB_BYTE2", 0);
  param.set("CDB_BYTE3", 0);
  param.set("CDB_BYTE4", 0);

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_TestUnitReady");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");


  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_SendDiagnostic( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_SendDiagnostic( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  NBytes = param.getInt("NUM_BYTES");
  Sglist_size = NBytes ;

  if( NBytes == 0 )
     Sglist_size = 8;

  param.set("MEMSIZE", (LONG)Sglist_size);

  if (!(param.isKeyword("NBUFF")))
      param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x1D);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// Unit off-line bit
  if(param.getInt("UNIT_OFF_LINE") != 0)
     temp |=0x1;

// Device off-line bit
  if( param.getInt("DEVICE_OFF_LINE") != 0 )
     temp |= 0x2;

// Self Test bit
  if( param.getInt("SELF_TEST") != 0 )
     temp |= 0x4;

// Page format bit
  if( param.getInt("PAGE_FORMAT") != 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// Reserved
  param.set("CDB_BYTE2", 0);

// No of Bytes
  param.set("CDB_BYTE4", (NBytes & 0xff));
  param.set("CDB_BYTE3", ((NBytes>>8)&0xff));

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_SendDiagnostic");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

/*
  if( param.getInt("IORB_ERROR_CODE") == 0 && param.getInt("DATA_DUMP"))
  {
    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
    IString temp = Sglist->out(); 	//AL
    param.files()->out1<<temp;
  }
*/

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Reserve( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:    extent reservation is not implemented
**
**
**************************************************************************
*/
APIRET _export scsiadd_Reserve( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  NBytes = param.getInt("NUM_BYTES");
  Sglist_size = NBytes ;

  if( NBytes == 0 )
     Sglist_size = 8;

  if (!(param.isKeyword("MEMSIZE")))
      param.set("MEMSIZE", (LONG)Sglist_size);

  if (!(param.isKeyword("NBUFF")))
      param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x16);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// Third party device ID (bits 1-3)
   temp = param.getInt("THIRD_PARTY_DEVICE_ID");
   temp = temp<<1;

// Extent bit
  if(param.getInt("EXTENT_RESERVE") != 0)
     temp |=0x1;

// Third party release bit
  if( param.getInt("THIRD_PARTY_RESERVE") != 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// Reserveation Identification
  param.set("CDB_BYTE2", param.getInt("RESERVATION_ID"));

// No of Bytes
  param.set("CDB_BYTE4", (NBytes & 0xff));
  param.set("CDB_BYTE3", ((NBytes>>8)&0xff));

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Reserve");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_Release( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:    extent release is not implemented
**
**
**************************************************************************
*/
APIRET _export scsiadd_Release( Kwd_List &param )
{

  ScatGat       *Sglist;
  ULONG         Sglist_size = 0;
  USHORT        NBytes = 0;
  ULONG         temp = 0;
  IString       s1, s2;

  NBytes = param.getInt("NUM_BYTES");
  Sglist_size = NBytes ;

  if( NBytes == 0 )
     Sglist_size = 8;

  if (!(param.isKeyword("MEMSIZE")))
      param.set("MEMSIZE", (LONG)Sglist_size);

  if (!(param.isKeyword("NBUFF")))
      param.set("NBUFF", 1);

  Sglist = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
    param.set(param["SCATGAT"], (LONG)Sglist);

// op code
  param.set("CDB_BYTE0", 0x17);

  param.set("CDB_BYTE1", 0);
  temp = 0;

// Third party device ID (bits 1-3)
   temp = param.getInt("THIRD_PARTY_DEVICE_ID");
   temp = temp<<1;

// Extent bit
  if(param.getInt("EXTENT_RELEASE") != 0)
     temp |=0x1;

// Third party release bit
  if( param.getInt("THIRD_PARTY_RELEASE") != 0 )
     temp |= 0x10;

  param.set("CDB_BYTE1", temp);

// Reserveation Identification
  param.set("CDB_BYTE2", param.getInt("RESERVATION_ID"));

// No of Bytes
  param.set("CDB_BYTE4", (NBytes & 0xff));
  param.set("CDB_BYTE3", ((NBytes>>8)&0xff));

// Control field
  temp = SetControlByte(param);
  param.set("CDB_BYTE5", temp);

  param.set("CALLED_FROM", (IString)"scsiadd_Release");
  ulRc = scsiadd_CDB6(param);
  param.unset("CALLED_FROM");

  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_CDB12( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_CDB12( Kwd_List &param )
{
  // scather gather list to hold info.
  ScatGat               *psg;

  psg = (ScatGat *)param.getPtr(param["SCATGAT"]);

  // handle to test dd.
  HFILE drvHndle       = param.getInt("DRIVEHANDLE");
  // paramblock for test dd.
  ULONG       paramlen = sizeof(PARAMS) + sizeof(SCSI_STATUS_BLOCK);
  BYTE *pb = new BYTE[paramlen];
  IString       CalledFrom;

  PARAMS                 *paramblock = (PARAMS *)pb;
  paramblock->flag      = param.getInt("MODE");
  paramblock->DevClass  = 1; // for disks.

  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);		   //AL
  paramblock->iorb.iorb_adapter_passthru.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_adapter_passthru);
  paramblock->iorb.iorb_adapter_passthru.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandCode    = IOCC_ADAPTER_PASSTHRU;
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier= IOCM_EXECUTE_CDB;
  paramblock->iorb.iorb_adapter_passthru.iorbh.RequestControl = 8;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Status         = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Timeout        = param.getInt("TIMEOUT");
  paramblock->iorb.iorb_adapter_passthru.iorbh.pStatusBlock   = (USHORT)(OFFSETOF(pb)+sizeof(PARAMS));
  paramblock->iorb.iorb_adapter_passthru.iorbh.StatusBlockLen = sizeof(SCSI_STATUS_BLOCK);
  paramblock->iorb.iorb_adapter_passthru.Flags                = 0;
  paramblock->iorb.iorb_adapter_passthru.pSGList              = psg->entry();
  paramblock->iorb.iorb_adapter_passthru.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_adapter_passthru.ppSGLIST             = 0;
  CDB12 *cdb = new CDB12;
  cdb->byte11 = param.getInt("CDB_BYTE11");
  cdb->byte10 = param.getInt("CDB_BYTE10");
  cdb->byte9 = param.getInt("CDB_BYTE9");
  cdb->byte8 = param.getInt("CDB_BYTE8");
  cdb->byte7 = param.getInt("CDB_BYTE7");
  cdb->byte6 = param.getInt("CDB_BYTE6");
  cdb->byte5 = param.getInt("CDB_BYTE5");
  cdb->byte4 = param.getInt("CDB_BYTE4");
  cdb->byte3 = param.getInt("CDB_BYTE3");
  cdb->byte2 = param.getInt("CDB_BYTE2");
  cdb->byte1 = param.getInt("CDB_BYTE1");
  cdb->byte0 = param.getInt("CDB_BYTE0");
  paramblock->iorb.iorb_adapter_passthru.pControllerCmd      = (BYTE * _Seg16 )cdb;
  paramblock->iorb.iorb_adapter_passthru.ControllerCmdLen    = 12;

  // scsi status block for testdd / test add.
  SCSI_STATUS_BLOCK *ssb = (SCSI_STATUS_BLOCK *)(pb + sizeof(PARAMS));
  ssb->Flags = 0;
  ssb->AdapterErrorCode = 0;
  ssb->TargetStatus = 0;
  ssb->ResidualLength = 0;
  ssb->AdapterDiagInfo[0] = 0;
  ssb->SenseData   = (SCSI_REQSENSE_DATA * _Seg16 )new SCSI_REQSENSE_DATA;
  ssb->ReqSenseLen = sizeof(SCSI_REQSENSE_DATA);

  if ( param.isKeyword("CALLED_FROM"))
     CalledFrom = strdup(param["CALLED_FROM"]);

  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x08,
                         pb, paramlen, &paramlen,
                         NULL, 0, NULL,
                         CalledFrom, "only call",
                         param.files()->out1 );

  param.set("IORB_ERROR_CODE" , ((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode));

  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)pb);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = scsiadd_printstatus(param);
  }
  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_CDB10( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_CDB10( Kwd_List &param )
{
  // scather gather list to hold info.
  ScatGat               *psg;

  psg = (ScatGat *)param.getPtr(param["SCATGAT"]);

  // handle to test dd.
  HFILE drvHndle       = param.getInt("DRIVEHANDLE");
  // paramblock for test dd.
  ULONG       paramlen = sizeof(PARAMS) + sizeof(SCSI_STATUS_BLOCK);
  BYTE *pb = new BYTE[paramlen];
  IString       CalledFrom;

  PARAMS                 *paramblock = (PARAMS *)pb;
  paramblock->flag      = param.getInt("MODE");
  paramblock->DevClass  = 1; // for disks.
  
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);	//AL
  paramblock->iorb.iorb_adapter_passthru.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_adapter_passthru);
  paramblock->iorb.iorb_adapter_passthru.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandCode    = IOCC_ADAPTER_PASSTHRU;
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier= IOCM_EXECUTE_CDB;
  paramblock->iorb.iorb_adapter_passthru.iorbh.RequestControl = 8;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Status         = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Timeout        = param.getInt("TIMEOUT");
  paramblock->iorb.iorb_adapter_passthru.iorbh.pStatusBlock   = (USHORT)(OFFSETOF(pb)+sizeof(PARAMS));
  paramblock->iorb.iorb_adapter_passthru.iorbh.StatusBlockLen = sizeof(SCSI_STATUS_BLOCK);
  paramblock->iorb.iorb_adapter_passthru.Flags                = 0;
  paramblock->iorb.iorb_adapter_passthru.pSGList              = psg->entry();
  paramblock->iorb.iorb_adapter_passthru.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_adapter_passthru.ppSGLIST             = 0;
  CDB10 *cdb = new CDB10;
  cdb->byte9 = param.getInt("CDB_BYTE9");
  cdb->byte8 = param.getInt("CDB_BYTE8");
  cdb->byte7 = param.getInt("CDB_BYTE7");
  cdb->byte6 = param.getInt("CDB_BYTE6");
  cdb->byte5 = param.getInt("CDB_BYTE5");
  cdb->byte4 = param.getInt("CDB_BYTE4");
  cdb->byte3 = param.getInt("CDB_BYTE3");
  cdb->byte2 = param.getInt("CDB_BYTE2");
  cdb->byte1 = param.getInt("CDB_BYTE1");
  cdb->byte0 = param.getInt("CDB_BYTE0");
  paramblock->iorb.iorb_adapter_passthru.pControllerCmd      = (BYTE * _Seg16 )cdb;
  paramblock->iorb.iorb_adapter_passthru.ControllerCmdLen    = 10;

  // scsi status block for testdd / test add.
  SCSI_STATUS_BLOCK *ssb = (SCSI_STATUS_BLOCK *)(pb + sizeof(PARAMS));
  ssb->Flags = 0;
  ssb->AdapterErrorCode = 0;
  ssb->TargetStatus = 0;
  ssb->ResidualLength = 0;
  ssb->AdapterDiagInfo[0] = 0;
  ssb->SenseData   = (SCSI_REQSENSE_DATA * _Seg16 )new SCSI_REQSENSE_DATA;
  ssb->ReqSenseLen = sizeof(SCSI_REQSENSE_DATA);

  if ( param.isKeyword("CALLED_FROM"))
     CalledFrom = strdup(param["CALLED_FROM"]);

  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x08,
                         pb, paramlen, &paramlen,
                         NULL, 0, NULL,
                         CalledFrom, "only call",
                         param.files()->out1 );

  param.set("IORB_ERROR_CODE" , ((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode));

  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)pb);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = scsiadd_printstatus(param);
  }
  return ulRc;
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_CDB6( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_CDB6( Kwd_List &param )
{
  // scather gather list to hold info.
  ScatGat               *psg;

  psg = (ScatGat *)param.getPtr(param["SCATGAT"]);

  // handle to test dd.
  HFILE drvHndle       = param.getInt("DRIVEHANDLE");
  // paramblock for test dd.
  ULONG       paramlen = sizeof(PARAMS) + sizeof(SCSI_STATUS_BLOCK);
  BYTE *pb = new BYTE[paramlen];
  IString       CalledFrom;

  PARAMS                 *paramblock = (PARAMS *)pb;
  paramblock->flag      = param.getInt("MODE");
  paramblock->DevClass  = 1; // for disks.

  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);  	//AL
  paramblock->iorb.iorb_adapter_passthru.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_adapter_passthru);
  paramblock->iorb.iorb_adapter_passthru.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandCode    = IOCC_ADAPTER_PASSTHRU;
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier= IOCM_EXECUTE_CDB;
  paramblock->iorb.iorb_adapter_passthru.iorbh.RequestControl = 8;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Status         = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Timeout        = param.getInt("TIMEOUT");
  paramblock->iorb.iorb_adapter_passthru.iorbh.pStatusBlock   = (USHORT)(OFFSETOF(pb)+sizeof(PARAMS));
  paramblock->iorb.iorb_adapter_passthru.iorbh.StatusBlockLen = sizeof(SCSI_STATUS_BLOCK);
  paramblock->iorb.iorb_adapter_passthru.Flags                = 0;
  paramblock->iorb.iorb_adapter_passthru.pSGList              = psg->entry();
  paramblock->iorb.iorb_adapter_passthru.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_adapter_passthru.ppSGLIST             = 0;
  CDB6 *cdb = new CDB6;
  cdb->byte5 = param.getInt("CDB_BYTE5");
  cdb->byte4 = param.getInt("CDB_BYTE4");
  cdb->byte3 = param.getInt("CDB_BYTE3");
  cdb->byte2 = param.getInt("CDB_BYTE2");
  cdb->byte1 = param.getInt("CDB_BYTE1");
  cdb->byte0 = param.getInt("CDB_BYTE0");
  paramblock->iorb.iorb_adapter_passthru.pControllerCmd      = (BYTE * _Seg16 )cdb;
  paramblock->iorb.iorb_adapter_passthru.ControllerCmdLen    = 6;

  // scsi status block for testdd / test add.
  SCSI_STATUS_BLOCK *ssb = (SCSI_STATUS_BLOCK *)(pb + sizeof(PARAMS));
  ssb->Flags = 0;
  ssb->AdapterErrorCode = 0;
  ssb->TargetStatus = 0;
  ssb->ResidualLength = 0;
  ssb->AdapterDiagInfo[0] = 0;
  ssb->SenseData   = (SCSI_REQSENSE_DATA * _Seg16 )new SCSI_REQSENSE_DATA;
  ssb->ReqSenseLen = sizeof(SCSI_REQSENSE_DATA);

  if ( param.isKeyword("CALLED_FROM"))
     CalledFrom = strdup(param["CALLED_FROM"]);

  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x08,
                         pb, paramlen, &paramlen,
                         NULL, 0, NULL,
                         CalledFrom, "only call",
                         param.files()->out1 );

  param.set("IORB_ERROR_CODE" , ((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode));

  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)pb);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = scsiadd_printstatus(param);
  }
  return ulRc;
}

/*
*************************************************************************
** Name:         void IStringIORB::CheckBit(int, int, IString, IString, IString)
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
void IStringIORB::CheckBit(int bit,
                                   int AlignIndicator,
                                             IString BitStr,
                                             IString TrueStr,
                                             IString FalseStr)
{
        if (bit)
        {
                if (AlignIndicator == 1)
                        *this += align1 + BitStr + TrueStr;
                else if (AlignIndicator == 2)
                        *this += align2 + BitStr + TrueStr;
                else
                        *this += align3 + (IString)"\n          " + BitStr + TrueStr;
        }
        else
        {
                if (AlignIndicator == 1)
                        *this += align1 + BitStr + FalseStr;
                else if (AlignIndicator == 2)
                        *this += align2 + BitStr + FalseStr;
                else
                        *this += align3 + BitStr + FalseStr;
        }
}

/*
*************************************************************************
** Name:  void IStringIORB::CheckStatus(USHORT * )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
void IStringIORB::CheckStatus(USHORT * StatusAddr)
{
//        struct			//AL
struct status
        {
                USHORT  StatusFlag1     :1;
                USHORT  StatusFlag2     :1;
                USHORT  StatusFlag3     :1;
                USHORT  StatusFlag4     :1;
                USHORT  StatusUnused    :12;
        } *pBitsStatus;

//	(USHORT*) pBitsStatus = SatusAddr;		// AL adjusted casting to satisfy
        pBitsStatus = (struct status*)StatusAddr;	// CSET compiler

        *this += "          ";
        (*this).CheckBit(pBitsStatus->StatusFlag1, 2, "",
                         "The adapter device driver has completed processing the request",
                         "Request processing in progress...");
        (*this).CheckBit(pBitsStatus->StatusFlag2, 2, "",
                         "An ERROR occurred while processing the request",
                         "Successfully processed the request");
        (*this).CheckBit(pBitsStatus->StatusFlag3, 3, "",
                         "An ERROR occurred, the adapter device driver successfully recovered through retries",
                         "");
        (*this).CheckBit(pBitsStatus->StatusFlag4, 3, "",
                         "The adapter device driver has returned status info in the STATUS BLOCK",
                         "");
}

/*
*************************************************************************
** Name:   void IStringIORB::CheckErrorCode(USHORT)
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
void IStringIORB::CheckErrorCode(USHORT TheErrorCode)
{
        *this += "\n          ";
        switch(TheErrorCode)
        {
                case 256     :  *this += "Error category: IORB command an adapter device driver receives";
                                break;
                case 257     :  *this += "ERROR: Command not supported";
                                break;
                case 258     :  *this += "ERROR: Command syntax inconsistency";
                                break;
                case 259     :  *this += "ERROR: Bad scatter/gather list (0-length segment)\n                 or an underlying hardware limitation";
                                break;
                case 33028   :  *this += "ERROR: Lack of a software resource--buffer, selector, and so forth";
                                break;
                case 261     :  *this += "ERROR: Aborted";
                                break;
                case 262     :  *this += "ERROR: Internal consistency check detected by ADD";
                                break;
                case 263     :  *this += "ERROR: An operating system failure...May retry";
                                break;
                case 512     :  *this += "Error category: IORB addressed unit";
                                break;
                case 513     :  *this += "ERROR: Unit not allocated";
                                break;
                case 514     :  *this += "ERROR: Unit has been allocated previously";
                                break;
                case 515     :  *this += "ERROR: Unit not ready";
                                break;
                case 516     :  *this += "ERROR: Unit power is off";
                                break;
                case 768     :  *this += "Error category: Relative block address";
                                break;
                case 33537   :  *this += "ADDRESSING ERROR: RBA could not be located...Retry";
                                break;
                case 770     :  *this += "ERROR: RBA exceeded the allowable maximum for \n                 the media currently in the device";
                                break;
                case 33539   :  *this += "ERROR: Data requested could not be read successfully";
                                break;
                case 1024    :  *this += "Error category: Media ";
                                break;
                case 1025    :  *this += "ERROR: Media not formatted";
                                break;
                case 1026    :  *this += "ERROR: Media not supported";
                                break;
                case 1027    :  *this += "ERROR: Media write-protected";
                                break;
                case 1028    :  *this += "ERROR: Media in the drive might have been changed";
                                break;
                case 1029    :  *this += "ERROR: Media is not present";
                                break;
                case 1280    :  *this += "Error Category: Adapter";
                                break;
                case 1281    :  *this += "ERROR: Adapter's inability to communicate with the host CPU";
                                break;
                case 34050   :  *this += "ERROR: Adapter's inability to communicate with an attached device...Retry";
                                break;
                case 34051   :  *this += "ERROR: Host adapter has lost data...Retry";
                                break;
                case 34052   :  *this += "ERROR: Host adapter is unable to supply data on demand to a device...Retry";
                                break;
                case 1285    :  *this += "ERROR: Host adapter detected an internal consistency check";
                                break;
                case 34054   :  *this += "ERROR: Adapter device driver timeout...Retry";
                                break;
                case 34055   :  *this += "ERROR: Failure of a device to respond to the host adapter";
                                break;
                case 1288    :  *this += "ERROR: Request operation or function is not supported by this adapter";
                                break;
                case 1289    :  *this += "ERROR: Error can not be classified";
                                break;
                case 1290    :  *this += "ERROR: ADD cannot classify an adapter-related error condition...Retry";
                                break;
                case 1536    :  *this += "Error category: Device";
                                break;
                case 34305   :  *this += "ERROR: Incorrect parity on data received by the host adapter by the device\n          ";
                                *this += "       or a breakdown in bus protocols between the device and the host adapter...Retry";
                                break;
                case 1538    :  *this += "ERROR: The requested operation or function is not supported by this device";
                                break;
                case 1539    :  *this += "ERROR: Device detected an internal consistency check";
                                break;
                case 34308   :  *this += "ERROR: Device is busy and cannot accept the requested operation...Retry";
                                break;
                case 34309   :  *this += "ERROR: Device Overrun...Retry";
                                break;
                case 34310   :  *this += "ERROR: Device Underrun...Retry";
                                break;
                case 1543    :  *this += "ERROR: Unexpected device reset occurred...Retry";
                                break;
                case 1544    :  *this += "ERROR: A device-related error cannot be classified by the ADD";
                                break;
                default      :  break;
        }
}

/*
*************************************************************************
** Name:         APIRET _export scsiadd_printstatus(Kwd_List &)

**
** Description: Prints status block info
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export scsiadd_printstatus(Kwd_List &params)
{
  PARAMS *paramblock;
  paramblock = (PARAMS *)params.getPtr(params["LABEL"]);
  IStringIORB s1("", "\n          ", "");
  IString s2;
  s1 += params["LABEL"] + "\n";
  if (paramblock != 0)
  {
        if (paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier ==
              IOCM_EXECUTE_CDB)
        {
            s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.Status);
            s1.CheckStatus(&paramblock->iorb.iorb_adapter_passthru.iorbh.Status);
        // prints a non-zero error code only
            if ( paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode != 0)
               s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode);
            s1.CheckErrorCode(paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode);
            SCSI_STATUS_BLOCK *pssb = (SCSI_STATUS_BLOCK *)((BYTE *)paramblock + sizeof(PARAMS));
            Bits temp(pssb->Flags);
            s1 += "\n    STATUS BLOCK:  ";
            s1 += "\n           Flags           : " + (IString)(long)pssb->Flags;
            s1 += "\n           AdapterErrCode  : " + (IString)(long)pssb->AdapterErrorCode;
            s1 += "\n           TargetStatus    : " + (IString)(long)pssb->TargetStatus;
            if (temp.bit(1))
              s1 += "\n           ResidualLength  : " + (IString)(long)pssb->ResidualLength;
            if (temp.bit(3))
            {
              s1 += "\n           AdapterDiagInfo : ";
              char temp[9];
              strncpy(temp, (char *)pssb->AdapterDiagInfo, 8);
              s1 += (IString)temp;
            }
            if (temp.bit(0))
            {
              s1 += "\n\n           Request Sense Data: \n ";
              s1 += "\n           ErrCode & Valid bit  : " + (IString)(long)pssb->SenseData->ErrCode_Valid;
              s1 += "\n           SegNum          : " + (IString)(long)pssb->SenseData->SegNum;
              s1 += "\n           SenseKey        : " + (IString)(long)pssb->SenseData->SenseKey;
              s1 += "\n           INFO            : " + (IString)(char)pssb->SenseData->INFO[0];
              s1 += (IString)(char)pssb->SenseData->INFO[1];
              s1 += (IString)(char)pssb->SenseData->INFO[2];
              s1 += (IString)(char)pssb->SenseData->INFO[3];
              s1 += "\n           AddLen          : " + (IString)(long)pssb->SenseData->AddLen;
              s1 += "\n           CmdInfo         : " + (IString)(char)pssb->SenseData->CmdInfo[0];
              s1 += (IString)(char)pssb->SenseData->CmdInfo[1];
              s1 += (IString)(char)pssb->SenseData->CmdInfo[2];
              s1 += (IString)(char)pssb->SenseData->CmdInfo[3];
              s1 += "\n           AddSenseCode    : " + (IString)(long)pssb->SenseData->AddSenseCode;
              s1 += "\n           AddSenseCodeQual: " + (IString)(long)pssb->SenseData->AddSenseCodeQual;
              s1 += "\n           FieldRepUnitCode: " + (IString)(long)pssb->SenseData->FieldRepUnitCode;
              s1 += "\n           KeySpecific     : " + (IString)(char)pssb->SenseData->KeySpecific[0];
              s1 += (IString)(char)pssb->SenseData->KeySpecific[1];
              s1 += (IString)(char)pssb->SenseData->KeySpecific[2];
              s1 += "\n";
            }

            params.files()->out1<<s1;
        }
  }
  delete paramblock;
  return 0;
}

/*
*************************************************************************
** Name:   IString printdevicetable(PARAMS *)
**
** Description:  Prints the Device Table
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
IString printdevicetable(PARAMS *paramblock)
{
  DEVICETABLE *pdevicetable = paramblock->iorb.iorb_configuration.pDeviceTable;
  IStringIORB s1("", "\n          ", ""); // output alignment indicator

  if (paramblock->iorb.iorb_configuration.iorbh.Status > 1) // failed
  {
    s1 += "IORB request failed for IOCM_GET_DEVICE_TABLE.";
    s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_configuration.iorbh.Status);
    s1.CheckStatus(&paramblock->iorb.iorb_configuration.iorbh.Status);
    s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_configuration.iorbh.ErrorCode);
    s1.CheckErrorCode(paramblock->iorb.iorb_configuration.iorbh.ErrorCode);
  }
  else
  {
    s1 += "Device Table: ";
    sprintf(OutBuff, "0x%2.2x",pdevicetable->ADDLevelMajor);
    s1 += "\n    ADD major support level      : " + (IString)OutBuff;
    sprintf(OutBuff, "0x%2.2x",pdevicetable->ADDLevelMinor);
    s1 += "\n    ADD minor support level      : " + (IString)OutBuff;
    sprintf(OutBuff, "0x%4.4x",pdevicetable->ADDHandle);
    s1 += "\n    ADD handle                   : " + (IString)OutBuff;
    sprintf(OutBuff, "%d",pdevicetable->TotalAdapters);
    s1 += "\n    Number of Adapters present   : " + (IString)OutBuff;

    BYTE * buff = (BYTE *)pdevicetable;
    buff += sizeof(DEVICETABLE) + ((pdevicetable->TotalAdapters-1) * 2);

    for (int i = 0; i < pdevicetable->TotalAdapters; i++)
    {
             if (pdevicetable->TotalAdapters >32) // exceed max
                break;
             ADAPTERINFO *pa;
             pa = (ADAPTERINFO *)buff;
             s1 += "\nAdapter Information : ";
             s1 += "\n    Adapter Name                          : " +
                   (IString)(char *)pa->AdapterName;
             s1 += "\n    Number of units this adapter detected : " +
                   (IString)(long)pa->AdapterUnits;
             sprintf(OutBuff, "0x%4.4x",pa->AdapterDevBus);
             s1 += "\n    Adapter-to-device bus protocol used   : " +
                   (IString)OutBuff;
             s1 += "  ";
      Bits bit((ULONG)pa->AdapterDevBus);
             switch(bit.bit(3,4))
             {
                case 0: s1 += "(Protocol not listed)";
                        break;
                case 1: s1 += "(DASD - ST506 CAM-I)";
                        break;
                case 2: s1 += "(DASD - ST506 CAM-II)";
                        break;
                case 3: s1 += "(DASD - ESDI)";
                        break;
                case 4: s1 += "(DASD - Diskette)";
                        break;
                case 5: s1 += "(SCSI - Version-I)";
                        break;
                case 6: s1 += "(SCSI - Version-II)";
                        break;
                case 7: s1 += "(SCSI - Version-III)";
                        break;
                case 8: s1 += "(non-SCSI CD-ROM interface)";
                        break;
                default:break;
             }
      if (bit.bit(8)) s1 += "\n        Fast SCSI bus timings";
      if (bit.bit(9)) s1 += "\n        8-bit bus width";
      if (bit.bit(10)) s1 += "\n        16-bit bus width";
      if (bit.bit(11)) s1 += "\n        32-bit bus width";

             s1 += "\n    Adapter IO Access      : " + (IString)(long)pa->AdapterIOAccess;
      bit = (ULONG)pa->AdapterIOAccess;
      if (!bit.bit(0)) s1 += "\n        -- I/O access not listed";
      if (bit.bit(0)) s1 += "\n        -- BusMaster I/O Access";
      if (bit.bit(1)) s1 += "\n        -- Programmed INs/OUTs";
      if (bit.bit(2)) s1 += "\n        -- 2nd-party DMA adapter";
      if (bit.bit(3)) s1 += "\n        --Memory-mapped I/O";

             sprintf(OutBuff, "0x%4.4x", pa->AdapterHostBus);
             s1 += "\n    Adapter Host Bus       : " + (IString)OutBuff;
             s1 += "\n        ";
      bit = (ULONG)pa->AdapterHostBus;
             switch(bit.bit(3,4))
             {
                case 0:  s1 += "-- Bus type not listed";
                         break;
                case 1:  s1 += "-- ISA";
                         break;
                case 2:  s1 += "-- Extended ISA";
                         break;
                case 3:  s1 += "-- Micro-channel";
                         break;
                case 15: s1 += "-- Bus type unknown";
                         break;
                default: break;
             }

             s1 += "\n        ";
             switch(bit.bit(7,4))
             {
                case 1:  s1 += "-- 8-bit bus";
                         break;
                case 2:  s1 += "-- 16-bit bus";
                         break;
                case 3:  s1 += "-- 32-bit bus";
                         break;
                case 4:  s1 += "-- 64-bit bus";
                         break;
                case 15: s1 += "-- Bus width unknown";
                         break;
                default: break;
             }

             s1 += "\n    Adapter SCSI Target ID : " + (IString)(long)pa->AdapterSCSITargetID;
             s1 += "\n    Adapter SCSI LUN       : " + (IString)(long)pa->AdapterSCSILUN;
             s1 += "\n    Adapter Flags          : " + (IString)(long)pa->AdapterFlags;
      bit = (ULONG)pa->AdapterFlags;
      if (bit.bit(0)) s1 += "\n        --This adapter supports >16M address";
      if (bit.bit(1)) s1 += "\n        --This adapter supports IBM SCBs";
      if (bit.bit(2)) s1 += "\n        --The hardware supports scatter/gather";
      if (bit.bit(3)) s1 += "\n        --The hardware supports cylinder/head/sector addressing";
      if (bit.bit(4)) s1 += "\n        --The adapter supports more than one device bus";

             buff += (sizeof(ADAPTERINFO) - sizeof(UNITINFO));
             for (int j = 0; j < pa->AdapterUnits; j++)
             {
               s1 += "\nUnit Info : ";
               s1 += "\n    Unit Adapter Index   : " + (IString)(long)pa->UnitInfo[j].AdapterIndex;
               s1 += "\n    Unit Index           : " + (IString)(long)pa->UnitInfo[j].UnitIndex;
        Bits bit((ULONG)pa->UnitInfo[j].UnitFlags);
               sprintf(OutBuff, "0x%4.4x",pa->UnitInfo[j].UnitFlags);
               s1 += "\n    Unit Flags           : " + (IString)OutBuff;
               if (bit.bit(0)) s1 += "\n        --This unit's media is removable";
               if (bit.bit(1)) s1 += "\n        --This unit can detect media removal";
               if (bit.bit(2)) s1 += "\n        --This unit supports read prefetch";
               if (bit.bit(3)) s1 += "\n        --This unit manages drive A:";
               if (bit.bit(4)) s1 += "\n        --This unit manages drive B:";
               if (bit.bit(5)) s1 += "\n        --The driver Suppresses DASD manager support";
               if (bit.bit(6)) s1 += "\n        --The driver Suppresses SCSI manager support";
               if (bit.bit(7)) s1 += "\n        --This unit is defective";

               s1 += "\n    Unit Handle          : " + (IString)(long)pa->UnitInfo[j].UnitHandle;
               s1 += "\n    Unit FilterADDHandle : " + (IString)(long)pa->UnitInfo[j].FilterADDHandle;
        bit = (ULONG)pa->UnitInfo[j].UnitType;
               sprintf(OutBuff, "%4.4x", pa->UnitInfo[j].UnitType);
               s1 += "\n    Unit Type            : " + (IString)OutBuff;
               s1 += "  ";
               switch(bit.bit(3,4))
               {
                        case 0: s1 += "(Direct access (DASD))";
                        break;
                    case 1: s1 += "(Tape)";
                            break;
                    case 2: s1 += "(Printer)";
                            break;
                    case 3: s1 += "(Processor)";
                            break;
                    case 4: s1 += "(Write Once/Read Many)";
                            break;
                    case 5: s1 += "(CD ROM)";
                            break;
                    case 6: s1 += "(Scanner)";
                            break;
                    case 7: s1 += "(Optical disk)";
                            break;
                    case 8: s1 += "(Changer (example, jukebox))";
                            break;
                    case 9:     s1 += "(Communication)";
                            break;
                    default:
             break;
               }
               s1 += "\n    Unit Queuing Count   : " + (IString)(long)pa->UnitInfo[j].QueuingCount;
               s1 += "\n    Unit SCSI Target ID  : " + (IString)(long)pa->UnitInfo[j].UnitSCSITargetID;
               s1 += "\n    Unit SCSI LUN        : " + (IString)(long)pa->UnitInfo[j].UnitSCSILUN;
               buff += sizeof(UNITINFO);
             }
    }
  }
  delete pdevicetable;
  return s1;
}

/*
*************************************************************************
** Name:  IString hex(IString)
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/

IString hex(IString s)
{
  char ch[7];
  sprintf(ch, "0x%.4X", s.asInt());
  return (IString)ch;
}

/*
*************************************************************************
** Name: IString print_inquiry_data( Kwd_List & )
**
** Description:  Prints the Inquiry data returned by the INQUIRY command
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
IString print_inquiry_data( Kwd_List &param )
{

IString         s1, s2;
ScatGat         *Sglist;
UCHAR           tempdata[127];

    Sglist = (ScatGat *)param.getPtr(param["SCATGAT"]);
     if( Sglist->GetByte( &tempdata, 0, 96 ) )
     {
        s2 = "ScatGat :: GetByte Failed ";
        s2 += "\n";
        param.files()->out1<<s2;
        return FALSE;
     }

     s1 = "\n";

     Bits byte0(tempdata[0]);
     s1 += "\n     Peripheral device type: " ;
     s1 += (ULONG)byte0.bit(0,5);
     switch(byte0.bit(0,5))
     {
        case 0: s1 += "\n        (Direct-access device,  e.g. magnetic disk)";
                break;
        case 1: s1 += "\n        (Sequential-access device, e.g. magnetic tape)";
                break;
        case 2: s1 += "\n        (Printer device)";
                break;
        case 3: s1 += "\n        (Processor device)";
                break;
        case 4: s1 += "\n        (Write once device, e.g. some optical disks)";
                break;
        case 5: s1 += "\n        (CD ROM device.)";
                break;
        case 6: s1 += "\n        (Scanner device.)";
                break;
        case 7: s1 += "\n        (Optical memory device, e.g. some optical disks)";
                break;
        case 8: s1 += "\n        (Medium changer device, e.g. jukeboxes)";
                break;
        case 9: s1 += "\n        (Communications device)";
                break;
        case 0x0A:
        case 0x0B: s1 += "\n        (Defined by ASC IT8 (Graphic arts pre-press devices))";
                break;
        case 0x0C:
        case 0x0D:
        case 0x0E: s1 += "\n        (Reserved)";
                break;
        case 0x1F: s1 +="\n        (Unknown or no device type)";
                break;
        default:
                break;
     }

     s1 += "\n     Peripheral qualifier:   ";
     s1 += (ULONG)byte0.bit(5,3);
     switch(byte0.bit(5,3))
     {
        case 0: s1 += "\n        (The specified device type is currently connected to this logical unit)";
                break;
        case 1: s1 += "\n        (The target is capable of supporting the specified peripheral device type on this logical unit)";
                break;
        case 2: s1 += "\n        (Reserved)";
                break;
        case 3: s1 += "\n        (The target is not capable of supporting a physical device on this logical unit)";
                break;
        case 4:
        case 5:
        case 6:
        case 7: s1 += "\n        (Vendor-specific)";
                break;
        default:
                break;
     }


     Bits byte1(tempdata[1]);
     s1 += "\n     Device-type modifier:   ";
     s1 += (ULONG)byte1.bit(0,7);

     s1 += (IString)"\n     Media Type:   ";
     s1 += (ULONG)byte1.bit(7);
     if(byte1.bit(7))
        s1 += "\n        (The Media on this device is removable)";
     else
        s1 += "\n        (The Media on this device is not removable)";


     Bits byte2(tempdata[2]);
     s1 += "\n     ANSI-approved version:  ";
     s1 += (ULONG)byte2.bit(0,3);
     switch(byte2.bit(0,3))
     {
        case 0: s1 += "\n        (The device might or might not comply to an ANSI-approved standard)";
                break;
        case 1: s1 += "\n        (The device complies to ANSI X3.131-1986 (SCSI-1))";
                break;
        case 2: s1 += "\n        (The device complies to ANSI X3.131-199X version of SCSI (SCSI-2))";
                break;
        case 3:
        case 4:
        case 5:
        case 6:
        case 7: s1 += "\n        (Reserved)";
                break;
        default:
                break;
     }

     s1 += "\n     ECMA version:   ";
     s1 += (ULONG)byte2.bit(3,3);
     if(byte2.bit(3,3) == 0)
        s1 += "\n        (The target does not claim complaince to ECMA version of SCSI (ECMA-111))";

     s1 += (IString)"\n     ISO version:   ";
     s1 += (ULONG)byte2.bit(6,2);
     if(byte2.bit(6,2) == 0)
        s1 += "\n        (The target does not claim complaince to ISO version of SCSI (ISO 9316))";

     Bits byte3(tempdata[3]);
     s1 += "\n     Response data format:   ";
     s1 += (ULONG)byte3.bit(0,4);
     switch(byte3.bit(0,4))
     {
        case 0: s1 += "\n        (Data format is as specified in SCSI-1)";
                break;
        case 1: s1 += "\n        (Compatible with some products that were designed prior to the development of this standard(ie. CCS) )";
                break;
        case 2: s1 += "\n        (The data shall be in the format specified in the international standard)";
                break;
        default: s1 += "\n        (Reserved)";
                break;
     }

     s1 += "\n     Terminate I/O process:   ";
     s1 += (ULONG)byte3.bit(6);
     if(byte3.bit(6))
        s1 += "\n        (The device supports the TERMINATE I/O PROCESS message) ";
     else
        s1 += "\n        (The device does not support the TERMINATE I/O PROCESS message) ";

     s1 += "\n     Async event notification capability:   ";
     s1 += (ULONG)byte3.bit(7);
// if it is a processor device
     if(byte0.bit(0,5) != 3)
       s1 += "\n        (This is not a processor device)";
     else
     {
       if(byte3.bit(7))
         s1 += "\n        (The processer device is capable of accepting asynchronous event notifications)";
       else
         s1 += "\n        (The processor device does not support asynchronous event notifications)";
     }

     s1 += "\n     Additional length in bytes (of parameters): ";
     s1 += (ULONG)tempdata[4];


     Bits byte7(tempdata[7]);
     s1 += "\n     Reset response:   ";
     s1 += (ULONG)byte7.bit(0);
     if(byte7.bit(0))
        s1 += "\n        (The device responds to the RESET condition with the soft RESET alternative) ";
     else
        s1 += "\n        (The device responds to the RESET condition with the hard RESET alternative) ";

     s1 += "\n     Command queuing:   ";
     s1 += (ULONG)byte7.bit(1);
     if(byte7.bit(1))
        s1 += "\n        (The device supports tagged command queuing for this logical unit) ";
     else
        s1 += "\n        (The device does not support tagged command queuing for this logical unit) ";

     s1 += "\n     Linked commands:   ";
     s1 += (ULONG)byte7.bit(3);
     if(byte7.bit(3))
         s1 += "\n        (The device supports linked commands for this logical unit)";
       else
         s1 += "\n        (The device does not support linked commands for this logical unit)";

     s1 += "\n     Synchronous Transfer:   ";
     s1 += (ULONG)byte7.bit(4);
     if(byte7.bit(4))
         s1 += "\n        (The device supports synchronous data transfer)";
       else
         s1 += "\n        (The device does not support synchronous data transfer)";

     s1 += "\n     Wide bus 16:   ";
     s1 += (ULONG)byte7.bit(5);
     if(byte7.bit(5))
         s1 += "\n        (The device supports 16-bit wide data transfers)";
       else
         s1 += "\n        (The device does not support 16-bit wide data transfers)";

     s1 += "\n     Wide bus 32:   ";
     s1 += (ULONG)byte7.bit(6);
     if(byte7.bit(6))
         s1 += "\n        (The device supports 32-bit wide data transfers)";
       else
         s1 += "\n        (The device does not support 32-bit wide data transfers)";

     if(!byte7.bit(5) && !byte7.bit(6))
        s1 += "\n        (The device only supports 8-bit wide data transfers)";

     s1 += "\n     Relative addressing:   ";
     s1 += (ULONG)byte7.bit(7);
     if(byte7.bit(7))
         s1 += "\n        (The device supports the relative addressing mode for this logical unit)";
       else
         s1 += "\n        (The device does not support relative addressing for this logical unit)";

     s1 += "\n     Vendor identification:   ";
     for(int i=8; i<=15; i++)
        s1 += tempdata[i];

     s1 += "\n     Product identification:   ";
     for(i=16; i<=31; i++)
        s1 += tempdata[i];

     s1 += "\n     Product revision level:   ";
     for( i=32; i<=35; i++)
        s1 += tempdata[i];
     s1 += "\n     Vendor-specific info:   ";
     for( i=36; i<=55; i++)
        s1 += tempdata[i];

     s1 += "\n";
     return s1;
}
/*
*************************************************************************
** Name:          APIRET SetControlByte( Kwd_List & )
**
** Description:   Sets the Control field (LINK and FLAG bits)
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET SetControlByte( Kwd_List &param )
{
   ULONG   temp = 0;

// Link bit
  if( param.getInt("CONTROL_LINK") != 0 )
     temp |= 0x1;

// Flag bit
  if( param.getInt("CONTROL_FLAG") != 0 )
     temp |= 0x2;

return temp;

}

/*
*************************************************************************
** Name: ULONG swaplong(ULONG)
**
** Description:   Reverses the bytes in a ULONG
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/

ULONG swaplong(ULONG swap)
{

        return (swap>>24 |
               (((swap << 8) >>24)<<8) |
               (((swap <<16) >>24) <<16) |
                  swap<<24);
}

