/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Jan. 1994.
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**
** Revisions:
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#ifndef kwdlist_h
#define kwdlist_h
#include "threadio.h"
#include "genlist.h"

class _export Kwd: public DdtObject<IString>                           //@01
{
public:
  Kwd(const IString& k, const IString& v):DdtObject<IString>(k){val(v);};       //@01
  virtual ~Kwd(){};
  virtual void val(const IString& v){val_ = v;};
  virtual IString val(){return val_;};
private:
  IString val_;
};

//#pragma warn -hid (not supported under CSET)

class _export Kwd_List: public List<IString, IString>
{
public:
  Kwd_List():List<IString, IString>(""){};         // Creates an empty list
  virtual ~Kwd_List(){};                         // Deletes the list
  virtual void set(const IString & kwd, const IString & value);    // Adds/changes keyword-value pair to the list
  virtual void set(const IString & kwd, const INT & value) {this->set(kwd,(LONG)value);};
  virtual void set(const IString & kwd, const USHORT & value);
  virtual void set(const IString & kwd, const LONG & value);        //AL added to avoid having to cast non-IStrings
  virtual void set(const IString & kwd, const ULONG & value);        //AL added to avoid having to cast non-IStrings
  virtual void unset(const IString &kwd);                // Removes a keyword-value pair from the list
  virtual IString operator[](IString kwd);         // Returns the corresponding value to a keyword
  virtual long int getInt(const IString &kwd);           // Returns a sscanf'd int corresponding to a keyword
  virtual unsigned long int getUnsigned(const IString & kwd); // Returns a sscanf'd unsigned corresponding to a keyword
  virtual void * getPtr(const IString & kwd);             // Returns a sscanf'd pointer corresponding to a keyword
  virtual BOOL isKeyword(const IString &kwd);            // Returns true if the keyword is known
  virtual void operator()(int inx, IString& kwd, IString& value);// Numerically indexes the list
  virtual int nKey() {return size();};   		    // Returns the number of entries on the list
  virtual FileInfo * files(); 					// Returns a pointer corresponding to the FILES keyword
};

//#pragma warn .hid

#endif

