/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Feb. 1994.
**
** Revisions: Barkha J. Herman, 05/10/94, added comments, headers.
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**   @02- ADL -11/16/94 - added <ary_type, elm_type> to four list operators
**          ADL 01/31/95  - removed "virtual" from in front of List::operator=, List::add, and list::operator[]
**                                      (trying to compile without hidden function warnings)
**
** Comments:
**
** Public Class/ Functions:
**   template <class T> class _export Object     //@01 eliminated
**   template <class a, class e> class _export List:public Object<e>
**
*************************************************************************
*/
#ifndef genlist_h
#define genlist_h

#ifndef NULL
#define NULL 0
#endif

typedef void(*pfn)(void*);

#include "ddtlist.h"
//--------------elminated class Object------------------@01
//
// Template <class a, class e> List - Dynamic array of template <class e> Objects.
//
template <class ary_type, class elm_type>
class _export List : public DdtObject<ary_type>                            //@01
{
  public:
    List(ary_type, unsigned b = 20, unsigned g = 20); // Constructor
    List(List<ary_type, elm_type>&);                  // Copy Constructor
    virtual ~List();                                  // Destructor
    
    virtual DdtObject<elm_type> * 	find(elm_type);              //@01
    virtual DdtObject<elm_type> *	remove(elm_type);                 //@01
    virtual void iterate(pfn);                                     
    List<ary_type, elm_type>&        operator=(List<ary_type, elm_type>&);        //@01 @02
    virtual inline List<ary_type, elm_type>& operator+=(DdtObject<elm_type>*);            //@01 @02
    virtual List<ary_type, elm_type>& 	     insert(DdtObject<elm_type>*, unsigned pos);  //@01 @02
//    virtual inline List&	             operator-=(elm_type);
    virtual List<ary_type, elm_type>&	     operator-=(elm_type);                        //@01 @02
    virtual inline List<ary_type, elm_type>& operator-=(DdtObject<elm_type>*);            //@01 @02
    inline DdtObject<elm_type> *     operator[](unsigned);         			  //@01
    virtual inline unsigned begin();
    virtual inline unsigned grow();
    virtual inline unsigned size();
  protected:
    void add(DdtObject<elm_type>*);                               //@01
    virtual void del(elm_type);
    virtual void del(DdtObject<elm_type>*);                                //@01
  private:
    void ShrinkOrGrow();
    DdtObject<elm_type> ** list;                                               //@01
    unsigned pgrow;
    unsigned pbegin;
    int nels;
    unsigned space;
};
//
// Operator += - adds given DdtObject to List.                            //@01
//
template <class a, class e>
inline List<a, e>& List<a, e>::operator+=(DdtObject<e>* obj) {      //@01
  add(obj);
  return *this;
}
//
// Operator -= - removes given DdtObject from List.                   //@01
//
template <class a, class e>
inline List<a, e>& List<a,e>::operator-=(DdtObject<e>* key) {      //@01
  del(key);
  return *this;
}
//
// Operator [] - returns nth DdtObject in List.                            //@01
//
template <class a, class e>
inline DdtObject<e>* List<a,e>::operator[](unsigned inx) {           //@01
  if(inx<nels) return list[inx];
  else return NULL;
}
//
// returns begining number of elements.
//
template <class a, class e>
inline unsigned List<a,e>::begin() {
  return pbegin;
}
//
// returns last growth number.
//
template <class a, class e>
inline unsigned List<a,e>::grow() {
  return pgrow;
}
//
// returns number of elements.
//
template <class a, class e>
inline unsigned List<a,e>::size() {
  return nels;
}

#pragma define (List<IString, ULONG>)
#pragma define (List<ULONG, IString>)
#pragma define (List<IString, IString>)

//-------------------------------putting geninst.h here---- @01
//#include <IString.hpp>
//* Possible instantiations  of List
//typedef unsigned long TID;
//typedef List<IString, TID> 	dummy1;
//typedef List<TID, IString>	dummy2;
//typedef List<IString, IString>	dummy3;
#endif
