/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Feb. 1994.
**
** Revisions: Barkha J. Herman - 05/10/94 - added comments, headers.
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**                             and replacing key() with setkey or getkey method
**
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#include "ddtos2.h"
#include "genlist.h"
//--------------------eliminated class Object ----------------- 01
/*
*************************************************************************
** Name:        template<class a, class e>
**              List<a,e>::List(a, unsigned, unsigned)
**
** Description: Constructor for template <class a, class e>List.
**              Calls ShrinkorGrow to allocate begining space.
**
** Parameters:  a        - array key
**              unsigned - begining number os elements.
**              unsigned - growth margin.
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
List<a,e>::List(a k, unsigned b, unsigned g):
DdtObject<a>(k),                                                                     //@01
pbegin(b),
space(0),
pgrow(g),
nels(0)
{
  ShrinkOrGrow();
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              List<a, e>::List(List<a,e>& rhs)
** Description: Copy constructor - copy given List.
**
** Parameters:  List &.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
List<a, e>::List(List<a,e>& rhs):
//DdtObject<a>(rhs.key()),                                                        //@01
DdtObject<a>(rhs.getkey()),                                                        //@01
nels(0)
{
  operator=(rhs);
}
/*
*************************************************************************
** Name:        template<class a, cla
**              List<a,e>::~List() 
** Description: Destructor.
**
** Parameters:  None.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
List<a,e>::~List()
{
  for(unsigned i = 0; i<nels; i++) delete list[i];
  nels = 0;
  delete[] list;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              DdtObject<e> * List<a,e>::find(e)
** Description: Find DdtObject with given key in List.
**
** Parameters:  DdtObject key e.
**
** Returns:     DdtObject<e> *.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
DdtObject<e> * List<a,e>::find(e k)                                            //@01
{
  DdtObject<e> * retvalue = NULL;                                             //@01
  for(unsigned i = 0; i<nels; i++)
  {
    DdtObject<e> * listi = list[i];                                                 //@01
//    e listikey = listi->key();
    e listikey = listi->getkey();
    BOOL cond = (k==listikey);
    if(cond)
    {
      retvalue = list[i];
      break;
    }
  }
  return retvalue;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              DdtObject<e> * List<a,e>::remove(e)
** Description: Remove DdtObject with given key from the List.
**
** Parameters:  DdtObject key e.
**
** Returns:     DdtObject<e> *.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
DdtObject<e> * List<a,e>::remove(e k)                                      //@01
{
  DdtObject<e> * obj = NULL;                                                   //@01
  for(unsigned i = 0; i<nels && obj == NULL; i++)
//    if(k==list[i]->key()) obj = list[i];
    if(k==list[i]->getkey()) obj = list[i];                                      //@01
  if(obj)
  {
    for(unsigned j = i-1; j<nels-1; j++)
      list[j] = list[j+1];
    list[j] = NULL;
    nels--;
    ShrinkOrGrow();
  }
  return obj;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              void List<a,e>::iterate(pfn) 
** Description: Call given function for each element in List.
**
** Parameters:  function pointer.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
void List<a,e>::iterate(pfn fn)
{
  for(unsigned i = 0; i<nels; i++) fn(list[i]);
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              List<a,e>& List<a,e>::operator=(List<a, e>& rhs)
** Description: Assignment operator - assign rhs to List.
**
** Parameters:  List &.
**
** Returns:     List &.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
List<a,e>& List<a,e>::operator=(List<a, e>& rhs)
{
  if(nels)
  {
    for(unsigned i = 0; i<nels; i++) delete list[i];
    nels = 0;
    delete[] list;
  }
  nels = rhs.size();
  pbegin = rhs.begin();
  pgrow = rhs.grow();
  space=0;
  ShrinkOrGrow();
  for(unsigned i = 0; i<nels; i++) list[i] = rhs[i];
  return *this;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              List<a,e>& List<a,e>::insert(DdtObject<e>* obj, unsigned pos)
** Description: Insert given DdtObject at given offset in List.
**
** Parameters:  DdtObject *, unsigned pos.
**
** Returns:     List &.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
List<a,e>& List<a,e>::insert(DdtObject<e>* obj, unsigned pos) {        //@01
  nels++;
  ShrinkOrGrow();
  for(unsigned i = nels-1; i>pos; i--) list[i] = list[i-1];
  if(pos<nels) list[pos] = obj;
  return *this;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              void List<a,e>::add(DdtObject<e>* obj) {
** Description: add given DdtObject to the List.
**
** Parameters:  DdtObject *.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
void List<a,e>::add(DdtObject<e>* obj) {                                 //@01
  nels++;
  ShrinkOrGrow();
  list[nels-1] = obj;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              void List<a,e>::del(e key) {
** Description: removes and deletes DdtObject with given key from the List.
**
** Parameters:  DdtObject key e.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
void List<a,e>::del(e key) {
  DdtObject<e> * obj = remove(key);                                           //@01
  delete obj;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              void List<a,e>::del(DdtObject<e>* k)
** Description: Removes and deletes given DdtObject from the List.
**
** Parameters:  DdtObject *.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
void List<a,e>::del(DdtObject<e>* k)                                          //@01
{
  for(unsigned i = 0; i<nels; i++)
    if(k==list[i])
    {
      delete k;
      break;
    }
  if(i<nels)
  {
    for(unsigned j = i; j<nels-1; j++)
      list[j] = list[j+1];
    list[j] = NULL;
    nels--;
    ShrinkOrGrow();
  }
}
/*
*************************************************************************
** Name:
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class a, class e>
List<a, e>& List<a,e>::operator-=(e key)
{
  del(key);
  return *this;
}
/*
*************************************************************************
** Name:        template<class a, class e>
**              void List<a, e>::ShrinkOrGrow()
** Description: This function increases or decreases the size of the
**              dynamic array as required.
**
** Parameters:  None.
**
** Returns:     None.
**
** Cautions:
**
**
**************************************************************************
*/
template<class a, class e>
void List<a, e>::ShrinkOrGrow()
{
  long lspace = space;
  long lpgrow = pgrow;
  if(space == 0)                 // if no space allocated for array.
  {
    space = pbegin;
    list = new DdtObject<e>*[space];  // allocate begining space.    //@01
  }
  // if space adjustment is required.
  else if((nels > space) || (nels < (lspace-2*lpgrow)))
  {
    // grow by atleast pgrow, never fall below begining size.
    unsigned frames = (nels-pbegin)/pgrow + 1;
    unsigned newsize = pbegin + frames*pgrow;
    space = newsize;
    // save old list, create new, copy all elements, delete old list.
    DdtObject<e> ** oldlist = list;                                              //@01
    list = new DdtObject<e>*[space];                                         //@01
    for(unsigned i = 0; i<nels; i++) list[i] = oldlist[i];
    delete[] oldlist;
  }
}
