/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Mar. 1994.
**
** Revisions:
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#ifndef dlllist_h
#define dlllist_h

#include "kwdlist.h"

void _export killDllList();

typedef APIRET (*mypfn)(Kwd_List&);

class _export DdtPFN: public DdtObject<IString> {                      //@01
public:
  DdtPFN(IString, unsigned long);
  virtual ~DdtPFN(){};

  APIRET operator()(Kwd_List& kl){return (*pfn_)(kl);};
  BOOL valid() {return (pfn_!=0);};
  unsigned long errcode() {return errcode_;};
private:
  unsigned long errcode_;
  mypfn * pfn_;
};

class _export Dll: public List<IString, IString> {
public:
  Dll(IString);
  virtual ~Dll();

  DdtPFN& operator()(IString);
  BOOL valid() {return (handle!=0);};
  unsigned long errcode() {return errcode_;};
private:
  unsigned long errcode_;
  unsigned long handle;
};

class _export DllList: public List<IString, IString> {
public:
  DllList(): List<IString, IString>(""){};
  virtual ~DllList(){};

  Dll& dll(IString);
};

extern DllList * dlllist;

#endif
