/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richrd Copeland, Jan. 1994.
**
** Revisions:
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#ifndef device_h
#define device_h
#include "kwdlist.h"

class _export Call_Frame: public Kwd_List {
public:
  Call_Frame(){};
  virtual ~Call_Frame(){};

//  virtual IString cmd(){return key();};                              
  virtual IString cmd(){return getkey();};                                 //@01
//  virtual void cmd(IString& newcom){key() =newcom;};           //@01
  virtual void cmd(IString& newcom){setkey(newcom);};            //@01
  virtual Kwd_List& kwd_list(){return *this;};
};
/*
*************************************************************************
** Name:         class Cmd_Syntax_List
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
class _export Cmd_Syntax_List: public List<IString, IString> {
public:
  Cmd_Syntax_List():List<IString, IString>(""){};
  virtual ~Cmd_Syntax_List(){};
  virtual void append(Call_Frame * cf){operator+=(cf);};
  virtual void operator()(IString cmd, IString& dll_name, IString& func_name);
  virtual BOOL syntax_check(Call_Frame&);
};
/*
*************************************************************************
** Name:         class _export Device
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
class _export Device: public Cmd_Syntax_List
{
public:
  Device(IString);
  virtual ~Device(){};
  virtual Cmd_Syntax_List &syntax(){return *this;};
  virtual BOOL isempty(){return empty;};
  virtual APIRET execute(Call_Frame&);
  virtual APIRET checkExpected(Call_Frame&);
private:
  VOID parssyntax(IString);
  BOOL empty;
};

IString _export parseWord(IString& str, char sep);

#endif


