//***************************************************************************/
//
// Filename:      DDTSCSI.CPP
//
// Description:   Device driver test, SCSI IOCtl functions.
//
// Owner:         Kishan Kasety
//
// Last Modified: 8/13/94
//
// changes:	  11/29/94 Adam Loving
//			   added conversions from long/ulong to IString
//			   in statements where IStrings were being added
//		
//
//***************************************************************************/

#include "apicover.h"
#include "ddtscsi.h"
#include "bit.h"

// Global variables
ULONG  ulRc;

VOID  printerror(ULONG&, Kwd_List &);

/*
*************************************************************************
** Name: APIRET _export SCSI_Open(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_Open( Kwd_List& param )
{
  ULONG   ulAction  = 0;
  ULONG   ulOpenFlag;
  ULONG   ulOpenMode;
  HFILE   hfDrvHandle;

  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE ;


  ulRc = ddtDosOpen( "SCSI-02$", &hfDrvHandle,
                     &ulAction, 0L, 0L, ulOpenFlag,
                     ulOpenMode, NULL, "SCSI_Open",
                     "only call",
                     param.files()->out1 );

  param.files()->out1.flush();
  if (ulRc != 0)
  {
    IString s1 = "Device failed to open.  Aborting Script";
    param.files()->out1<<s1;
    param.files()->out1.flush();
    exit(ulRc);
  }
  param.set("DRIVEHANDLE", (IString)(long)hfDrvHandle );  //AL added extra conversion
  return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_Close(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_Close( Kwd_List& param )
{
  HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosClose( hfDrvHandle,
                      "SCSI_Close",
                      "only call",
                      param.files()->out1 );

  param.files()->out1.flush();
  return ulRc;
}


/*
*************************************************************************
** Name: APIRET _export SCSI_ReadDevParams(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export SCSI_ReadDevParams( Kwd_List& param )
{
  struct
  {
    USHORT        usDevKeyIndex;
    BYTE          SCB;
    BYTE          AdapterIndex;
    USHORT        usDevFlags;
    BYTE          LUN;
    BYTE          PUN;
  } data;


   IString   s1, s2;
   ULONG    ulDataSize = sizeof(data);
   HFILE    hfDrvHandle = param.getInt("DRIVEHANDLE");
   HFILE    hfDevHandle = param.getInt("DEVICEHANDLE");
   ULONG    ulParamSize = sizeof(hfDevHandle);

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x43,
                          &hfDevHandle, ulParamSize,
                          &ulParamSize, &data,
                          ulDataSize, &ulDataSize,
                          "SCSI_ReadDevParams",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    s1 = "Device Key Index : ";
    s1 = s1 + (IString)(long)data.usDevKeyIndex + (IString)"\nSCB Architecture Card Comp. Level : ";
    s1 = s1 + (IString)(long)data.SCB + (IString)"\nAdapter Index : ";
    s1 = s1 + (IString)(long)data.AdapterIndex + (IString)"\nDevice Flags : ";
    s1 = s1 + (IString)(long)data.usDevFlags + (IString)"\nLogical Unit Number (LUN) : ";
    s1 = s1 + (IString)(long)data.LUN + (IString)"\nPhysical Unit Number (PUN) : ";
    s1 = s1 + (IString)(long)data.PUN;
  }
   param.files()->out1<<s1;
   param.files()->out1.flush();
   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_ResetInitialize(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_ResetInitialize(Kwd_List & param)
{
  struct
  {
    HFILE          hfDevHandle;
    USHORT         usSenseDataSize;
  } paramblock;

   HFILE     hfDrvHandle = param.getInt("DRIVEHANDLE");
   ULONG     ulParamSize = sizeof(paramblock);
   paramblock.hfDevHandle = param.getInt("DEVICEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x45,
                          &paramblock, ulParamSize,
                          &ulParamSize, NULL, 0, NULL,
                          "SCSI_ResetInitialize",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);

   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_EnableAdapterCache(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_EnableAdapterCache(Kwd_List & param)
{
   IString s1;
   HFILE      hfDevHandle = param.getInt("DEVICEHANDLE");
   ULONG      ulParamSize = sizeof(hfDevHandle);
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x4D,
                          &hfDevHandle, ulParamSize,
                          &ulParamSize, NULL, 0, NULL,
                          "SCSI_EnableAdapterCache",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);

   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_DisableAdapterCache(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_DisableAdapterCache(Kwd_List & param)
{
   IString     s1;
   HFILE      hfDevHandle = param.getInt("DEVICEHANDLE");
   ULONG      ulParamSize = sizeof(hfDevHandle);
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");


   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x4E,
                          &hfDevHandle, ulParamSize,
                          &ulParamSize, NULL, 0, NULL,
                          "SCSI_DisableAdapterCache",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);

   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_AdaptCacheStatus(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export SCSI_AdaptCacheStatus(Kwd_List & param)
{
   IString     s1, s2;
   BYTE       data;
   HFILE      hfDevHandle = param.getInt("DEVICEHANDLE");
   ULONG      ulDataSize = sizeof(data);
   ULONG      ulParamSize = sizeof(hfDevHandle);
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");


   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x4F,
                          &hfDevHandle, ulParamSize,
                          &ulParamSize, &data,
                          ulDataSize, &ulDataSize,
                          "SCSI_AdaptCacheStatus",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
   s1 = "Adapter Cache Status : ";
   s1 = s1 + (IString)(long)data;
  }
  param.files()->out1<<s1;
  param.files()->out1.flush();
  return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_SetDeviceTimeout(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_SetDeviceTimeout(Kwd_List & param)
{
   IString     s1, s2;
  struct
  {
    HFILE          hfDevHandle;
    ULONG          ulTimeout;
  } paramblock;

   ULONG      ulParamSize = sizeof(paramblock);
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");

   paramblock.hfDevHandle = param.getInt("DEVICEHANDLE");
   paramblock.ulTimeout = param.getInt("TIMEOUT");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x50,
                          &paramblock, ulParamSize,
                          &ulParamSize, NULL, 0, NULL,
                          "SCSI_SetDeviceTimeout",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    s1 = "Timeout Value Set : ";
    s1 = s1 + (IString)(ULONG)paramblock.ulTimeout;
    param.files()->out1<<s1;
    param.files()->out1.flush();
  }

   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_ReadDeviceTimeout(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_ReadDeviceTimeout(Kwd_List & param)
{
   IString     s1, s2;
   HFILE      hfDevHandle = param.getInt("DEVICEHANDLE");
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");
   ULONG      data;
   ULONG      ulDataSize = sizeof(data);
   ULONG      ulParamSize = sizeof(hfDevHandle);

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x51,
                          &hfDevHandle, ulParamSize,
                          &ulParamSize, &data,
                          ulDataSize, &ulDataSize,
                          "SCSI_ReadDeviceTimeout",
                          "only call",
                           param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    s1 = "Timeout Value Read : ";
    s1 = s1 + (IString)(ULONG)data;
    param.files()->out1<<s1;
    param.files()->out1.flush();
  }
  return ulRc;

}

/*
*************************************************************************
** Name: APIRET _export SCSI_TransferSCB(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_TransferSCB(Kwd_List & param)
{
  struct
  {
    HFILE          hfDevHandle;
    USHORT         usSenseDataSize;
    ULONG          ulPhysicalSCBPtr;
    ULONG          ulLogicalSCBPtr;
    BYTE           Flags;
  } paramblock;

   IString          s1;
   USHORT          data;
   ULONG           ulDataSize = sizeof(data);
   ULONG           ulParamSize = sizeof(paramblock);
   HFILE           hfDrvHandle = param.getInt("DRIVEHANDLE");
   paramblock.hfDevHandle = param.getInt("DEVICEHANDLE");
   paramblock.usSenseDataSize = 256;
   paramblock.ulPhysicalSCBPtr = param.getInt("PHYSICALSCBPTR");
   paramblock.ulLogicalSCBPtr = param.getInt("LOGICALSCBPTR");
   paramblock.Flags = param.getInt("FLAGS");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x52,
                          &paramblock, ulParamSize,
                          &ulParamSize, &data,
                          ulDataSize, &ulDataSize,
                          "SCSI_TransferSCB",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

   if (ulRc != 0)
    printerror(ulRc, param);

// **** on error the data buffer might contain sense data ???

   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_AllocateDevice(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_AllocateDevice(Kwd_List & param)
{
  struct
  {
    BYTE          PeripheralType;
    BYTE          TypeFlag;
    USHORT        usAvailDev;
  } paramblock;

   IString           s1;
   USHORT           data;
   ULONG            ulDataSize = sizeof(data);
   ULONG            ulParamSize = sizeof(paramblock);
   HFILE            hfDrvHandle = param.getInt("DRIVEHANDLE");

   paramblock.PeripheralType = param.getInt("PERIPHTYPE");
   paramblock.TypeFlag = param.getInt("DEVTYPEFLG");
   paramblock.usAvailDev = param.getInt("AVAILDEV");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x55,
                          &paramblock, ulParamSize,
                          &ulParamSize, &data,
                          ulDataSize, &ulDataSize,
                          "SCSI_AllocateDevice",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
   param.set("DEVICEHANDLE", (IString)(long)data );
   s1 = "Allocated Device Handle : ";
   s1 = s1 + (IString)(long)data;
  }

  param.files()->out1<<s1;
  param.files()->out1.flush();

  return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_DeallocateDevice(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_DeallocateDevice(Kwd_List & param)
{
   IString     s1;
   HFILE      hfDevHandle = param.getInt("DEVICEHANDLE");
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");

   ULONG      ulParamSize = sizeof(hfDevHandle);


   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x54,
                          &hfDevHandle, ulParamSize,
                          &ulParamSize, NULL, 0, NULL,
                          "SCSI_DeallocateDevice",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);

   return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_PeripheralTypeCount(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_PeripheralTypeCount(Kwd_List & param)
{
  struct
  {
    BYTE          PeripheralType;
    BYTE          TypeFlag;
  } paramblock;

   IString         s1, s2;
   USHORT         data;
   ULONG          ulDataSize = sizeof(data);
   ULONG          ulParamSize = sizeof(paramblock);
   HFILE          hfDrvHandle = param.getInt("DRIVEHANDLE");

   paramblock.PeripheralType = param.getInt("PERIPHTYPE");
   paramblock.TypeFlag = param.getInt("DEVTYPEFLG");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x56,
                          &paramblock, ulParamSize,
                          &ulParamSize, &data,
                          ulDataSize, &ulDataSize,
                          "SCSI_PeripheralTypeCount",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();
  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    s1 = "Count of Device Type Requested : ";
    s1 = s1 + (IString)(long)data;
  }
  param.files()->out1<<s1;
  param.files()->out1.flush();

  return ulRc;
}

/*
*************************************************************************
** Name: APIRET _export SCSI_SendAbort(Kwd_List &)
**
** Description:
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export SCSI_SendAbort(Kwd_List & param)
{
  struct
  {
     HFILE        hfDevHandle;
     USHORT       usSenseDataSize;
     ULONG        Reserved;
  } paramblock;

   IString     s1;
   HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");
   ULONG      ulParamSize = sizeof(paramblock);
   paramblock.hfDevHandle = param.getInt("DEVICEHANDLE");
   paramblock.usSenseDataSize = 256;
   paramblock.Reserved = 0;

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x57,
                          &paramblock, ulParamSize,
                          &ulParamSize, NULL, 0, NULL,
                          "SCSI_SendAbort",
                          "only call",
                          param.files()->out1 );

   param.files()->out1.flush();

  if (ulRc != 0)
    printerror(ulRc, param);

   return ulRc;
}

/*
******************************************************************
* printerror(ULONG)
*
*
******************************************************************
*/
VOID printerror(ULONG &ul, Kwd_List &param)
{
  IString s1;

  s1 = "\n";
  Bits errcode(ul);

  if(errcode.bit(7))
    s1 += "        SCSI Driver-Specific error.";

  if(errcode.bit(15))
  {
    s1 += "\n        Request completed with Error:";
    switch ((ul & 0xff) & 0xf)
    {
        case 0: s1 += "\n        Device Error ";
                break;
        case 1: s1 += "\n        Timeout Error";
                break;
        case 2: s1 += "\n        Unusual Wakeup Error";
                break;
        case 3: s1 += "\n        DevHlp Error";
                break;
        case 4: s1 += "\n        Request Block Not Available";
                break;
        case 5: s1 += "\n        Maximum Device Support Exceeded";
                break;
        case 6: s1 += "\n        Interrupt Level Not Available";
                break;
        case 7: s1 += "\n        Device Not Available";
                break;
        case 8: s1 += "\n        More IRQ Levels than Adapters";
                break;
        case 9: s1 += "\n        Device Busy";
                break;
        case 0x0A: s1 += "\n        Request Sense Failed";
                break;
        case 0x0B: s1 += "\n        Adapter Cache Not Supported";
                break;
        default:
                s1 += "Unknown error; Return code is : ";
                char temp[30];
                sprintf(temp, "%.4X", errcode.bit(0,7));
//              s1 = s1 + (IString)(long)ul;
                s1 = s1 + " 0x" + temp;
                break;
     }
   }
   param.files()->out1<<s1;
   ul = 0;
   return;
}


