/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Feb. 1994.
**
** Revisions:
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#include "thread.h"

#define ID_TIMER 1

HAB _export getHAB();
MRESULT scaleEverything(HWND _hwnd,ULONG,MPARAM,MPARAM);               //AL added


class _export PMThread: public DdtThread
{
public:
  PMThread(const IString& logFileName,const IString& errFileName, const IString& script); //AL added script
  virtual ~PMThread();

  virtual IString userIO(IString& prompt, INT wait);
         // If wait<0, wait forever for response to be returned.
					// If wait==0, display message and return empty IString.
					// If wait>0, wait maximum of *wait* seconds for response to
					//   be returned.
  virtual void echoLog(IString);	// Echo a string and a newline to the logfile window
  virtual IString getScriptFileName() {return _scriptFileName;};      // AL returns name of script from which thread was created
  virtual APIRET  doline(USHORT&);  // Execute a line of script
  virtual MRESULT execute(ULONG, MPARAM, MPARAM);  // Message router for PMThread AL removed EXPENTRY
  virtual MRESULT wmchar(ULONG, MPARAM, MPARAM);  //AL removed EXPENTRY
  virtual void disableInput();
  virtual void enableInput();
  virtual void setPrompt(IString);
  virtual void threadProc();
  virtual FileInfo * pubfiles() {return files();};
  friend MRESULT EXPENTRY _export PMThreadProc(HWND, ULONG, MPARAM, MPARAM);
  friend void EXPENTRY _export pmThreadProc(ULONG);
  friend void _export DDTPMTerm();
private:
  HWND		  _hwnd;		      // Handle to PMThread window
  HMQ		  _hmq;           // Handle to messge queue
  BOOL     _keyhit;        // flag
  BOOL	 	  _validinput;    // flag
  BOOL	 	  _input;         // flag
  volatile USHORT	_cmd;
  IString 	_line;
  IString 	_response;
  IString	_logFileName;
  IString	_scriptFileName;		//AL added this
  IString 	_prompt;
  HAB		  _hab;           // Handle to anchor block
  TID 	 	   tid;           // thread id
};
