/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Barkha Herman, Feb. 1994.
**
** Revisions:
** -----------------------------------------------------------------------
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**
**   Sedat Akyurek 10/24/94 - Pwordoccurence and PWord added for parsing.
**      Pars_Line has been added tokens list, filename and line_no.
**      Getline and popline of Pars_buffer now return Pars_Line instead of IString.
** Comments:
**
** Public Class/ Functions:
** _export Pars_Line
** _export Pars_Buffer
**
*************************************************************************
*/
#ifndef ddtparse_h
#define ddtparse_h

#include "ddt.h"
#include <istring.hpp>
//#include "ddtlist.h"

/**********************************************************************/
// The WordOccurence and Words classes are from IString implementation.
// They are borrowed to implement parsing a line.

// Class to record occurrence of a word:
struct  PWordOccurrence {
public:
PWordOccurrence
 *pNext;
unsigned
  pos,
  len;
PWordOccurrence ( unsigned p )
  : pos( p ), len( 0 ), pNext( NULL ) { }
~PWordOccurrence ( ) { };
};

// Class to hold length/position for all words:
class  PWords {
public:
 PWords ( const IString& );
virtual ~PWords ();
PWordOccurrence
 &operator[] ( unsigned n ) const;
unsigned
  count,
  ref;
PWordOccurrence
 *p;
};



class _export Pars_Line:public DdtObject<IString>       //@01
{
public:
  // Pars_Line(IString);
  Pars_Line(IString, unsigned line_no = 0);   // SA
  Pars_Line(Pars_Line&);                      // SA
  virtual ~Pars_Line();
  virtual IString getnword(USHORT, BOOL);
  virtual IString getnword(USHORT, IString sz = DDT_CMPSTR, BOOL bool = FALSE);
  virtual IString getrest(USHORT, BOOL bool = FALSE);
  virtual IString stripword(CHAR);
  virtual IString stripword(IString, BOOL bool = FALSE);
  virtual VOID  reset(IString);
  virtual VOID operator=(IString& s1){reset(s1);};
  virtual Pars_Line& operator=(Pars_Line&);
  virtual unsigned numWords() {return tokens->count;};       // SA
  virtual VOID     setfilename(IString *fn){filename = fn;};  // SA
  virtual IString  getfilename(){return *filename;};          // SA
  virtual unsigned lineno(){return line_no;};                // SA
private:
  IString word_;
  PWords *tokens;   // SA
  unsigned line_no; // SA
  IString *filename; // SA
};

//#pragma warn -hid (not supported under CSET)
class _export Pars_Buffer:public List<IString, IString> {
public:
  Pars_Buffer(USHORT);
  virtual ~Pars_Buffer();
  virtual Pars_Line getline(USHORT);  // SA
  virtual Pars_Line popline();        // SA
  virtual VOID   add(IString);
  virtual Pars_Line &parsline();

private:
  Pars_Line parsline_;
};
//#pragma warn .hid
#endif
