//
//-------------------------------------------------------------------------
// Copyright: (C) IBM BocaRaton Ltd. 1994
//
// Classification: IBM Test Tool
//
// Original Author and Date: Kishan Kasety, 03/04/94.
//
// Revisions:  Barkha Herman 08/03/94 - removed flush(), removed
//               file I/O functions, renamed parallel port functions from
//               BIDI_ to Para_, renamed bidi functions from BIDI_ to Bidi_.
//
//               Fran Brown 08/11/94 - changed CPL and LPI in set and
//               query frame from BYTE to unsigned char.  Added  messages
//               related to state of spooler on bad RC from IOCTL
//
//              Adam Loving 03/05/95 - ported to IBM CSet
//
// Comments:  
//
// Public Class/ Functions:
//
//-------------------------------------------------------------------------
//
#include <string.h>
#include "apicover.h"
#include "ddtpara.h"

// Global variables
ULONG   ulRc;
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_Open( Kwd_List &)
//
// Description:   calls ddtDosOpen on the devicedriver
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_Open( Kwd_List& param )
{
  ULONG         ulAction = 0;
  ULONG         ulOpenFlag;
  ULONG         ulOpenMode;
  HFILE         hfdrvhandle;

  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE;

  IString devicename = param["DEVICENAME"];

  ulRc = ddtDosOpen( (char *)devicename, &hfdrvhandle, &ulAction,
                     0, 0, ulOpenFlag, ulOpenMode, NULL, 
                     "Para_Open", "only call",
                     param.files()->out1 );

  if (ulRc != 0)
  {
    IString s1 = "Device failed to open.  Aborting Script";
    param.files()->out1<<s1;
    DosExit(0,ulRc);
  }
  param.set("DRIVEHANDLE", (IString)(long)hfdrvhandle );
  return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_Close( Kwd_List &)
//
// Description:   calls ddtDosClose on the device driver.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_Close( Kwd_List& param )
{
  HFILE   hfdrvhandle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosClose( hfdrvhandle,
                      "Para_Close",
                      "only call",
                      param.files()->out1 );

  return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_ReadFile( Kwd_List &)
//
// Description:   
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_ReadFile( Kwd_List& param )
{
  ULONG         ulAction = 0;
  ULONG         ulOpenFlag;
  ULONG         ulOpenMode;
  HFILE         hfFilehandle;
  PCHAR         FileName;
  ULONG         ulByteCount;
  Buffer        *buff;
  ULONG         ulDataSize;
  IString        s1;

  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE;

  FileName = strdup(param["FILENAME"]);

 ulRc = ddtDosOpen( FileName, &hfFilehandle, &ulAction,
                     0, 0, ulOpenFlag, ulOpenMode, NULL,
                     "Para_ReadFile", "only call",
                     param.files()->out1 );

  if (ulRc != 0)
  {
    IString s1 = "Could not open the file for Read.";
    param.files()->out1<<s1;
    return ulRc;
  }
  ulByteCount = param.getInt("BYTECOUNT");
  buff = new Buffer(param[BUFFER], ulByteCount, param.getPtr(BUFFER_LIST));

  ulRc = ddtDosRead( hfFilehandle, buff->buffer(), ulByteCount, &ulDataSize,
                     "Para_ReadFile", "only call",
                     param.files()->out1);
  
  param.set(param[BUFFER],(LONG)buff);

  ulRc = ddtDosClose( hfFilehandle,
                      "Para_ReadFile",
                      "only call",
                      param.files()->out1 );

  return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_WriteFile( Kwd_List &)
//
// Description:
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_WriteFile( Kwd_List& param )
{
  ULONG         ulAction = 0;
  ULONG         ulOpenFlag;
  ULONG         ulOpenMode;
  HFILE         hfFilehandle;
  PCHAR         FileName;
  ULONG         ulByteCount;
  Buffer        *buff;
  ULONG         ulDataSize;
  IString        s1;

  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE;

  FileName = strdup(param["FILENAME"]);


  ulRc = ddtDosOpen( FileName, &hfFilehandle, &ulAction,
                     0, 0, ulOpenFlag, ulOpenMode, NULL,
                     "Para_WriteFile", "only call",
                     param.files()->out1 );

  if (ulRc != 0)
  {
    IString s1 = "Could not open the file for Write.";
    param.files()->out1<<s1;
    return ulRc;
  }
  param.set("FILEHANDLE", (IString)(long)hfFilehandle );

  ulRc = Para_WriteSubFn(param);

  ulRc = ddtDosClose( hfFilehandle,
                      "Para_WriteFile",
                      "only call",
                      param.files()->out1 );

  return ulRc;

}
APIRET  Para_WriteSubFn( Kwd_List &param )
{
  HFILE         hfFilehandle = param.getInt("FILEHANDLE");
  ULONG         ulByteCount;
  Buffer        *buff;
  ULONG         ulDataSize;
  IString        s1;
  
  buff = (Buffer*) param.getPtr(param[BUFFER]);
  ulByteCount = buff->size();

  ulRc = ddtDosWrite( hfFilehandle, buff->buffer(), ulByteCount, &ulDataSize,
                     "Para_WriteFile", "only call",
                     param.files()->out1);

  if (ulRc != 0)
    return ulRc;

  param.set(param[BUFFER],(LONG)buff);
 
  return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Bidi_SetComMode( Kwd_List &)
//
// Description:   Sets the parallel port Communication modes.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Bidi_SetComMode( Kwd_List& param )
{
   BYTE         paramblock = 0;
   struct
   {
     USHORT     usComModeFlags;
     USHORT     usReserved1;
     ULONG      ulReserved2;
   }data;

   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");
 
   data.usComModeFlags = param.getInt("COMMODE");
   data.usReserved1 = 0;
   data.ulReserved2 = 0;

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x52, &paramblock,
                          ulParamSize, &ulParamSize, 
                          &data, ulDataSize, &ulDataSize,
                          "Bidi_SetComMode", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
      return ulRc;

   s1 = " Communication Mode Flags ";
   s1 += (IString)(LONG)data.usComModeFlags +(IString) "\n Reserved1 : ";
   s1 += (IString)(LONG)data.usReserved1 + (IString) "\n Reserved2 : ";
   s1 += (IString)(LONG)data.ulReserved2;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Bidi_QComMode( Kwd_List &)
//
// Description:  queries the parallel port communication modes.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Bidi_QComMode( Kwd_List& param )
{
   BYTE         paramblock = 0;
   struct
   {
     USHORT     usComModeFlags;
     USHORT     usReserved1;
     ULONG      ulReserved2;
   }data;

   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   data.usReserved1 = 0;
   data.ulReserved2 = 0;

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x72, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Bidi_QComMode", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
      return ulRc;

   s1 = " Communication Mode Flags ";
   s1 += (IString)(LONG)data.usComModeFlags + (IString) "\n Reserved1 : ";
   s1 += (IString)(LONG)data.usReserved1 + (IString) "\n Reserved2 : ";
   s1 += (IString)(LONG)data.ulReserved2;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Bidi_SetRdTimeOut( Kwd_List &)
//
// Description:  sets the parallel port read timeout value.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Bidi_SetRdTimeOut( Kwd_List& param)
{
   BYTE         paramblock = 0;
   USHORT       usdata;
   IString      s1;
   ULONG        ulDataSize = sizeof(usdata);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   usdata = param.getInt("RDTIMEOUT");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x53, &paramblock,
                          ulParamSize, &ulParamSize,
                          &usdata, ulDataSize, &ulDataSize,
                          "Bidi_SetRdTimeOut", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
      return ulRc;

   s1 = " Read Time Out Value(secs) : ";
   s1 += (IString)(LONG)usdata;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Bidi_QRdTimeOut( Kwd_List &)
//
// Description:  queries the parallel port read timeout value.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Bidi_QRdTimeOut( Kwd_List& param )
{
   BYTE         paramblock = 0;
   USHORT       usdata;
   IString      s1;
   ULONG        ulDataSize = sizeof(usdata);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x73, &paramblock,
                          ulParamSize, &ulParamSize,
                          &usdata, ulDataSize, &ulDataSize,
                          "Bidi_QRdTimeOut", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
      return ulRc;

   s1 = " Time Out Value(secs) : ";
   s1 += (IString)(LONG)usdata;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Bidi_QDeviceID( Kwd_List &)
//
// Description:  Queries the device ID of the peripheral attached to the parallel port.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Bidi_QDeviceID( Kwd_List& param )
{
   BYTE         paramblock = 0;
   
   struct
   {
     UCHAR         BytesRet[2];
     CHAR          Asciidata[1022];
   } data;

   IString      s1;
   USHORT       BytesRtnd;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");
   
   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x74, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Bidi_QDeviceID", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
      return ulRc;

   BytesRtnd = 255*data.BytesRet[0]+data.BytesRet[1];
   data.Asciidata[BytesRtnd-2]='\0';

   CHAR    OutBuff[1024];
   s1 = "Bytes returned  : ";
   sprintf(OutBuff, "0x%4.4x", BytesRtnd);
   s1 += OutBuff;

   s1 += "\n\tDevice ID : \n";
   s1 += data.Asciidata;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_SetFrameCtrl( Kwd_List &)
//
// Description:  sets frame control.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_SetFrameCtrl( Kwd_List& param )
{
   struct
   {
     unsigned char       CPL;
     unsigned char       LPI;
   }data;

   unsigned char         paramblock = 0;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   data.CPL = param.getInt("CPL");
   data.LPI = param.getInt("LPI");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x42, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_SetFrameCtrl", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Chars Per Line : ";
   s1 += (IString)(LONG)data.CPL + (IString)("\n Lines Per Inch : ");
   s1 += (IString)(LONG)data.LPI;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_SetInfinRetry( Kwd_List &)
//
// Description:   sets Infinite Retry
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_SetInfinRetry( Kwd_List& param )
{
   
   BYTE         paramblock = 0;
   BYTE         data;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   data = param.getInt("RETRY");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x44, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_SetInfinRetry", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   if (data == 0)
      s1 = "Infinite Retry Disabled ";
   else if (data == 1)
      s1 = "Infinite Retry Enabled ";
   else
      s1 = "Invalid value in data field ";

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_InitParllPort( Kwd_List &)
//
// Description:  Initializes a parallel port.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_InitParllPort( Kwd_List& param )
{

   BYTE         paramblock = 0;
   BYTE         data = 0;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x46, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_InitParllPort", "only call",
                          param.files()->out1 );

      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_ActivateFont( Kwd_List &)
//
// Description:  activates a font.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_ActivateFont( Kwd_List& param )
{
   struct
   {
     USHORT     usCodePage;
     USHORT     usFontID;
   }data;

   BYTE         paramblock = 0;
   IString       s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   data.usCodePage = param.getInt("CODEPAGE");
   data.usFontID = param.getInt("FONTID");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x48, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_ActivateFont", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 65027) {
        s1 = "Check that Spooler is Enabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Code Page : ";        
   s1 += (IString)(LONG)data.usCodePage + (IString)("\n Font ID : ");
   s1 += (IString)(LONG)data.usFontID;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_SetPrtJobTitle( Kwd_List &)
//
// Description:  sets the print-job title.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_SetPrtJobTitle( Kwd_List& param )
{
   struct
   {
     USHORT     usLength;
     ULONG      ulTitleAddr;
   }data;

   BYTE         paramblock = 0;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");
   PCHAR        JobTitle    = strdup(param["JOBTITLE"]);

   data.ulTitleAddr = (ULONG) &JobTitle;
   data.usLength = strlen(JobTitle);

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x4D, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_SetPrtJobTitle", "only call",
                          param.files()->out1 );
   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Length : ";
   s1 += (IString)(LONG)data.usLength + (IString)("\n Address of Title : ");
   s1 += (IString)(LONG)data.ulTitleAddr + (IString)"\n JOB TITLE : ";
   s1 += JobTitle;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_SetPPWrtTimeOut( Kwd_List &)
//
// Description:  sets the parallel port Write timeout value.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_SetPPWrtTimeOut( Kwd_List& param )
{
   BYTE         paramblock = 0;
   USHORT       usdata;
   IString      s1;
   ULONG        ulDataSize = sizeof(usdata);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   usdata = param.getInt("PPWRTTIMEOUT");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x4E, &paramblock,
                          ulParamSize, &ulParamSize,
                          &usdata, ulDataSize, &ulDataSize,
                          "Para_SetPPWRTTimeOut", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Parallel Port Wrtie Time Out Value(secs) : ";
   s1 += (IString)(LONG)usdata;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_QFrameCtrl( Kwd_List &)
//
// Description:  queries the frame control.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_QFrameCtrl( Kwd_List& param )
{
   struct
   {
     unsigned char       CPL;
     unsigned char       LPI;
   }data;

   BYTE         paramblock = 0;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x62, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_QFrameCtrl", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Chars Per Line : ";
   s1 += (IString)(LONG)data.CPL + (IString)("\n Lines Per Inch : ");
   s1 += (IString)(LONG)data.LPI;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_QInfinRetry( Kwd_List &)
//
// Description:  queries Infinite Retry.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_QInfinRetry( Kwd_List& param )
{

   BYTE         paramblock = 0;
   BYTE         data;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x64, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_QInfinRetry", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   if (data == 0)
      s1 = "Infinite Retry Disabled ";
   else if (data == 1)
      s1 = "Infinite Retry Enabled ";
   else
      s1 = "Invalid value in data field ";

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_QParllPort( Kwd_List &)
//
// Description:  queries parallel port status.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_QParllPort( Kwd_List& param )
{

   BYTE         paramblock = 0;
   BYTE         data;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x66, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_QParllPort", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Value in data field : ";        // output to be formatted
   s1 += (IString)(LONG)data;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_QActiveFont( Kwd_List &)
//
// Description:  queries an active font.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_QActiveFont( Kwd_List& param )
{
   struct
   {
     USHORT     usCodePage;
     USHORT     usFontID;
   }data;

   BYTE         paramblock = 0;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x69, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_QActiveFont", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 65027) {
        s1 = "Check that Spooler is Enabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Code Page : ";
   s1 += (IString)(LONG)data.usCodePage + (IString)("\n Font ID : ");
   s1 += (IString)(LONG)data.usFontID;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_VerifyFont( Kwd_List &)
//
// Description:  verifies that a particular code page and font is available.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_VerifyFont( Kwd_List& param )
{
   struct
   {
     USHORT     usCodePage;
     USHORT     usFontID;
   }data;

   BYTE         paramblock = 0;
   IString      s1;
   ULONG        ulDataSize = sizeof(data);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   data.usCodePage = param.getInt("CODEPAGE");
   data.usFontID = param.getInt("FONTID");
 
   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x6A, &paramblock,
                          ulParamSize, &ulParamSize,
                          &data, ulDataSize, &ulDataSize,
                          "Para_VerifyFont", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 65027) {
        s1 = "Check that Spooler is Enabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " Code Page : ";
   s1 += (IString)(LONG)data.usCodePage + (IString)("\n Font ID : ");
   s1 += (IString)(LONG)data.usFontID;

   param.files()->out1<<s1;
   return ulRc;
}
//
//-------------------------------------------------------------------------
// Name: APIRET _export Para_QPPWrtTimeOut( Kwd_List &)
//
// Description:  queries parallel port Wrtie Time-Out Value.
//
// Parameters:  Kwd_List &.
//
// Returns:     APIRET.
//
// Cautions:
//
//
//-------------------------------------------------------------------------
//
APIRET _export Para_QPPWrtTimeOut( Kwd_List& param )
{
   BYTE         paramblock = 0;
   USHORT       usdata;
   IString      s1;
   ULONG        ulDataSize = sizeof(usdata);
   ULONG        ulParamSize = sizeof(paramblock);
   HFILE        hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x05, 0x6E, &paramblock,
                          ulParamSize, &ulParamSize,
                          &usdata, ulDataSize, &ulDataSize,
                          "Para_QPPWrtTimeOut", "only call",
                          param.files()->out1 );

   if (ulRc != 0)
     {
      if (ulRc == 1) {
        s1 = "Check that Spooler is Disabled ";
        param.files()->out1<<s1;
      } /* endif */
      return ulRc;
     }

   s1 = " PP Write Time Out Value(secs) : ";
   s1 += (IString)(LONG)usdata;

   param.files()->out1<<s1;
   return ulRc;
}
