/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date:  Adam Loving 4 Jan 95
**
** Comments:
**
** Public Class/ Functions:
** 
** 
**
*************************************************************************
*/
#include "genlist.h"
#ifndef ddtoutf_h
#define ddtoutf_h
#include <istring.hpp>

class FormatSpec
{
public:
  FormatSpec();
  FormatSpec(IString cv, 
               unsigned short s,
               unsigned short l,
               unsigned short e,
               char t,
               unsigned short ts,
               char tb,
               char fb);
  IString getCreatorVariable() {return creatorVariable;};
  void setCreatorVariable(IString creator) {creatorVariable=creator;};
  Boolean isValid() {return valid;};
  unsigned short getStart() {return start;};
  unsigned short getLength() {return length;};
  unsigned short getElements() {return elements;};
  IString getErrormsg() {return errormsg;};
//protected:
  IString creatorVariable;      // format specified like this:  creatorVariable%D[5]... etc.
  unsigned short start;
  unsigned short length;
  unsigned short elements;
  char type;                 // type is will be denoted by 'C', 'I', 'U', or 'F'
  unsigned short typesize;
  char tobase;          // tobase is denoted by 'H', 'X', 'D', 'O', 'B', or 'C'
  char frombase;      // from base will be 'H', 'D', 'O', 'B', 'C'
  Boolean valid;
  IString errormsg;
};

class FormattedList: public List<IString, IString>, public FormatSpec
{
public:
  FormattedList(): List<IString,IString>(""), FormatSpec() {createDescription();};
  FormattedList(IString cv, unsigned short s, unsigned short l, unsigned short e, char t, unsigned short ts, char tb, char fb);
  ~FormattedList(){};
  IString getDescription() {return description;};
  void confirmFormatFor(unsigned long);
  IString firstIString();
private:
  void createDescription();
  IString description;
};

class DdtOutFormat: public FormatSpec
{
public:
  DdtOutFormat( const IString&);
  virtual FormattedList * format( const IString& inString, unsigned long inLength=-1);
  virtual void setFromBase(char base) {frombase = base;};
private:
  virtual IString formatSubString(const IString & inString);
  virtual IString convertToDecimal(const IString & inString);
  IString complete(const signed char value);
  IString complete(const short value);
  IString complete(const long value);
  IString complete(const unsigned char value);
  IString complete(const unsigned short value);
  IString complete(const unsigned long value);
  IString complete(const float value);
  IString complete(const double value);
  int insideBrackets(IString & Parsestring, unsigned short & index);
};

#endif
