/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Barkha J. Herman
**
** Revisions:
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**   @02- ADL -11/16/94 - changed DdtObject copy constructor to satisfy cset
**
** Comments:
**
** Public Class/ Functions:
**  _export DdtObject
**  _export DdtList
*************************************************************************
*/
#ifndef _ddtlist_h
#define _ddtlist_h

#include "ddtos2.h"
#include <istring.hpp>

template <class keytype> class _export DdtObject
{
  public:
    DdtObject(){};
    DdtObject(const keytype & kparm){k=kparm;};                              //@01
    DdtObject(DdtObject<keytype> &){};			//@02  <class keytype> added
    virtual ~DdtObject(){};

  //  key()  is old method.. do not use .. kept for old code..       //@01
//    virtual keytype &key(){return k;};
  //  the following 2 methods  replace key()
    virtual keytype getkey(){return k;};                                 //@01
    virtual void setkey(const keytype & kparm){k=kparm;};                  //@01
  private:
    keytype k;
};

template <class keytype> struct _export DdtNode
{
    DdtNode<keytype> *previous;
    DdtObject<keytype> *object;
    DdtNode<keytype> *next;
};

typedef void (*DDTPFN) (void *);

//template <class keytype> class _export DdtList:public DdtObject<keytype> //@01
template <class keytype> class _export DdtList
{
  public:
    DdtList();
    virtual ~DdtList();
    virtual void iterate(DDTPFN);
    virtual DdtObject<keytype> *find(keytype);
    virtual void remove(keytype);
    virtual void empty();
    virtual void push(DdtObject<keytype> *);
    virtual void add(DdtObject<keytype> *);
    virtual DdtObject<keytype> *pop();
  private:
    DdtNode<keytype> *node;
};

//* All possible instantiations of DdtObject

typedef DdtObject<IString> This_is_a_dummy_object_1;

//* All possible instantiations of DdtList

#pragma define (DdtList<short>)
#pragma define (DdtList<unsigned short>)
#pragma define (DdtList<long>)
#pragma define (DdtList<unsigned long>)
#pragma define (DdtList<char>)
#pragma define (DdtList<unsigned char>)
#pragma define (DdtList<IString>)

typedef DdtList<SHORT>     this_is_a_dummy_typedef_1;
typedef DdtList<USHORT>    this_is_a_dummy_typedef_2;
typedef DdtList<LONG>      this_is_a_dummy_typedef_3;
typedef DdtList<ULONG>     this_is_a_dummy_typedef_4;
typedef DdtList<CHAR>      this_is_a_dummy_typedef_5;
typedef DdtList<UCHAR>     this_is_a_dummy_typedef_6;
typedef DdtList<IString>    this_is_a_dummy_typedef_7;
#endif
