/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Barkha J. Herman, Jan. 1994
**
** Revisions:
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject insteadu
**                             and replacing key() with setkey or getkey method
**
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#include "ddtos2.h"
#include "ddtlist.h"
/*
*************************************************************************
** Name:         template <class keytype> DdtList<keytype>::DdtList()
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> DdtList<keytype>::DdtList()
{
   node = NULL;
}
/*
*************************************************************************
** Name:         template <class keytype> DdtList<keytype>::~DdtList()
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> DdtList<keytype>::~DdtList()
{
   empty();
}
/*
*************************************************************************
** Name:         template <class keytype>
**               void DdtList<keytype>::iterate(DDTPFN)
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype>
void DdtList<keytype>::iterate(DDTPFN func)
{
  DdtNode<keytype> *temp = node;
  while (temp)
  {
     func(temp->object);
     temp = temp->next;
  }
}
/*
*************************************************************************
** Name:         template <class keytype>
**               DdtObject<keytype> *DdtList<keytype>::pop()
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype>
DdtObject<keytype> *DdtList<keytype>::pop()
{
   DdtNode<keytype> *temp = node;
   DdtObject<keytype> *obj = NULL;
   if (temp != NULL)
   {
      obj = node->object;
      node = temp->next;
      if (temp->next != NULL)
        temp->next->previous = NULL;
      delete temp;
   }
   return obj;
}
/*
*************************************************************************
** Name:         template <class keytype>
**               void DdtList<keytype>::push(DdtObject<keytype> *)
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> 
void DdtList<keytype>::push(DdtObject<keytype> *obj)
{
  DdtNode<keytype> * n = new DdtNode<keytype>;
  n->object = obj;
  n->next = node;
  n->previous = NULL;
  if (node != NULL)
   node->previous = n;
  node = n;
 }
/*
*************************************************************************
** Name:         template <class keytype>
**               void DdtList<keytype>::remove(keytype)
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> 
void DdtList<keytype>::remove(keytype k)
{
   DdtNode<keytype> *temp = node;
   while (temp != NULL)
   {
//     if (temp->object->key() == k)
     if (temp->object->getkey() == k)                                      //@01
       break;
     temp = temp->next;
   }
   if (temp != NULL)
   {
      if ((temp->previous == NULL) && (temp->next == NULL))
        node = NULL;
      if (temp->previous != NULL)
        temp->previous->next = temp->next;
      if (temp->next != NULL)
        temp->next->previous = temp->previous;
      delete temp;
   }
}
/*
*************************************************************************
** Name:         template <class keytype>
**               DdtObject<keytype> *DdtList<keytype>::find(keytype)
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> 
DdtObject<keytype> *DdtList<keytype>::find(keytype k)
{
   DdtNode<keytype> *temp = node;
   while (temp != NULL)
   {
//     if (temp->object->key() == k)
     if (temp->object->getkey() == k)                                     //@01
       break;
     temp = temp->next;
   }
   if (temp != NULL)
     return temp->object;
   else
     return NULL;
}
/*
*************************************************************************
** Name:         template <class keytype>
**               void DdtList<keytype>::empty()
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> 
void DdtList<keytype>::empty()
{
   while (node)
   {
     DdtObject<keytype> *obj = pop();
     delete obj;
   }
}
/*
*************************************************************************
** Name:         template <class keytype>
**               void DdtList<keytype>::add(DdtObject<keytype> *)
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
template <class keytype> 
void DdtList<keytype>::add(DdtObject<keytype> *obj)
{
//  DdtObject<keytype> *temp = find(obj->key());
  DdtObject<keytype> *temp = find(obj->getkey());                    //@01
  if (temp == NULL)
  {
    DdtNode<keytype> * n = new DdtNode<keytype>;
    n->object = obj;
    n->next = node;
    n->previous = NULL;
    if (node != NULL)
     node->previous = n;
    node = n;
  }
  else
  {
   delete temp;
   temp = obj;
  }
}

