/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, June 1994.
**
** Revisions:
**
** Comments:
**
**
** Public Class/ Functions:
**
*************************************************************************
*/

// DDTKBD.H defines the stub functions for testing the keyboard IDC's for
//	the device dependent keyboard driver.  The stub functions require
//	the test device driver, TESTKBD.SYS, to be loaded at boot time.
#include "ddtos2.h"
#include "kwdlist.h"

// ***************************************************
// ***************************************************
// ************** Device Dependent IDCs **************
// ***************************************************
// ***************************************************

// **************************
// * Open / Close functions *
// **************************

// Function: open
// Description:  Opens the TESTKBD.SYS device driver, returns a handle
//	in keyword "HANDLE", and calls the OPEN IDC of KBDDD.SYS.
APIRET _export open(Kwd_List&);

// Function: close
// Description: Calls the CLOSE IDC of KBDDD.SYS and closes the
//    	TESTKBD.SYS device driver.  Also removes "HANDLE" from
//	the keyword list.
APIRET _export close(Kwd_List&);

// *******************
// * Query functions *
// *******************

// Function: query_caps
// Description: Calls the QUERY CAPABILITIES IDC of KBDDD.SYS and
//	outputs the results to the logfile.  Also sets the
//	keywords: MAXTYPA, MINTYPA, MAXDELAY, MINDELAY, KEYCOUNT, and
//	NUMLEDS.
APIRET _export query_caps(Kwd_List&);

// Function: query_typematic
// Description: Calls the QUERY TYPEMATIC IDC of KBDDD.SYS and
// 	outputs the results to the logfile.  Also sets the keywords:
//	TYPASEL and DELAYSEL.
APIRET _export query_typematic(Kwd_List&);

// Function: query_LEDs
// Description: Calls the QUERY LEDs IDC of KBDDD.SYS and
//	outputs the results to the logfile.  This IDC queries
//	which LEDs are currently lit.
APIRET _export query_LEDs(Kwd_List&);

// Function: query_IDs
// Description: Calls the QUERY IDs IDC of KBDDD.SYS and outputs
//	the results to the logfile.  Also sets the keywords:
//	ID and KEYCOUNT.  This IDC returns the byte ID of the
//	keyboard as well as the number of keys.
APIRET _export query_IDs(Kwd_List&);

// Function: query_disabled
// Description: Calls the QUERY DISABLED IDC of KBDDD.SYS and
//	outputs the results to the logfile.  This function simply
//	returns whether the keyboard has been disabled by a previous
//	call to disable_keyboard.
APIRET _export query_disabled(Kwd_List&);

// Function: query_kbd_ready
// Description: Calls the QUERY KBD READY IDC of KBDDD.SYS and
//	outputs the results to the logfile.
APIRET _export query_kbd_ready(Kwd_List&);

// ****************************************************
// * The following functions change the state of the  *
// * keyboard.  Each of these IDCs can be executed in *
// * interrupt or non-interrupt mode.  Interrupt mode *
// * is specified by the tag "_int" at the end of the *
// * function name.                                   *
// ****************************************************

// Function: disable_kbd and disable_kbd_int
// Description: Calls the DISABLE KBD IDC to disable the
//	keyboard.  WARNING: always follow a call to this
//	function with a call to enable_kbd.
APIRET _export disable_kbd(Kwd_List&);
APIRET _export disable_kbd_int(Kwd_List&);

// Function: enable_kbd and enable_kbd_int
// Description: Calls the ENABLE KBD IDC to enable the
// 	keyboard.
APIRET _export enable_kbd(Kwd_List&);
APIRET _export enable_kbd_int(Kwd_List&);

// Function: reset_hardware and reset_hardware_int
// Description: Calls the RESET HARDWARE IDC to reset the
//	hardware to some base, start state.
APIRET _export reset_hardware(Kwd_List&);
APIRET _export reset_hardware_int(Kwd_List&);

// Function: set_typematic and set_typematic_int
// Description:  Calls the SET TYPEMATIC IDC to set the
//	typematic rate and delay.  Takes two keywords,
//	TYPASEL (0-31) and DELAYSEL (0-3) in addition to
//	the TESTKBD.SYS handle.
APIRET _export set_typematic(Kwd_List&);
APIRET _export set_typematic_int(Kwd_List&);

// Function: set_LEDs and set_LEDs_int
// Description: Calls the SET LEDS IDC to set the LEDs.  The
//	one keyword is the flag LEDS, which should consist of
//	a three-digit binary number denoting which LEDs to set
//	and which to clear:
//		xxx
//		123
//    	1: Caps Lock
//	2: Num Lock
//	3: Scroll Lock
APIRET _export set_LEDs(Kwd_List&);
APIRET _export set_LEDs_int(Kwd_List&);

// ****************************************
// * Miscellaneous KBDDD.SYS IDC commands *
// ****************************************

// Function: send_generic
// Description: Calls the SEND GENERIC IDC to send a generic
//	command string to the keyboard.  The command string
//	is specified by the "COMMAND" keyword, and the device
//	driver will wait for an acknowlegement if the "ACK"
//	keyword is set to a nonzero value.
APIRET _export send_generic(Kwd_List&);

// Function: flush_partial_keys
// Description: Calls the FLUSH PARTIAL KEYS IDC to reset the
//	device driver to a home state.
APIRET _export flush_partial_keys(Kwd_List&);

// Function: save_state and restore_state
// Description: Calls the SAVE STATE or RESTORE STATE IDC to
//	be used with Advanced Power Management.
APIRET _export save_state(Kwd_List&);
APIRET _export restore_state(Kwd_List&);

//-----------------------------------------------------------------------------
// ***************************************************
// ***************************************************
// ************* Device Independent IDCs *************
// ***************************************************
// ***************************************************

// Function: open_di
// Description: Assuming that TESTKBD.SYS has already been opened
//	by the stub open, open a channel for IDC with KBDDI.SYS.  Sets
//	the keyword IDCHANDLE for a handle to the DI IDC.
APIRET _export open_di(Kwd_List&);

// Function: close_di
// Description: Close the IDC channel with KBDDI.SYS.
APIRET _export close_di(Kwd_List&);

// Function: process_keystroke
// Description: Send the PROCESS KEYSTROKE IDC to KBDDI.SYS and
//	process a keystroke.  This requires the keywords:
//	XCHAR, SCAN, STATUS, DSHIFT, SHIFT, and TIME.
APIRET _export process_keystroke(Kwd_List&);

// Function: process_reinit
// Description: Sent the PROCESS REINIT IDC to KBDDI.SYS to
//	process a reinit.
APIRET _export process_reinit(Kwd_List&);

// Function: print_last_idc
// Description: Print the last IDC call to TESTKBD.SYS.  This
//	does not enter the keyboard driver at all.
APIRET _export print_last_idc(Kwd_List&);
