/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Feb. 1994.
**
** Revisions:
**
** Comments:
**    This file provides function declarations for some device independent
**    stub functions for all use.
**
** Public Class/ Functions:
**
*************************************************************************
*/
#ifndef ddtglobal_h
#define ddtglobal_h

#include "kwdlist.h"

// Functions defined in Globals.DLL

#ifdef __cplusplus
extern "C" {
#endif

APIRET _Export includeheader(Kwd_List&);
APIRET _export set(Kwd_List&);
APIRET _export dump(Kwd_List&);
APIRET _export input(Kwd_List&);
APIRET _export pause(Kwd_List&);
APIRET _export log(Kwd_List&);
APIRET _export out(Kwd_List&);
APIRET _export clear(Kwd_List&);
APIRET _export compare(Kwd_List&);
APIRET _export decrement(Kwd_List&);
APIRET _export increment(Kwd_List&);
APIRET _export label(Kwd_List&);   	// save the pc in the $label keyword
APIRET _export jump(Kwd_List&);    	// jump to labeled statement "$label"
APIRET _export add(Kwd_List&);          // $($res)=$op1+$op2
APIRET _export sub(Kwd_List&);          // $($res)=$op1-$op2
APIRET _export proc(Kwd_List&);		// Sets up a procedure labeled $label which is $($lines) long,
					//    	including the return statement but not the procedure
					//	declaration statement
APIRET _export call(Kwd_List&);		// Calls a procedure $label
APIRET _export ret(Kwd_List&);		// Returns from a procedure call
APIRET _export doloop(Kwd_List&);	// begins a do..while or a do..for loop
APIRET _export endfor(Kwd_List&);	// terminates a for loop by incrementing $i, checking the
					// 	value of $cond, and either branching back or terminating
APIRET _export endwhile(Kwd_List&);	// Checks $COND and loops or terminates accordingly
APIRET _export IF(Kwd_List&);		// Executes the next statement if $cond is true, else jumps one down
APIRET _export allocateBuffer(Kwd_List&); // Allocates 1000 byte buffer
APIRET _export filedump (Kwd_List&); // appends to said file 
APIRET _export debugexp (Kwd_List&); // for checking out expected operations
#ifdef __cplusplus
}
#endif

#endif

