/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Feb. 1994.
**
** Revisions:
**
** Comments:
**  This header file provides the function declaration for the DASD
**  Stub functions.
**
** Public Class/ Functions:
**
*************************************************************************
*/
#include "kwdlist.h"

typedef ULONG  DWORD;
typedef USHORT WORD;

struct BPB
{
  WORD  SectorSize;		    // Bytes / sector
  BYTE  ClusterSize;		  // Sectors / cluster
  WORD  ReservedSectors; 	// I'm not sure what this is
  BYTE  FATCount;		      // Number of FATs
  WORD  RootCount;		    // Number of root directory entries
  WORD  TotalSectors;		  // Total number of sectors
  BYTE  MediaDescriptor;	// Media Descriptor
  WORD  FATSize;		      // Sectors / FAT
  WORD  TrackSize;		    // Sectors / Track
  WORD  HeadCount;		    // Number of heads
  DWORD HiddenSectors;  	// Hidden Sectors
  DWORD LgTotalSectors; 	// Large Total Sectors
  BYTE  Reserved[6];		  // Reserved
};

struct PhysicalParams {
  WORD Reserved1;
  WORD CylinderCount;
  WORD HeadCount;
  WORD TrackSize;
  WORD Reserved[4];
};

struct HDRDATA {
  BYTE cmd;
  WORD head;
  WORD cyl;
  union {
    WORD startsec;
    WORD numtrack;
  };
  WORD numsec;
};

struct Tuple {
  BYTE c;
  BYTE h;
  BYTE r;
  BYTE n;
};

struct sectorinfo {
  WORD sectornum;
  WORD sectorsize;
};

// Function declarations.
// open_logical: 	IN: 	DEVICENAME
//		           OUT: 	add DRIVEHANDLE
APIRET _export open_logical(Kwd_List&);	

// close_logical:	IN: 	DRIVEHANDLE
//               OUT: 	del DRIVEHANDLE
APIRET _export close_logical(Kwd_List&);

// lock_logical: 	IN: 	DRIVEHANDLE
//			         OUT:

APIRET _export lock_logical(Kwd_List&);	

// unlock_logical: 	IN: 	DRIVEHANDLE
//                 OUT:
APIRET _export unlock_logical(Kwd_List&);

// qmedia_sense: 	IN: 	DRIVEHANDLE      
//			         OUT:  Media Information

APIRET _export qmedia_sense(Kwd_List&);

// qlogical_map: 	IN: 	DRIVEHANDLE      
//			         OUT:  Logical Drive Number

APIRET _export qlogical_map(Kwd_List&);

// set_logical_map: 	IN: 	DRIVEHANDLE      
//			            OUT:  Logical Drive Number

APIRET _export set_logical_map(Kwd_List&);

// block_removable: 	IN: 	DRIVEHANDLE      
//			            OUT:  REMOVEABLE MEDIA (Y/N)

APIRET _export block_removable(Kwd_List&);

// redetermine_media: 	IN: 	DRIVEHANDLE      
//			               OUT:  RESERVED

APIRET _export redetermine_media(Kwd_List&); 

// get_params		IN:	DRIVEHANDLE
//	               OUT:	SECTORSIZE, CLUSTERSIZE, FATCOUNT,
//			               ROOTCOUNT, SECTORCOUNT, FATSIZE, TRACKSIZE,
//				            HEADCOUNT
APIRET _export get_logical_params(Kwd_List&); 

// read_logical: 	IN:	DRIVEHANDLE, HEAD, CYLINDER, SECTORSTART,
//					         SECTORSIZE, TRACKSIZE, $BUFFER
//			         OUT:	add $(BUFFER)

APIRET _export read_logical(Kwd_List&);	

// write_logical: 	IN:	DRIVEHANDLE, HEAD, CYLINDER, SECTORSTART,
//					            $BUFFFER, $($BUFFER), TRACKSIZE
//	                  OUT:

APIRET _export write_logical(Kwd_List&);	

// verify_logical: 	IN:	DRIVEHANDLE, HEAD, CYLINDER, SECTORSTART,
//				            	SECTORCOUNT, SECTORSIZE, TRACKSIZE
//                   OUT:	add VERIFY (1/0)

APIRET _export verify_logical(Kwd_List&);    	 

// format_track:  	IN: 	DRIVEHANDLE, TRACKNUM, HEAD,
//                         TRACKSIZE, SECTORSIZE
//		 	            OUT:

APIRET _export format_track(Kwd_List&);

// open_physical: 	IN:	DISKNUMBER (e.g. "1:" for first fixed disk)
//			            OUT:	add DISKHANDLE

APIRET _export open_physical(Kwd_List&);	 

// close_physical	IN:	DISKHANDLE
//		         	OUT:	del DISKHANDLE

APIRET _export close_physical(Kwd_List&);	 

// lock_physical	IN:	DISKHANDLE
//			         OUT:

APIRET _export lock_physical(Kwd_List&);	 

// unlock_physical	IN:	DISKHANDLE
//			           OUT:

APIRET _export unlock_physical(Kwd_List&);	 

// get_physical_params	IN:	DISKHANDLE
// 		               OUT:	CYLINDERCOUNT, TRACKCOUNT, TRACKSIZE

APIRET _export get_physical_params(Kwd_List&);	 

// write_physical: 	IN:	DISKHANDLE, HEAD, CYLINDER, SECTORSTART, $BUFFER,
//                   		$($BUFFER), TRACKSIZE, SECTORSIZE
//	                  OUT:

APIRET _export write_physical(Kwd_List&);	 

// read_physical: 	IN:	DISKHANDLE, HEAD, CYLINDER, SECTORSTART, 
//					            SECTORCOUNT, SECTORSIZE, $BUFFER, TRACKSIZE
//	                  OUT:	add $($BUFFER)

APIRET _export read_physical(Kwd_List&);	 

// verify_physical:	IN:	DISKHANDLE, HEAD, CYLINDER, SECTORSTART, SECTORCOUNT,
//					            SECTORSIZE, TRACKSIZE
//	                  OUT:	add VERIFY (1/0)

APIRET _export verify_physical(Kwd_List&);   	 

// read_file:		IN:	FILENAME, BYTESTART, BYTECOUNT, $BUFFER
//			         OUT:	add $($BUFFER)

APIRET _export read_file(Kwd_List&);		 

// write_file:		IN:	FILENAME, BYTESTART, $BUFFER, $(BUFFER)
//			         OUT:

APIRET _export write_file(Kwd_List&);      	 

PVOID getParmList(Kwd_List&, BOOL isWrite);
PVOID getFormatParm(Kwd_List&);
