/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland Feb. 1994
**
** Revisions:  03/05/95 Adam Loving - porting to IBM CSet
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#include <string.h>       // AL added brackets
#include "apicover.h"
#include "buffer.h"
#include "ddtdasd.h"
#include <istring.hpp>  // AL added brackets

PVOID getParmList(Kwd_List& param, BOOL isWrite) {
  WORD TrackSize = param.getInt("TRACKSIZE");
  WORD sectorsize = param.getInt("SECTORSIZE");
  HDRDATA hdrdata;
  ULONG SectorCount;
  Buffer * buf = (Buffer *)param.getPtr(param[BUFFER]);
  if (isWrite) {
    SectorCount= buf->size()/sectorsize;
  } else {
    SectorCount= param.getInt("SECTORCOUNT");
  } /* endif */
//  ULONG SectorCount = (isWrite
//	?(buf->size()/sectorsize)
//	:(param.getInt("SECTORCOUNT")));
  hdrdata.head = param.getInt("HEAD");
  hdrdata.cyl = param.getInt("CYLINDER");
  hdrdata.startsec = param.getInt("SECTORSTART");
  hdrdata.cmd = 0;
  hdrdata.numsec = SectorCount;
  sectorinfo * tracklayout = new sectorinfo[TrackSize];
  for(USHORT i = 0; i<TrackSize ;i++) {
    USHORT inx = i;
    tracklayout[inx].sectorsize = sectorsize;
    tracklayout[inx].sectornum = i;
  }
  ULONG ParmSize = sizeof(HDRDATA) + (TrackSize * sizeof(sectorinfo));
  PCHAR pParmList = new char[ParmSize];
  memcpy(pParmList, &hdrdata, sizeof(HDRDATA));
  PVOID offset = &pParmList[sizeof(HDRDATA)];
  memcpy(offset, tracklayout, ParmSize-sizeof(HDRDATA));
  delete[] tracklayout;
  return pParmList;
}

PVOID getFormatParm(Kwd_List& param) {
  WORD TrackSize = param.getInt("TRACKSIZE");
  WORD Cylinder = param.getInt("TRACK");
  WORD Head = param.getInt("HEAD");
  WORD sectorsize = param.getInt("SECTORSIZE");
  BYTE SaveBytes;
  switch(sectorsize) {
  case 128: SaveBytes = 0; break;
  case 256: SaveBytes = 1; break;
  case 512: SaveBytes = 2; break;
  case 1024:SaveBytes = 4; break;
  }
  HDRDATA hdrdata;
  hdrdata.cmd = 0;
  hdrdata.head = Head;
  hdrdata.cyl = Cylinder;
  hdrdata.numtrack = 0;
  hdrdata.numsec = TrackSize;
  Tuple * TrackTable = new Tuple[TrackSize];
  for(USHORT i = 0; i<TrackSize; i++) {
    TrackTable[i].c = Cylinder;
    TrackTable[i].h = Head;
    TrackTable[i].r = i+1;
    TrackTable[i].n = SaveBytes;
  }
  ULONG ParmSize = 9+4*TrackSize;
  PCHAR pParmList = new char[ParmSize];
  memcpy(pParmList, &hdrdata, sizeof(HDRDATA));
  PVOID offset = &pParmList[sizeof(HDRDATA)];
  memcpy(offset, TrackTable, ParmSize-sizeof(HDRDATA));
  return pParmList;
}


/*
*************************************************************************
** Name:        APIRET _export open_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export open_logical(Kwd_List& param)
{

  APIRET rc;
  ULONG ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ULONG ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE |
	       OPEN_FLAGS_DASD;
  PCHAR devname = strdup(param["DEVICENAME"]);
  HFILE handle;
  ULONG action;

  // Open, get handle

  rc = ddtDosOpen(devname,
	     &handle,
	     &action,
	     0,
	     0,
	     ulOpenFlag,
	     ulOpenMode,
	     NULL,
	     "DASD open_logical",
	     "only call",
	     param.files()->out1);
  param.files()->out1.flush();
  if(!rc) param.set("DRIVEHANDLE", (IString)(long)handle);
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export close_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export close_logical(Kwd_List& param)
{

  APIRET rc;

  rc = ddtDosClose((HFILE) param.getInt("DRIVEHANDLE"),
		   "DASD close_logical",
		   "only call",
		   param.files()->out1);
  param.files()->out1.flush();
  param.unset("DRIVEHANDLE");
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export lock_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export lock_logical(Kwd_List& param) 
{

  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
   		                  0x08, 0x00, &ParmList, ParmLen,
		                     &ParmLen, &Data, DataLen, &DataLen,
		                     "DASD lock_logical",
		                     "only call",
		                     param.files()->out1);

  return rc;
}
/*
*************************************************************************
** Name:        APIRET _export lock_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export query_lock(Kwd_List& param) 
{

  APIRET rc;
  struct
   {
    BYTE command;
    USHORT drive;
   } paramblock;
  paramblock.command = 0;
  paramblock.drive = param.getInt("DRIVE");
  ULONG ParmLen = sizeof(paramblock);
  USHORT Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
   		                  0x08, 0x66, &paramblock, ParmLen,
		                     &ParmLen, &Data, DataLen, &DataLen,
		                     "DASD query_lock",
		                     "only call",
		                     param.files()->out1);

  if (!rc)
   {
   IString s1("Return Status :");
   s1 += IString(Data).d2x();
   param.files()->out1<<s1;
   }
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export unlock_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export unlock_logical(Kwd_List& param)
{

  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
		                     0x08, 0x01, &ParmList, ParmLen,
		                     &ParmLen, &Data, DataLen, &DataLen,
		                     "DASD unlock_logical",
		                     "only call",
		                     param.files()->out1);
  
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export qmedia_sense(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export qmedia_sense(Kwd_List& param) 
{
  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
		               0x08, 0x60, &ParmList, ParmLen,
                     &ParmLen, &Data, DataLen, &DataLen,
                     "DASD qmedia_sense",
		               "only call",
		               param.files()->out1);
                     param.files()->out1.flush();
  
   IString s1;

   if (!rc)
   {
    s1 = "  Media Information : ";
     
    if (Data == 0)
          s1 += "Unable to determine media type";
       else
          if (Data == 1)
            s1 += "720KB diskette is present in 3.5-inch drive";
       else
          if (Data == 2)
            s1 += "1.44MB diskette is present in 3.5-inch drive";
       else
          if (Data == 3)
            s1 += "2.88MB diskette is present in 3.5-inch drive";
       else
         s1 += (long)Data;
   }
                                
   param.files()->out1<<s1;
   return rc;
}

/*
*************************************************************************
** Name:        APIRET _export qlogical_map(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export qlogical_map(Kwd_List& param) 
{

  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
		               0x08, 0x21, &ParmList, ParmLen,
                     &ParmLen, &Data, DataLen, &DataLen,
                     "DASD qlogical_map",
		               "only call",
		               param.files()->out1);
                     param.files()->out1.flush();
  
   IString s1;

   if (!rc)
   {
    s1 = "  Logical Drive Number : ";
     
    if (Data == 0)
          s1 += "Drive Letter unchanged ";
       else
       {
          s1 += "The new drive number is : ";
          s1 += (long)Data;
       }   
   }
                                
   param.files()->out1<<s1;
   return rc;
}
/*
*************************************************************************
** Name:        APIRET _export set_logical_map(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export set_logical_map(Kwd_List& param) 
{

  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
		               0x08, 0x03, &ParmList, ParmLen,
                     &ParmLen, &Data, DataLen, &DataLen,
                     "DASD set_logical_map",
		               "only call",
		               param.files()->out1);
  
   IString s1;

   s1 = "  Logical Drive Number : ";
   s1 += (long)Data; 
                                   
   param.files()->out1<<s1;
   return rc;
}

/*
*************************************************************************
** Name:        APIRET _export block_removable(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export block_removable(Kwd_List& param) 
{

  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
		               0x08, 0x20, &ParmList, ParmLen,
                     &ParmLen, &Data, DataLen, &DataLen,
                     "DASD block_removable",
		               "only call",
		               param.files()->out1);
  
   IString s1;

   if (!rc)
   {
    s1 = "  Type of Media : ";
     
    if (Data == 0)
          s1 += "Media is removable";
       else
          s1 += "Nonremovable media";
   }
                                
   param.files()->out1<<s1;
   return rc;
}

/*
*************************************************************************
** Name:        APIRET _export redetermine_media(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export redetermine_media(Kwd_List& param) 
{

  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = sizeof(ParmList);
  BYTE Data = 0;
  ULONG DataLen = sizeof(Data);

  rc = ddtDosDevIOCtl((HFILE) param.getInt("DRIVEHANDLE"),
		               0x08, 0x02, &ParmList, ParmLen,
                     &ParmLen, &Data, DataLen, &DataLen,
                     "DASD redetermine_media",
		               "only call",
		               param.files()->out1);
  
 /*  param.files()->out1<<s1;   */
   return rc;
}

/*
*************************************************************************
** Name:        APIRET _export get_logical_params(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export get_logical_params(Kwd_List& param) 
{

  HFILE handle = param.getInt("DRIVEHANDLE");
  BYTE ParamList = 1;
  ULONG ParmLen = 1;
  struct
  {
    BPB    bpb;
    USHORT Cylinder;
    BYTE   DeviceType;
    USHORT DeviceAttrib1 :1;
    USHORT DeviceAttrib2 :1;
    USHORT DeviceAttrib3 :1;
    USHORT DeviceAttrib4 :1;
  } Data;
  ULONG DataLen = sizeof(Data);

  APIRET rc = ddtDosDevIOCtl(handle, 0x08, 0x63,
                            &ParamList, ParmLen,
                            &ParmLen, &Data,
			                       DataLen, &DataLen,
			                       "DASD get_params",
			                       "only call",
			                       param.files()->out1);
  if(!rc) 
  {
    param.set("SECTORSIZE", (LONG) Data.bpb.SectorSize);
    param.set("CLUSTERSIZE", (LONG) Data.bpb.ClusterSize);
    param.set("FATCOUNT", (LONG) Data.bpb.FATCount);
    param.set("ROOTCOUNT", (LONG) Data.bpb.RootCount);
    param.set("SECTORCOUNT", (LONG) Data.bpb.TotalSectors);
    if(Data.bpb.TotalSectors) param.set("$SECTORCOUNT", (LONG) Data.bpb.TotalSectors);
    else param.set("$SECTORCOUNT", (LONG) Data.bpb.LgTotalSectors);
    param.set("FATSIZE", (LONG) Data.bpb.FATSize);
    param.set("TRACKSIZE", (LONG) Data.bpb.TrackSize);
    param.set("HEADCOUNT", (LONG) Data.bpb.HeadCount);
    param.set("LGSECTORCOUNT", (LONG) Data.bpb.LgTotalSectors);
    param.set("CYLINDER", (LONG)Data.Cylinder);
    IString s1;
    s1  =  "\nLogical Device Parameters :\n  ";
    s1 +=  "\n  Sector Size         : ";
    s1 +=  (long)Data.bpb.SectorSize;
    s1 +=  "\n  Cluster Size        : ";
    s1 +=  (long)Data.bpb.ClusterSize;
    s1 +=  "\n  FatCount            : ";
    s1 +=  (long)Data.bpb.FATCount;
    s1 +=  "\n  RootCount           : ";
    s1 +=  (long)Data.bpb.RootCount;
    s1 +=  "\n  FatSize             : ";
    s1 +=  (long)Data.bpb.FATSize;
    s1 +=  "\n  Track Size          : ";
    s1 +=  (long)Data.bpb.TrackSize;
    s1 +=  "\n  Number of Heads     : ";
    s1 +=  (long)Data.bpb.HeadCount;
    s1 +=  "\n  Number of Sectors   : ";
    s1 +=  (long)Data.bpb.LgTotalSectors;
    s1 +=  "\n  Number of Cylinders : ";
    s1 += (long)Data.Cylinder;  
    s1 +=  "\n  Device Type         : ";
    
    if (Data.DeviceType == 0)
         s1 +=  "48 TPI low-density diskette drive \n";
       else
         if (Data.DeviceType == 1)
            s1 += "96 TPI high-density diskette drive \n";
       else
          if (Data.DeviceType == 2)
            s1 += "3.5-inch 720kb diskette drive \n";
       else
          if (Data.DeviceType == 3)
            s1 += "8-inch single density diskette drive \n";
       else
          if (Data.DeviceType == 4)
            s1 += "8-inch double density diskette drive \n";
       else
          if (Data.DeviceType == 5)
            s1 += "Fixed disk \n";
       else
          if (Data.DeviceType == 6)
            s1 += "Tape drive \n";
       else
          if (Data.DeviceType == 7)
            s1 += "Other (includes 1.44MB 3.5-inch diskette drive) \n";
       else
          if (Data.DeviceType == 8)
            s1 += "R/W optical disk \n";
       else
          if (Data.DeviceType == 9)
            s1 += "3.5-inch 4.0MB diskette drive (2.88MB formatted) \n  ";
       else
       {
         s1 += (long)Data.DeviceType;
         s1 += "\n";
       }   
    s1 +=  "  Device Attributes   : ";
    
    if (Data.DeviceAttrib1 == 0)
         s1 += "Removeable Media \n  ";
    else
         if (Data.DeviceAttrib1 == 1)
            s1 += "Media can not be removed \n  ";
               
    if (Data.DeviceAttrib2 == 0)
       s1 += "                    : Unsure if media has changed \n  ";
    else
       if (Data.DeviceAttrib2 == 1)
          s1 += "                    : Media was removed since last I/O operation \n  ";
       
    if (Data.DeviceAttrib3 == 0)
    {
       s1 += "                    : Device does not support physical\n  ";
       s1 += "                       addressess more than 16MB \n  ";
    }
    else
       if (Data.DeviceAttrib3 == 1)
       {
          s1 += "                    : Device supports physical addressess\n  ";
          s1 += "                       more than 16MB \n";
       }          
    param.files()->out1<<s1;
  }
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export read_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export read_logical(Kwd_List& param)
{
  HFILE handle = (HFILE) param.getInt("DRIVEHANDLE");
  APIRET rc;
  PVOID pParmList = getParmList(param, FALSE);
  ULONG ParmLen = 9+4*(param.getInt("TRACKSIZE"));
  ULONG DataLen = param.getInt("SECTORCOUNT")*param.getInt("SECTORSIZE");
  Buffer * pData = new Buffer(param[BUFFER], DataLen, param.getPtr(BUFFER_LIST));
  rc = ddtDosDevIOCtl(handle, 0x08, 0x64,
                      pParmList, ParmLen, &ParmLen,
                      pData->buffer(), DataLen, &DataLen,
                      "DASD read_logical", "only call", param.files()->out1);
  if(rc) return rc;
  param.set(param[BUFFER], (LONG)pData);
  delete[] pParmList;
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export write_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export write_logical(Kwd_List& param)
{

  if(param.isKeyword(param[BUFFER])) {
    Buffer * buf = (Buffer *)param.getPtr(param[BUFFER]);
    HFILE handle = (HFILE) param.getInt("DRIVEHANDLE");
    APIRET rc;
    PVOID pParmList = getParmList(param, TRUE);
    ULONG DataLen = buf->size();
    ULONG ParmLen = 9+4*(param.getInt("TRACKSIZE"));
    rc = ddtDosDevIOCtl(handle,
		 0x08, 0x44, pParmList, ParmLen,
		 &ParmLen, buf->buffer(), DataLen,
		 &DataLen,
		 "DASD write_logical",
		 "only call",
		 param.files()->out1);
    param.files()->out1.flush();
    delete[] pParmList;
    return rc;
  }
  else return 87;
}

/*
*************************************************************************
** Name:        APIRET _export verify_logical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export verify_logical(Kwd_List& param)
{

  HFILE handle = (HFILE) param.getInt("DRIVEHANDLE");
  APIRET rc;
  PVOID pParmList = getParmList(param, FALSE);
  ULONG ParmLen = 9+4*(param.getInt("TRACKSIZE"));
  rc = ddtDosDevIOCtl(handle,
		 0x08, 0x65, pParmList, ParmLen,
		 &ParmLen, NULL, 0, NULL,
		 "DASD verify_logical",
		 "only call",
		 param.files()->out1);
  param.files()->out1.flush();
  if(!rc) param.set("VERIFY", "1");
  else param.unset("VERIFY");
  delete[] pParmList;
  return rc;
}

APIRET _export format_track(Kwd_List& param)
{

  ULONG handle = param.getInt("DRIVEHANDLE");
  APIRET rc;
  { PCHAR Parm = "";
    ULONG ParmLen = 1;
    BYTE Data = 0;
    ULONG DataLen = 1;
    rc = ddtDosDevIOCtl(handle, 0x08, 0x04,
			Parm, ParmLen, &ParmLen,
			&Data, DataLen, &DataLen,
			"DASD format_track",
			"begin format call",
			param.files()->out1);
    param.files()->out1.flush();
    if(rc) return rc;
  }
  { PVOID Parm = getFormatParm(param);
    ULONG ParmLen = 9+4*param.getInt("TRACKSIZE");
    BYTE Data = 0;
    ULONG DataLen = 1;
    rc = ddtDosDevIOCtl(handle, 0x08, 0x45,
			Parm, ParmLen, &ParmLen,
			&Data, DataLen, &DataLen,
			"DASD format_track",
			"format track call",
			param.files()->out1);
    param.files()->out1.flush();
    if(rc) return rc;
  }
  { BYTE Parm = 0;
    ULONG ParmLen = 1;
    BYTE Data = 0;
    ULONG DataLen = 1;

    rc = ddtDosDevIOCtl(handle, 0x08, 0x02,
			&Parm, ParmLen, &ParmLen,
			&Data, DataLen, &DataLen,
			"DASD format_track",
			"redetermine media call",
			param.files()->out1);
    param.files()->out1.flush();
  }
  return rc;
}


/*
*************************************************************************
** Name:        APIRET _export open_physical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export open_physical(Kwd_List& param) {
  APIRET rc;
  IString str(param["DISKNUMBER"]);
  PCHAR temp = strdup(str);
  USHORT diskhandle;
  rc = ddtDosPhysicalDisk(INFO_GETIOCTLHANDLE, &diskhandle, 2,
		temp, str.length()+1,
		"DASD open_physical",
		"only call",
		param.files()->out1);
  param.files()->out1.flush();
  delete temp;
  if(rc) return rc;
  param.set("DISKHANDLE", (long)diskhandle);
  return rc;
}

APIRET _export close_physical(Kwd_List& param) {
  APIRET rc;
  USHORT diskhandle = param.getInt("DISKHANDLE");
  rc = ddtDosPhysicalDisk(INFO_FREEIOCTLHANDLE, NULL, 0,
		&diskhandle, 2,
		"DASD close_physical",
		"only call",
		param.files()->out1);
  param.files()->out1.flush();
//  param.unset("DISKHANDLE");
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export lock_physical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export lock_physical(Kwd_List& param) {
  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = 1;
  BYTE Data[31];
  ULONG DataLen = 31;
  memset(Data, 0, 31);
  rc = ddtDosDevIOCtl(param.getInt("DISKHANDLE"),
		 0x09, 0x00, &ParmList, ParmLen,
		 &ParmLen, &Data, DataLen, &DataLen,
		 "DASD lock_physical",
		 "only call",
		 param.files()->out1);
  param.files()->out1.flush();
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export unlock_physical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export unlock_physical(Kwd_List& param) {
  APIRET rc;
  BYTE ParmList = 0;
  ULONG ParmLen = 1;
  BYTE Data[31];
  ULONG DataLen = 31;
  memset(Data, 0, 31);
  rc = ddtDosDevIOCtl(param.getInt("DISKHANDLE"),
		0x09, 0x01, &ParmList, ParmLen,
		&ParmLen, &Data, DataLen, &DataLen,
		"DASD unlock_physical",
		"only call",
		param.files()->out1);
  param.files()->out1.flush();
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export get_physical_params(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export get_physical_params(Kwd_List& param) 
{

  HFILE handle = (HFILE) param.getInt("DISKHANDLE");
  APIRET rc;
  PhysicalParams Data;
  WORD ParamList = 0;
  ULONG ParmLen = 1;
  ULONG DataLen = sizeof(PhysicalParams);

  rc = ddtDosDevIOCtl(handle, 0x09, 0x63,
			             &ParamList, ParmLen, &ParmLen,
			             &Data, DataLen, &DataLen,
			             "DASD get_physical_params",
			             "only call",
			              param.files()->out1);
  if(!rc) 
  {
    param.set("HEADCOUNT", (IString)(long)Data.HeadCount);
    param.set("TRACKSIZE", (IString)(long)Data.TrackSize);
    param.set("CYLINDERCOUNT", (IString)(long)Data.CylinderCount);
    IString s1;
    s1  =  "\n  Physical Device Parameters :\n  ";
    s1 +=  "\n     Number of Cylinders             : ";
    s1 +=  (long)Data.CylinderCount;
    s1 +=  "\n     Number of Sectors per Tracks    : ";
    s1 +=  (long)Data.TrackSize;
    s1 +=  "\n     Number of Heads                 : ";
    s1 +=  (long)Data.HeadCount;
    s1 += "\n";
    param.files()->out1<<s1;
  }
  return rc;
}
/*
*************************************************************************
** Name:        APIRET _export write_physical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export write_physical(Kwd_List& param) {
  if(param.isKeyword(param[BUFFER])) {
    HFILE handle = (HFILE) param.getInt("DISKHANDLE");
    APIRET rc;
    PVOID pParmList = getParmList(param, TRUE);
    Buffer * buf = (Buffer *)param.getPtr(param[BUFFER]);
    ULONG ParmLen = 9+4*param.getInt("TRACKSIZE");
    ULONG DataLen = buf->size();
    rc = ddtDosDevIOCtl(handle,
		 0x09, 0x44, pParmList, ParmLen,
		 &ParmLen, buf->buffer(), DataLen,
		 &DataLen,
		 "DASD write_physical",
		 "only call",
		 param.files()->out1);
    param.files()->out1.flush();
    delete[] pParmList;
    return rc;
  }
  else return 87;
}

/*
*************************************************************************
** Name:        APIRET _export read_physical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export read_physical(Kwd_List& param) {
  HFILE handle = (HFILE) param.getInt("DISKHANDLE");
  APIRET rc;
  PVOID pParmList = getParmList(param, FALSE);
  ULONG ParmLen = 9+4*param.getInt("TRACKSIZE");
  ULONG DataLen = param.getInt("SECTORCOUNT")*param.getInt("SECTORSIZE");
  Buffer * pData = new Buffer(param[BUFFER], DataLen, param.getPtr(BUFFER_LIST));
  rc = ddtDosDevIOCtl(handle,
		 0x09, 0x64, pParmList, ParmLen,
		 &ParmLen, pData->buffer(), DataLen,
		 &DataLen,
		 "DASD read_physical",
		 "only call",
		 param.files()->out1);
  param.files()->out1.flush();
  if(rc) return rc;
  param.set(param[BUFFER], (LONG)pData);
  delete[] pParmList;
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export verify_physical(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export verify_physical(Kwd_List& param) {
  HFILE handle = (HFILE) param.getInt("DISKHANDLE");
  APIRET rc;
  PVOID pParmList = getParmList(param, FALSE);
  ULONG ParmLen = 9+4*param.getInt("TRACKSIZE");
  rc = ddtDosDevIOCtl(handle,
		 0x09, 0x65, pParmList, ParmLen,
		 &ParmLen, NULL, 0, NULL,
		 "DASD verify_physical",
		 "only call",
		 param.files()->out1);
  param.files()->out1.flush();
  if(!rc) param.set("VERIFY", "1");
  delete[] pParmList;
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export read_file(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export read_file(Kwd_List& param) {
  ULONG   rc;
  ULONG   DataLenMax;
  IString   pFilename  = param["FILENAME"];
  ULONG   ulStartPosition = param.getInt("BYTESTART");
  ULONG ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ULONG ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE;
  PCHAR fn = strdup(pFilename);
  ULONG action = 0;
  HFILE handle;
  rc = ddtDosOpen( fn,
		     &handle,
		     &action,
		     0,
		     0,
		     ulOpenFlag,
		     ulOpenMode,
		     NULL,
		     "DASD read_file",
		     "only call",
		     param.files()->out1 );

  delete fn;
  param.files()->out1.flush();
  if(rc) return rc;

  rc = ddtDosSetFilePtr( handle,
			   ulStartPosition,
			   FILE_BEGIN,
			   &ulStartPosition,
			   "DASD read_file",
			   "only call",
			   param.files()->out1 );

  param.files()->out1.flush();
  if(rc) return rc;

  ULONG count = param.getInt("BYTECOUNT");
  Buffer * buf = new Buffer(param[BUFFER], count, param.getPtr(BUFFER_LIST));
  rc = ddtDosRead( handle,
		     buf->buffer(),
		     count,
		     &DataLenMax,
		     "DASD read_file",
		     "only call",
		     param.files()->out1 );

  param.files()->out1.flush();
  rc = ddtDosClose( handle,
		  "DASD read_file",
		  "only call",
		  param.files()->out1 );

  param.set(param[BUFFER], (LONG)buf);
  param.files()->out1.flush();
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export write_file(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export write_file(Kwd_List& param) {
  ULONG   rc;
  ULONG   DataLenMax;
  IString   Filename  = param["FILENAME"];
  ULONG   ulStartPosition = param.getInt("BYTESTART");
  ULONG ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
  ULONG ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR |
	OPEN_SHARE_DENYWRITE | OPEN_ACCESS_WRITEONLY;
  PCHAR fn = strdup(Filename);
  ULONG action = 0;
  HFILE handle;
  rc = ddtDosOpen( fn,
		     &handle,
		     &action,
		     0,
		     0,
		     ulOpenFlag,
		     ulOpenMode,
		     NULL,
		     "DASD write_file",
		     "only call",
		     param.files()->out1 );
  delete fn;
  param.files()->out1.flush();
  if(rc) return rc;

  rc = ddtDosSetFilePtr( handle,
			   ulStartPosition,
			   FILE_BEGIN,
			   &ulStartPosition,
			   "DASD write_file",
			   "only call",
			   param.files()->out1 );
  param.files()->out1.flush();
  if(rc) return rc;

  Buffer * buf = (Buffer*) param.getPtr(param[BUFFER]);
  ULONG count = buf->size();
  rc = ddtDosWrite( handle,
		     buf->buffer(),
		     count,
		     &DataLenMax,
		     "DASD write_file",
		     "only call",
		     param.files()->out1 );
  param.files()->out1.flush();
  if(rc) return rc;
  rc = ddtDosClose( handle,
		  "DASD write_file",
		  "only call",
		  param.files()->out1 );
  param.set(param[BUFFER], (LONG)buf);
  param.files()->out1.flush();
  return rc;
}

/*
*************************************************************************
** Name:        APIRET _export set_deviceparams(Kwd_List &param)
**
** Description: 
**              
**              
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export set_deviceparams(Kwd_List& param)
{

  APIRET rc;
  HFILE hfile = param.getInt("DRIVEHANDLE");
  struct
  {
    BYTE commandinfo;
    BYTE driveunit;
  } pblock;
  ULONG plen = sizeof(pblock);
  struct
  {
    BPB  bpb;
    WORD cyl;
    BYTE devtype;
    WORD attrib;
  } data;
  ULONG dlen = sizeof(data);
  pblock.commandinfo = 0;
  pblock.commandinfo | 10; 

  data.bpb.SectorSize        = param.getInt("SECTORSIZE");		 
  data.bpb.ClusterSize       = param.getInt("CLUSTERSIZE");		 
  data.bpb.ReservedSectors   = 0;
  data.bpb.FATCount          = param.getInt("FATCOUNT");		   
  data.bpb.RootCount         = param.getInt("ROOTCOUNT");		   
  data.bpb.TotalSectors      = param.getInt("TOTALSECTORS");		
  data.bpb.MediaDescriptor   = 0;
  data.bpb.FATSize           = param.getInt("FATSIZE");		     
  data.bpb.TrackSize         = param.getInt("TRACKSIZE");		   
  data.bpb.HeadCount         = param.getInt("HEADCOUNT");		   
  data.bpb.HiddenSectors     = 0;
  data.bpb.LgTotalSectors    = param.getInt("TOTALSECTORS"); 
  data.cyl                   = param.getInt("CYLINDERS");
  data.devtype               = param.getInt("DEVICETYPE");
  data.attrib                = 0;
  rc = ddtDosDevIOCtl(hfile, 8, 0x43, &pblock, plen, &plen,
                      &data, dlen, &dlen, "Only call", "set_deviceparams",
                      param.files()->out1);
  return rc;
}






