/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Kishan Kasety, Jan. 1994.
**
** Revisions:  Stahlke, Dec. 1994 - Add 3 Check Functions
**
** Comments:
**   This file provides the functional description for the cdrom stub
**   routines for device driver test.
**
** Public Class/ Functions:
**   Declarations for:
**
*************************************************************************
*/
#ifndef DDTCDROM_H
#define DDTCDROM_H
#include "ddt.h"
#include <stdio.h>

// Parameter lenghts specific to CD device.

#define COOKEDSECTOR              2048

// CDROM Device Driver Test Procedures.

APIRET _export cdrom_qdriveletter    (Kwd_List&);
APIRET _export cdrom_devopen         (Kwd_List&);
APIRET _export cdrom_devclose        (Kwd_List&);
APIRET _export cdrom_eject           (Kwd_List&);
APIRET _export cdrom_devreadfile     (Kwd_List&);
APIRET _export cdrom_seek            (Kwd_List&);
APIRET _export cdrom_querystatus     (Kwd_List&);
APIRET _export cdrom_querychaninfo   (Kwd_List&);
APIRET _export cdrom_queryupccode    (Kwd_List&);
APIRET _export cdrom_reset           (Kwd_List&);
APIRET _export cdrom_unlockdoor      (Kwd_List&);
APIRET _export cdrom_lockdoor        (Kwd_List&);
APIRET _export cdrom_stopaudio       (Kwd_List&);
APIRET _export cdrom_resumeaudio     (Kwd_List&);
APIRET _export cdrom_qaudiodiskinfo  (Kwd_List&);
APIRET _export cdrom_queryaudiostatus(Kwd_List&);
APIRET _export cdrom_qdriverinfo     (Kwd_List&);
APIRET _export cdrom_qsectorinfo     (Kwd_List&);
APIRET _export cdrom_qvolsize        (Kwd_List&);
APIRET _export cdrom_qaudiotrack     (Kwd_List&);
APIRET _export cdrom_playaudio       (Kwd_List&);
APIRET _export cdrom_read2352        (Kwd_List&);
APIRET _export cdrom_readpre2352     (Kwd_List&);
APIRET _export cdrom_qdriveletter    (Kwd_List&);
APIRET _export cdrom_qaudiochaninfo  (Kwd_List&);
APIRET _export cdrom_devread2048     (Kwd_List&);
APIRET _export cdrom_drivelocation   (Kwd_List&);
APIRET _export cdrom_getdevparams    (Kwd_List&);
APIRET _export cdrom_checksector     (Kwd_List&);
APIRET _export cdrom_checkreturn     (Kwd_List&);
APIRET _export cdrom_checkvalue      (Kwd_List&);
APIRET drivelogical                  (Kwd_List&);
APIRET driveredbook                  (Kwd_List&);
static VOID MSFtoLBF                 (Kwd_List&, HFILE, ULONG );
APIRET seekredbook                   (Kwd_List&);
APIRET seeklogical                   (Kwd_List&);
APIRET playredbook                   (Kwd_List&);
APIRET playlogical                   (Kwd_List&);
APIRET read2352redbook               (Kwd_List&);
APIRET read2352logical               (Kwd_List&);
APIRET readpre2352redbook            (Kwd_List&);
APIRET readpre2352logical            (Kwd_List&);
VOID   printerror                    (ULONG&, Kwd_List &);

#endif

