/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Kishan Kasety Jan. 1994
**
** Revisions:
** ----------------------------------------------------------------------
**   02/11/94    Barkha J. Herman    Modified to comply with coding specs.
**   12/09/94    Stahlke  Update to Microsoft standards.
**   02/03/95    Adam Loving ported to IBM CSET
**
** Comments:
**
** Public Class/ Functions:
**
*************************************************************************
*/
#pragma pack(4)       // collection classes require 4-byte structure pack
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <IString.hpp>
#include "ddtos2.h"
#include "apicover.h"
#pragma pack(1) 
#include "ddtcdrom.h"

#define MAXLEN 80

// Global variables
ULONG  ulRc;
ULONG errmask = 0xFF;


/*
*************************************************************************
** Name:        APIRET _export cdrom_devopen(Kwd_List &param)
**
** Description: retireves driveletter from keyword list, sets open
**              flags, calls cdrom_qdriveletter to validate driveletter,
**              and calls ddtDosOpen.
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_devopen( Kwd_List& param )
{
  ULONG   ulAction  = 0;    
  ULONG   ulOpenFlag;
  ULONG   ulOpenMode;
  IString  devicename;
  HFILE   drvhndle;

  ulRc = cdrom_qdriveletter(param);
  if (ulRc != 0)
    printerror(ulRc, param);
  ULONG ulnumdrives = param.getInt("$DRIVES");
  if (ulnumdrives < 1)
  {
     IString s1;
     s1 = "No CDROM Drives detected.  Aborting Script";
     param.files()->out1<<s1;
//     exit(ulRc);
     DosExit(0,ulRc);
  }
  devicename = param["DEVICENAME"];
  PCHAR temp = strdup(devicename);
  if (islower(temp[0]))
   temp[0] = temp[0]-32;
  if ((temp[0] < param.getInt("$FIRSTCD")+65)||
      (temp[0] > param.getInt("$FIRSTCD")+64+ulnumdrives))
  {
    IString s1;
    s1 = "Invalid drive letter specified. \n";
//    s1 = s1 + temp[0] + " specified. Aborting script.";
    temp[0] = (param.getInt("$FIRSTCD")) + 65;
    temp[1] = 58;  // ASCII for ":";
    temp[2] = 0;

    s1 += "\tAssigning the First CDROM drive attached ";
    s1 += temp[0];
    s1 += temp[1];

    param.files()->out1<<s1;
//    exit(0);
//    DosExit(0,0);
  }
  param.unset("$FIRSTCD");
  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE |
               OPEN_FLAGS_DASD;
  ulRc = ddtDosOpen( temp, &drvhndle, &ulAction, 0L, 0L, ulOpenFlag,
                     ulOpenMode, NULL, "cdrom_devopen", "only call",
					           param.files()->out1 );
  delete[] temp;
  if (ulRc != 0)
  {
    printerror(ulRc, param);
    IString s1;
    s1 = "Device failed to open.  Aborting Script";
    param.files()->out1<<s1;
//   exit(ulRc);
    DosExit(0,ulRc);
  }
  param.set("DRIVEHANDLE", (IString)(long)drvhndle );
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_devclose(Kwd_List &param)
**
** Description:  calls ddtDosClose with cdrom drivehandle.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_devclose( Kwd_List& param )
{
  HFILE   drvhndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosClose( drvhndle,
							        "cdrom_devclose",
							        "only call",
							        param.files()->out1 );

  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_getdevparams(Kwd_List &)
**
** Description: Get Device Parameters (BPB)
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_getdevparams(Kwd_List& param)
{
   struct
   {
      UCHAR     bpb[31];
      USHORT    cylinder;
      UCHAR     devtype;
      UCHAR     attr;
    } data;
   struct       BPBlock
   {
      USHORT    bs;
      UCHAR     sc;
      USHORT    rs;
      UCHAR     nf;
      USHORT    rt;
      USHORT    ts;
      UCHAR     md;
      USHORT    fs;
      USHORT    st;
      USHORT    hn;
      ULONG     hs;
      ULONG     ls;
    };
    HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");
    ULONG   ulDatasize = sizeof(data);
    BYTE    ParamList = 1;
    ULONG   Parmlen = 1;
    struct BPBlock *pbpb;

    pbpb  = (BPBlock *)&data;
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x08, 0x63,
                           &ParamList,Parmlen,&Parmlen,
                           &data, ulDatasize, &ulDatasize,
                           "cdrom_getdevparams", "only call",
                           param.files()->out1 );

    if (ulRc == 0)
      {
        IString s1;
        s1 = "Disc sector size is: ";
        s1 += (IString)(ULONG)pbpb->bs;
        s1 += "\n        Disc sector count is: ";
        s1 += (IString)(ULONG)pbpb->ls;
        s1 += "\n        Device type code is: ";
        s1 += (IString)(ULONG)data.devtype;
        param.files()->out1<<(s1);
        param.set("BYTESPERSECTOR", (IString)(ULONG)pbpb->bs);
        param.set("LARGESECTORS", (IString)(ULONG)pbpb->ls);
        param.set("DEVICETYPE", (IString)(ULONG)data.devtype);
      }
    param.set("CDRC", (IString)(ulRc & errmask));
    if (ulRc != 0)
      {
        printerror(ulRc, param);
        param.set("BYTESPERSECTOR", 0);
        param.set("LARGESECTORS", 0);
        param.set("DEVICETYPE", 0);
      }
    return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_eject(Kwd_List &param)
**
** Description:  ejects cdrom.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_eject( Kwd_List& param )
{
  HFILE   drvHndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl( drvHndle, 0x80, 0x44, "CD01", 4, NULL, NULL, 0, NULL,
							           "cdrom_eject", "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_devreadfile(Kwd_List &param)
**
** Description:  reads a specified file BYTECOUNT bytes from BYTESTART.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_devreadfile( Kwd_List& param )
{
  ULONG   ulAction = 0;  
  ULONG   ulOpenFlag;
  ULONG   ulOpenMode;
  ULONG   ulDataSize;
  IString  s1;
  PCHAR   pFilename;
  HFILE   hfFleHandle;
  Buffer *buff;
  
  s1 = param["FILENAME"];
  pFilename = strdup(s1);
  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE;

  ulRc = ddtDosOpen( pFilename, &hfFleHandle, &ulAction, 0L,
		                  0L, ulOpenFlag, ulOpenMode, NULL,
		                  "cdrom_devreadfile", "only call",
		                  param.files()->out1 );
  delete[] pFilename;
  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
     ULONG l1 = param.getInt("BYTESTART");
     ulRc = ddtDosSetFilePtr( hfFleHandle, l1,
					     FILE_BEGIN, &l1,
			                         "cdrom_devreadfile", "only call",
			                         param.files()->out1 );

     if( ulRc != DDT_OK )
     return ulRc;
     buff = new Buffer (param["BUFFER"], param.getInt("BYTECOUNT"),
                        param.getPtr(BUFFER_LIST));
     ulRc = ddtDosRead( hfFleHandle, buff->buffer(), param.getInt("BYTECOUNT"),
		                     &ulDataSize, "cdrom_devreadfile", "only call",
                        param.files()->out1 );
     param.set(param["BUFFER"], (LONG)buff);
     param.set("CDRC", (IString)(ulRc & errmask));
     ulRc = ddtDosClose( hfFleHandle, "cdrom_devread", "only call",
			    			          param.files()->out1 );

  }
  return ulRc;
}                                        
/*
*************************************************************************
** Name:         APIRET _export cdrom_seek(Kwd_List &param)
**
** Description:  calls seeklogical or seekredbook on the basis of
**               ADDRESSMODE passed.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_seek(Kwd_List& param)
{
   IString addmode = param["ADDRESSMODE"];
   if(addmode == (IString)"REDBOOK")
     ulRc = seekredbook(param);
   else if(addmode == (IString)"LOGICALBLOCK")
     ulRc = seeklogical(param);
   else
   {
      IString s1;
      s1 = "ERROR : undefined Addressmode in cdrom_seek";
      param.files()->out1<<s1;
      ulRc = 0;
   }
   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   return ulRc;
}
/*
*************************************************************************
** Name:         APIRET seeklogical(Kwd_List &param)
**
** Description:  seeks to specified SECTORSTART.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET seeklogical(Kwd_List &param)
{
   struct 
   {
      CHAR     devdrvr[4];
      UCHAR    addmode;
      LONG     start;
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.addmode = 0;
    paramblock.start = param.getInt("SECTORSTART");
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x50, &paramblock,
                           ulParamsize, &ulParamsize, NULL, 0, NULL,
                           "cdrom_seek", "LOGICAL", param.files()->out1 );
    return ulRc;
}
/*
*************************************************************************
** Name:         APIRET seekredbook(Kwd_List &param)
**
** Description:  seeks to the specified TIMESTART.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET seekredbook(Kwd_List &param)
{
   struct 
   {
      CHAR     devdrvr[4];
      UCHAR    addmode;
      BYTE     start[4];
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.addmode = 1;
    IString msf = param["TIMESTART"];
    PCHAR ach1 = strdup(msf);
    paramblock.start[3] = 0;
    paramblock.start[2] = ((ach1[0]-48) * 10) + (ach1[1]-48);
    paramblock.start[1] = ((ach1[3]-48) * 10) + (ach1[4]-48);
    paramblock.start[0] = ((ach1[6]-48) * 10) + (ach1[7]-48);
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x50, &paramblock,
                           ulParamsize, &ulParamsize, NULL, 0, NULL,
                           "cdrom_seek", "REDBOOK", param.files()->out1 );
    delete[] ach1;

    return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_querystatus(Kwd_List &param)
**
** Description:  queries device status.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_querystatus(Kwd_List& param)
{
   HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");
   struct
   {
     int  door_open       : 1;
     int  door_unlocked   : 1;
     int  read_raw        : 1;
     int  read_write      : 1;
     int  audio_video     : 1;
     int  interleave      : 1;
     int                  : 1;
     int  prefetch        : 1;
     int  audio_channel   : 1;
     int  msf             : 1;
     int                  : 1;
     int  disk_absent     : 1;
     int  playing_audio   : 1;
     int                  : 18;
   }data;
   ULONG  ulDatasize = sizeof(data);
   ulRc = ddtDosDevIOCtl(hfDrvHandle, 0x80, 0x60, "CD01", 4, NULL,
                         &data, ulDatasize, &ulDatasize, "cdrom_querystatus",
                         "only call", param.files()->out1 );

   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   else
   {
     IString s1;
     s1 = "Device status: ";
     if (data.door_open != 0)
       s1 = s1 + "\n     DOOR IS OPEN";
     else
       s1 = s1 + "\n     DOOR IS CLOSED";
     if (data.door_unlocked == 0)
       s1 = s1 + "\n     DOOR IS LOCKED";
     else
       s1 = s1 + "\n     DOOR IS UNLOCKED";
     if (data.read_raw != 0)
       s1 = s1 + "\n     SUPPORTS READ 2048 AND READ 2352";
     if (data.read_write != 0)
       s1 = s1 + "\n     SUPPORTS READ AND WRITE";
     if (data.audio_video != 0)
       s1 = s1 + "\n     DRIVE CAN PLAY AUDIO AND VIDEO";
     if (data.interleave != 0)
       s1 = s1 + "\n     ISO-9660 INTERLEAVING AND SKIP SUPPORTED";
     if (data.prefetch != 0)
       s1 = s1 + "\n     PREFETCHING SUPPORTED INTERNALLY";
     if (data.audio_channel != 0)
       s1 = s1 + "\n     SUPPORTS AUDIO CHANNEL MANIPULATION";
     if (data.msf != 0)
       s1 = s1 + "\n     SUPPORTS MINUTE-SECOND-FRAME ADDRESSING";
     if (data.disk_absent != 0)
       s1 = s1 + "\n     DISC IS NOT PRESENT";
     else
       s1 = s1 + "\n     DISC IS PRESENT";
     if (data.playing_audio != 0)
       s1 = s1 + "\n     DRIVE IS PLAYING AUDIO";
     else
       s1 = s1 + "\n     DRIVE IS NOT PLAYING AUDIO";
     param.files()->out1<<s1;
   }
   return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_drivelocation(Kwd_List &param)
**
** Description:  calls drivelogical or driveredbook on the basis of
**               ADDRESSMODE passed.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_drivelocation(Kwd_List& param)
{
   IString addmode = param["ADDRESSMODE"];
   if(addmode == (IString)"REDBOOK")
     ulRc = driveredbook(param);
   else if(addmode == (IString)"LOGICALBLOCK")
     ulRc = drivelogical(param);
   else
   {
      IString s1;
      s1 = "ERROR : undefined Addressmode in cdrom_drivelocation";
      param.files()->out1<<s1;
      ulRc = 0;
   }
   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   return ulRc;
}
/*
*************************************************************************
** Name:         APIRET drivelogical(Kwd_List &param)
**
** Description:  seeks to specified SETORSTART.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET drivelogical(Kwd_List &param)
{
   struct 
   {
      CHAR     devdrvr[4];
      UCHAR    addmode;
    } paramblock; 
    ULONG  data;
    ULONG uldatasize = sizeof(data);
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.addmode = 0;
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x70, &paramblock,
                           ulParamsize, &ulParamsize, &data, 4, &uldatasize,
                           "cdrom_drivelocation", "LOGICAL", param.files()->out1 );
    if(ulRc == 0)
      {
        IString s1 = "The location of the drive head is : ";
        s1 += (IString)(LONG) data;
        param.files()->out1<<s1;
      }
    return ulRc;
}
/*
*************************************************************************
** Name:         APIRET driveredbook(Kwd_List &param)
**
** Description:  seeks to the specified TIMESTART.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET driveredbook(Kwd_List &param)
{
   struct 
   {
      CHAR     devdrvr[4];
      UCHAR    addmode;
    } paramblock;
    BYTE data [4];
    ULONG uldatasize = sizeof(data);
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.addmode = 1;
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x70, &paramblock,
                           ulParamsize, &ulParamsize, &data, 4, &uldatasize,
                           "cdrom_drivelocation", "REDBOOK", param.files()->out1 );
    if(ulRc == 0)
      {
        CHAR temp[9];
        IString s1("The location of the drive head is : ");
        sprintf(temp, "%2.2d:%2.2d:%2.2d", data[2], data[1], data[0]);
        s1 +=temp;
        param.files()->out1<<s1;
      }
    return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_querychaninfo(Kwd_List &param)
**
** Description:  queries audio channel information.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_querychaninfo(Kwd_List& param)
{
   struct 
   {
      BYTE      adr;
      BYTE      track;
      BYTE      index;
      BYTE      min;
      BYTE      sec;
      BYTE      frm;
      BYTE      tmp;
      BYTE      dmin;
      BYTE      dsec;
      BYTE      dfrm;
   } data;
   ULONG  ulDataSize = sizeof(data);

   HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");
   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x81, 0x63, "CD01", 4, NULL,
                          &data, ulDataSize, &ulDataSize,
                          "cdrom_querychaninfo", "only call",
                          param.files()->out1 );

   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   else
   {
     param.set("TRACK", (IString)(ULONG)data.track);
     IString s1;
     s1 = "\n     Control and ADR byte :";
     s1 += (IString)(LONG) data.adr; 
     s1 += "\n     Track # :"; 
     s1 += (IString)(LONG) data.track; 
     s1 += "\n     Index   :";
     s1 += (IString)(LONG) data.index;
     s1 += "\n     Elapsed time within track : ";
     CHAR temp[9];
     sprintf(temp, "%2.2d:%2.2d:%2.2d", data.min, data.sec, data.frm);
     s1 +=temp;
     s1 += "\n     Elapsed time on disk      : ";
     sprintf(temp, "%2.2d:%2.2d:%2.2d", data.dmin, data.dsec, data.dfrm);
     s1+=temp;
     param.files()->out1<<(s1);
   }
   return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_queryupccode(Kwd_List &param)
**
** Description:  queries upccode of the cd.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_queryupccode(Kwd_List& param)
{
   struct 
   {
      BYTE    adr;                   // Control and adr Byte
      UCHAR   upc[7];                // upc ( Universal Product Code)
      BYTE    tmp;                   //  00
      BYTE    frame;                 // frame
   } data;
   ULONG   ulDataSize = sizeof(data);
   HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x79, "CD01", 4, NULL,
                          &data, ulDataSize, &ulDataSize,
                          "cdrom_queryupccode", "only call", param.files()->out1 );
        
   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   else
   {
     IString s1;
     s1 = "Control and ADR byte : ";
     s1 = s1 + (IString)(LONG)data.adr + "\n     Universal product Code : ";
     char tempupc[14];
     sprintf(tempupc, "%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x",	//AL
                    data.upc[0], data.upc[1], data.upc[2], 	//AL
                    data.upc[3], data.upc[4], data.upc[5],	//AL
                    data.upc[6]);				//AL
     s1 += (IString)tempupc;					//AL
//     for (int i = 0; i < 7; i++)
//     {
//       char temp[2];
//       sprintf(temp, "%2.2x", data.upc[i]);
//       s1 = s1 + temp;
//     }
     s1 = s1 + "\n     Frame : ";
     s1 = s1 + (IString)(LONG)data.frame;
     param.files()->out1<<s1;
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_reset(Kwd_List &param)
**
** Description:  resets cdrom drive.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_reset( Kwd_List& param )
{
   HFILE   drvHndle = param.getInt("DRIVEHANDLE");

   ulRc = ddtDosDevIOCtl(drvHndle, 0x80, 0x40, "CD01", 4, NULL, NULL, 0, NULL,
								   "cdrom_reset", "only call", param.files()->out1 );
  param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_unlockdoor(Kwd_List &param)
**
** Description:  unlocks cdrom drive door.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_unlockdoor( Kwd_List& param )
{
  struct
  {
    CHAR cd01[4];
    BYTE flag;
  } data;
  data.cd01[0] = 'C';
  data.cd01[1] = 'D';
  data.cd01[2] = '0';
  data.cd01[3] = '1';
  data.flag = 0;
  ULONG ulDatasize = sizeof(data);
  HFILE   drvHndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl( drvHndle, 0x80, 0x46, &data, 5, &ulDatasize,
                         NULL, 0, NULL, "cdrom_unlockdoor", "only call",
                         param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_lockdoor(Kwd_List &param)
**
** Description:  locks cdrom drive door.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_lockdoor( Kwd_List& param )
{
  struct
  {
    CHAR cd01[4];
    BYTE flag;
  } data;
  data.cd01[0] = 'C';
  data.cd01[1] = 'D';
  data.cd01[2] = '0';
  data.cd01[3] = '1';
  data.flag = 1;
  ULONG ulDatasize = sizeof(data);

  HFILE   drvHndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl(drvHndle, 0x80, 0x46, &data, 5, &ulDatasize, NULL, 0,
                        NULL, "cdrom_lockdoor", "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_stopaudio(Kwd_List &param)
**
** Description:  stops audio.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_stopaudio( Kwd_List& param )
{
  HFILE   drvHndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl(drvHndle, 0x81, 0x51, "CD01", 4, NULL, NULL, 0, NULL,
							          "cdrom_stopaudio", "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_resumeaudio(Kwd_List &param)
**
** Description:  resumes audio from the last play.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_resumeaudio( Kwd_List& param )
{
  HFILE   drvHndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl(drvHndle, 0x81, 0x52, "CD01", 4, NULL, NULL, 0, NULL,
							          "cdrom_resumeaudio", "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_qaudiodiskinfo(Kwd_List &param)
**
** Description:  queries audio disk information.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qaudiodiskinfo( Kwd_List& param )
{
  struct 
  {
    UCHAR  lowtrack;
    UCHAR  hightrack;
    BYTE  add[4];
  } data;
  ULONG  uldatasize = sizeof(data);
  HFILE  drvHndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl( drvHndle, 0x81, 0x61, "CD01", 4, NULL, &data,
                         uldatasize, &uldatasize, "cdrom_qaudiodiskinfo",
                         "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    IString s1;
    s1 = "  Audio Disk Information :\n";
    s1 = s1 + "          Lowest Track    : ";
    s1 = s1 + (IString)(LONG) data.lowtrack  +(IString)"\n";
    param.set("LOWTRACK", (IString)(long) data.lowtrack);
    s1 = s1 + "          Highest Track   : ";
    s1 = s1 + (IString)(LONG) data.hightrack + "\n";
    param.set("HIGHTRACK", (IString)(long) data.hightrack);
    s1 = s1 + "          RedBook Address : ";
    CHAR temp[9]; 
    sprintf(temp, "%2.2d:%2.2d:%2.2d", data.add[0], data.add[1], data.add[2]);
    s1+=temp;
    param.files()->out1<<s1;
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export cdrom_queryaudiostatus(Kwd_List &param)
**
** Description:  queries audio status.
**
** Parameters:   Kwd_List &.
**
** Returns:      APIRET.
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_queryaudiostatus(Kwd_List& param)
{
   struct 
   {
      USHORT  audiostatus;    
      BYTE    start[4];       
      BYTE    end[4];        
    } data;
    ULONG  ulParamsize ;
    ULONG  ulDataSize = sizeof(data);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    USHORT pausemask = 0x0001;

    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x81, 0x65,
                           "CD01", 4, NULL, &data, ulDataSize,
                           &ulDataSize, "cdrom_queryaudiostatus",
                           "only call", param.files()->out1 );

    param.set("CDRC", (IString)(ulRc & errmask));
    if (ulRc != 0)
      printerror(ulRc, param);
    else
    {
      param.set("PAUSE", (IString)(ULONG)(data.audiostatus & pausemask));
      IString s1;
      if (data.audiostatus & pausemask)
        s1 = "Audio status is paused";
      else
        s1 = "Audio Status is not-paused";
      s1 = s1 + "\n      Start Location : ";
      CHAR temp[9];
      sprintf(temp, "%2.2d:%2.2d:%2.2d", data.start[2], data.start[1], data.start[0]);
      s1+=temp;
      s1 = s1 + "\n      End Location   : ";
      sprintf(temp, "%2.2d:%2.2d:%2.2d", data.end[2], data.end[1], data.end[0]);
      s1+=temp;
      param.files()->out1<<s1;
      ;
    }
    return ulRc;
}
/*
*************************************************************************
** Name:        APIRET _export cdrom_qdriverinfo(Kwd_List &)
**
** Description: queries driver info. 
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qdriverinfo(Kwd_List & param)
{
  BYTE   data[4];
  ULONG  ulDataSize = 4;
  HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl(hfDrvHandle, 0x80, 0x61,
                        "CD01", 4, NULL, &data, ulDataSize,
                        &ulDataSize, "cdrom_qdriverinfo",
			"only call", param.files()->out1 );

  ;
  IString s1;
  s1 = "Device Driver ID : ";
  s1 = s1 + (IString)(CHAR)data[0] +(IString)(CHAR)data[1] + (IString)(CHAR)data[2] + (IString)(CHAR)data[3];
  param.files()->out1<<s1;
  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name:        APIRET _export cdrom_qsectorinfo(Kwd_List &)
**
** Description: quries sector info. 
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qsectorinfo(Kwd_List & param)
{
  USHORT usdata;
  ULONG  ulDataSize;
  HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
  ulDataSize = sizeof(usdata);

  ulRc = ddtDosDevIOCtl(hfDrvHandle, 0x80, 0x63,
                        "CD01", 4, NULL, &usdata, ulDataSize,
                        &ulDataSize, "cdrom_qsectorinfo",
                        "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    param.set("SECTORSIZE", (IString)(ULONG) usdata);
    IString s1;
    s1 = "Sector Size : ";
    s1 = s1 + (IString)(LONG)usdata;
    param.files()->out1<<s1;
  }
  return ulRc;
}
/*
*************************************************************************
** Name:        APIRET _export cdrom_qvolsize(Kwd_List &)
**
** Description: queries volume size. 
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qvolsize(Kwd_List & param)
{
  ULONG  uldata;
  ULONG  ulDataSize = sizeof(ULONG);
  HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosDevIOCtl(hfDrvHandle, 0x80, 0x78,
                        "CD01", 4, NULL, &uldata, ulDataSize,
                        &ulDataSize, "cdrom_qvolsize",
                        "only call", param.files()->out1 );

  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    param.set("VOLSIZE", (IString)(ULONG)uldata);
    IString s1;
    s1 = "Volume Size : ";
    s1 = s1 + (IString)(LONG)uldata;
    param.files()->out1<<s1;
  }
  return ulRc;
}
/*
*************************************************************************
** Name:        APIRET _export cdrom_qaudiotrack(Kwd_List &)
**
** Description: queries audio track information. 
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qaudiotrack(Kwd_List & param)
{
  struct
  {
    BYTE cd01[4];
    BYTE track;
  } paramblock;
  ULONG ulParamsize = sizeof(paramblock);
  paramblock.track = param.getInt("TRACK");
  paramblock.cd01[0] = 'C';
  paramblock.cd01[1] = 'D';
  paramblock.cd01[2] = '0';
  paramblock.cd01[3] = '1';
  struct
  {
    BYTE  add[4];
    BYTE  control;
  } data;
  ULONG  ulDataSize = sizeof(data);
  HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
  UINT   chanmask = 0x80;
  UINT   typemask = 0x40;
  UINT   copymask = 0x20;
  UINT   emphmask = 0x10;

  ulRc = ddtDosDevIOCtl(hfDrvHandle, 0x81, 0x62,
                        &paramblock, ulParamsize, &ulParamsize,
			&data, ulDataSize, &ulDataSize, "cdrom_qaudiotrack",
                        "only call", param.files()->out1 );

  ;
  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  else
  {
    IString s1;
    s1 = s1 + "\nTrack Control Information:";
    s1 = s1 + "\n     Track #:"+ (IString)(LONG)param.getInt("TRACK");
    s1 = s1 + "\n     Redbook Address : ";
    char temp[9];
    sprintf(temp, "%2.2d:%2.2d:%2.2d", data.add[2], data.add[1], data.add[0]);
    s1 = s1 + temp;
 
    if (data.control & typemask)
        s1 = s1 + "\n     Data track; ";
    else
      {
        s1 = s1 + "\n     Audio track; ";
        if (data.control & chanmask)
          s1 = s1 + "4 channel ";
        else
          s1 = s1 + "2 channel ";
        if (data.control & emphmask)
          s1 = s1 + "with pre-emphasis; ";
        else
          s1 = s1 + "without pre-emphasis; ";
      }
    if (data.control & copymask)
        s1 = s1 + "copy permitted";
    else
      s1 = s1 + "copy prohibited";
    param.files()->out1<<s1;
  }
  return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_playaudio(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_playaudio(Kwd_List& param)
{
   IString addmode = param["ADDRESSMODE"];
   if(addmode == (IString)"REDBOOK")
     ulRc = playredbook(param);
   else if(addmode == (IString)"LOGICALBLOCK")
     ulRc = playlogical(param);
   else
     {
       IString s1;
       s1 = "ERROR : undefined ADDRESSMODE in cdrom_playaudio";
       param.files()->out1<<s1;
       ulRc=0;
     }
   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   return ulRc;
}
/*
*************************************************************************
** Name: APIRET playlogical(Kwd_List &)
**
** Description: play audio SECTORCOUNT from provided SETORSTART.  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET playlogical(Kwd_List &param)
{
   struct
   {
      CHAR     devdrvr[4];
      BYTE     addmode;
      LONG     start;
      LONG     end;
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.addmode = 0;
    paramblock.start = param.getInt("SECTORSTART");
    paramblock.end = param.getInt("SECTORCOUNT");
    paramblock.end += paramblock.start;

    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x81, 0x50, &paramblock,
                           ulParamsize, &ulParamsize, NULL, 0, NULL,
                           "cdrom_playaudio", "LOGICAL", param.files()->out1 );
    return ulRc;
}
APIRET playredbook(Kwd_List &param)
{
   struct 
   {
      CHAR     devdrvr[4];
      BYTE     addmode;
      BYTE     start[4];
      BYTE     end[4];
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.addmode = 1;
    IString msf = param["TIMESTART"];
    PCHAR ach1 = strdup(msf);
    paramblock.start[3] = 0;
    paramblock.start[2] = ((ach1[0]-48) * 10) + (ach1[1]-48);
    paramblock.start[1] = ((ach1[3]-48) * 10) + (ach1[4]-48);
    paramblock.start[0] = ((ach1[6]-48) * 10) + (ach1[7]-48);
    msf = param["TIMESTOP"];
    ach1 = strdup(msf);
    paramblock.end[3] = 0;
    paramblock.end[2] = ((ach1[0]-48) * 10) + (ach1[1]-48);
    paramblock.end[1] = ((ach1[3]-48) * 10) + (ach1[4]-48);
    paramblock.end[0] = ((ach1[6]-48) * 10) + (ach1[7]-48);
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x81, 0x50, &paramblock,
                           ulParamsize, &ulParamsize, NULL, 0, NULL,
                           "cdrom_playaudio", "REDBOOK", param.files()->out1 );
    delete[] ach1;
    return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_read2352(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_read2352( Kwd_List& param )
{
    IString addmode = param["ADDRESSMODE"];
    if(addmode == (IString)"REDBOOK")
      ulRc = read2352redbook(param);
    else if(addmode == (IString)"LOGICALBLOCK")
     ulRc = read2352logical(param);
    else
    {
       IString s1;
       s1 = "ERROR : undefined ADDRESSMODE in cdrom_read2352";
       param.files()->out1<<s1;
       ulRc = 0;
    }
   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   return ulRc;
}
APIRET read2352redbook(Kwd_List &param)
{
   Buffer * buff;
   struct 
   {
      CHAR     devdrvr[4];
      BYTE     addmode;
      USHORT   usSectors;
      BYTE     start[4];
      BYTE     byte[3];
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.byte[0] = 0;
    paramblock.byte[1] = 0;
    paramblock.byte[2] = 0;
    paramblock.addmode = 1;
    IString msf = param["TIMESTART"];
    PCHAR ach1 = strdup(msf);
    paramblock.start[3] = 0;
    paramblock.start[2] = ((ach1[0]-48) * 10) + (ach1[1]-48);
    paramblock.start[1] = ((ach1[3]-48) * 10) + (ach1[4]-48);
    paramblock.start[0] = ((ach1[6]-48) * 10) + (ach1[7]-48);
    paramblock.usSectors = param.getInt("SECTORCOUNT");
    ULONG ulDatasize = paramblock.usSectors*2352;
    buff = new Buffer (param["BUFFER"], ulDatasize,
                       param.getPtr(BUFFER_LIST));
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x72, &paramblock,
                           ulParamsize, &ulParamsize, buff->buffer(), ulDatasize, 
                           &ulDatasize, "cdrom_read2352", "REDBOOK", param.files()->out1);
    delete[] ach1;
    param.set(param["BUFFER"], (LONG)buff);
    return ulRc;
}
APIRET read2352logical(Kwd_List &param)
{
   Buffer * buff;
   struct 
   {
      CHAR     devdrvr[4];
      BYTE     addmode;
      USHORT   usSectors;
      LONG     start;
      BYTE     byte[3];
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.byte[0] = 0;
    paramblock.byte[1] = 0;
    paramblock.byte[2] = 0;
    paramblock.addmode = 0;
    paramblock.start = param.getInt("SECTORSTART");
    paramblock.usSectors = param.getInt("SECTORCOUNT");
    ULONG ulDatasize = paramblock.usSectors*2352;
    buff = new Buffer (param["BUFFER"], ulDatasize, 
                       param.getPtr(BUFFER_LIST));
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x72, &paramblock,
                           ulParamsize, &ulParamsize, buff->buffer(), ulDatasize, 
                           &ulDatasize, "cdrom_read2352", "LOGICAL", param.files()->out1);
    param.set(param["BUFFER"], (LONG)buff);
    return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_readpre2352(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_readpre2352( Kwd_List& param )
{
    IString addmode = param["ADDRESSMODE"];
    if(addmode == (IString)"REDBOOK")
      ulRc = readpre2352redbook(param);
    else if(addmode == (IString)"LOGICALBLOCK")
     ulRc = readpre2352logical(param);
    else
    {
       IString s1;
       s1 = "ERROR : undefined ADDRESSMODE in cdrom_readpre2352";
       param.files()->out1<<s1;
       ulRc = 0;
    }
   param.set("CDRC", (IString)(ulRc & errmask));
   if (ulRc != 0)
     printerror(ulRc, param);
   return ulRc;
}
APIRET readpre2352redbook(Kwd_List &param)
{
   Buffer * buff;
   struct 
   {
      CHAR     devdrvr[4];
      BYTE     addmode;
      USHORT   usSectors;
      BYTE     start[4];
      BYTE     byte[3];
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.byte[0] = 0;
    paramblock.byte[1] = 0;
    paramblock.byte[2] = 0;
    paramblock.addmode = 1;
    IString msf = param["TIMESTART"];
    PCHAR ach1 = strdup(msf);
    paramblock.start[3] = 0;
    paramblock.start[2] = ((ach1[0]-48) * 10) + (ach1[1]-48);
    paramblock.start[1] = ((ach1[3]-48) * 10) + (ach1[4]-48);
    paramblock.start[0] = ((ach1[6]-48) * 10) + (ach1[7]-48);
    paramblock.usSectors = param.getInt("SECTORCOUNT");
    ULONG ulDatasize = paramblock.usSectors*2352;
    buff = new Buffer (param["BUFFER"], ulDatasize, 
                       param.getPtr(BUFFER_LIST));
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x71, &paramblock,
                           ulParamsize, &ulParamsize, buff->buffer(), ulDatasize, 
                           &ulDatasize, "cdrom_readpre2352", "REDBOOK", param.files()->out1);
    param.set(param["BUFFER"], (LONG)buff);
    delete[] ach1;
    return ulRc;
}
APIRET readpre2352logical(Kwd_List &param)
{
   Buffer * buff;
   struct 
   {
      CHAR     devdrvr[4];
      BYTE     addmode;
      USHORT   usSectors;
      LONG     start;
      BYTE     byte[3];
    } paramblock;
    ULONG  ulParamsize = sizeof(paramblock);
    HFILE  hfDrvHandle = param.getInt("DRIVEHANDLE");
    paramblock.devdrvr[0] = 'C';
    paramblock.devdrvr[1] = 'D';
    paramblock.devdrvr[2] = '0';
    paramblock.devdrvr[3] = '1';
    paramblock.byte[0] = 0;
    paramblock.byte[1] = 0;
    paramblock.byte[2] = 0;
    paramblock.addmode = 0;
    paramblock.start = param.getInt("SECTORSTART");
    paramblock.usSectors = param.getInt("SECTORCOUNT");
    ULONG ulDatasize = paramblock.usSectors*2352;
    buff = new Buffer (param["BUFFER"], ulDatasize, 
                       param.getPtr(BUFFER_LIST));
    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x80, 0x71, &paramblock,
                           ulParamsize, &ulParamsize, buff->buffer(), ulDatasize, 
                           &ulDatasize, "cdrom_readpre2352", "LOGICAL", param.files()->out1);
    param.set(param["BUFFER"], (LONG)buff);
    return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_qdriverletter(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qdriveletter( Kwd_List& param )
{
  struct
  {
    USHORT usNum;
    USHORT usOffset;
  } data;
  ULONG   ulDatasize = sizeof(data);
  ULONG   ulAction = 0;  
  ULONG   ulOpenFlag;
  ULONG   ulOpenMode;
  HFILE   hfFleHandle;
  Buffer *buff;
  
  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE;

  ulRc = ddtDosOpen( "CD-ROM2$", &hfFleHandle, &ulAction, 0L,
		                 0L, ulOpenFlag, ulOpenMode, NULL,
				 "cdrom_qdriveletter", "only call",
				 param.files()->out1 );
  if( ulRc != DDT_OK )
    return ulRc;

  ulRc = ddtDosDevIOCtl(hfFleHandle, 0x82, 0x60, NULL, 0, NULL, &data,
			ulDatasize, &ulDatasize, "cdrom_qdriveletter",
			"only call", param.files()->out1 );
  param.set("CDRC", (IString)(ulRc & errmask));
  if (data.usNum != 0)
  {
    param.set("$DRIVES", (IString)(long) data.usNum);
    param.set("$FIRSTCD", (IString)(long) data.usOffset);
  }
  if (ulRc != 0)
    return ulRc;
  ulRc = ddtDosClose( hfFleHandle,
							        "cdrom_qdriveletter",
							        "only call",
							        param.files()->out1 );
     if (ulRc != 0)
       printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_qaudiochaninfo(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_qaudiochaninfo(Kwd_List& param)
{
   struct 
   {
      UCHAR     outChan0InputChan;
      UCHAR     outChan0VolChan;
      UCHAR     outChan1InputChan;
      UCHAR     outChan1VolChan;
      UCHAR     outChan2InputChan;
      UCHAR     outChan2VolChan;
      UCHAR     outChan3InputChan;
      UCHAR     outChan3VolChan;
    } data;
    HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");
    ULONG   ulDatasize = sizeof(data);

    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x81, 0x60, "CD01", 4, NULL,
                           &data, ulDatasize, &ulDatasize,
                           "cdrom_qaudiochaninfo", "only call",
                           param.files()->out1 );

    param.set("CDRC", (IString)(ulRc & errmask));
    if (ulRc == 0)
      {
        param.set("INCHAN1", (IString)(ULONG)data.outChan0InputChan);
        param.set("INCHAN2", (IString)(ULONG)data.outChan1InputChan);
        param.set("OUTVOL1", (IString)(ULONG)data.outChan0VolChan);
        param.set("OUTVOL2", (IString)(ULONG)data.outChan1VolChan);
        IString s1;
        IString x;
        s1 = s1 + "\n     Input Channel for Output channel 0 : ";
        x = data.outChan0InputChan;
        s1 = s1 + x.c2d() + "\n";
//    s1 = s1 + (IString)(LONG)data.outChan0InputChan + "\n";
        s1 = s1 + "     Volume for Output channel 0 : ";
        x = data.outChan0VolChan;
        s1 = s1 + x.c2d() + "\n";
        s1 = s1 + "     Input Channel for Output channel 1 : ";
        x = data.outChan1InputChan;
        s1 = s1 + x.c2d() + "\n";
        s1 = s1 + "     Volume for Output channel 1 : ";
        x = data.outChan1VolChan;
        s1 = s1 + x.c2d() + "\n";
        param.files()->out1<<s1;
      }
    if (ulRc != 0)
      printerror(ulRc, param);
    return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_audiochaninfo(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_audiochaninfo(Kwd_List& param)
{
   struct 
   {
      BYTE      outChan0InputChan;
      BYTE      outChan0VolChan;
      BYTE      outChan1InputChan;
      BYTE      outChan1VolChan;
      BYTE      outChan2InputChan;
      BYTE      outChan2VolChan;
      BYTE      outChan3InputChan;
      BYTE      outChan3VolChan;
    } data;
    HFILE   hfDrvHandle = param.getInt("DRIVEHANDLE");
    ULONG   ulDatasize = sizeof(data);

    data.outChan0InputChan = param.getInt("INPUT1");
    data.outChan0VolChan = param.getInt("VOL1");
    data.outChan1InputChan = param.getInt("INPUT2");
    data.outChan1VolChan = param.getInt("VOL2");
    data.outChan2InputChan = 2;
    data.outChan2VolChan = 255;
    data.outChan3InputChan = 3;
    data.outChan3VolChan = 255;

    ulRc = ddtDosDevIOCtl( hfDrvHandle, 0x81, 0x40, "CD01", 4, NULL,
                           &data, ulDatasize, &ulDatasize,
                           "cdrom_audiochaninfo", "only call",
                           param.files()->out1 );

    param.set("CDRC", (IString)(ulRc & errmask));
    if (ulRc != 0)
      printerror(ulRc, param);
    return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_read2048(Kwd_List &)
**
** Description:  
**
** Parameters:  Kwd_List &. 
**
** Returns:     APIRET. 
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export cdrom_devread2048( Kwd_List& param )
{
  ULONG      ulStartPosition;
  Buffer    *buff;
  HFILE      hfDrvHandle = param.getInt("DRIVEHANDLE");
  ULONG      ulsecstart = param.getInt("SECTORSTART");
  ULONG      ulseccount = param.getInt("SECTORCOUNT");
  ULONG      ulDatasize = 2048*ulseccount;

  ulsecstart *= 2048L;
  ulRc = ddtDosSetFilePtr( hfDrvHandle, ulsecstart, FILE_BEGIN,
                           &ulStartPosition, "cdrom_devread2048",
                           "Only call", param.files()->out1 );
  
  buff = new Buffer (param["BUFFER"], ulDatasize, param.getPtr(BUFFER_LIST));
  ulRc = ddtDosRead( hfDrvHandle, buff->buffer(), ulDatasize,
                     &ulDatasize, "cdrom_devread2048",
                     "Only call", param.files()->out1 );

  param.set(param["BUFFER"], (LONG)buff);
  param.set("CDRC", (IString)(ulRc & errmask));
  if (ulRc != 0)
    printerror(ulRc, param);
  return ulRc;
}
/*
*************************************************************************
** Name: APIRET _export cdrom_checksector(Kwd_List &)
**
** Description: Function compares an input sector number with a sector
**              number found at a known position in the input buffer
**              for tracks 1, 3 and 6 on the IBM Test CDROM.  Sector
**              number is stored in a doubleword (lower 3 bytes and
**              1-based) at doubleword offset 0 for cooked records
**              and offset 4 for raw records.
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:    Function limited to use with IBM Test CDROM tracks 1,3,6
**
**************************************************************************
*/
APIRET _export cdrom_checksector( Kwd_List& param )
{
  IString    readmode = param["READMODE"];
  IString    buffername = (param["$BUFFER"]);
  ULONG      ultemp;
  ULONG      *ulptr;
  ULONG      ulsector = param.getInt("$SECTOR");
  Buffer     *buffptr = (Buffer *)param.getPtr(buffername);

  ulptr = (ULONG *)buffptr->buffer();

  if ((ulptr == NULL) || (buffptr == NULL))
    {
      IString s1 = "ERROR:  Input buffer for CHECKSECTOR is NULL";
      param.files()->out1 << s1;
      return(0);
     }

  if (readmode == (IString)"COOKED")
    {
      ultemp = *ulptr & 0xFFFFFF;   //AND out high-end byte
      if ((ultemp - 1) != ulsector)
        {
         IString s1 = "Failure:  Expected sector value not found in buffer";
         s1 = s1 + "\n    Sector read = " + (IString)(LONG)ulsector;
         param.files()->out1 << s1;
        }
      return(0);
     }
   else if (readmode == (IString)"RAW")
    {
      ultemp = *(ulptr + 4) & 0xFFFFFF;  //AND out high-end byte
      if ((ultemp - 1) != ulsector)
        {
         IString s1 = "Failure:  Expected sector value not found in buffer";
         s1 = s1 + "\n    Sector read = " + (IString)(LONG)ulsector;
         param.files()->out1 << s1;
        }
      return(0);
     }
   else
    {
      IString s1 = "ERROR:  Undefined READMODE in CHECKSECTOR";
      param.files()->out1 << s1;
      return(0);
     }
}
/*
*************************************************************************
** Name: APIRET _export cdrom_checkreturn(Kwd_List &)
**
** Description: Function compares an input return code with a value
**              set by a previous function.  If the values do not
**              compare, a failure message is logged.   
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:    Function limited to use with CDROM functions.
**
**************************************************************************
*/
APIRET _export cdrom_checkreturn( Kwd_List& param )
{
  ULONG      ulfuncrc = param.getInt("CDRC");
  ULONG      ulexpect = param.getInt("$RC");
  IString    s1;

  if (ulexpect != ulfuncrc)
    {
       s1 = "Failure:  Expected return code not received";
       s1 = s1 + "\n    Expected rc = " + (IString)(LONG)ulexpect;
     }
   else
     s1 = "Success:  Return code check passed";
   param.files()->out1 << s1;
   return(0);
}
/*
*************************************************************************
** Name: APIRET _export cdrom_checkvalue(Kwd_List &)
**
** Description: Function compares an input numeric value with a parameter
**              value set by a previous function.  If the values do not
**              compare, a failure message is logged.   
**
** Parameters:  Kwd_List &.
**
** Returns:     APIRET.
**
** Cautions:    Previous function must have successfully set input parms
**
**************************************************************************
*/
APIRET _export cdrom_checkvalue( Kwd_List& param )
{
  ULONG      ulparm   = param.getInt("$PARM");
  ULONG      ulexpect = param.getInt("$EXPECT");
  IString    s1;

  if (ulexpect != ulparm)
    {
       s1 = "Failure:  Expected value not received";
       s1 = s1 + "\n    Expected value = " + (IString)(LONG)ulexpect;
       s1 = s1 + "\n    Returned parameter = " + (IString)(LONG)ulparm;
     }
   else
     s1 = "Success:  Expected parameter value received";
   param.files()->out1 << s1;
   return(0);
}
/*
******************************************************************
* printerror(ULONG)
*
*
******************************************************************
*/
VOID printerror(ULONG &ul, Kwd_List &param)
{
 IString s1;
 s1 = "ERROR: ";
 switch (ul)
 {
   case 0xff02:
      s1 += "Device Not Ready.";
      break;
   case 0xff03:
      s1 += "Unknown Command.";
      break;
   case 0xff04:
      s1 += "Cyclic Redundancy Check Failure.";
      break;
   case 0xff06:
      s1 += "Seek error.";
      break;
   case 0xff07:
      s1 += "Unknown Media.";
      break;
   case 0xff08:
      s1 += "Sector Not Found.";
      break;
   case 0xff0a:
      s1 += "Write Error.";
      break;
   case 0xff0c:
      s1 += "General Faliure.";
      break;
   case 0xff10:
      s1 += "Uncertain Media.";
      break;
   case 0xff13:
      s1 += "Unsupported Parameter.";
      break;
   case 0xff14:
      s1 += "Device already in use.";
      break;
   default:
      s1 += "Unknown error; Return code is : ";
      char temp[30];
      sprintf(temp, "%.4X", ul);
//      s1 = s1 + (IString)(LONG)ul;
      s1 = s1 + " 0x" + temp;
      break;
   }
   param.files()->out1<<s1;
   ul = 0;
   return;
}
