/*
**************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification:		IBM Test Tool
**
** Original Author and Date:	Barkha Herman, March 24, 1994.
**
** Revisions:	Jesse Chen (co-op, CAL Berkeley) 4/19/1994
**		Barkha J. Herman 4/27/94 - Added ASYNC support
**		Adam Loving 12/21 - replaced (__far16 *) qualifiers with (* _Seg16)
**				     - changed several calls to strncpy from 
**				        strncpy(paramblock->Drvname,...etc to
**				        strncpy((char*)&(paramblock->DrvNam[0]),...
**				     - changed casting of pBitsStatus in Check Status function
**					
**
** Comments:			Expanded flags to output readable strings.
**
** Public Class/ Functions:
**
**************************************************************************
*/
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "ddtos2.h"
#include "kwdlist.h"
#include "apicover.h"
#include "dasdadd.h"
#include "clsiorb.h"
#include "scatgat.h"
#include "bit.h"

// global stuff 

CHAR	OutBuff[256];
IString printdevicetable(PARAMS *);
APIRET _export printstatus(Kwd_List &);
IString hex(IString);

/*
*************************************************************************
** Name:         APIRET _export dd_open( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_open( Kwd_List& param )
{
  APIRET  ulRc;
  ULONG   ulAction  = 0;
  ULONG   ulOpenFlag;
  ULONG   ulOpenMode;
  HFILE   drvhndle;

  ulOpenFlag = OPEN_ACTION_OPEN_IF_EXISTS;
  ulOpenMode = OPEN_FLAGS_FAIL_ON_ERROR | OPEN_SHARE_DENYWRITE;
  ulRc = ddtDosOpen( "DASDADD$", &drvhndle, &ulAction, 0L, 0L, ulOpenFlag,
		                  ulOpenMode, NULL, "dd_open", "only call",
		                  param.files()->out1);
  param.set("DRIVEHANDLE", (long)drvhndle );
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetDrivers( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetDrivers( Kwd_List& param )
{
  APIRET 	  ulRc;
  HFILE 	    drvHndle = param.getInt("DRIVEHANDLE");
  PARAMS 	  paramblock;
  ULONG      paramlen = sizeof(paramblock);
  UCHAR     	aDrvNam[32][16];
  ULONG     	datalen = 16*32;

  paramblock.nDrivers = 0;
  paramblock.DevClass = 1; // for disks.
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x00,
			                    &paramblock, paramlen, &paramlen,
	                        aDrvNam, datalen, &datalen,
		                   	  "dd_GetDrivers", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    IString s1("Drivers Names:");
    param.set("DRIVERS", (IString)(long)paramblock.nDrivers);
    for (int i = 0; i < paramblock.nDrivers; i++)
     {
       s1 = s1 + "\n     " +(IString)(const char *)aDrvNam[i];
     }
     param.files()->out1<<s1;
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetDeviceTable( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetDeviceTable( Kwd_List& param )
{
  APIRET                 ulRc   = 0;
  HFILE                  drvHndle = param.getInt("DRIVEHANDLE");
  DEVICETABLE  * _Seg16 pdevicetable;
  ULONG                  datalen = MAX_DT_SIZE;
  PARAMS                *paramblock = new PARAMS;
  BYTE                  *buffer = new BYTE[MAX_DT_SIZE];

  pdevicetable         = (DEVICETABLE * _Seg16)buffer;
  paramblock->DevClass = 1; // for disks.
  paramblock->flag     = param.getInt("MODE");

  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);    //AL
//  strncpy(paramblock->DrvNam,param["DRVNAME"],16);
  paramblock->iorb.iorb_configuration.iorbh.Length
	                 = sizeof(paramblock->iorb.iorb_configuration);
  paramblock->iorb.iorb_configuration.iorbh.UnitHandle     = 0;
  paramblock->iorb.iorb_configuration.iorbh.CommandCode    = IOCC_CONFIGURATION;
  paramblock->iorb.iorb_configuration.iorbh.CommandModifier= IOCM_GET_DEVICE_TABLE;
  paramblock->iorb.iorb_configuration.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_configuration.iorbh.Status         = 0;
  paramblock->iorb.iorb_configuration.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_configuration.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_configuration.pDeviceTable         = pdevicetable;
  paramblock->iorb.iorb_configuration.DeviceTableLen       = MAX_DT_SIZE;
  ULONG paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x01,
			                    paramblock, paramlen, &paramlen,
			                    pdevicetable, datalen, &datalen,
			                    "dd_GetDeviceTable", "only call",
                         param.files()->out1 );
  if (ulRc == 0)
    if (paramblock->flag == 1)
    {
      IString s1;
      s1 = printdevicetable(paramblock);
      param.files()->out1<<s1;
    }
    else
     param.set(param["LABEL"], (LONG)paramblock);
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_AllocateUnit( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_AllocateUnit( Kwd_List& param )
{
  APIRET       ulRc;
  PARAMS       *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  UNITINFO     data;
  ULONG        datalen = sizeof(UNITINFO);
  HFILE        drvHndle = param.getInt("DRIVEHANDLE");
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_control.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_unit_control);
  paramblock->iorb.iorb_unit_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_control.iorbh.CommandCode    = IOCC_UNIT_CONTROL;
  paramblock->iorb.iorb_unit_control.iorbh.CommandModifier= IOCM_ALLOCATE_UNIT;
  paramblock->iorb.iorb_unit_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_control.pUnitInfo            = (UNITINFO * _Seg16)&data;
  paramblock->iorb.iorb_unit_control.UnitInfoLen          = datalen;
  paramblock->iorb.iorb_unit_control.Flags                = 0;
  ULONG        paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x02,
                         paramblock, paramlen, &paramlen,
                         &data, datalen, &datalen,
                   		 "dd_AllocateUnit", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_DeAllocateUnit( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_DeAllocateUnit( Kwd_List& param )
{
  APIRET       ulRc;
  UNITINFO     data;
  ULONG        datalen = sizeof(UNITINFO);
  PARAMS       *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE        drvHndle = param.getInt("DRIVEHANDLE");
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_control.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_unit_control);
  paramblock->iorb.iorb_unit_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_control.iorbh.CommandCode    = IOCC_UNIT_CONTROL;
  paramblock->iorb.iorb_unit_control.iorbh.CommandModifier= IOCM_DEALLOCATE_UNIT;
  paramblock->iorb.iorb_unit_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_control.pUnitInfo            = (UNITINFO * _Seg16)&data;
  paramblock->iorb.iorb_unit_control.UnitInfoLen          = datalen;
  paramblock->iorb.iorb_unit_control.Flags                = 0;
  ULONG        paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x02,
			 paramblock, paramlen, &paramlen,
			 &data, datalen, &datalen,
			 "dd_DeAllocateUnit", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_ChangeUnitInfo( Kwd_List& )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/

APIRET _export dd_ChangeUnitInfo( Kwd_List& param )
{
  APIRET       ulRc;
  UNITINFO     data;
  ULONG        datalen = sizeof(UNITINFO);
  PARAMS       *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE        drvHndle = param.getInt("DRIVEHANDLE");
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_control.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_unit_control);
  paramblock->iorb.iorb_unit_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_control.iorbh.CommandCode    = IOCC_UNIT_CONTROL;
  paramblock->iorb.iorb_unit_control.iorbh.CommandModifier= IOCM_CHANGE_UNITINFO;
  paramblock->iorb.iorb_unit_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_control.pUnitInfo            = (UNITINFO * _Seg16)&data;
  paramblock->iorb.iorb_unit_control.UnitInfoLen          = datalen;
  paramblock->iorb.iorb_unit_control.Flags                = 0;
  ULONG        paramlen  = sizeof(paramblock);
  data.AdapterIndex      = param.getInt("ADAPTERINDEX");
  data.UnitIndex         = param.getInt("UNITINDEX");
  data.UnitFlags         = param.getInt("UNITFLAGS");
  data.UnitHandle        = param.getInt("UNITHANDLE");
  data.FilterADDHandle   = param.getInt("FILTERHANDLE");
  data.UnitType          = param.getInt("UNITTYPE");
  data.QueuingCount      = param.getInt("QUEUINGCOUNT");
  data.UnitSCSITargetID  = param.getInt("UNITSCSIID");
  data.UnitSCSILUN       = param.getInt("UNITSCSILUN");
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x02,
			 paramblock, paramlen, &paramlen,
			 &data, datalen, &datalen,
			 "dd_ChangeUnitInfo", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetMediaGeometry( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetMediaGeometry( Kwd_List &param )
{
  APIRET      ulRc;
  GEOMETRY    data;
  ULONG       datalen = sizeof(data);
  PARAMS      *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_geometry.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_geometry);
  paramblock->iorb.iorb_geometry.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_geometry.iorbh.CommandCode    = IOCC_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.CommandModifier= IOCM_GET_MEDIA_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_geometry.iorbh.Status         = 0;
  paramblock->iorb.iorb_geometry.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_geometry.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_geometry.pGeometry            = (GEOMETRY * _Seg16)&data;
  paramblock->iorb.iorb_geometry.GeometryLen          = datalen;
  ULONG       paramlen = sizeof(paramblock);
  
  data.TotalSectors    = 0;
  data.BytesPerSector  = 0;
  data.Reserved        = 0;
  data.NumHeads        = 0;
  data.TotalCylinders  = 0;
  data.SectorsPerTrack = 0;
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x03,
                         paramblock, paramlen, &paramlen,
                         &data, datalen, &datalen,
			 "dd_GetMediaGeometry", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_SetMediaGeometry( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_SetMediaGeometry( Kwd_List &param )
{
  APIRET      ulRc;
  GEOMETRY    data;
  ULONG       datalen = sizeof(data);
  PARAMS      *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_geometry.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_geometry);
  paramblock->iorb.iorb_geometry.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_geometry.iorbh.CommandCode    = IOCC_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.CommandModifier= IOCM_SET_MEDIA_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_geometry.iorbh.Status         = 0;
  paramblock->iorb.iorb_geometry.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_geometry.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_geometry.pGeometry            = (GEOMETRY * _Seg16)&data;
  paramblock->iorb.iorb_geometry.GeometryLen          = datalen;
  ULONG       paramlen = sizeof(paramblock);
  data.TotalSectors    = param.getInt("TOTALSECTORS");
  data.BytesPerSector  = param.getInt("BYTESPERSECTOR");
  data.Reserved        = 0;
  data.NumHeads        = param.getInt("NUMHEAD");
  data.TotalCylinders  = param.getInt("TOTALCYLINDER");
  data.SectorsPerTrack = param.getInt("SECTORPERTRACK");
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x03,
                         paramblock, paramlen, &paramlen,
                         &data, datalen, &datalen,
			 "dd_SetMediaGeometry", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetDeviceGeometry( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetDeviceGeometry( Kwd_List &param )
{
  APIRET      ulRc;
  GEOMETRY    data;
  ULONG       datalen = sizeof(data);
  PARAMS      *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_geometry.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_geometry);
  paramblock->iorb.iorb_geometry.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_geometry.iorbh.CommandCode    = IOCC_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.CommandModifier= IOCM_GET_DEVICE_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_geometry.iorbh.Status         = 0;
  paramblock->iorb.iorb_geometry.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_geometry.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_geometry.pGeometry            = (GEOMETRY * _Seg16)&data;
  paramblock->iorb.iorb_geometry.GeometryLen          = datalen;
  ULONG       paramlen = sizeof(paramblock);
  data.TotalSectors    = 0;
  data.BytesPerSector  = 0;
  data.Reserved        = 0;
  data.NumHeads        = 0;
  data.TotalCylinders  = 0;
  data.SectorsPerTrack = 0;
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x03,
                         paramblock, paramlen, &paramlen,
                         &data, datalen, &datalen,
			 "dd_GetDeviceGeometry", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_SetLogicalGeometry( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_SetLogicalGeometry( Kwd_List &param )
{
  APIRET      ulRc;
  GEOMETRY    data;
  ULONG       datalen = sizeof(data);
  PARAMS      *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_geometry.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_geometry);
  paramblock->iorb.iorb_geometry.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_geometry.iorbh.CommandCode    = IOCC_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.CommandModifier= IOCM_SET_LOGICAL_GEOMETRY;
  paramblock->iorb.iorb_geometry.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_geometry.iorbh.Status         = 0;
  paramblock->iorb.iorb_geometry.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_geometry.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_geometry.pGeometry            = (GEOMETRY * _Seg16)&data;
  paramblock->iorb.iorb_geometry.GeometryLen          = datalen;
  ULONG       paramlen = sizeof(paramblock);
  data.TotalSectors    = param.getInt("TOTALSECTORS");
  data.BytesPerSector  = param.getInt("BYTESPERSECTOR");
  data.Reserved        = 0;
  data.NumHeads        = param.getInt("NUMHEAD");
  data.TotalCylinders  = param.getInt("TOTALCYLINDER");
  data.SectorsPerTrack = param.getInt("SECTORPERTRACK");
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x03,
			 paramblock, paramlen, &paramlen,
			 &data, datalen, &datalen,
			 "dd_SetLogicalGeometry", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_Read( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_Read( Kwd_List &param )
{
  APIRET                 ulRc;
  PARAMS                 *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE                  drvHndle = param.getInt("DRIVEHANDLE");
  ScatGat                *psg;
  psg = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
  paramblock->DevClass = 1; // for disks

  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_executeio.iorbh.Length
			= sizeof(paramblock->iorb.iorb_executeio);
  paramblock->iorb.iorb_executeio.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_executeio.iorbh.CommandCode    = IOCC_EXECUTE_IO;
  paramblock->iorb.iorb_executeio.iorbh.CommandModifier= IOCM_READ;
  paramblock->iorb.iorb_executeio.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_executeio.iorbh.Status         = 0;
  paramblock->iorb.iorb_executeio.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_executeio.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_executeio.pSGList              = psg->entry();
  paramblock->iorb.iorb_executeio.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_executeio.ppSGList             = 0;
  paramblock->iorb.iorb_executeio.RBA                  = param.getInt("RBA");
  paramblock->iorb.iorb_executeio.BlockCount           = param.getInt("BLOCKCOUNT");
  paramblock->iorb.iorb_executeio.BlocksXferred        = 0;
  paramblock->iorb.iorb_executeio.BlockSize            = param.getInt("BLOCKSIZE");
  paramblock->iorb.iorb_executeio.Flags                = param.getInt("READFLAGS");
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x04,
			 paramblock, paramlen, &paramlen,
			 NULL, 0, NULL,
			 "dd_Read", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_ReadVerify( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_ReadVerify( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle  = param.getInt("DRIVEHANDLE");
  ScatGat                *psg;
  psg = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));


  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_executeio.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_executeio);
  paramblock->iorb.iorb_executeio.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_executeio.iorbh.CommandCode    = IOCC_EXECUTE_IO;
  paramblock->iorb.iorb_executeio.iorbh.CommandModifier= IOCM_READ_VERIFY;
  paramblock->iorb.iorb_executeio.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_executeio.iorbh.Status         = 0;
  paramblock->iorb.iorb_executeio.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_executeio.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_executeio.pSGList              = psg->entry();
  paramblock->iorb.iorb_executeio.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_executeio.ppSGList             = 0;
  paramblock->iorb.iorb_executeio.RBA                  = param.getInt("RBA");
  paramblock->iorb.iorb_executeio.BlockCount           = param.getInt("BLOCKCOUNT");
  paramblock->iorb.iorb_executeio.BlocksXferred        = 0;
  paramblock->iorb.iorb_executeio.BlockSize            = param.getInt("BLOCKSIZE");
  paramblock->iorb.iorb_executeio.Flags                = param.getInt("READFLAGS");
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x04,
			 paramblock, paramlen, &paramlen,
			 NULL, 0, NULL,
			 "dd_ReadVerify", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_ReadPrefetch( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_ReadPrefetch( Kwd_List &param )
{
  APIRET         ulRc;
  SCATGATENTRY   data;
  ULONG          datalen = sizeof(data);
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");
  ScatGat                *psg;
  psg = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_executeio.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_executeio);
  paramblock->iorb.iorb_executeio.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_executeio.iorbh.CommandCode    = IOCC_EXECUTE_IO;
  paramblock->iorb.iorb_executeio.iorbh.CommandModifier= IOCM_READ_PREFETCH;
  paramblock->iorb.iorb_executeio.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_executeio.iorbh.Status         = 0;
  paramblock->iorb.iorb_executeio.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_executeio.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_executeio.pSGList              = psg->entry(); 
  paramblock->iorb.iorb_executeio.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_executeio.ppSGList             = 0;
  paramblock->iorb.iorb_executeio.RBA                  = param.getInt("RBA");
  paramblock->iorb.iorb_executeio.BlockCount           = param.getInt("BLOCKCOUNT");
  paramblock->iorb.iorb_executeio.BlocksXferred        = 0;
  paramblock->iorb.iorb_executeio.BlockSize            = param.getInt("BLOCKSIZE");
  paramblock->iorb.iorb_executeio.Flags                = param.getInt("READFLAGS");
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x04,
			 paramblock, paramlen, &paramlen,
			 &data, datalen, &datalen,
			 "dd_ReadPrefetch", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_Write( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_Write( Kwd_List &param )
{
  APIRET         ulRc;
  SCATGATENTRY   data;
  ULONG          datalen = sizeof(data);
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");
  ScatGat                *psg;
  psg = (ScatGat *)param.getPtr("SCATGAT");
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_executeio.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_executeio);
  paramblock->iorb.iorb_executeio.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_executeio.iorbh.CommandCode    = IOCC_EXECUTE_IO;
  paramblock->iorb.iorb_executeio.iorbh.CommandModifier= IOCM_WRITE;
  paramblock->iorb.iorb_executeio.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_executeio.iorbh.Status         = 0;
  paramblock->iorb.iorb_executeio.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_executeio.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_executeio.pSGList              = psg->entry(); // (SCATGATENTRY * _Seg16)&data;
  paramblock->iorb.iorb_executeio.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_executeio.ppSGList             = 0;
  paramblock->iorb.iorb_executeio.RBA                  = param.getInt("RBA");
  paramblock->iorb.iorb_executeio.BlockCount           = param.getInt("BLOCKCOUNT");
  paramblock->iorb.iorb_executeio.BlocksXferred        = 0;
  paramblock->iorb.iorb_executeio.BlockSize            = param.getInt("BLOCKSIZE");
  paramblock->iorb.iorb_executeio.Flags                = param.getInt("READFLAGS");
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x04,
			 paramblock, paramlen, &paramlen,
			 &data, datalen, &datalen,
			 "dd_Write", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_WriteVerify( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_WriteVerify( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");
  ScatGat                *psg;
  psg = (ScatGat *)param.getPtr("SCATGAT");
  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_executeio.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_executeio);
  paramblock->iorb.iorb_executeio.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_executeio.iorbh.CommandCode    = IOCC_EXECUTE_IO;
  paramblock->iorb.iorb_executeio.iorbh.CommandModifier= IOCM_WRITE_VERIFY;
  paramblock->iorb.iorb_executeio.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_executeio.iorbh.Status         = 0;
  paramblock->iorb.iorb_executeio.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_executeio.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_executeio.pSGList              = psg->entry(); 
  paramblock->iorb.iorb_executeio.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_executeio.ppSGList             = 0;
  paramblock->iorb.iorb_executeio.RBA                  = param.getInt("RBA");
  paramblock->iorb.iorb_executeio.BlockCount           = param.getInt("BLOCKCOUNT");
  paramblock->iorb.iorb_executeio.BlocksXferred        = 0;
  paramblock->iorb.iorb_executeio.BlockSize            = param.getInt("BLOCKSIZE");
  paramblock->iorb.iorb_executeio.Flags                = param.getInt("READFLAGS");
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x04,
			 paramblock, paramlen, &paramlen,
			 NULL, 0, NULL,
			 "dd_WriteVerify", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetUnitStatus( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetUnitStatus( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_status.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_unit_status);
  paramblock->iorb.iorb_unit_status.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_status.iorbh.CommandCode    = IOCC_UNIT_STATUS;
  paramblock->iorb.iorb_unit_status.iorbh.CommandModifier= IOCM_GET_UNIT_STATUS;
  paramblock->iorb.iorb_unit_status.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_status.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_status.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_status.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_status.UnitStatus           = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x06,
			 paramblock, paramlen, &paramlen,
			 NULL, 0, NULL,
			 "dd_GetUnitStatus", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetChangelineState( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetChangelineState( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_status.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_unit_status);
  paramblock->iorb.iorb_unit_status.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_status.iorbh.CommandCode    = IOCC_UNIT_STATUS;
  paramblock->iorb.iorb_unit_status.iorbh.CommandModifier= IOCM_GET_CHANGELINE_STATE;
  paramblock->iorb.iorb_unit_status.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_status.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_status.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_status.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_status.UnitStatus           = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x06,
			 paramblock, paramlen, &paramlen,
			 NULL, 0, NULL,
			 "dd_GetChangelineState", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetMediaSense( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetMediaSense( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_status.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_unit_status);
  paramblock->iorb.iorb_unit_status.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_status.iorbh.CommandCode    = IOCC_UNIT_STATUS;
  paramblock->iorb.iorb_unit_status.iorbh.CommandModifier= IOCM_GET_MEDIA_SENSE;
  paramblock->iorb.iorb_unit_status.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_status.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_status.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_status.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_status.UnitStatus           = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x06,
                         paramblock, paramlen, &paramlen,
                         NULL, 0, NULL,
			                    "dd_GetMediaSense", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_GetLockStatus( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_GetLockStatus( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_unit_status.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_unit_status);
  paramblock->iorb.iorb_unit_status.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_unit_status.iorbh.CommandCode    = IOCC_UNIT_STATUS;
  paramblock->iorb.iorb_unit_status.iorbh.CommandModifier= IOCM_GET_LOCK_STATUS;
  paramblock->iorb.iorb_unit_status.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_unit_status.iorbh.Status         = 0;
  paramblock->iorb.iorb_unit_status.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_unit_status.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_unit_status.UnitStatus           = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x06,
			                    paramblock, paramlen, &paramlen,
			                    NULL, 0, NULL,
			                    "dd_GetLockStatus", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_Abort( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_Abort( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_ABORT;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
			                    paramblock, paramlen, &paramlen,
			                    NULL, 0, NULL,
			                    "dd_Abort", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_Reset( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_Reset( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_RESET;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
			                    paramblock, paramlen, &paramlen,
			                    NULL, 0, NULL,
			                    "dd_Reset", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_Suspend( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_Suspend( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_SUSPEND;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = param.getInt("SUSPENDFLAG");
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
                         paramblock, paramlen, &paramlen,
			                    NULL, 0, NULL,
			                    "dd_Suspend", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_Resume( Kwd_List & )
**
** Description:
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_Resume( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_RESUME;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
                         paramblock, paramlen, &paramlen,
                         NULL, 0, NULL,
	 						            "dd_Resume", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_LockMedia( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_LockMedia( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
		     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_LOCK_MEDIA;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
                         paramblock, paramlen, &paramlen,
                         NULL, 0, NULL,
			                    "dd_LockMedia", "only call", param.files()->out1 );
  if (ulRc == 0)
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_UnlockMedia( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_UnlockMedia( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_UNLOCK_MEDIA;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
			                    paramblock, paramlen, &paramlen,
			                    NULL, 0, NULL,
			                    "dd_UnlockMedia", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_EjectMedia( Kwd_List & )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_EjectMedia( Kwd_List &param )
{
  APIRET         ulRc;
  PARAMS         *paramblock = new PARAMS;
  paramblock->flag = param.getInt("MODE");
  HFILE drvHndle = param.getInt("DRIVEHANDLE");

  paramblock->DevClass = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_device_control.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_device_control);
  paramblock->iorb.iorb_device_control.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_device_control.iorbh.CommandCode    = IOCC_DEVICE_CONTROL;
  paramblock->iorb.iorb_device_control.iorbh.CommandModifier= IOCM_EJECT_MEDIA;
  paramblock->iorb.iorb_device_control.iorbh.RequestControl = IORB_DISABLE_RETRY;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_device_control.iorbh.Status         = 0;
  paramblock->iorb.iorb_device_control.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_device_control.iorbh.Timeout        = 0;
  paramblock->iorb.iorb_device_control.Flags                = 0;
  ULONG       paramlen = sizeof(paramblock);
  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x07,
                         paramblock, paramlen, &paramlen,
                         NULL, 0, NULL,
	 						            "dd_EjectMedia", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)paramblock);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_CDB12( Kwd_List &param )
{
  APIRET                 ulRc;
  // scather gather list to hold info.
  ScatGat               *psg;
  psg = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
  // handle to test dd.
  HFILE drvHndle       = param.getInt("DRIVEHANDLE");
  // paramblock for test dd.
  ULONG       paramlen = sizeof(PARAMS) + sizeof(SCSI_STATUS_BLOCK);
  BYTE *pb = new BYTE[paramlen];

  PARAMS                 *paramblock = (PARAMS *)pb;
  paramblock->flag      = param.getInt("MODE");
  paramblock->DevClass  = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_adapter_passthru.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_adapter_passthru);
  paramblock->iorb.iorb_adapter_passthru.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandCode    = IOCC_ADAPTER_PASSTHRU;
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier= IOCM_EXECUTE_CDB;
  paramblock->iorb.iorb_adapter_passthru.iorbh.RequestControl = 8;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Status         = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Timeout        = param.getInt("TIMEOUT");
  paramblock->iorb.iorb_adapter_passthru.iorbh.pStatusBlock   = (USHORT)(OFFSETOF(pb)+sizeof(PARAMS));
  paramblock->iorb.iorb_adapter_passthru.iorbh.StatusBlockLen = sizeof(SCSI_STATUS_BLOCK);
  paramblock->iorb.iorb_adapter_passthru.Flags                = 0;
  paramblock->iorb.iorb_adapter_passthru.pSGList              = psg->entry(); 
  paramblock->iorb.iorb_adapter_passthru.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_adapter_passthru.ppSGLIST             = 0;
  CDB12 *cdb = new CDB12;
  cdb->byte11 = param.getInt("CDB_BYTE11");
  cdb->byte10 = param.getInt("CDB_BYTE10");
  cdb->byte9 = param.getInt("CDB_BYTE9");
  cdb->byte8 = param.getInt("CDB_BYTE8");
  cdb->byte7 = param.getInt("CDB_BYTE7");
  cdb->byte6 = param.getInt("CDB_BYTE6");
  cdb->byte5 = param.getInt("CDB_BYTE5");
  cdb->byte4 = param.getInt("CDB_BYTE4");
  cdb->byte3 = param.getInt("CDB_BYTE3");
  cdb->byte2 = param.getInt("CDB_BYTE2");
  cdb->byte1 = param.getInt("CDB_BYTE1");
  cdb->byte0 = param.getInt("CDB_BYTE0");
  paramblock->iorb.iorb_adapter_passthru.pControllerCmd      = (BYTE * _Seg16)cdb;
  paramblock->iorb.iorb_adapter_passthru.ControllerCmdLen    = 12;

  // scsi status block for testdd / test add.
  SCSI_STATUS_BLOCK *ssb = (SCSI_STATUS_BLOCK *)(pb + sizeof(PARAMS));
  ssb->Flags = 0;           
  ssb->AdapterErrorCode = 0;
  ssb->TargetStatus = 0;    
  ssb->ResidualLength = 0;  
  ssb->AdapterDiagInfo[0] = 0;
  ssb->SenseData   = (SCSI_REQSENSE_DATA * _Seg16)new SCSI_REQSENSE_DATA;
  ssb->ReqSenseLen = sizeof(SCSI_REQSENSE_DATA);

  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x08,
                         pb, paramlen, &paramlen,
                         NULL, 0, NULL,
	 						            "dd_CDB12", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)pb);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_CDB10( Kwd_List &param )
{
  APIRET                 ulRc;
  // scather gather list to hold info.
  ScatGat               *psg;
  psg = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
  // handle to test dd.
  HFILE drvHndle       = param.getInt("DRIVEHANDLE");
  // paramblock for test dd.
  ULONG       paramlen = sizeof(PARAMS) + sizeof(SCSI_STATUS_BLOCK);
  BYTE *pb = new BYTE[paramlen];

  PARAMS                 *paramblock = (PARAMS *)pb;
  paramblock->flag      = param.getInt("MODE");
  paramblock->DevClass  = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_adapter_passthru.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_adapter_passthru);
  paramblock->iorb.iorb_adapter_passthru.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandCode    = IOCC_ADAPTER_PASSTHRU;
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier= IOCM_EXECUTE_CDB;
  paramblock->iorb.iorb_adapter_passthru.iorbh.RequestControl = 8;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Status         = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Timeout        = param.getInt("TIMEOUT");
  paramblock->iorb.iorb_adapter_passthru.iorbh.pStatusBlock   = (USHORT)(OFFSETOF(pb)+sizeof(PARAMS));
  paramblock->iorb.iorb_adapter_passthru.iorbh.StatusBlockLen = sizeof(SCSI_STATUS_BLOCK);
  paramblock->iorb.iorb_adapter_passthru.Flags                = 0;
  paramblock->iorb.iorb_adapter_passthru.pSGList              = psg->entry(); 
  paramblock->iorb.iorb_adapter_passthru.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_adapter_passthru.ppSGLIST             = 0;
  CDB10 *cdb = new CDB10;
  cdb->byte9 = param.getInt("CDB_BYTE9");
  cdb->byte8 = param.getInt("CDB_BYTE8");
  cdb->byte7 = param.getInt("CDB_BYTE7");
  cdb->byte6 = param.getInt("CDB_BYTE6");
  cdb->byte5 = param.getInt("CDB_BYTE5");
  cdb->byte4 = param.getInt("CDB_BYTE4");
  cdb->byte3 = param.getInt("CDB_BYTE3");
  cdb->byte2 = param.getInt("CDB_BYTE2");
  cdb->byte1 = param.getInt("CDB_BYTE1");
  cdb->byte0 = param.getInt("CDB_BYTE0");
  paramblock->iorb.iorb_adapter_passthru.pControllerCmd      = (BYTE * _Seg16)cdb;
  paramblock->iorb.iorb_adapter_passthru.ControllerCmdLen    = 10;

  // scsi status block for testdd / test add.
  SCSI_STATUS_BLOCK *ssb = (SCSI_STATUS_BLOCK *)(pb + sizeof(PARAMS));
  ssb->Flags = 0;           
  ssb->AdapterErrorCode = 0;
  ssb->TargetStatus = 0;    
  ssb->ResidualLength = 0;  
  ssb->AdapterDiagInfo[0] = 0;
  ssb->SenseData   = (SCSI_REQSENSE_DATA * _Seg16)new SCSI_REQSENSE_DATA;
  ssb->ReqSenseLen = sizeof(SCSI_REQSENSE_DATA);

  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x08,
                         pb, paramlen, &paramlen,
                         NULL, 0, NULL,
	 						            "dd_CDB10", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)pb);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_CDB6( Kwd_List &param )
{
  APIRET                 ulRc;
  // scather gather list to hold info.
  ScatGat               *psg;
  psg = new ScatGat(param.getInt("MEMSIZE"), param.getInt("NBUFF"));
  // handle to test dd.
  HFILE drvHndle       = param.getInt("DRIVEHANDLE");
  // paramblock for test dd.
  ULONG       paramlen = sizeof(PARAMS) + sizeof(SCSI_STATUS_BLOCK);
  BYTE *pb = new BYTE[paramlen];

  PARAMS                 *paramblock = (PARAMS *)pb;
  paramblock->flag      = param.getInt("MODE");
  paramblock->DevClass  = 1; // for disks.
  strncpy((char*)&(paramblock->DrvNam[0]),param["DRVNAME"],16);
  paramblock->iorb.iorb_adapter_passthru.iorbh.Length
                     = sizeof(paramblock->iorb.iorb_adapter_passthru);
  paramblock->iorb.iorb_adapter_passthru.iorbh.UnitHandle     = param.getInt("UNITHANDLE");
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandCode    = IOCC_ADAPTER_PASSTHRU;
  paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier= IOCM_EXECUTE_CDB;
  paramblock->iorb.iorb_adapter_passthru.iorbh.RequestControl = 8;
  if (paramblock->flag != 1)
    paramblock->iorb.iorb_configuration.iorbh.RequestControl|IORB_ASYNC_POST;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Status         = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode      = 0;
  paramblock->iorb.iorb_adapter_passthru.iorbh.Timeout        = param.getInt("TIMEOUT");
  paramblock->iorb.iorb_adapter_passthru.iorbh.pStatusBlock   = (USHORT)(OFFSETOF(pb)+sizeof(PARAMS));
  paramblock->iorb.iorb_adapter_passthru.iorbh.StatusBlockLen = sizeof(SCSI_STATUS_BLOCK);
  paramblock->iorb.iorb_adapter_passthru.Flags                = 0;
  paramblock->iorb.iorb_adapter_passthru.pSGList              = psg->entry(); 
  paramblock->iorb.iorb_adapter_passthru.cSGList              = psg->nbuff();
  paramblock->iorb.iorb_adapter_passthru.ppSGLIST             = 0;
  CDB6 *cdb = new CDB6;
  cdb->byte5 = param.getInt("CDB_BYTE5");
  cdb->byte4 = param.getInt("CDB_BYTE4");
  cdb->byte3 = param.getInt("CDB_BYTE3");
  cdb->byte2 = param.getInt("CDB_BYTE2");
  cdb->byte1 = param.getInt("CDB_BYTE1");
  cdb->byte0 = param.getInt("CDB_BYTE0");
  paramblock->iorb.iorb_adapter_passthru.pControllerCmd      = (BYTE * _Seg16)cdb;
  paramblock->iorb.iorb_adapter_passthru.ControllerCmdLen    = 6;

  // scsi status block for testdd / test add.
  SCSI_STATUS_BLOCK *ssb = (SCSI_STATUS_BLOCK *)(pb + sizeof(PARAMS));
  ssb->Flags = 0;           
  ssb->AdapterErrorCode = 0;
  ssb->TargetStatus = 0;    
  ssb->ResidualLength = 0;  
  ssb->AdapterDiagInfo[0] = 0;
  ssb->SenseData   = (SCSI_REQSENSE_DATA * _Seg16 )new SCSI_REQSENSE_DATA;
  ssb->ReqSenseLen = sizeof(SCSI_REQSENSE_DATA);

  ulRc = ddtDosDevIOCtl( drvHndle, 0xFF, 0x08,
                         pb, paramlen, &paramlen,
                         NULL, 0, NULL,
	 						            "dd_CDB6", "only call", param.files()->out1 );
  if (ulRc == 0) 
  {
    param.set(param["LABEL"], (LONG)pb);
    param.set(param["SCATGAT"], (LONG)psg);
    if (paramblock->flag == 1)
      ulRc = printstatus(param);
  }
  return ulRc;
}
/*
*************************************************************************
** Name:         APIRET _export dd_close( Kwd_List& )
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export dd_close( Kwd_List& param )
{
  APIRET  ulRc;
  HFILE   drvhndle = param.getInt("DRIVEHANDLE");

  ulRc = ddtDosClose( drvhndle,
							        "dd_close",
							        "only call",
							        param.files()->out1 );
  return ulRc;
}
/*
*************************************************************************
** Name:         void IStringIORB::CheckBit(int, int, IString, IString, IString)
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
void IStringIORB::CheckBit(int bit,
                   		   int AlignIndicator,
			                     IString BitStr,
			                     IString TrueStr,
			                     IString FalseStr)
{
	if (bit)
	{
		if (AlignIndicator == 1)
			*this += align1 + BitStr + TrueStr;
		else if (AlignIndicator == 2)
			*this += align2 + BitStr + TrueStr;
		else
			*this += align3 + (IString)"\n          " + BitStr + TrueStr;
	}
	else
	{
		if (AlignIndicator == 1)
			*this += align1 + BitStr + FalseStr;
		else if (AlignIndicator == 2)
			*this += align2 + BitStr + FalseStr;
		else
			*this += align3 + BitStr + FalseStr;
	}
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
void IStringIORB::CheckStatus(USHORT * StatusAddr)
{
//	struct			//AL
struct status
	{
		USHORT	StatusFlag1	:1;
		USHORT	StatusFlag2	:1;
		USHORT	StatusFlag3	:1;
		USHORT	StatusFlag4	:1;
		USHORT	StatusUnused	:12;
	} *pBitsStatus;

//	(USHORT *)pBitsStatus = StatusAddr; 		//AL replaced this line with the following
	pBitsStatus = (struct status*)StatusAddr;	// 	line.	

	*this += "          ";
	(*this).CheckBit(pBitsStatus->StatusFlag1, 2, "",
			 "The adapter device driver has completed processing the request",
			 "Request processing in progress...");
	(*this).CheckBit(pBitsStatus->StatusFlag2, 2, "",
			 "An ERROR occurred while processing the request",
			 "No error in processing the request");
	(*this).CheckBit(pBitsStatus->StatusFlag3, 3, "",
			 "An error is recovered by the adapter device driver through retries",
			 "");
	(*this).CheckBit(pBitsStatus->StatusFlag4, 3, "",
			 "The adapter device driver has returned status information in the buffer",
			 "");
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
void IStringIORB::CheckErrorCode(USHORT TheErrorCode)
{
	*this += "\n          ";
	switch(TheErrorCode)
	{
		case 256     :	*this += "Error category: IORB command an adapter device driver receives";
				break;
		case 257     :	*this += "ERROR: Command not supported";
				break;
		case 258     :	*this += "ERROR: Command syntax inconsistency";
				break;
		case 259     :	*this += "ERROR: Bad scatter/gather list (0-lenth segment)\n                 or an underlying hardware limitation";
				break;
		case 33028   :	*this += "ERROR: Lack of a software resource--buffer, selector, and so forth";
				break;
		case 261     :	*this += "ERROR: Aborted";
				break;
		case 262     :	*this += "ERROR: Internal consistency check detected by ADD";
				break;
		case 263     :	*this += "ERROR: An operating system failure...May retry";
				break;
		case 512     :	*this += "Error category: IORB addressed unit";
				break;
		case 513     :	*this += "ERROR: Unit not allocated";
				break;
		case 514     :	*this += "ERROR: Unit has been allocated previously";
				break;
		case 515     :	*this += "ERROR: Unit not ready";
				break;
		case 516     :	*this += "ERROR: Unit power is off";
				break;
		case 768     :	*this += "Error category: Relative block address";
				break;
		case 33537   :	*this += "ADDRESSING ERROR: RBA could not be located...Retry";
				break;
		case 770     :	*this += "ERROR: RBA exceeded the allowable maximum for \n                 the media currently in the device";
				break;
		case 33539   :	*this += "ERROR: Data requested could not be read successfully";
				break;
		case 1024    :	*this += "Error category: Media ";
				break;
		case 1025    :	*this += "ERROR: Media not formatted";
				break;
		case 1026    :	*this += "ERROR: Media not supported";
				break;
		case 1027    :	*this += "ERROR: Media write-protected";
				break;
		case 1028    :	*this += "ERROR: Media in the drive might have been changed";
				break;
		case 1029    :	*this += "ERROR: Media is not present";
				break;
		case 1280    :	*this += "Error Category: Adapter";
				break;
		case 1281    :	*this += "ERROR: Adapter's inability to communicate with the host CPU";
				break;
		case 34050   :	*this += "ERROR: Adapter's inability to communicate with an attached device...Retry";
				break;
		case 34051   :	*this += "ERROR: Host adapter has lost data...Retry";
				break;
		case 34052   :	*this += "ERROR: Host adapter is unable to supply data on demand to a device...Retry";
				break;
		case 1285    :	*this += "ERROR: Host adapter detected an internal consistency check";
				break;
		case 34054   :	*this += "ERROR: Adapter device driver timeout...Retry";
				break;
		case 34055   :	*this += "ERROR: Failure of a device to respond to the host adapter";
				break;
		case 1288    :	*this += "ERROR: Request operation or function is not supported by this adapter";
				break;
		case 1289    :	*this += "ERROR: Error can not be classified";
				break;
		case 1290    :	*this += "ERROR: ADD cannot classify an adapter-related error condition...Retry";
				break;
		case 1536    :	*this += "Error category: Device";
				break;
		case 34305   :	*this += "ERROR: Incorrect parity on data received by the host adapter by the device\n          ";
				*this += "       or a breakdown in bus protocols between the device and the host adapter...Retry";
				break;
		case 1538    :	*this += "ERROR: The requested operation or function is not supported by this device";
				break;
		case 1539    :	*this += "ERROR: Device detected an internal consistency check";
				break;
		case 34308   :	*this += "ERROR: Device is busy and cannot accept the requested operation...Retry";
				break;
		case 34309   :	*this += "ERROR: Device Overrun...Retry";
				break;
		case 34310   :	*this += "ERROR: Device Underrun...Retry";
				break;
		case 1543    :	*this += "ERROR: Unexpected device reset occurred...Retry";
				break;
		case 1544    :	*this += "ERROR: A device-related error cannot be classified by the ADD";
				break;
		default	     :  break;
	}
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
APIRET _export printstatus(Kwd_List &params)
{
  PARAMS *paramblock;
  paramblock = (PARAMS *)params.getPtr(params["LABEL"]);
  IStringIORB s1("", "\n          ", "");
  IString s2;
  s1 += params["LABEL"] + "\n";
  if (paramblock != 0)
  {
    while (paramblock->iorb.iorb_configuration.iorbh.Status == 0); 
    switch (paramblock->iorb.iorb_configuration.iorbh.CommandCode)
    {
      case IOCC_CONFIGURATION:
        if (paramblock->iorb.iorb_configuration.iorbh.CommandModifier ==
                 IOCM_GET_DEVICE_TABLE)
        {
          s1 +=  printdevicetable(paramblock);
        }
        break;
      case IOCC_UNIT_CONTROL:
        if (paramblock->iorb.iorb_unit_control.iorbh.CommandModifier ==
                  IOCM_ALLOCATE_UNIT)
          s2 = "IOCM_ALLOCATE_UNIT";
        else if (paramblock->iorb.iorb_unit_control.iorbh.CommandModifier ==
                  IOCM_DEALLOCATE_UNIT)
          s2 = "IOCM_DEALLOCATE_UNIT";
        else if (paramblock->iorb.iorb_unit_control.iorbh.CommandModifier ==
                  IOCM_CHANGE_UNITINFO)
          s2 = "IOCM_CHANGE_UNITINFO";
        else
        {
          s2 = "UNKNOWN MODIFIER FOR IOCC_UNIT_CONTROL - ";
          s2 += (IString)(long)paramblock->iorb.iorb_unit_control.iorbh.CommandModifier;
          params.files()->out1<<s2;
          break;
        }
        if (paramblock->iorb.iorb_unit_control.iorbh.Status > 1)
        {
          s1 += "IORB request failed for" + s2;
          s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_configuration.iorbh.Status);
          s1.CheckStatus(&paramblock->iorb.iorb_configuration.iorbh.Status);
          s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_configuration.iorbh.ErrorCode);
          s1.CheckErrorCode(paramblock->iorb.iorb_configuration.iorbh.ErrorCode);
        }
        break;
      case IOCC_GEOMETRY:
        switch (paramblock->iorb.iorb_geometry.iorbh.CommandModifier)
        {
          case IOCM_GET_MEDIA_GEOMETRY:
           s2 = "IOCM_GET_MEDIA_GEOMETRY";
          case IOCM_SET_MEDIA_GEOMETRY:
           s2 = "IOCM_SET_MEDIA_GEOMETRY";
          case IOCM_GET_DEVICE_GEOMETRY:
           s2 = "IOCM_GET_DEVICE_GEOMETRY";
          case IOCM_SET_LOGICAL_GEOMETRY:
           s2 = "IOCM_SET_LOGICAL_GEOMETRY";
           break;
          default:
           s2 = "UNKNOWN MODIFIER FOR IOCC_GEOMETRY" +
                (IString)(long)paramblock->iorb.iorb_geometry.iorbh.CommandModifier;
           break;
        }
        if ((paramblock->iorb.iorb_geometry.iorbh.CommandModifier ==
               IOCM_GET_MEDIA_GEOMETRY) ||
             (paramblock->iorb.iorb_geometry.iorbh.CommandModifier ==
               IOCM_GET_DEVICE_GEOMETRY))
        {
          if (paramblock->iorb.iorb_geometry.iorbh.Status == 1)
          {
            s1 += "Geometry :";
            s1 += "\n    Total Sectors     : " + (IString)(long)paramblock->iorb.iorb_geometry.pGeometry->TotalSectors;
            s1 += "\n    Bytes Per Sector  : " + (IString)(long)paramblock->iorb.iorb_geometry.pGeometry->BytesPerSector;
            s1 += "\n    Number of Heads   : " + (IString)(long)paramblock->iorb.iorb_geometry.pGeometry->NumHeads;
            s1 += "\n    Total Cylinders   : " + (IString)(long)paramblock->iorb.iorb_geometry.pGeometry->TotalCylinders;
            s1 += "\n    Sectors Per Track : " + (IString)(long)paramblock->iorb.iorb_geometry.pGeometry->SectorsPerTrack;
          }
        }
        if (paramblock->iorb.iorb_geometry.iorbh.Status > 1)
        {
          s1 += "IORB request failed for " + s2;
          s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_geometry.iorbh.Status);
          s1.CheckStatus(&paramblock->iorb.iorb_geometry.iorbh.Status);
          s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_geometry.iorbh.ErrorCode);
          s1.CheckErrorCode(paramblock->iorb.iorb_geometry.iorbh.ErrorCode);
        }
        break;
      case IOCC_EXECUTE_IO:
      {
        if (paramblock->iorb.iorb_executeio.iorbh.Status > 1)
        {
          if (paramblock->iorb.iorb_executeio.iorbh.CommandModifier ==
              IOCM_READ)
            s1 += "IORB request failed for IOCM_READ.";
          if (paramblock->iorb.iorb_executeio.iorbh.CommandModifier ==
              IOCM_READ_VERIFY)
            s1 += "IORB request failed for IOCM_READ_VERIFY.";
          if (paramblock->iorb.iorb_executeio.iorbh.CommandModifier ==
              IOCM_READ_PREFETCH)
            s1 += "IORB request failed for IOCM_READ_PREFETCH.";
          if (paramblock->iorb.iorb_executeio.iorbh.CommandModifier ==
              IOCM_WRITE)
            s1 += "IORB request failed for IOCM_WRITE.";
          if (paramblock->iorb.iorb_executeio.iorbh.CommandModifier ==
              IOCM_WRITE_VERIFY)
            s1 += "IORB request failed for IOCM_WRITE_VERIFY.";
          s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_executeio.iorbh.Status);
          s1.CheckStatus(&paramblock->iorb.iorb_executeio.iorbh.Status);
          s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_executeio.iorbh.ErrorCode);
          s1.CheckErrorCode(paramblock->iorb.iorb_executeio.iorbh.ErrorCode);
        }
        else
        {
          s1 += "Blocks transferred succesfully: ";
          s1 += (IString)(long)paramblock->iorb.iorb_executeio.BlocksXferred;
          ScatGat *psg = (ScatGat *)params.getPtr(params["SCATGAT"]);
	IString tempout = psg->out();		//AL
          params.files()->out1<<tempout;		//AL
        }
        break;
      }
      case IOCC_FORMAT:
        break;   // Format not supported by this DLL.
      case IOCC_UNIT_STATUS:
      {
        if (paramblock->iorb.iorb_unit_status.iorbh.Status > 1)
        {
          if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
              IOCM_GET_UNIT_STATUS)
            s1 += "IORB request failed for IOCM_GET_UNIT_STATUS.";
          if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
              IOCM_GET_CHANGELINE_STATE)
            s1 += "IORB request failed for IOCM_CHANGELINE_STATE.";
          if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
              IOCM_GET_MEDIA_SENSE)
            s1 += "IORB request failed for IOCM_GET_MEDIA_SENSE.";
          if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
              IOCM_GET_LOCK_STATUS)
            s1 += "IORB request failed for IOCM_GET_LOCK_STATUS.";
          s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_unit_status.iorbh.Status);
          s1.CheckStatus(&paramblock->iorb.iorb_unit_status.iorbh.Status);
          s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_unit_status.iorbh.ErrorCode);
          s1.CheckErrorCode(paramblock->iorb.iorb_unit_status.iorbh.ErrorCode);
        }
        else
        {
          Bits bit((ULONG)paramblock->iorb.iorb_unit_status.UnitStatus);
          sprintf(OutBuff, "%4.4x", paramblock->iorb.iorb_unit_status.UnitStatus);
          if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
            IOCM_GET_UNIT_STATUS)
          {
            s1 += "\nUnit Stauts: " + (IString)OutBuff;
            if (bit.bit(0)) s1 += "\n    -- Unit Ready";
            if (bit.bit(1)) s1 += "\n    -- Unit Powered on";
            if (bit.bit(2)) s1 += "\n    -- Unit Operational";
            if (!bit.bit(2)) s1 += "\n    -- Unit Defective";
          }
          else if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
                   IOCM_GET_CHANGELINE_STATE)
          {
            s1 += "\nChangelineState : " + (IString)OutBuff;
            if (bit.bit(0)) s1 +=  "Changeline occurred";
          }
          else if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
                   IOCM_GET_MEDIA_SENSE)
          {
            s1 += "\nMediaSense : " + (IString)OutBuff;
            s1 += "\n          ";
            switch(bit.bit(3,4))
            {
	             case 0: s1 += "Unable to determine drive";
	               break;
	             case 1: s1 += "720KB in 3.5\" drive";
		             break;
	             case 2:	s1 += "1.44MB in 3.5\" drive";
		             break;
	             case 3: s1 += "2.88MB in 3.5\" drive";
		             break;
	             default:break;
            }
          }
          else if (paramblock->iorb.iorb_unit_status.iorbh.CommandModifier ==
                   IOCM_GET_LOCK_STATUS)
          {
            s1 += "\nLockStatus : " + (IString)OutBuff;
            if (bit.bit(0)) s1 += "Unit locked";
          }
        }
        break;
      }
      case IOCC_DEVICE_CONTROL:
      {
        if (paramblock->iorb.iorb_device_control.iorbh.Status > 1)
        {
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_ABORT)
            s1 += "IORB request failed for IOCM_ABORT.";
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_SUSPEND)
            s1 += "IORB request failed for IOCM_SUSPEND.";
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_RESUME)
            s1 += "IORB request failed for IOCM_RESUME.";
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_LOCK_MEDIA)
            s1 += "IORB request failed for IOCM_LOCK_MEDIA.";
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_UNLOCK_MEDIA)
            s1 += "IORB request failed for IOCM_UNLOCK_MEDIA.";
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_EJECT_MEDIA)
            s1 += "IORB request failed for IOCM_EJECT_MEDIA.";
          s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_device_control.iorbh.Status);
          s1.CheckStatus(&paramblock->iorb.iorb_device_control.iorbh.Status);
          s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_device_control.iorbh.ErrorCode);
          s1.CheckErrorCode(paramblock->iorb.iorb_device_control.iorbh.ErrorCode);
        }
        else
        {
          if (paramblock->iorb.iorb_device_control.iorbh.CommandModifier ==
              IOCM_SUSPEND)
          {
            Bits bit(paramblock->iorb.iorb_device_control.Flags);
            if (bit.bit(0)) s1 += "Suspend should occur once the current request is complete";
            else s1 += "Suspend should occur once the unit is idle";
          }
        }
        break;
      }
      case IOCC_ADAPTER_PASSTHRU:
      {
        if (paramblock->iorb.iorb_adapter_passthru.iorbh.CommandModifier ==
              IOCM_EXECUTE_CDB)
        {
            s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.Status);
            s1.CheckStatus(&paramblock->iorb.iorb_adapter_passthru.iorbh.Status);
            s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode);
            s1.CheckErrorCode(paramblock->iorb.iorb_adapter_passthru.iorbh.ErrorCode);
            SCSI_STATUS_BLOCK *pssb = (SCSI_STATUS_BLOCK *)((BYTE *)paramblock + sizeof(PARAMS));
            Bits temp(pssb->Flags);
            s1 += " \n    Status Block: \n ";
            s1 += "\n    Flags           : " + (IString)(long)pssb->Flags;
            s1 += "\n    AdapterErrorCode: " + (IString)(long)pssb->AdapterErrorCode;
            s1 += "\n    TargetStatus    : " + (IString)(long)pssb->TargetStatus;
            if (temp.bit(1))
              s1 += "\n    ResidualLength  : " + (IString)(long)pssb->ResidualLength;
            if (temp.bit(3))
            {
              s1 += "\n    AdapterDiagInfo : ";
              char temp[9];
              strncpy(temp, (char *)pssb->AdapterDiagInfo, 8);
              s1 += (IString)temp;
            }
            if (temp.bit(0))
            {
              s1 += " \n    Request Sense Data: \n ";
              s1 += "\n    ErrCode_Valid   : " + (IString)(long)pssb->SenseData->ErrCode_Valid;
              s1 += "\n    SegNum          : " + (IString)(long)pssb->SenseData->SegNum;
              s1 += "\n    SenseKey        : " + (IString)(long)pssb->SenseData->SenseKey;
              s1 += "\n    INFO            : " + (IString)(char)pssb->SenseData->INFO[0];
              s1 += (IString)(char)pssb->SenseData->INFO[1];
              s1 += (IString)(char)pssb->SenseData->INFO[2];
              s1 += (IString)(char)pssb->SenseData->INFO[3];
              s1 += "\n    AddLen          : " + (IString)(long)pssb->SenseData->AddLen;
              s1 += "\n    CmdInfo         : " + (IString)(char)pssb->SenseData->CmdInfo[0];
              s1 += (IString)(char)pssb->SenseData->CmdInfo[1];
              s1 += (IString)(char)pssb->SenseData->CmdInfo[2];
              s1 += (IString)(char)pssb->SenseData->CmdInfo[3];
              s1 += "\n    AddSenseCode    : " + (IString)(long)pssb->SenseData->AddSenseCode;
              s1 += "\n    AddSenseCodeQual: " + (IString)(long)pssb->SenseData->AddSenseCodeQual;
              s1 += "\n    FieldRepUnitCode: " + (IString)(long)pssb->SenseData->FieldRepUnitCode;
              s1 += "\n    KeySpecific     : " + (IString)(char)pssb->SenseData->KeySpecific[0];
              s1 += (IString)(char)pssb->SenseData->KeySpecific[1];
              s1 += (IString)(char)pssb->SenseData->KeySpecific[2];
            }
            //delete pssb->SenseData;
            //delete pssb;

            s1 += "IOCM_EXECUTE_CDB returned following data:";
            params.files()->out1<<s1;
            ScatGat *psg = (ScatGat *)params.getPtr(params["SCATGAT"]);
 	 IString tempout = psg->out(); 		//AL
            params.files()->out1<<tempout;	//AL

        }
      }
        break;
      default:
        break;
    }
  }
  params.files()->out1<<s1;
  delete paramblock;
  return 0;
}
/*
*************************************************************************
** Name:         
**
** Description: 
**
** Parameters:
**
** Returns:
**
** Cautions:
**
**
**************************************************************************
*/
IString printdevicetable(PARAMS *paramblock)
{
  DEVICETABLE *pdevicetable = paramblock->iorb.iorb_configuration.pDeviceTable;
  IStringIORB s1("", "\n          ", ""); // output alignment indicator

  if (paramblock->iorb.iorb_configuration.iorbh.Status > 1) // failed
  {
    s1 += "IORB request failed for IOCM_GET_DEVICE_TABLE.";
    s1 += "\n    Status: " + hex((IString)(long)paramblock->iorb.iorb_configuration.iorbh.Status);
    s1.CheckStatus(&paramblock->iorb.iorb_configuration.iorbh.Status);
    s1 += "\n    Error : " + hex((IString)(long)paramblock->iorb.iorb_configuration.iorbh.ErrorCode);
    s1.CheckErrorCode(paramblock->iorb.iorb_configuration.iorbh.ErrorCode);
  }
  else
  {
    s1 += "Device Table: ";
    sprintf(OutBuff, "0x%2.2x",pdevicetable->ADDLevelMajor);
    s1 += "\n    ADD major support level      : " + (IString)OutBuff;
    sprintf(OutBuff, "0x%2.2x",pdevicetable->ADDLevelMinor);
    s1 += "\n    ADD minor support level      : " + (IString)OutBuff;
    sprintf(OutBuff, "0x%4.4x",pdevicetable->ADDHandle);
    s1 += "\n    ADD handle                   : " + (IString)OutBuff;
    sprintf(OutBuff, "%d",pdevicetable->TotalAdapters);
    s1 += "\n    Number of Adapters present   : " + (IString)OutBuff;

    BYTE * buff = (BYTE *)pdevicetable;
    buff += sizeof(DEVICETABLE) + ((pdevicetable->TotalAdapters-1) * 2);

    for (int i = 0; i < pdevicetable->TotalAdapters; i++)
    {
	     if (pdevicetable->TotalAdapters >32) // exceed max
	        break;
	     ADAPTERINFO *pa;
	     pa = (ADAPTERINFO *)buff; 
	     s1 += "\nAdapter Information : ";
	     s1 += "\n    Adapter Name                          : " +
	           (IString)(char *)pa->AdapterName;
	     s1 += "\n    Number of units this adapter supports : " +
	           (IString)(long)pa->AdapterUnits;
	     sprintf(OutBuff, "0x%4.4x",pa->AdapterDevBus);
	     s1 += "\n    Adapter-to-device bus protocol used   : " +
	           (IString)OutBuff;
	     s1 += "  ";
      Bits bit((ULONG)pa->AdapterDevBus);
	     switch(bit.bit(3,4))
	     {
	     	case 0:	s1 += "(Protocol not listed)";
	     		break;
	     	case 1: s1 += "(DASD - ST506 CAM-I)";
	     		break;
	     	case 2: s1 += "(DASD - ST506 CAM-II)";
	     		break;
	     	case 3:	s1 += "(DASD - ESDI)";
	     		break;
	     	case 4: s1 += "(DASD - Diskette)";
	     		break;
	     	case 5: s1 += "(SCSI - Version-I)";
	     		break;
	     	case 6:	s1 += "(SCSI - Version-II)";
	     		break;
	     	case 7:	s1 += "(SCSI - Version-III)";
	     		break;
	     	case 8: s1 += "(non-SCSI CD-ROM interface)";
	     		break;
	     	default:break;
	     }
      if (bit.bit(8)) s1 += "\n        Fast SCSI bus timings";
      if (bit.bit(9)) s1 += "\n        8-bit bus width";
      if (bit.bit(10)) s1 += "\n        16-bit bus width";
      if (bit.bit(11)) s1 += "\n        32-bit bus width";
      
	     s1 += "\n    Adapter IO Access      : " + (IString)(long)pa->AdapterIOAccess;
      bit = (ULONG)pa->AdapterIOAccess;
      if (!bit.bit(0)) s1 += "\n        -- I/O access not listed";
      if (bit.bit(0)) s1 += "\n        -- BusMaster I/O Access";
      if (bit.bit(1)) s1 += "\n        -- Programmed INs/OUTs";
      if (bit.bit(2)) s1 += "\n        -- 2nd-party DMA adapter";
      if (bit.bit(3)) s1 += "\n        --Memory-mapped I/O";
      
	     sprintf(OutBuff, "0x%4.4x", pa->AdapterHostBus);
	     s1 += "\n    Adapter Host Bus       : " + (IString)OutBuff;
	     s1 += "\n        ";
      bit = (ULONG)pa->AdapterHostBus;
	     switch(bit.bit(3,4))
	     {
	     	case 0:  s1 += "-- Bus type not listed";
	     		 break;
	     	case 1:  s1 += "-- ISA";
	     		 break;
	     	case 2:  s1 += "-- Extended ISA";
	     		 break;
	     	case 3:  s1 += "-- Micro-channel";
	     		 break;
	     	case 15: s1 += "-- Bus type unknown";
	     		 break;
	     	default: break;
	     }
      
	     s1 += "\n        ";
	     switch(bit.bit(7,4))
	     {
	     	case 1:  s1 += "-- 8-bit bus";
	     		 break;
	     	case 2:  s1 += "-- 16-bit bus";
	     		 break;
	     	case 3:  s1 += "-- 32-bit bus";
	     		 break;
	     	case 4:  s1 += "-- 64-bit bus";
	     		 break;
	     	case 15: s1 += "-- Bus width unknown";
	     		 break;
	     	default: break;
	     }
      
	     s1 += "\n    Adapter SCSI Target ID : " + (IString)(long)pa->AdapterSCSITargetID;
	     s1 += "\n    Adapter SCSI LUN       : " + (IString)(long)pa->AdapterSCSILUN;
	     s1 += "\n    Adapter Flags          : " + (IString)(long)pa->AdapterFlags;
      bit = (ULONG)pa->AdapterFlags;
      if (bit.bit(0)) s1 += "\n        --This adapter supports >16M address";
      if (bit.bit(1)) s1 += "\n        --This adapter supports IBM SCBs";
      if (bit.bit(2)) s1 += "\n        --The hardware supports scatter/gather";
      if (bit.bit(3)) s1 += "\n        --The hardware supports cylinder/head/sector addressing";
      if (bit.bit(4)) s1 += "\n        --The adapter supports more than one device bus";
      
	     buff += (sizeof(ADAPTERINFO) - sizeof(UNITINFO));
	     for (int j = 0; j < pa->AdapterUnits; j++)
	     {
	       s1 += "\nUnit Info : ";
	       s1 += "\n    Unit Adapter Index   : " + (IString)(long)pa->UnitInfo[j].AdapterIndex;
	       s1 += "\n    Unit Index           : " + (IString)(long)pa->UnitInfo[j].UnitIndex;
        bit = (ULONG)pa->UnitInfo[j].UnitFlags;
	       sprintf(OutBuff, "0x%4.4x",pa->UnitInfo[j].UnitFlags);
	       s1 += "\n    Unit Flags           : " + (IString)OutBuff;
	       if (bit.bit(0)) s1 += "\n        --This unit's media is removable";
	       if (bit.bit(1)) s1 += "\n        --This unit can detect media removal";
	       if (bit.bit(2)) s1 += "\n        --This unit supports read prefetch";
	       if (bit.bit(3)) s1 += "\n        --This unit manages drive A:";
	       if (bit.bit(4)) s1 += "\n        --This unit manages drive B:";
	       if (bit.bit(5)) s1 += "\n        --The driver Suppresses DASD manager support";
	       if (bit.bit(6)) s1 += "\n        --The driver Suppresses SCSI manager support";
	       if (bit.bit(7)) s1 += "\n        --This unit is defective";
      
	       s1 += "\n    Unit Handle          : " + (IString)(long)pa->UnitInfo[j].UnitHandle;
	       s1 += "\n    Unit FilterADDHandle : " + (IString)(long)pa->UnitInfo[j].FilterADDHandle;
        bit = (ULONG)pa->UnitInfo[j].UnitType;
	       sprintf(OutBuff, "%4.4x", pa->UnitInfo[j].UnitType);
	       s1 += "\n    Unit Type            : " + (IString)OutBuff;
	       s1 += "  ";
	       switch(bit.bit(3,4))
	       {
	        	case 0: s1 += "(Direct access (DASD))";
	     	    	break;
	     	    case 1: s1 += "(Tape)";
	     		    break;
	     	    case 2: s1 += "(Printer)";
	     		    break;
	     	    case 3: s1 += "(Processor)";
	     		    break;
	     	    case 4: s1 += "(Write Once/Read Many)";
	     		    break;
	     	    case 5: s1 += "(CD ROM)";
	     		    break;
	     	    case 6: s1 += "(Scanner)";
	     		    break;
	     	    case 7: s1 += "(Optical disk)";
	     		    break;
	     	    case 8: s1 += "(Changer (example, jukebox))";
	     		    break;
	     	    case 9:	s1 += "(Communication)";
	     		    break;
	     	    default:
             break;
	       }
	       s1 += "\n    Unit Queuing Count   : " + (IString)(long)pa->UnitInfo[j].QueuingCount;
	       s1 += "\n    Unit SCSI Target ID  : " + (IString)(long)pa->UnitInfo[j].UnitSCSITargetID;
	       s1 += "\n    Unit SCSI LUN        : " + (IString)(long)pa->UnitInfo[j].UnitSCSILUN;
	       buff += sizeof(UNITINFO);
	     }
    }
  }
  delete pdevicetable;
  return s1;
}
IString hex(IString s)
{
  char ch[7];
  sprintf(ch, "0x%.4X", s.asInt());
  return (IString)ch;
}










