/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richard Copeland, Jan. 1994.
**
** Revisions:
** -----------------------------------------------------------------------
** 03/01/94  Barkha J. Herman  Added headers, comments.
**                             Changed all var names from _* to *_.
**
**   @01- FCB -10/10/94 - Eliminating Object class - using DdtObject instead
**                             and replacing key() with setkey or getkey method
**
** Comments:
**
** Public Class/ Functions:
** _export Buffer
** _export BufferList
**
*************************************************************************
*/
#ifndef _BUFFER_H
#define _BUFFER_H

#include "ddtkwds.h"
#include "genlist.h"
//#include "geninst.h"                         //@01 eliminated
#include "ddtos2.h"
#include <stdlib.h>

class _export BufferList;

class _export Buffer: public DdtObject<IString>     //@01
{
public:
  Buffer(const IString & kwd, const size_t  & size,  void * = NULL); //@01
  virtual ~Buffer();
  virtual PVOID buffer() const {return (PVOID) _buffer;};      //@01
  virtual IString asIString();          // AL
  virtual void reallocate(const size_t & size);                     //@01
  virtual Buffer& operator=(Buffer&);
  virtual BOOL operator==(Buffer&);
  virtual int compare(const Buffer&,  size_t &);                   //@01
//  virtual IString kwd(){return key();};
  virtual IString kwd(){return getkey();};                           //@01
  virtual size_t size() const {return _size;} ;
private:
  PCHAR _buffer;
  size_t _size;
};

class _export BufferList: protected List<IString, IString>
{
public:
  BufferList():List<IString, IString>(""){};
  virtual ~BufferList(){};

  virtual void setBuffer(Buffer*);
  virtual void removeBuffer(IString& kwd){remove(kwd);};
  virtual void deleteBuffer(IString& kwd){operator-=(kwd);};
};
#endif
