/*
************************************************************************
** Copyright: (C) IBM BocaRaton Ltd. 1994
**
** Classification: IBM Test Tool
**
** Original Author and Date: Richar Copeland, Jan. 1994.
**
** Revisions:
**
** Comments:
**   This file provides the functional description for the cover routines
**   for OS/2 2.1 system calls to be used both by DDT as well as the
**   stub writer.  
**
** Public Class/ Functions:
**   Declarations for:
**     ddtDosOpen
**     ddtDosRead
**     ddtDosWrite
**     ddtDosDevIOCtl
**     ddtDosClose
**     ddtDosPhysicalDisk
**
*************************************************************************
*/
#ifndef _apicover_h
#define _apicover_h

#include "threadio.h"

APIRET _export ddtDosOpen(PSZ    pszFileName,
			  PHFILE pHf,
			  PULONG pulAction,
			  ULONG  cbFile,
			  ULONG  ulAttribute,
			  ULONG  fsOpenFlags,
			  ULONG  fsOpenMode,
			  PEAOP2 peaop2 ,
			  IString pszCallingRoutineName,
			  IString pszLocationDescription,
			  OutputStream& output);
APIRET _export ddtDosRead(HFILE hFile,
			  PVOID pBuffer,
			  ULONG cbRead,
			  PULONG pcbActual,
			  IString pszCallingRoutineName,
			  IString pszLocationDescription,
			  OutputStream& output);
APIRET _export ddtDosWrite(HFILE hFile,
			   PVOID pBuffer,
			   ULONG cbRead,
			   PULONG pcbActual,
			   IString pszCallingRoutineName,
			   IString pszLocationDescription,
			   OutputStream& output);
APIRET _export ddtDosDevIOCtl(HFILE hDevice,
			      ULONG category,
			      ULONG function,
			      PVOID pParams,
			      ULONG cbParmLenMax,
			      PULONG pcbParmLen,
			      PVOID pData,
			      ULONG cbDataLenMax,
			      PULONG pcbDataLen,
			      IString pszCallingRoutineName,
			      IString pszLocationDescription,
			      OutputStream& output);
APIRET _export ddtDosSetFilePtr( HFILE hf1,
				 LONG l2,
				 ULONG ul3,
				 PULONG pul4,
				 IString pszCallingRoutineName,
				 IString pszLocationDescription,
				 OutputStream& output);
APIRET _export ddtDosClose(HFILE hFile,
			   IString pszCallingRoutineName,
			   IString pszLocationDescription,
			   OutputStream& output);
APIRET _export ddtDosPhysicalDisk( ULONG ulFunction,
				   PVOID pDataPtr,
				   ULONG ulDataLen,
				   PVOID pParmPtr,
				   ULONG ulParmLen,
				   IString pszCallingRoutineName,
				   IString pszLocationDescription,
				   OutputStream& output);



#endif

