;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/**********************************************************************
;/*
;/* Module:         XGARING0.INC
;/*
;/* Description:    OS/2 kernel device driver support header file
;/*
;/**********************************************************************
true            equ     1
false           equ     0

STDIO           EQU     1               ;standard IO handle

bitmap_s     struc                      ; 
virt_addr    dd  0                      ; 
phys_addr    dd  0                      ; 
lock_handle  dd  0                      ; 
bitmap_size  dd  0                      ; 
lock_type    dw  0                      ; 
bitmap_s     ends                       ; 

pmlock_s         struc                  ; 
pmlock_count     dw      ?              ; count of bitmaps to lock
pmlock_bitmap    dd      ?              ; pointer to bitmap struc
pmlock_s         ends                   ; 

pmunlock_s       struc                  ; 
pmunlock_count   dw      ?              ; count of bitmaps to unlock
pmunlock_handle  dd      ?              ; handle of bitmap to unlock
pmunlock_s       ends                   ; 

WORDPART        STRUC
lo              dw      ?               ;lo part at +0
hi              dw      ?               ;hi part at +2
WORDPART        ENDS

solid_blt_b             equ     008028000h
thru_blt_b              equ     0A8128000h
solid_blt               equ     008018000h

sprite_hwvis            equ     0100h+sprite_control    ;sprite visible

hsprite_s       struc
hsprite_len     dw      ?               ; 
hsprite_coord   dd      ?               ; coord
hsprite_s       ends

hssprite_s      struc
hssprite_len    dw      ?               ; 
hssprite_flags  db      ?               ; flags
hssprite_res    db      ?               ; 
hssprite_hot_x  db      ?               ; hot point x
hssprite_hot_y  db      ?               ; hot point y
hssprite_addr   dd      ?               ; address of sprite definition
hssprite_width  dw      ?               ; width
hssprite_height dw      ?               ; height
hssprite_col1_green dw  ?               ; col1 green
hssprite_col1_red   dw  ?               ; col1 red
hssprite_col1_blue  dw  ?               ; col1 blue
hssprite_col2_green dw  ?               ; col1 green
hssprite_col2_red   dw  ?               ; col1 red
hssprite_col2_blue  dw  ?               ; col1 blue
hssprite_s      ends

; coordinate structure
coord   struc
xcoord  dw      0
ycoord  dw      0
coord   ends



;
;These constants define device header attribute bits
;

Devlev_1        EQU     0000000010000000B       ;Bits 7-9 - DOS 5.0
Dev_Chr_Dev     EQU     1000000000000000B       ;Bit 15 - Device is a chr dev
Dev_30          EQU     0000100000000000B       ;Bit 11 - Open/Close/Removable

;
; OS2 return codes
;

No_Error        EQU     0100H   ;No errors encounterd; Done
General_Failure EQU     810cH   ;General failure error code
Unknown_Command EQU     8103H   ;Unknown command error code

Valid_Category  EQU     10      ;Valid category for IOCTL command received
Valid_Function  EQU     40h     ;Valid function for IOCTL command received


;
; Structure of a GDT descriptor
;

SELDESC         STRUC
limit           DW      0               ;Offset of last byte in segment
base_low        DW      0               ;Low 16-bits of 24-bit address
base_high       DB      0               ;High 8-bits of 24-bit address
access          DB      0               ;Access rights - DPL etc.
resvd           DW      0               ;Reserved word
SELDESC         ENDS

;
; Structure of a Call Gate
;

CALLGATE        STRUC
ofset           DW      0               ;entry point offset
selector        DW      0               ;entry point selector
count           DB      0               ;count of stack dwords to transfer
protect         DB      0               ;access rights - DPL etc.
resrvd          DW      0               ;Reserved word
CALLGATE        ENDS

;
; Structure of a parse table entry
;

parseBlock      STRUC
                DB      ?
                DB      ?
                DW      ?
parseBlock      ENDS

;
; Structure of an ABIOS request packet for READ POS function
;

Request_Block   STRUC
ReqBlockLen     DW      0
LID             DW      0
Unit            DW      0
Function        DW      0
Res1            DW      0
Res2            DW      0
ReturnCode      DW      0
TimeOut         DW      0

; READ POS data

SlotNo          DB      0       ;10
res3            DB      0       ;11
adaptorID       DW      0       ;12
res4            DW      0       ;14
Data_Off        DW      0       ;16
Data_Sel        DW      0       ;18
missed          DW      0       ;1A
Res5            DW      0       ;1C
                DB      64 dup (0)
Request_Block   ENDS

;
;Structure of a DosDevIOCtl request packet
;

PktMax          EQU     20          ;max size for a sub packet

Packet          STRUC
PktLen          DB        ?         ; Length in bytes of packet
PktUnit         DB        ?         ; Subunit number of block device
PktCmd          DB        ?         ; Command code
PktStatus       DW        ?         ; Status word
PktDOSLink      DD        ?         ; Reserved
PktDevLink      DD        ?         ; Device multiple-request link
PktData         DB        PktMax dup (?) ; Data pertaining to specific packet
Packet          ENDS

;
;Pointer constants for the request packets
;

InitpEnd        EQU     DWORD PTR PktData+1     ;Pointer to free mem after dev
GIOCatFunc      EQU     WORD  PTR PktData       ;Category Code & Function Code
GIOCategory     EQU     BYTE  PTR PktData       ;Category Code
GIOParaPack     EQU     DWORD PTR PktData+2     ;Pointer to parameter packet
GIODataPack     EQU     DWORD PTR PktData+6     ;Pointer to data packet
GIOFunction     EQU     BYTE  PTR PktData+1     ;Function code

RPDSFlags       EQU     WORD  PTR PktData       ;Device Support Flags
DevSupp_GT16M   EQU     01h     ;Device support Flags > 16M memory supported


ifdef EARLY20
; We had to define the DevHlp values ourselves because there was no
; public include file in the build which had them
;
; These numbers are actually different than the ones used in later versions
; of OS/2 2.0
;

;
;Device helper services
;
DevHlp_Run                  equ     05H
DevHlp_Lock                 equ     13H
DevHlp_EOI                  equ     31H
DevHlp_Block                equ     04H
DevHlp_SetIRQ               equ     1BH
DevHlp_SemReq               equ     06H
DevHlp_Unlock               equ     14H
DevHlp_SemClear             equ     07H
DevHlp_VerifyAccess         equ     27H
DevHlp_VirtToPhys           equ     16H
DevHlp_PhysToUVirt          equ     17H
DevHlp_AllocGDTSelector     equ     2DH
DevHlp_GetLIDEntry          equ     34H
DevHlp_SetROMvector         equ     1AH
; NB. This DevHlp was wrongly named at 1.2
DevHlp_PhysToGDTSelector    equ     2EH
DevHlp_FreeLIDEntry         equ     35H
DevHlp_ABIOSCommonEntry     equ     37H

ifdef REAL_CRUISER
;#####################################
;# start of additional defines for 2.0
;#####################################
DevHlp_PhysToGDTSel         equ     42H
DevHlp_VMLock               equ     43H
DevHlp_VMUnlock             equ     44H
DevHlp_VMAlloc              equ     45H
DevHlp_VMFree               equ     46H
DevHlp_VMProcessToGlobal    equ     47H
DevHlp_VMGlobalToProcess    equ     48H
DevHlp_VirtToLin            equ     49H
DevHlp_LinToGDTSel          equ     4AH
DevHlp_GetDecInfo           equ     4BH
DevHlp_LinToPageList        equ     4CH
DevHlp_PageListToLin        equ     4DH
DevHlp_PageListToGDTSel     equ     4EH
DevHlp_DynamicAPI           equ     5aH

VMLock_NOBLOCK          equ     00000001b
VMLock_CONTIGUOUS       equ     00000010b
VMLock_BELOW16M         equ     00000100b
VMLock_MARKDIRTY        equ     00001000b
VMLock_LONGTERM         equ     00010000b
VMLock_VERIFYONLY       equ     00100000b
VMLock_PERMANENT        equ     01000000b

;#####################################
;# end of 2.0 defines
;#####################################
endif ; REAL_CRUISER

else


include devhlp.inc

endif ; EARLY20

;
; Alarm error codes
;

NOEWAYERR       EQU     0001H                   ;no eway's installed
INITGDTERR      EQU     0002H                   ;can't allocate GDT entries
BADINDEXERR     EQU     0003H                   ;received duff request
PHYSUVIRTERR    EQU     0004H                   ;error during GDT modification

LOCKERR         EQU     8005H                   ;virtual address lock error
VERFYERR        EQU     8006H                   ;virtual address verify error
UNLOCKERR       EQU     8007H                   ;locked-handle unlock error
VIRT2PHYSERR    EQU     8008H                   ;virtual to physical xlate err

GETLIDERR       EQU     0001H
COMENTYERR      EQU     0002H
FREELIDERR      EQU     0003H

;
; OS/2 call equates
;

LLOCK_BITS      EQU     0100H                   ;long term lock
SLOCK_BITS      EQU     0000H                   ;short term lock
VERIFYREAD      EQU     0H                      ;only read verify
VERIFYWRITE     EQU     0H                      ;read/write verify
MEMREGBLKLEN    EQU     80H                     ;80H memory mapped reg's

;
; DPL of TIND & eway IO regs, and the R2 call gates
;

PROTLEV         EQU     3                       ;set GDT selectors R3 protect

;
; sysErr macro sets up for error report back at ring 2
;

sysErr  MACRO   index, error
        mov     drvError, error
        ENDM


flatlock        struc
VirtualAddress  dd      ?       ; pointer to memory to lock
PhysicalAddress dd      ?       ; physical address after locking
cMemorySize     dd      ?       ; size in bytes of memory block
ActionFlags     dd      ?       ; long term vs short term
LockHandle1     dd      ?       ; 12 byte lock handle
LockHandle2     dd      ?       ; 12 byte lock handle
LockHandle3     dd      ?       ; 12 byte lock handle
flatlock        ends

Max_Cmd_Code    EQU     27      ;Packet command code > 27 unsupported

; POS ID constants
XGA_ID_HIGHEST  equ 08fdbh
XGA_DMQS_ID     equ 08fdah
XGA_ID_LOWEST   equ 08fd8h

ifdef MATROX
; Constants and definitions associated with the MATROX card support

MATROX_ID               equ     80EEh

ILUM_ACCESS_MASK        equ     11101101b
Y_ORIGIN_TOP_LEFT       equ     00010000b
ENABLE_FRAME_BUFFER     equ     00000010b

SELECT_ILLUMINATOR      equ     24h
SELECT_VGA              equ     20h
PROGRESSIVE_SCAN        equ     02h

ILUM_ACCESS             equ     3e63h
ACS_BUF_DEF             equ     3e64h

KEY_SELECT              equ     3e72h

ACS_BUF_CTRL            equ     3fa2h
DISP_POS_Y              equ     3fb2h
CRTC_CTRL               equ     3f65h

MEM_START_X_0           equ     3f80h
MEM_START_Y_0           equ     3f82h
MEM_START_X_1           equ     3f90h
MEM_START_Y_1           equ     3f92h

endif ; MATROX
