/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/* MODULE NAME: EDD0TYPE.H                                            */
/*                                                                    */
/* DESCRIPTION: Ring0 C type definitions.                             */
/*                                                                    */
/* CHANGE HISTORY:                                                    */
/*                                                                    */
/*   17Sep92 KJE - DCR53004 (WPS Implementation for INT 10 DMQS       */
/*                 Services.                                          */
/**********************************************************************/

/**********************************************************************/
/* These structures define the DMQS primary data in the Extended BIOS */
/* Data Area.                                                         */
/**********************************************************************/
typedef struct
{
   BYTE    bSlot;
   USHORT  usXGALevel;
   ULONG   ulVendorDisplayData;
   USHORT  usIOBase;      
   USHORT  usRegSeg;
   USHORT  us1MPhysAperture;
   USHORT  us4MPhysAperture;
   USHORT  usVRAMBase;
   USHORT  usMonitorID;
   BYTE    bVRAMSize;
   ULONG   ulAlternateCoproRegBase;
           /* KJE - Fix to reflect latest DMQS Data Structure Format. */
} DMQSPDI;

/**********************************************************************/
typedef DMQSPDI FAR *PDMQSPDI;

/**********************************************************************/
typedef struct
{
   USHORT  usNextBlockOffset;
   USHORT  usAdapterID;
   ULONG   ulInt10Location;
   BYTE    bNumberOfXGASubsystems;
   BYTE    bNumberOfXGATableEntries;
   BYTE    bTableSize;
   BYTE    reserved[5];
   DMQSPDI DMQSPrimaryDataInstance[0];     /* Can be up to 8 of these */

} DMQSPD;

/**********************************************************************/
typedef DMQSPD FAR *PDMQSPD;

/**********************************************************************/
typedef struct
{
   USHORT  usNextDMQSPDI;
   DMQSPDI Int10DMQSPDI;
   BYTE    usReserved;
           /* KJE - Fix to reflect latest DMQS Data Structure Format. */

} INT10DMQSPDI;

/**********************************************************************/
typedef INT10DMQSPDI FAR *PINT10DMQSPDI;

/**********************************************************************/
typedef struct _DGS_HEADER
{
    BYTE    HeaderData[34];    /* Fixed data !                !!NEW!! */
    USHORT  TotalLength;       /* Total file length in bytes          */
    USHORT  MonitorID;         /*                                     */
    BYTE    FileLevel;         /*                                     */
    BYTE    NumberOfModes;     /*                                     */
    USHORT  MonitorType;       /* 0=MonCRT 1=ColCRT 2=MonLCD 3=ColLCD */
    USHORT  ScreenWidth;       /* in millimeters                      */
    USHORT  ScreenHeight;      /* in millimeters                      */
    BYTE    Reserved[4];       /*                                     */

} DGS_HEADER;

/**********************************************************************/
typedef DGS_HEADER FAR * PDGS_HEADER;

/**********************************************************************/
typedef struct _REGDATA
{
    BYTE    Type;      /* 0 = direct, 1 = indexed      */
    BYTE    Address;   /* 0 - F direct, 0 - FF indexed */
    BYTE    Value;
} REGDATA;

/**********************************************************************/
typedef REGDATA FAR * PREGDATA;

/**********************************************************************/
typedef struct _DGS_MODEHEADER
{
    USHORT  DataLength;
    USHORT  PixWidth;
    USHORT  PixHeight;
    USHORT  MinXGALevel;
    USHORT  Offset;

} DGS_MODEHEADER;

/**********************************************************************/
typedef DGS_MODEHEADER FAR * PDGS_MODEHEADER;

/**********************************************************************/
typedef struct _DGS_MODE
{
    DGS_MODEHEADER  ModeInfo;
    REGDATA         ModeData[1];

} DGS_MODE;

/**********************************************************************/
typedef struct _DGS_DATA
{
    DGS_MODE        Mode[1];

} DGS_DATA;

/**********************************************************************/
typedef DGS_DATA FAR * PDGS_DATA;

/**********************************************************************/
typedef struct _MONTABLETYPE
{
  USHORT                monid;
  PDGS_HEADER           pheader;
  PDGS_DATA             pdata;

} MONTABLETYPE;
