/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = VVGA.H                                         */
/*                                                                    */
/*   Description     = Virtual VGA function prototypes.               */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#ifdef VVGA
HVDD    OpenVDD(VOID);
BOOL    CloseVDD(HVDD hVDD);
BOOL    VGAIsActive(VOID);
VOID    ActivatePlanarVGA(VOID);
VOID    ActivatePlanarVGAWorker(VOID);
VOID    DeactivatePlanarVGA(VOID);
VOID    DeactivatePlanarVGAWorker(VOID);
VOID    CheckForVirtualVGA(VOID);
VOID    StartVirtualVGA(VOID);
VOID    StopVirtualVGA(VOID);
VOID    LookForFreePlanarXGA(VOID);

#ifdef TEST_VGA_MEM
PBYTE   GetVGAVRAMPointer(VOID);
#endif /* TEST_VGA_MEM */

#ifdef WE_REQUEST_VGA_BITS
BOOL    RequestVGABitmapBits( SGID          sgid,
                              LONG          lScanStart,
                              LONG          clScanCount,
                              PBYTE         pBitmapBits,
                              PBITMAPINFO2  pbmi2 );
#endif /* WE_REQUEST_VGA_BITS */

#endif /* VVGA */
