/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = VRAMMAN.H
 *
 * DESCRIPTIVE NAME = VRAM Memory Manager Header
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifdef ENDIVE
#include "endive.h"

#define APP_NAME               "PM_DISPLAYDRIVERS"
#define KEY_NAME               "ACCELERATEDDRIVERS"
#define NAME_SIZE              256

#define RC_SUCCESS             0
#define RC_SIMULATE            1
#define RC_UNSUPPORTED         2
#define RC_ERROR               3

#define QSTATUS                0x9ae8  /* queue status register    */
#define QBUSY                  0x0200  /* executing a graphics cmd */
#define QEMPTY                 0x0400  /* queue empty              */
#define WaitQIdle()            while(inpw(QSTATUS) & QBUSY)
#define WaitQEmpty()           while(!(inpw(QSTATUS) & QEMPTY))

typedef struct _VRAMLIST
{
   struct _VRAMLIST *next;
   POINTL ptlStart;
   ULONG ulSize;
   ULONG ulID;
   ULONG ulWidth;
   ULONG ulHeight;
   ULONG ulHandle;
   ULONG ulFlags;
   PVOID pSysMem;
   BOOL fUsed;
} VRAMLIST;
typedef VRAMLIST *PVRAMLIST;

typedef struct _HANDLELIST
{
   struct _HANDLELIST *next;
   ULONG ulHandle;
   ULONG ulFlags;
} HANDLELIST;
typedef HANDLELIST *PHANDLELIST;

typedef struct _STATICLIST
{
   struct _STATICLIST *next;
   ULONG ulHandle;
   ULONG ulID;
   POINTL ptlStart;
   ULONG ulSize;
   ULONG ulFlags;
} STATICLIST;
typedef STATICLIST *PSTATICLIST;

typedef struct _VRAMINIT
{
   POINTL ptlStart;
   ULONG ulSize;
   ULONG ulWidth;
   ULONG ulHeight;
} VRAMINIT;
typedef VRAMINIT *PVRAMINIT;

typedef ULONG (EXPENTRY FNHWCMD)(PVOID, PVOID);
typedef ULONG (EXPENTRY FNHWIOPL)(FNHWCMD *, PVOID, PVOID);
FNHWIOPL HWCallIOPL;

ULONG ENDIVERegister(PVOID, PVOID);
ULONG ENDIVERequestHardWare(PVOID, PVOID);
ULONG ENDIVEAlloc(PVOID, PVOID);
ULONG EXPENTRY ENDIVEDeath(BOOL*, BOOL*);
ULONG EXPENTRY ENDIVESeamless(BOOL*, BOOL*);
ULONG InitializeVRAM(PVRAMINIT);
ULONG AllocVRAM(PVRAMALLOCIN, PVRAMALLOCOUT, ULONG);
ULONG DeAllocVRAM(PVRAMALLOCIN);
ULONG QueryVRAM(PVRAMALLOCIN, PVRAMALLOCOUT);
VOID SaveVRAM(VOID);
VOID RestoreVRAM(VOID);
VOID CopyVRAM(BOOL, PVRAMLIST);
VOID SaveAllVRAM(VOID);
VOID RestoreAllVRAM(VOID);
ULONG FindFree(PVRAMALLOCIN, PVRAMALLOCOUT);
BOOL QueryFlags(PVRAMHWREQUESTIN, PVRAMHWREQUESTOUT);
VOID QueryStatic(PVRAMHWREQUESTIN, PVRAMHWREQUESTOUT);
ULONG AddStatic(PVRAMALLOCIN, PVRAMALLOCOUT);
VOID DeleteStatic(ULONG, BOOL);
VOID UpdateStatic(POINTL);
VOID UpdateAllStatic(VOID);
VOID FreeHandle(ULONG);
VOID FreeList(VOID);
VOID MergeList(PVRAMLIST *, PVRAMLIST);
ULONG AddLink(PVRAMLIST *, PVRAMLIST);
ULONG AddHandle(ULONG, ULONG);
BOOL FindHandle(ULONG);
BOOL AccelInUse(VOID);
VOID DeleteHandle(ULONG, BOOL);
ULONG FreeMem(PVOID);
PVOID AllocMem(ULONG);
VOID GetFBInfo(VOID);
ULONG InitAccel(VOID);
VOID LoadAccel(VOID);
VOID UnLoadAccel(VOID);

extern VOID CacheManager(BOOL);
extern VOID eddt_InvalidateCache(VOID);
extern ULONG DeacquireFB(BOOL);
extern ULONG AcquireFB(ULONG, PACQUIREFB, BOOL);
#endif
