/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/* Cruiser function prototypes                                        */
/**********************************************************************/

#ifdef PALETTE_MGR
DSPENTRY DeviceAnimatePalette(HDC     hdc,
                              PDEVPAL hdevpal,
                              ULONG   ulFormat,
                              ULONG   ulStart,
                              ULONG   cclr,
                              PULONG  pclr,
                              PDC     pdcArg,
                              ULONG   ulFunN );

DSPENTRY DeviceSetPaletteEntries(HDC     hdc,
                                 PDEVPAL hdevpal,
                                 ULONG   ulFormat,
                                 ULONG   ulStart,
                                 ULONG   cclr,
                                 PULONG  pclr,
                                 PDC     pdcArg,
                                 ULONG   ulFunN );

DSPENTRY DeviceCreatePalette(HDC          hdc,
                             PPALETTEINFO ppalinfo,
                             PDEVPAL      hdevpal,
                             PDC          pdcArg,
                             ULONG        ulFunN);

DSPENTRY DeviceDeletePalette(HDC          hdc,
                             PDEVPAL      hdevpal,
                             PDC          pdcArg,
                             ULONG        ulFunN);

DSPENTRY RealizePalette(HDC          hdc,
                        PULONG       pflType,
                        PULONG       pcclr,
                        PDC          pdcArg,
                        ULONG        ulFunN);

DSPENTRY UpdateColors(HDC          hdc,
                      PDC          pdcArg,
                      ULONG        ulFunN);

DSPENTRY QueryHWPaletteInfo(HDC    hdc,
                            ULONG  ulStart,
                            ULONG  cclr,
                            PULONG pclr,
                            PDC    pdcArg,
                            ULONG  ulFunN);

DSPENTRY QueryPaletteRealization(HDC     hdc,
                                 ULONG   ulStart,
                                 ULONG   cclr,
                                 PULONG  pclr,
                                 PDC     pdcArg,
                                 ULONG   ulFunN);

DSPENTRY DeviceResizePalette(HDC     hdc,
                             PDEVPAL hdevpal,
                             ULONG   ulSize,
                             PDC     pdcArg,
                             ULONG   ulFunN);

/**********************************************************************/
/* internal routines                                                  */
/**********************************************************************/
VOID DRIVERCALL InnerSetPaletteEntries( PDEVPAL hdevpal,
                                        ULONG   ulStart,
                                        ULONG   cclr,
                                        PULONG  pclr);

VOID DRIVERCALL InnerDeletePalette(PDEVPAL hdevpal);

PDEVPAL DRIVERCALL GetPaletteMemory(ULONG);

VOID DRIVERCALL FreePaletteMemory(PDEVPAL hdevpal);

ULONG DRIVERCALL InnerRealizePalette(PULONG       pflType,
                                     PULONG       pcclr);

ULONG DRIVERCALL RealizeDefaultPalette(VOID);

ULONG DRIVERCALL ClosestHWPaletteMatch(RGB2       rgb);

ULONG DRIVERCALL ExactHWPaletteMatch(RGB2);

VOID DRIVERCALL FreeNonDefaultSlots(VOID);

VOID DRIVERCALL RemoveForegroundMarkings(VOID);

VOID DRIVERCALL RemoveBackgroundMarkings(VOID);

VOID DRIVERCALL UpdateRectangle(PRECTL rectangle);

ULONG DRIVERCALL NearestPaletteIndex(RGB2 RGBColor);
#endif /* PALETTE_MGR */
#ifdef FLOOD_FILL
DSPENTRY ScanLR(HDC     hdc,
                PPOINTL pPoint,
                LONG    flCmd,
                LONG    Colour,
                PLONG   pxLeft,
                PLONG   pxRight,
                PDC     pdcArg,
                ULONG   FunN);
#endif /* FLOOD_FILL */
#ifdef DRAW_BITS
DSPENTRY DrawBits(HDC          hdc,
                  PBYTE        pbBits,
                  PBITMAPINFO2 pbmiInfoTable,
                  LONG         lCount,
                  PPOINTL      aptlPoints,
                  LONG         lRop,
                  ULONG        flOptions,
                  PDC          pdcArg,
                  ULONG        ulFunN);
#endif /* DRAW_BITS */
