/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#ifdef DCAF
/**********************************************************************/
/*                                                                    */
/*   Module          = SETSCR.C                                       */
/*                                                                    */
/*   Description     = SetScreenBits Entry Point.                     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDICOMFLAGS
#define INCL_DDIMISC
#define INCL_GRE_REGIONS
#define INCL_GRE_SCREEN
#include <eddinclt.h>
#include <memman.h>
#include <eddgextf.h>
#include <eddmextf.h>
#include <eddbcone.h>
#include <eddhcone.h>
#include <hwaccess.h>

#include <edddtypt.h>
#include <eddhtype.h>
#include <dcaf.h>

extern PBYTE            pPhunkVirt;
extern DDTType          DDT;
extern PPFNL            EnginesDispatchTable;
extern SSB_PB           Spad;
extern ULONG            cFormatTableEntries;
extern BitmapHeader     DirectListEntry;


PBYTE   CreateConvertTable_4ext_4int(VOID);
PBYTE   CreateConvertTable_4ext_8int(VOID);
PBYTE   CreateConvertTable_4ext_16int(VOID);
PBYTE   CreateConvertTable_8ext_16int(VOID);
#ifdef S3
PBYTE   CreateConvertTable_4ext_24int(VOID);
PBYTE   CreateConvertTable_8ext_24int(VOID);
#endif

VOID    ExpandRect8();
VOID    ExpandRect16();

VOID    convert_row_4pl_4pkint();
VOID    convert_row_4pl_8pk();
VOID    convert_row_4pl_16pk();
VOID    convert_row_4pkext_4pkint();
VOID    convert_row_4pk_8pk();
VOID    convert_row_4pk_16pk();
VOID    convert_row_8pk_16pk();
#ifdef S3
VOID    convert_row_4pl_24pk();
VOID    convert_row_4pk_24pk();
VOID    convert_row_8pk_24pk();
VOID    convert_row_16pk_24pk();
#endif

extern PBYTE            pConvertTable_4ext_4int;
extern PBYTE            pConvertTable_4_8;
extern PBYTE            pConvertTable_4_16;
extern PBYTE            pConvertTable_8_16;
#ifdef S3
extern PBYTE            pConvertTable_4_24;
extern PBYTE            pConvertTable_8_24;
#endif

/**********************************************************************/
/* Define a table of valid source and destination data formats.       */
/* Each entry in this table represents a valid src and dst format     */
/* pairing.                                                           */
/**********************************************************************/
#ifdef S3
    #define NUM_VALID_FORMAT_PAIRS 13
#else
    #define NUM_VALID_FORMAT_PAIRS 9
#endif

VALID_DATA_FORMATS   aSSBValidDataFormats[NUM_VALID_FORMAT_PAIRS] =
{
    /******************************************************************/
    /* 4bpp planar external -> 4bpp packed internal                   */
    /******************************************************************/
    { (GSB_4BPP_PLANAR << 8) | GSB_4BPP_LINEAR,
       (PFN)convert_row_4pl_4pkint,
       &pConvertTable_4ext_4int,
       (PFN)CreateConvertTable_4ext_4int  },

    /******************************************************************/
    /* 4bpp planar external -> 8bpp packed internal                   */
    /******************************************************************/
    { (GSB_4BPP_PLANAR << 8) | GSB_8BPP_LINEAR,
       (PFN)convert_row_4pl_8pk,
       &pConvertTable_4_8,
       (PFN)CreateConvertTable_4ext_8int },

    /******************************************************************/
    /* 4bpp planar external -> 16bpp packed internal                  */
    /******************************************************************/
    { (GSB_4BPP_PLANAR << 8) | GSB_16BPP_LINEAR,
       (PFN)convert_row_4pl_16pk,
       &pConvertTable_4_16,
       (PFN)CreateConvertTable_4ext_16int },

    /******************************************************************/
    /* 4bpp packed external -> 4bpp packed internal                   */
    /******************************************************************/
    { (GSB_4BPP_LINEAR << 8) | GSB_4BPP_LINEAR,
       (PFN)convert_row_4pkext_4pkint,
       &pConvertTable_4ext_4int,
       (PFN)CreateConvertTable_4ext_4int  },

    /******************************************************************/
    /* 4bpp packed external -> 8bpp packed internal                   */
    /******************************************************************/
    { (GSB_4BPP_LINEAR << 8) | GSB_8BPP_LINEAR,
       (PFN)convert_row_4pk_8pk,
       &pConvertTable_4_8,
       (PFN)CreateConvertTable_4ext_8int },

    /******************************************************************/
    /* 4bpp packed external -> 16bpp packed internal                  */
    /******************************************************************/
    { (GSB_4BPP_LINEAR << 8) | GSB_16BPP_LINEAR,
       (PFN)convert_row_4pk_16pk,
       &pConvertTable_4_16,
       (PFN)CreateConvertTable_4ext_16int },

    /******************************************************************/
    /* 8bpp packed external -> 8bpp packed internal                   */
    /******************************************************************/
    { (GSB_8BPP_LINEAR << 8) | GSB_8BPP_LINEAR,
       (PFN)NULL,
       NULL,
       (PFN)NULL },

    /******************************************************************/
    /* 8bpp packed external -> 16bpp packed internal                  */
    /******************************************************************/
    { (GSB_8BPP_LINEAR << 8) | GSB_16BPP_LINEAR,
       (PFN)convert_row_8pk_16pk,
       &pConvertTable_8_16,
       (PFN)CreateConvertTable_8ext_16int },

    /******************************************************************/
    /* 16bpp packed external -> 16bpp packed internal                 */
    /******************************************************************/
    { (GSB_16BPP_LINEAR << 8) | GSB_16BPP_LINEAR,
       (PFN)NULL,
       NULL,
       (PFN)NULL }

#ifdef S3
    ,
    /******************************************************************/
    /* 4bpp planar external -> 24bpp packed internal                  */
    /******************************************************************/
    { (GSB_4BPP_PLANAR << 8) | GSB_24BPP_LINEAR,
       (PFN)convert_row_4pl_24pk,
       &pConvertTable_4_24,
       (PFN)CreateConvertTable_4ext_24int },

    /******************************************************************/
    /* 4bpp packed external -> 24bpp packed internal                  */
    /******************************************************************/
    { (GSB_4BPP_LINEAR << 8) | GSB_24BPP_LINEAR,
       (PFN)convert_row_4pk_24pk,
       &pConvertTable_4_24,
       (PFN)CreateConvertTable_4ext_24int },

    /******************************************************************/
    /* 8bpp packed external -> 24bpp packed internal                  */
    /******************************************************************/
    { (GSB_8BPP_LINEAR << 8) | GSB_24BPP_LINEAR,
       (PFN)convert_row_8pk_24pk,
       &pConvertTable_8_24,
       (PFN)CreateConvertTable_8ext_24int },

    /******************************************************************/
    /* 16bpp packed external -> 24bpp packed internal                 */
    /******************************************************************/
    { (GSB_16BPP_LINEAR << 8) | GSB_24BPP_LINEAR,
       (PFN)convert_row_16pk_24pk,
       NULL,
       (PFN)NULL }
#endif

};


/**********************************************************************/
/* SetScreenBits                                                      */
/*                                                                    */
/* A region of screen pixel data is reconstructed from the buffer     */
/* provided by the caller and copied into a memory bitmap of the      */
/* display device.  The buffer contains data provided by the          */
/* GetScreenBits function.                                            */
/*                                                                    */
/* The supplied DC must be of memory type with a bitmap selected.     */
/*                                                                    */
/* There is no clipping.  If a rectangle exceeds the bitmap           */
/* dimensions then the function will terminate immediately with an    */
/* error logged. The bitmap may be left in a partially drawn state    */
/* as prior rectangles may have been copied into it.                  */
/*                                                                    */
/* This is a drawing primitive, therefore correlation, boundary       */
/* accumulation and drawing could take place.  However this is        */
/* essentially a private interface (at least the caller is well       */
/* behaved) so we will totally ignore the function bits, and will     */
/* always just do the drawing and nothing else.                       */
/*                                                                    */
/* The routine may be passed a region handle, in which case the area  */
/* defined by the set bits will be added to the region.               */
/*                                                                    */
/* The XGA driver may be passed 4bpp planar, 4bpp packed, 8bpp packed */
/* and 16bpp packed data.                                             */
/*                                                                    */
/**********************************************************************/

DDIENTRY SetScreenBits( HDC     hdc,
                        PBYTE   pSrcBuffer,
                        ULONG   cbDataLength,
                        HRGN    hrgn,
                        PDC     pdcArg,
                        ULONG   FunN )
{
    ULONG           ulError;
    ULONG           ulSrcDataFormat;
    ULONG           ulDstDataFormat;
    ULONG           ulCombinedDataFormat;
    ULONG           iFormat;
    PBYTE           pFinalSrcByte;
    RECTL           rcl;
    pBitmapHeader   pbmh;
    ULONG           cyRowsFromTop;

    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

    /******************************************************************/
    /* EnterDriver                                                    */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* Perform Error Checks.                                          */
    /******************************************************************/
    if (FunNTest(COM_PATH))
    {
        ulError = PMERR_INV_IN_PATH;
        goto ssb_log_err_exit;
    }

    if (FunNTest(COM_AREA))
    {
        ulError = PMERR_INV_IN_AREA;
        goto ssb_log_err_exit;
    }

    /******************************************************************/
    /* We must be setting the bits into a memory DC.                  */
    /******************************************************************/
    if (pdcArg->DCIDCType != OD_MEMORY)
    {
        ulError = PMERR_INV_DC_TYPE;
        goto ssb_log_err_exit;
    }

    if (pdc->DCIBitmapType == BITMAP_NOT_SELECTED)
    {
        ulError = PMERR_BITMAP_NOT_SELECTED;
        goto ssb_log_err_exit;
    }

    /******************************************************************/
    /* If the data length is zero then we can exit immediately.       */
    /******************************************************************/
    if (cbDataLength == 0)
    {
        goto ssb_ok_exit;
    }

    /******************************************************************/
    /* Check that the data length is at least the size of the header. */
    /******************************************************************/
    if (cbDataLength < sizeof(PACKETHDR))
    {
        ulError = PMERR_INV_LENGTH_OR_COUNT;
        goto ssb_log_err_exit;
    }

    /******************************************************************/
    /* Check the passed data length agrees with the data length given */
    /* in the packet header.                                          */
    /******************************************************************/
    if ( ((PPACKETHDR)pSrcBuffer)->ulLength != cbDataLength)
    {
        ulError = PMERR_INV_LENGTH_OR_COUNT;
        goto ssb_log_err_exit;
    }

    /******************************************************************/
    /* Calculate the address of the first and last data bytes.        */
    /******************************************************************/
    Spad.pNextSrcByte = pSrcBuffer + sizeof(PACKETHDR);
    pFinalSrcByte = pSrcBuffer + cbDataLength - 1;

    /******************************************************************/
    /* Extract the data format from the packet header.                */
    /******************************************************************/
    ulSrcDataFormat = (ULONG)((PPACKETHDR)pSrcBuffer)->usFormat;

    /******************************************************************/
    /* Calculate the code representing our internal data format.      */
    /******************************************************************/
    if (DDT.BitCount == 4)
        ulDstDataFormat = GSB_4BPP_LINEAR;
    else if (DDT.BitCount == 8)
        ulDstDataFormat = GSB_8BPP_LINEAR;
    else
        ulDstDataFormat = GSB_16BPP_LINEAR;
#ifdef S3
    if (DDT.BitCount == 24)
        ulDstDataFormat = GSB_24BPP_LINEAR;
#endif

    /******************************************************************/
    /* Check that we have a valid combination of src/dst formats.     */
    /******************************************************************/
    ulCombinedDataFormat = (ulSrcDataFormat << 8) | ulDstDataFormat;
    for (iFormat = 0; iFormat < NUM_VALID_FORMAT_PAIRS; iFormat++)
    {
        if (aSSBValidDataFormats[iFormat].ulSrcDstFormat ==
                                               ulCombinedDataFormat)
        {
            break;
        }
    }

    /******************************************************************/
    /* If the format combination is invalid then raise an error.      */
    /******************************************************************/
    if (iFormat >= NUM_VALID_FORMAT_PAIRS)
    {
        ulError = PMERR_INCOMPAT_COLOR_FORMAT;
        goto ssb_log_err_exit;
    }

    /******************************************************************/
    /* The src/dst combination is valid.                              */
    /* See if conversion is required, and if so then make sure        */
    /* that the required conversion table has been created.           */
    /******************************************************************/
    if (aSSBValidDataFormats[iFormat].ppConvertTable != NULL)
    {
        Spad.fConversionRequired = TRUE;
        Spad.pfnConvertRow =
                  aSSBValidDataFormats[iFormat].pfnRowConversionRoutine;

        /**************************************************************/
        /* See if the required conversion table has been created.     */
        /**************************************************************/
        if (*(aSSBValidDataFormats[iFormat].ppConvertTable) == NULL)
        {
            /**********************************************************/
            /* Create the required conversion table.                  */
            /**********************************************************/
            *(aSSBValidDataFormats[iFormat].ppConvertTable) =
                (aSSBValidDataFormats[iFormat].pfnCreateConvertTable)();

            /**********************************************************/
            /* Check that the convert table was created.              */
            /**********************************************************/
            if (*(aSSBValidDataFormats[iFormat].ppConvertTable) == NULL)
            {
                goto ssb_err_exit;
            }
        }
    }
    else
    {
#ifdef S3
        if ( ulCombinedDataFormat == ((GSB_16BPP_LINEAR << 8) | GSB_24BPP_LINEAR))
        {
            Spad.fConversionRequired = TRUE;
            Spad.pfnConvertRow =
                      aSSBValidDataFormats[iFormat].pfnRowConversionRoutine;
        }
        else
#endif
            Spad.fConversionRequired = FALSE;
    }

    /******************************************************************/
    /* Get the pointer to the currently selected bitmap header.       */
    /******************************************************************/
    pbmh = pdc->DCISelListEntry;

    /******************************************************************/
    /* Store some useful values in the scratch-pad. These will be     */
    /* used in the lower-level assembly routine.                      */
    /* All of these values will remain constant for every rectangle.  */
    /******************************************************************/
    Spad.cbBytesPerScanline = pbmh->BytesPerLine;
    Spad.pConvertBuffer1 = pPhunkVirt;
    Spad.pConvertBuffer2 = pPhunkVirt + MAX_SCANLINE_BYTES;

    /******************************************************************/
    /* Check that the hardware is idle before we start using the      */
    /* PHUNK.                                                         */
    /******************************************************************/
    WaitForRealHWFunction();

    /******************************************************************/
    /* Keep processing the source (compressed) data until it is all   */
    /* done.                                                          */
    /******************************************************************/
    while (Spad.pNextSrcByte < pFinalSrcByte)
    {

#ifdef FIREWALLS
        /**************************************************************/
        /* Check that the rectangle has reasonable coordinates.       */
        /**************************************************************/
        if ( (((PRECTS)Spad.pNextSrcByte)->pts1.x < 0) ||
             (((PRECTS)Spad.pNextSrcByte)->pts1.y < 0) ||
             (((PRECTS)Spad.pNextSrcByte)->pts2.x >
                              (SHORT)pbmh->Info.Width) ||
             (((PRECTS)Spad.pNextSrcByte)->pts2.y >
                              (SHORT)pbmh->Info.Height) )
        {
            ulError = PMERR_INV_RECT;
            goto ssb_log_err_exit;
        }
#endif
        /**************************************************************/
        /* Transfer the rect coords from the buffer into a local      */
        /* variable (while also extending them to LONGs).             */
        /**************************************************************/
        rcl.xLeft   = (LONG)(((PRECTS)Spad.pNextSrcByte)->pts1.x);
        rcl.yBottom = (LONG)(((PRECTS)Spad.pNextSrcByte)->pts1.y);
        rcl.xRight  = (LONG)(((PRECTS)Spad.pNextSrcByte)->pts2.x);
        rcl.yTop    = (LONG)(((PRECTS)Spad.pNextSrcByte)->pts2.y);

        /**************************************************************/
        /* Move past the rectangle to the data.                       */
        /**************************************************************/
        Spad.pNextSrcByte += sizeof(RECTS);

        /**************************************************************/
        /* Calculate how many rows and columns we have to process     */
        /* for this rectangle.                                        */
        /**************************************************************/
        Spad.cyRowsToDo = rcl.yTop - rcl.yBottom;
        Spad.cPelsPerRow = rcl.xRight - rcl.xLeft;

        /**************************************************************/
        /* Calculate how many rows from the top of the bitmap the     */
        /* top of the rectangle is.                                   */
        /**************************************************************/
        cyRowsFromTop = pbmh->Info.Height - rcl.yTop;

        /**************************************************************/
        /* Calculate the number of bytes per row of the rectangle,    */
        /* and the address in the destination bitmap of the top left  */
        /* corner.                                                    */
        /**************************************************************/
        if (DDT.BitCount == 4)
        {
            Spad.cbBytesPerDstRow = Spad.cPelsPerRow / 2;
            Spad.pTopDstRow = pbmh->Bitmap +
                  (cyRowsFromTop*Spad.cbBytesPerScanline) + rcl.xLeft/2;
        }
        else if (DDT.BitCount == 8)
        {
            Spad.cbBytesPerDstRow = Spad.cPelsPerRow;
            Spad.pTopDstRow = pbmh->Bitmap +
                    (cyRowsFromTop*Spad.cbBytesPerScanline) + rcl.xLeft;
        }
        else if (DDT.BitCount == 16)
        {
            Spad.cbBytesPerDstRow = Spad.cPelsPerRow * 2;
            Spad.pTopDstRow = pbmh->Bitmap +
                (cyRowsFromTop * Spad.cbBytesPerScanline) + rcl.xLeft*2;
        }
#ifdef S3
        else if (DDT.BitCount == 24)
        {
            Spad.cbBytesPerDstRow = Spad.cPelsPerRow * 3;
            Spad.pTopDstRow = pbmh->Bitmap +
                (cyRowsFromTop * Spad.cbBytesPerScanline) + rcl.xLeft*3;
        }
#endif

        /**************************************************************/
        /* Work out the delta from the end of a row to the beginning  */
        /* of the next row in the destination bitmap.                 */
        /**************************************************************/
        Spad.cbEndOfRowInc =
                        Spad.cbBytesPerScanline - Spad.cbBytesPerDstRow;

        /**************************************************************/
        /* The number of data fields in the source data depends       */
        /* upon the rectangle width and the SOURCE bits per pel       */
        /**************************************************************/
        if ( ((ulSrcDataFormat & GSB_BPP_FLAGS) == GSB_OPT_4BPP) ||
             ((ulSrcDataFormat & GSB_BPP_FLAGS) == GSB_OPT_8BPP) )
        {
            /**********************************************************/
            /* Source data is 4bpp with 8-bit data fields, or 8bpp    */
            /* with 16-bit data fields.                               */
            /* Therefore there is one data field for every two source */
            /* pels.                                                  */
            /**********************************************************/
            Spad.cDataFieldsPerRow = Spad.cPelsPerRow / 2;
        }
        else
        {
            /**********************************************************/
            /* Source data is 16bpp with 16-bit data fields.          */
            /* Therefore there is one data field for each source pel. */
            /**********************************************************/
            Spad.cDataFieldsPerRow = Spad.cPelsPerRow;
        }

        /**************************************************************/
        /* Decompress the current rect into our internal bitmap       */
        /* (also doing any necessary conversions).                    */
        /**************************************************************/
        if ((ulSrcDataFormat & GSB_BPP_FLAGS) == GSB_OPT_4BPP)
        {
            /**********************************************************/
            /* The source data has 8-bit data fields.                 */
            /**********************************************************/
            Spad.pNextSrcByte = ExpandRect8();
        }
        else
        {
            /**********************************************************/
            /* The source data has 16-bit data fields.                */
            /**********************************************************/
            Spad.pNextSrcByte = ExpandRect16();
        }

        /**************************************************************/
        /* Check for errors.                                          */
        /**************************************************************/
        if (Spad.pNextSrcByte == 0)
        {
            goto ssb_err_exit;
        }

        /**************************************************************/
        /* If we were passed a region handle then update it to add    */
        /* the rectangle that we have just decompressed.              */
        /**************************************************************/
        if (hrgn != 0)
        {
            if (0 == EnginesDispatchTable[NGreCombineRectRegion & 0xff]
                                           ( hdc,
                                             hrgn,
                                             &rcl,
                                             hrgn,
                                             CRGN_OR,
                                             pdcArg,
                                             NGreCombineRectRegion ) )
            {
                goto ssb_err_exit;
            }
        }
    }

ssb_ok_exit:
    /******************************************************************/
    /* Return success.                                                */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(TRUE);

ssb_log_err_exit:
    /******************************************************************/
    /* Log the error.                                                 */
    /******************************************************************/
    if (ulError)
    {
        LogError(ulError);
    }

ssb_err_exit:
    /******************************************************************/
    /* Return FALSE to indicate error.                                */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(FALSE);

} /* SetScreenBits */



#endif /* DCAF */
