/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#define USEENGINE
/**********************************************************************/
/*                                                                    */
/* semaphor.h                                                         */
/*                                                                    */
/* Semaphore header file.                                             */
/*                                                                    */
/**********************************************************************/

#ifdef SEAMLESS
extern FSRSEM   FSRDriverSem;
extern ULONG    SeamlessInitSem(VOID);
// extern USHORT   FSRSemEnter32(PFSRSEM);
// extern USHORT   FSRSemLeave32(PFSRSEM);
extern USHORT _syscall RAMSEMREQUEST32(PFSRSEM);
extern USHORT _syscall RAMSEMCLEAR32(PFSRSEM);

/**********************************************************************/
/* Initialises the XGA FSR semaphore used to serialise driver usage   */
/* and stop the PM and         drivers conflicting.  Stores the       */
/* semaphore in the global FSRDriverSem.  Should only be called once. */
/* Returns NO_ERROR since initialising the FSR can not go wrong.      */
/**********************************************************************/
#define CreateDriverSemaphore() SeamlessInitSem()

/**********************************************************************/
/* This is a NULL operation for an FSR semaphore.                     */
/**********************************************************************/
#define OpenDriverSemaphore()

/**********************************************************************/
/* This is a NULL operation for an FSR semaphore.                     */
/**********************************************************************/
#define CloseDriverSemaphore()

/**********************************************************************/
/* Requests the semaphore used to serialise driver usage. If the      */
/* semaphore is already owned, the requesting thread is suspended     */
/* until the owning thread releases it.                               */
/**********************************************************************/
#define RequestDriverSemaphore() RAMSEMREQUEST32(&FSRDriverSem)

/**********************************************************************/
/* Releases the semaphore used to serialise driver usage.             */
/**********************************************************************/
#define ReleaseDriverSemaphore() RAMSEMCLEAR32(&FSRDriverSem)


#else /* ifdef SEAMLESS else */


#ifdef USEENGINE
/**********************************************************************/
/* These are the versions of the semaphore macros for use when we     */
/* are using the exported engine semaphores                           */
/**********************************************************************/
ULONG _syscall GreRequestMutexSem(ULONG shandle);
ULONG _syscall GreReleaseMutexSem(ULONG shandle);

#define HDRIVERSEM  14

/**********************************************************************/
/* These functions are handled by the engine for us (I hope!)         */
/**********************************************************************/
#define CreateDriverSemaphore() NO_ERROR
#define OpenDriverSemaphore()
#define CloseDriverSemaphore()

/**********************************************************************/
/* Requests the semaphore used to serialise driver usage. If the      */
/* semaphore is already owned, the requesting thread is suspended     */
/* until the owning thread releases it.                               */
/**********************************************************************/
#define RequestDriverSemaphore() GreRequestMutexSem(HDRIVERSEM)

/**********************************************************************/
/* Releases the semaphore used to serialise driver usage.             */
/**********************************************************************/
#define ReleaseDriverSemaphore() GreReleaseMutexSem(HDRIVERSEM)

#else /* ifdef USEENGINE else */

extern HMTX   hDriverSem;

/**********************************************************************/
/* Create the XGA semaphore used to serialise driver usage. Stores    */
/* the semaphore handle in the global hDriverSem.                     */
/* Should only be called once.                                        */
/* Returns the Dos return value.                                      */
/**********************************************************************/
#define CreateDriverSemaphore()                                        \
    DosCreateMutexSem (NULL, /* Semaphore name */                      \
                       &hDriverSem,                                    \
                       DC_SEM_SHARED,                                  \
                       FALSE /* Initial state unowned */)


/**********************************************************************/
/* Opens the semaphore used to serialise driver usage to allow a      */
/* process other than the creator to use it. Should be called when a  */
/* new process starts and only once per process.                      */
/**********************************************************************/
#define OpenDriverSemaphore()                                          \
    {                                                                  \
        HMTX    hLocalSem = hDriverSem;                                \
        DosOpenMutexSem(NULL, &hLocalSem);                             \
    }


/**********************************************************************/
/* Closes the semaphore used to serialise driver usage. This          */
/* should be done once by a terminating process to ensure the usage   */
/* count is correctly maintained. The usage count should never fall   */
/* to zero so this function will not destroy the semaphore.           */
/**********************************************************************/
#define CloseDriverSemaphore() DosCloseMutexSem(hDriverSem)


/**********************************************************************/
/* Requests the semaphore used to serialise driver usage. If the      */
/* semaphore is already owned, the requesting thread is suspended     */
/* until the owning thread releases it.                               */
/**********************************************************************/
#define RequestDriverSemaphore()                                       \
        DosRequestMutexSem(hDriverSem,SEM_INDEFINITE_WAIT)


/**********************************************************************/
/* Releases the semaphore used to serialise driver usage.             */
/**********************************************************************/
#define ReleaseDriverSemaphore() DosReleaseMutexSem(hDriverSem)


#endif /* ifdef USEENGINE else */

#endif /* ifdef SEAMLESS else */




