/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/* Function prototypes.                                               */
/**********************************************************************/
VOID    UpdateVRAMBitmap(VOID);
VOID    AccessVRAMBitmap(VOID);

#define MAX_PIDADDR 1024

typedef struct _PIDADDR
{
    ULONG       pid;
    ULONG       flataddress;
} PIDADDR;

/**********************************************************************/
/* Define the IDs that identify the various adapters.                 */
/**********************************************************************/
#define XGA_ID     0x08fdb
#define MATROX_ID  0x080ee

/**********************************************************************/
/* A macro to determine if we are currently running the display       */
/* driver on a Matrox board.                                          */
/**********************************************************************/
#define RunningOnMatrox() (aiXGAAdapter.AdapterID == MATROX_ID)

/**********************************************************************/
/* A macro to determine if we are currently running the display       */
/* driver on an XGA board.                                            */
/**********************************************************************/
#define RunningOnXGA() (aiXGAAdapter.AdapterID == XGA_ID)
