/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#define INCL_DOSPROCESS
#define INCL_DOSDEVICES
#include <eddinclt.h>

#ifdef MATROX
extern BitmapHeader     VRAMBitmap;
extern ADAPTERINFO      aiXGAAdapter;

ULONG   LastPID;
PIDADDR PIDTable[MAX_PIDADDR];
ULONG   cPID = 0;

VOID    UpdateVRAMBitmap(VOID)
{
    PTIB    pThreadInfo;
    PPIB    pProcessInfo;
    ULONG   i;
    ULONG   ThisPID;

    if (RunningOnMatrox())
    {
        /**************************************************************/
        /* Our flat model address for VRAM is unfortunately only      */
        /* valid in a single process.  Thus we must determine which   */
        /* process we are in, and set our global address accordingly. */
        /**************************************************************/
        DosGetInfoBlocks(&pThreadInfo,
                         &pProcessInfo);

        ThisPID = pProcessInfo->pib_ulpid;
        if (ThisPID != LastPID)
        {
            /**********************************************************/
            /* This process is not the same as the last one.          */
            /* Save this as the current PID, and set the global       */
            /* address accordingly.                                   */
            /**********************************************************/
            LastPID = ThisPID;

            i = 0;
            while ( PIDTable[i].pid != ThisPID )
            {
                i++;
            }
            VRAMBitmap.Bitmap = PIDTable[i].flataddress;
        }
    }
}


VOID    AccessVRAMBitmap(VOID)
{
    ULONG       fn_id = IO_FLAT_ACCESS;
    ULONG       flataddress;
    PTIB        pThreadInfo;
    PPIB        pProcessInfo;

    if (RunningOnMatrox())
    {
        DosDevIOCtl( aiXGAAdapter.hfDevHandle,
                     XGA_CATEGORY,
                     GEN_FUNCTION,
                     (PVOID)&fn_id,
                     sizeof(fn_id),  /* not passed to level 1 ring0 code */
                     NULL,           /* not passed to level 1 ring0 code */
                     (PVOID)&flataddress,
                     sizeof(flataddress),
                                     /* not passed to level 1 ring0 code */
                     NULL            /* not passed to level 1 ring0 code */
                   );

        DosGetInfoBlocks(&pThreadInfo,
                         &pProcessInfo);

        /**************************************************************/
        /* Save this information in the PIDTable.                     */
        /**************************************************************/
        PIDTable[cPID].flataddress = flataddress;
        PIDTable[cPID].pid         = pProcessInfo->pib_ulpid;

        /**************************************************************/
        /* Move to the next entry in the table.                       */
        /**************************************************************/
        cPID++;
    }
}
#endif /* MATROX */
