/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = INIT.C                                         */
/*                                                                    */
/*   Description     = Contains the DLL initialization routine        */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DOSERRORS
#define INCL_DOSSEMAPHORES
#include <eddinclt.h>

#include <semaphor.h>
#include <memman.h>

extern HMODULE hModule;

/**********************************************************************/
/* Load procedure called once when the module is loaded               */
/*                                                                    */
/* The parameters are explained in \dos\task\tklibi.c                 */
/**********************************************************************/
APIRET APIENTRY XGA_DLLInit(HMODULE hmod,
                            ULONG   pdll)
{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(pdll);


    /******************************************************************/
    /* Save our hmod so we can use it in DosGetResource calls.        */
    /******************************************************************/
    hModule = hmod;

    /******************************************************************/
    /* Create the EnterDriver semaphore.                              */
    /******************************************************************/
    if (NO_ERROR != CreateDriverSemaphore())
    {
        /**************************************************************/
        /* Create failed, return failure                              */
        /**************************************************************/
        return(FALSE);
    }

    /******************************************************************/
    /* Everthing was OK.                                              */
    /******************************************************************/
    return(TRUE);
}
