/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = ENDIVE.H
 *
 * DESCRIPTIVE NAME = ENDIVE Header
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define VRAM_ALLOCATE                1
#define VRAM_DEALLOCATE              2
#define VRAM_QUERY                   3

#define ENDIVE_REGISTER_HANDLE       0x0001
#define ENDIVE_REGISTER_VRAMONLY     0x1000

#define ENDIVE_REQUEST_HARDWARE      0x0001
#define ENDIVE_REQUEST_UNAVAILABLE   0x0001
#define ENDIVE_REQUEST_RELOCATED     0x0002

#define ENDIVE_ALLOC_SHARED          0x0001
#define ENDIVE_ALLOC_RECTANGLE       0x0002
#define ENDIVE_ALLOC_WORKBUFFER      0x0004
#define ENDIVE_ALLOC_STATIC          0x1000

#define FOURCC( ch0, ch1, ch2, ch3 )                      \
  ( (ULONG)(BYTE)(ch0) | ( (ULONG)(BYTE)(ch1) << 8 ) |    \
  ( (ULONG)(BYTE)(ch2) << 16 ) | ((ULONG)(BYTE)(ch3) << 24 ) )

#define FOURCC_LUT8 FOURCC('L','U','T','8')  /* 8-bit palettized */
#define FOURCC_R565 FOURCC('R','5','6','5')  /* RGB 565 */
#define FOURCC_R555 FOURCC('R','5','5','5')  /* RGB 555 */
#define FOURCC_R666 FOURCC('R','6','6','6')  /* RGB 666 */
#define FOURCC_R664 FOURCC('R','6','6','4')  /* RGB 664 */
#define FOURCC_RGB3 FOURCC('R','G','B','3')  /* RGB 24 in 3 bytes */
#define FOURCC_BGR3 FOURCC('B','G','R','3')  /* BGR 24 in 3 bytes */
#define FOURCC_RGB4 FOURCC('R','G','B','4')  /* RGB 24 in 4 bytes */
#define FOURCC_BGR4 FOURCC('B','G','R','4')  /* BGR 24 in 4 bytes */
#define FOURCC_Y888 FOURCC('Y','8','8','8')  /* YUV 24 */
#define FOURCC_Y411 FOURCC('Y','4','1','1')  /* YUV 411 interleaved 4 by 1 subsampled*/
#define FOURCC_Y422 FOURCC('Y','4','2','2')  /* YUV 422 (CCIR601) */
#define FOURCC_YUV9 FOURCC('Y','U','V','9')  /* YUV9 */
#define FOURCC_Y2X2 FOURCC('Y','2','X','2')  /* YUV 2 by 2 subsampled multi-plane */
#define FOURCC_Y4X4 FOURCC('Y','4','X','4')  /* YUV 4 by 4 subsampled multi-plane */

typedef struct _VRAMREGISTERIN
{
   ULONG ulLength;
   ULONG ulHandle;
   ULONG ulFlags;
} VRAMREGISTERIN;
typedef VRAMREGISTERIN *PVRAMREGISTERIN;

typedef struct _VRAMREGISTEROUT
{
   ULONG ulLength;
   ULONG ulFlags;
   ULONG ulHandle;
} VRAMREGISTEROUT;
typedef VRAMREGISTEROUT *PVRAMREGISTEROUT;

typedef struct _VRAMHWREQUESTIN
{
   ULONG ulLength;
   ULONG ulHandle;
   ULONG ulID;
   PACQUIREFB pAcquireFB;
   ULONG ulFlags;
} VRAMHWREQUESTIN;
typedef VRAMHWREQUESTIN *PVRAMHWREQUESTIN;

typedef struct _VRAMHWREQUESTOUT
{
   ULONG ulLength;
   ULONG ulFlags;
   POINTL ptlStart;
   ULONG ulSize;
   PVOID pSysMem;
   ULONG ulScanLineBytes;
} VRAMHWREQUESTOUT;
typedef VRAMHWREQUESTOUT *PVRAMHWREQUESTOUT;

typedef struct _VRAMALLOCIN
{
   ULONG ulLength;
   ULONG ulFlags;
   ULONG ulID;
   ULONG ulFunction;
   ULONG ulHandle;
   ULONG ulSize;
   ULONG ulWidth;
   ULONG ulHeight;
} VRAMALLOCIN;
typedef VRAMALLOCIN *PVRAMALLOCIN;

typedef struct _VRAMALLOCOUT
{
   ULONG ulLength;
   ULONG ulFlags;
   ULONG ulID;
   POINTL ptlStart;
   ULONG ulSize;
   ULONG ulScanLineBytes;
} VRAMALLOCOUT;
typedef VRAMALLOCOUT *PVRAMALLOCOUT;

#define ENDIVE_INIT            1
#define ENDIVE_QUERY           2
#define ENDIVE_PUT             3
#define ENDIVE_GET             4
#define ENDIVE_FOREGROUND      5
#define ENDIVE_BACKGROUND      6

#define GHI_CMD_EXTENSION      14

typedef ULONG (EXPENTRY FNVMIENTRY)(ULONG, ULONG, PVOID, PVOID);

typedef struct _HWEXTENSIONIN
{
   ULONG ulLength;
   ULONG ulXSubFunction;
   ULONG cScrChangeRects;
   PRECTL arectlScreen;
   ULONG ulXFlags;
   PVOID pXP1;
} HWEXTENSIONIN;
typedef HWEXTENSIONIN *PHWEXTENSIONIN;

typedef struct _HWEXTENSIONOUT
{
   ULONG ulLength;
   ULONG ulFlags;
} HWEXTENSIONOUT;
typedef HWEXTENSIONOUT *PHWEXTENSIONOUT;

#define EXT_SERIALIZEDAC       0x0001
#define FB_SUPPORTSVRAMALLOC   0x0001

typedef struct _FBINFO
{
   ULONG ulLength;
   ULONG ulFlags;
   ULONG ulBPP;
   ULONG ulXres;
   ULONG ulYres;
   ULONG ulScanLineBytes;
   ULONG fccColorEncoding;
   ULONG ulENDIVEDrivers;
} FBINFO;
typedef FBINFO *PFBINFO;

