/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDVEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     AVIO routines                                  */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
DDIENTRY eddv_CharRect (HDC             hdc,
                        PVIOPS          VioPS,
                        LPGridRectRef   ArgCharRect,
                        PDC             pdcArg,
                        ULONG           FunN);

DDIENTRY eddv_CharStr (HDC              hdc,
                       PVIOPS           VioPS,
                       LPGridStringRef  ArgCharString,
                       PDC              pdcArg,
                       ULONG            FunN);

DDIENTRY eddv_ScrollRect (HDC                hdc,
                          PVIOPS             VioPS,
                          LPScrollRectRef    ArgScrollRect,
                          PDC                pdcArg,
                          ULONG              FunN);

DDIENTRY eddv_UpdateCursor (HDC         hdc,
                            PVIOPS      VioPS,
                            PDC         pdcArg,
                            ULONG       FunN);

DDIENTRY eddv_DeviceSetAVIOFont2 (HDC           hdc,
                                  PFATTRS       pFattrs,
                                  PFOCAFONT     FontDef,
                                  LONG          LCIDindex,
                                  PDC           pdcArg,
                                  ULONG         FunN);

/**********************************************************************/
/* Internal routines.                                                 */
/**********************************************************************/
VOID DRIVERCALL CheckAVIOFonts(PVIOPS  VioPS);

VOID DRIVERCALL CheckAVIOFontsCached(PVIOPS  VioPS);

VOID DRIVERCALL CGAText(VOID);

VOID DRIVERCALL MFIText(VOID);

VOID DRIVERCALL InvertAVIOCursor(PVIOPS  VioPS);

VOID DRIVERCALL CalculateGridOffsets(PAVIOINFO pAvioInfo,
                                     PVIOPS    VioPS);

/**********************************************************************/
/* Assembler code routines                                            */
/**********************************************************************/
VOID DRIVERCALL CGATextBlock(PFONTDETAILS pFontDetails,
                             PAVIOINFO    pAvioInfo);
VOID DRIVERCALL MFITextBlock(PFONTDETAILS pFontDetails,
                             PAVIOINFO    pAvioInfo);
VOID DRIVERCALL AVIOScroll(PVOID);

VOID DRIVERCALL AVIOCursor(VOID);

ULONG DRIVERCALL update_cache_charrect_2(PFONTDETAILS pFontDetails,
                                         PAVIOINFO    pAvioInfo);
ULONG DRIVERCALL update_cache_charrect_4(PFONTDETAILS pFontDetails,
                                         PAVIOINFO    pAvioInfo);
