/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDTYPET                                       */
/*                                                                    */
/*   Description     = Display Device Driver types                    */
/*                                                                    */
/*   Function        = Contains all those types that all routines     */
/*                     include.                                       */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* World coordinate type                                              */
/**********************************************************************/
typedef struct _WcsPoint { /* wpt */
        LONG X;
        LONG Y;
    } WcsPoint;

/**********************************************************************/
/* Device coordinate type                                             */
/**********************************************************************/

typedef struct _DevPoint { /* dpt */
        SHORT X;
        SHORT Y;
    } DevPoint;

typedef DevPoint * pDevPoint;

/**********************************************************************/
/* AVIO coordinate type                                               */
/**********************************************************************/
typedef struct _AvioPoint { /* avp */
        SHORT Col;
        SHORT Row;
    } AvioPoint;

/**********************************************************************/
/* World coordinate rectangle type                                    */
/**********************************************************************/
typedef WcsPoint WcsRect[2];
typedef WcsRect * pWcsRect;
typedef WcsPoint * pWcsPoint;

/**********************************************************************/
/* Device coordinate rectangle type                                   */
/**********************************************************************/
typedef DevPoint DevRect[2];
typedef DevRect * pDevRect;

/**********************************************************************/
/* Types for AVIO rectangles                                          */
/**********************************************************************/
typedef AvioPoint AvioRect[2];

typedef struct _AvioBlock { /* avb */
        SHORT Col0;
        SHORT Row0;
        SHORT Col1;
        SHORT Row1;
    } AvioBlock;

/**********************************************************************/
/* Type for Clip Rectangles                                           */
/**********************************************************************/

typedef struct _ClipRectangle { /* clr */
        SHORT    X0;
        SHORT    X0H;
        SHORT    Y0;
        SHORT    Y0H;
        SHORT    X1;
        SHORT    X1H;
        SHORT    Y1;
        SHORT    Y1H;
    } ClipRectangle;

typedef ClipRectangle * lpClipRectangle;

typedef struct _BoundClipRect { /* bcr */
        SHORT   X0;
        SHORT   Y0;
        SHORT   X1;
        SHORT   Y1;
    } BoundClipRect;

typedef BoundClipRect * lpBoundClipRect;


/**********************************************************************/
/* Type for Polyscanline rectangles                                   */
/**********************************************************************/
typedef struct _ScanRectangle { /* scr */
    coord_pr    coord;
    SHORT       width;
    SHORT       height;
} ScanRectangle;

typedef ScanRectangle * lpScanRectangle;

/**********************************************************************/
/* Type definitions for Color Tables                                  */
/**********************************************************************/

typedef struct _COLOURTABLETYPE { /* ctt */
        RGB2      LogRGB;             /* Logical RGB value           */
        ULONG     PhyIndex;           /* Physical index of nearest   */
    } COLORTABLETYPE;

typedef COLORTABLETYPE * PCOLORTABLE;

/**********************************************************************/
/* Background and foreground color pairs                              */
/**********************************************************************/

typedef struct _COLORPAIR { /* cp */
        ULONG  ForeColor;              /* f/g physical color index    */
        ULONG  BackColor;              /* b/g physical color index    */
    } COLORPAIR;

/**********************************************************************/
/* Type for AI character definition block                             */
/**********************************************************************/
typedef struct CharSetDef AICharDef;

typedef AICharDef * pAICharDef;

/**********************************************************************/
/* structure for realized fonts                                       */
/**********************************************************************/

typedef struct _RealizedFontType { /* rft */
        pAICharDef                AICharSetDefn;
        USHORT                    EntryInFontMetrics;
        USHORT                    Codepage;
    } RealizedFontType;

typedef RealizedFontType * pRealizedFontType;

/**********************************************************************/
/* structure for object locking                                       */
/**********************************************************************/
typedef struct _OBJECT { /* ob */
    PID         Pid;
    TID         Tid;
    USHORT      LockCount;
    USHORT      BusyError;
} OBJECT;
typedef OBJECT * LPOBJECT;

/**********************************************************************/
/* Type definition for Bitmap bits                                    */
/**********************************************************************/

typedef PBYTE lpBitmap;

/**********************************************************************/
/* Type definition for extended bitmap info table                     */
/**********************************************************************/

typedef struct ExtBMParams { /* ebmp */
        USHORT  Width;
        USHORT  Height;
        USHORT  BitCount;
        USHORT  HWWidth;
        USHORT  HWHeight;
        USHORT  HWFormat;
    } ExtBMParms;

/**********************************************************************/
/* Type definition for information required by marker in addition     */
/* to the bitmap header.                                              */
/**********************************************************************/
typedef struct MARKER_INFO { /* mi */
        USHORT  MarginWidth;
        USHORT  MarginHeight;
    } MARKER_INFO;
typedef MARKER_INFO * PMARKER_INFO;

/**********************************************************************/
/* Type definition for extended bitmap header                         */
/**********************************************************************/

typedef struct _BitmapHeader { /* bmh */
        lpBitmap           Bitmap;      /* the actual bitmap bits !   */
        ULONG              BMPhys;      /* bitmap physical address    */
        ULONG              BMSize;      /* size (bytes) of bitmap     */
        ExtBMParms         Info;        /* width, height and bitcount */
        HDC                DCHandle;    /* DC handle if selected      */
        USHORT             BytesPerLine;/* bytes needed for one row   */
#ifdef VRAMPTR
        ULONG              bm_cache_slot;
#endif /* VRAMPTR */
        MARKER_INFO        MarkerInfo;  /* Information needed by markers */
    } BitmapHeader;

typedef BitmapHeader * pBitmapHeader;

/* HACK! */
#define BitmapParms ExtBMParms

/**********************************************************************/
/* Type definitions for the DC Instance Data and the Device Driver's  */
/* view of DC.                                                        */
/**********************************************************************/
/**********************************************************************/
/* define the number of clip rectangles cached in the dc              */
/**********************************************************************/
#define CACHED_CLIPS 4
/**********************************************************************/
/* Define the constant that will always be the first word in a DC     */
/* structure. This allows us to reject a DC pointer if the word that  */
/* it points to does not contain DC_IDENTIFIER.                       */
/**********************************************************************/
#define DC_IDENTIFIER 0xDC

/**********************************************************************/
/* New type, common to PM and AVIO fonts                              */
/**********************************************************************/
typedef struct _fontdetails { /* fd */
    PFOCAFONT       pFocaFont;
    USHORT          usCachedFontIndex;
    USHORT          usCodePage;
    PUSHORT         pCodePageVector;
    USHORT          usFontID;
} FONTDETAILS;

typedef FONTDETAILS * PFONTDETAILS;

typedef struct _avioinfo { /* avi */
    PVOID   pfciTable[4];              /* from AVIOParms !!!!         */
    BYTE    bCellWidth;
    BYTE    bCellHeight;
    SHORT   sXoffset;
    SHORT   sYoffset;
} AVIOINFO;

typedef AVIOINFO * PAVIOINFO;

typedef struct _DC { /* dc */
    USHORT          DCIIdentifier;     /* Contains DC_IDENTIFIER      */
    ULONG           DCIDCType;         /* DC type 0 -> 8              */
    HDC             DCIhdc;            /* DC handle                   */

    struct _DC *    DCINextEntry;      /* next instance               */
    LONG            DCISaveCount;      /* number of saved DC states   */

    pBitmapHeader   DCISelListEntry;   /* selected bitmap list entry  */
    USHORT          DCIBitmapType;     /* current bitmap type         */

    DevPoint        DCICurrPosAI;      /* current position - AI       */

    DCHARBUNDLE     DCICurTxtAts;      /* Current Text Attrs Bundle   */
    DLINEBUNDLE     DCICurLinAts;      /* Current Line Attrs Bundle   */
    DAREABUNDLE     DCICurPtnAts;      /* Current Pattern Attrs Bundle*/
    DIMAGEBUNDLE    DCICurImgAts;      /* Current Image Attrs Bundle  */
    DMARKERBUNDLE   DCICurMrkAts;      /* Current Marker Attrs Bundle */

    USHORT          DCILinePatCnt;     /* Current line pattern count  */
    USHORT          DCILineTypMask;    /* Mask used for line types    */

    DevPoint        DCIPatternOrigin;  /* pattern origin - AI         */

    pBitmapHeader   DCIMarker;         /* pointer to marker defn      */
    BOOL            DCIMarkerSimReq;   /* on if simulation required   */

    pRealizedFontType DCIRealizedFonts;/* Font Table array.           */
    USHORT          DCIFontTabNum;     /* Number of Font Table entries*/
    BOOL            DCIPairKerning;    /* Enabled\Disabled state      */

    ULONG           DCICodePage;       /* currently selected codepage */

    BOOL            DCITextSim;        /* set if text simulation req. */

    DevPoint        DCIOrigin;         /* current DC origin           */

    PCOLORTABLE     DCIColorTable;     /* pointer to color table      */
    BOOL            DCIBackgndDefined; /* status of CLR_BACKGROUND    */
    BOOL            DCINeutralDefined; /* status of CLR_NEUTRAL       */
    USHORT          DCIColTabSize;     /* color table size            */
    USHORT          DCIColFormat;      /* format of color table       */
    USHORT          DCIColStatus;      /* status of color table       */
    USHORT          DCILowIndex;       /* lowest index in table       */
    USHORT          DCIHighIndex;      /* highest index in table      */
    USHORT          DCISysColState;    /* Latest state of sys colors  */


    COLORPAIR       DCILineColatts;    /* Line color indices          */
    COLORPAIR       DCIPattColatts;    /* Pattern colors indices      */
    COLORPAIR       DCICharColatts;    /* Character colors indices    */
    COLORPAIR       DCIImagColatts;    /* Image colors indices        */
    COLORPAIR       DCIMarkColatts;    /* Marker colors indices       */

    ClipRectangle   DCIClipRects[CACHED_CLIPS];
                                       /* Clip Rectangles             */
    BOOL            ClipChanged;       /*                             */
    USHORT          DCIClipOrder;      /* Order of clip rects         */
    USHORT          DCIClipNum;        /* Number of Clip Rectangles   */
    DevRect         DCIBoundingClip;   /* current screen/bitmap area  */
    USHORT          DCIEngineClips;    /* Clip regions in engine      */
    BOOL            DCIIsDirty;        /* Indicates when clip regions */
                                       /* are invalid                 */

    WcsRect         DCIGPIBounds;      /* current GPI bounds          */
    BOOL            DCIDefGPIBounds;   /* on if GPI bounds are dflt   */
    DevRect         DCIUserBounds;     /* current User bounds         */
    BOOL            DCIDefUserBounds;  /* on if User bounds are dflt  */

    SHORT           DCIConvFactor;     /* for device - AI conversion  */

    BOOL            DCICorrInvalid;    /* Correlation rects invalid   */
    WcsRect         DCIPickWindowPage; /* Pick window in Page coords  */
    DevRect         DCIPickWindowDevice;
                                       /* Pick window in Device coords*/
    DevRect *       DCICorrRects;      /* current correlation rects   */
    USHORT          DCICorrNum;        /* number of corr rectangles   */
    USHORT          DCICorrSize;       /* number of corr rectangles   */
                                       /* that storage has been       */
                                       /* allocated for               */

    XFORM           DCITransform;      /* Transformation data         */

    FONTDETAILS     DCIAvioFonts[CNT_LOADABLE_LCIDS + 1];
                                       /* AVIO loadable font dfns     */

    USHORT          DCIChanged;        /* shows non-default bundles   */

    pAICharDef      DCIAICharDefAddr;  /* AI character definition add */
    pAICharDef      DCIBaseCharDefAddr;/* AI char def for default font*/
    USHORT          DCISpacingType;    /* spacing type of current font*/
    BOOL            DCIXFrmSimple;     /* transform type              */
    ULONG           StyleNumber;       /* line style state & mask     */

    USHORT          DCICommandMask;    /* Used to mask Command bits   */

    POINTL          DCICurrPosWorld;   /* Current world position      */
    pBitmapHeader   TempPattern;       /* temp pattern for direct DD  */
    AVIOINFO        DCIAvioInfo;       /* avioparms stuff             */
    FONTDETAILS     CurrentFont;       /* the PM format current font  */
    PDEVPAL         Palette;           /* handle/pointer of palette   */
    PRGB2           DCIDeviceDefaultPalette;
                                       /* device default palette which*/
                                       /* was current last time color */
                                       /* table indexs were calculated*/

    ULONG           Dummy1;            /* these are here to allow new */
    ULONG           Dummy2;            /* fields without rebuilding   */
    } DC;

typedef DC * PDC;

/**********************************************************************/
/* work space for drawing functions, only valid while AI sema4 held   */
/**********************************************************************/
typedef VOID (PASCAL *pVF)();
typedef BOOL (PASCAL *pBF)();
typedef struct _AIWORK { /* aiw */
        pVF     PerClipFunc;
        pBF     PerSegFunc;
        USHORT  Flags;
        USHORT  SubBMHeight;
        BYTE    User[16];
        DevRect Bound;
    } AIWORK;


/**********************************************************************/
/* structures to pass to the AI for locking and unlocking             */
/**********************************************************************/
#ifndef   _8514
typedef struct _LockDataStruct { /* lds */
    USHORT  Count;
    ULONG   Address[1];
} LockDataStruct;

typedef struct _UnLockDataStruct { /* uds */
    USHORT  Count;
    ULONG   Handle[1];
} UnlockDataStruct;

typedef struct _PMDevParmsStruct { /* pmdp */
    ULONG  VRAMBase;
    ULONG  pXGARegs;
    USHORT IOBase;
} PMDevParmsStruct;

typedef PMDevParmsStruct * pPMDevParmsStruct;
#endif

/**********************************************************************/
/* Type definition for FontCacheInfo                                  */
/**********************************************************************/
#define MAX_NUM_CODEPOINTS 256

typedef struct _FONTCACHEINFO { /* fci */
        FOCAMETRICS     fmFontMetrics;
        USHORT          usHashMetrics;
        USHORT          usUsageCount;
        USHORT          usFontID;
        USHORT          usCodePage;
        ULONG           aulCachedCharOffset[MAX_NUM_CODEPOINTS];
#ifdef FULL_ADDRESS
        PVOID           apCharDef[MAX_NUM_CODEPOINTS];
#else /* ndef FULL_ADDRESS */
        USHORT          apCharDef[MAX_NUM_CODEPOINTS];
#endif /* ndef FULL_ADDRESS */

/**********************************************************************/
/* Defect 75206. 800x600x16bit in 1 MB VRAM doesn't leave enough room */
/* to cache large AVio fonts in one plane.  So, for this resolution,  */
/* we reduce the number of cached fonts to 8 and allow them to wrap   */
/* (once) to plane index + 8. For each character, ausPlaneOffset is   */
/* set to:                                                            */
/*              0 - in plane 0 through 7                              */
/*              1 - in plane 8 through 15                             */
/*             -1 - not in 16 bit color, ignore                       */
/**********************************************************************/
#ifdef  _8514
        USHORT          ausPlaneOffset[MAX_NUM_CODEPOINTS];
#endif
    } FONTCACHEINFO;

typedef FONTCACHEINFO * PFONTCACHEINFO;

/**********************************************************************/
/* This definition of MAX_NUM_CACHED_FONTS will use as many fonts     */
/* as we can fit into a complete segment. However, this is a bit      */
/* greedy (to use 64K for cache information), so we will currently    */
/* use a fixed (lower) constant.                                      */
/**********************************************************************/
//#define MAX_NUM_CACHED_FONTS (65536 / sizeof(FONTCACHEINFO))
#ifdef _8514
    #define MAX_NUM_CACHED_FONTS 8
#else
    #define MAX_NUM_CACHED_FONTS 10
#endif

typedef struct CharSetDef AIFONT;
typedef AIFONT * PAIFONT;

typedef union _INTFONT { /* if */
        FOCAFONT       FocaFont;
        AIFONT         AIFont;
    } INTFONT;
typedef INTFONT * PINTFONT;

/*** To be moved to PMDEV.H in the future ***/

      /* DevEscape codes for Software Motion Video support */
      #define DEVESC_GETAPERTURE          33000L
      #define DEVESC_ACQUIREFB            33010L
      #define DEVESC_DEACQUIREFB          33020L
      #define DEVESC_SWITCHBANK           33030L
#ifdef ENDIVE
      #define DEVESC_REGISTER             34000L
      #define DEVESC_HWREQUEST            34010L
      #define DEVESC_VRAMALLOC            34020L
      #define DEVESC_EXTPUT               34030L
      #define DEVESC_EXTGET               34040L
      #define DEVESC_EXTQUERY             34050L
      #define DEVESC_QUERYFB              34060L
#endif

      /* structure for DEVESC_GETAPERTURE */
      typedef struct _APERTURE {  /* aperture */
         ULONG ulPhysAddr;
         ULONG ulApertureSize;
         ULONG ulScanLineSize;
         RECTL rctlScreen;
      } APERTURE;
      typedef APERTURE *PAPERTURE;

      /* structure for DEVESC_ACQUIREFB */
      typedef struct _ACQUIREFB {  /* acquirefb */
         ULONG fAFBFlags;
         ULONG ulBankNumber;
         RECTL rctlXRegion;
      } ACQUIREFB;
      typedef ACQUIREFB *PACQUIREFB;

      /************************************/
      /* Bit definitions for fAFBFlags    */
      /************************************/
      #define AFB_SWITCH 1

      /* structure for DEVESC_SWITCHBANK */
      typedef struct _SWITCHBANK {  /* switchbank */
         ULONG ulBankNum;
      } SWITCHBANK;
      typedef SWITCHBANK *PSWITCHBANK;

/*** end of PMDEV.H changes ***/

