/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDTEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     Text routines                                  */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


DSPENTRY eddt_CharStringPos (HDC        hdc,
                             PPOINTL    ArgStart,
                             PPOINTL    ArgOpaqRect,
                             ULONG      ArgOptions,
                             ULONG      ArgCharnum,
                             PCHAR      ArgCodePoints,
                             PULONG     ArgPosVector,
                             PCSP_INFO  ArgAttrs,
                             PDC        pdcArg,
                             ULONG      FunN);

DSPENTRY eddt_CharString (HDC       hdc,
                          ULONG     ArgCharnum,
                          PCHAR     ArgCodePoints,
                          PDC       pdcArg,
                          ULONG     FunN);

DSPENTRY eddt_QueryTextBox (HDC           hdc,
                            ULONG         ArgCharnum,
                            PCHAR         ArgCodePoints,
                            ULONG         ArgCount,
                            pWcsRect      ArgTextBox,
                            PDC           pdcArg,
                            ULONG         FunN);

DSPENTRY eddt_QueryCharPositions (HDC           hdc,
                                  PPOINTL       ArgStartXY,
                                  ULONG         ArgOptions,
                                  ULONG         ArgCharnum,
                                  PCHAR         ArgCodePoints,
                                  PLONG         ArgPosVector,
                                  PLONG         ArgXY,
                                  PDC           pdcArg,
                                  ULONG         FunN);

DSPENTRY eddt_QueryWidthTable(HDC       hdc,
                              ULONG     ArgFirstChar,
                              ULONG     ArgCount,
                              PULONG    ArgWidthTable,
                              PDC       pdcArg,
                              ULONG     FunN);

USHORT PASCAL FAR eddt_LocateFont (VOID);

VOID PASCAL NEAR eddt_GetTextBox (USHORT        Charnum,
                                  PUCHAR        CodePoints,
                                  SHORT *       Vector,
                                  PDC           pdcBox);

pCharSetDef PASCAL eddt_LoadFont (PSZ   FileName);

VOID PASCAL eddt_Interpolate(PBYTE      pXLateTable);

USHORT PASCAL NEAR eddt_ConvertIncVector(SHORT * DevVector,
                                         USHORT  NumVec,
                                         PLONG   WldVector);

USHORT PASCAL FAR eddt_InitialiseCacheInfo (VOID);

VOID PASCAL FAR  eddt_LocateCachedFont ( PFONTDETAILS pFontDetails );

VOID PASCAL FAR eddt_InvalidateCache (VOID);

USHORT PASCAL FAR eddt_CacheCharacter( CHAR chArgCodePoint,
                                       PFONTDETAILS pFontDetails );

VOID PASCAL FAR eddt_TidyUpAfterCaching(VOID);

ULONG cdecl eddh_update_cache( PCHAR          pCodePoints,
                         ULONG          ulCharNum,
                         PFONTCACHEINFO pFontCacheInfo,
                         PFONTDETAILS   pFontDetails,
                         PUSHORT        pStringWidth );

VOID PASCAL FAR eddt_FreeCachedFont ( USHORT usFontID,
                                      USHORT usCachedFontIndex );

USHORT GetBackgroundMix(USHORT usBackMix);
