/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module          = EDDTESUB                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function handlers  */
/*                     subroutines for Fonts                          */
/*                                                                    */
/*   Function        = LocateFont()                                   */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/*                                                                    */
/* include Display Device Driver constants                            */
/* include Display Device Driver return codes                         */
/* include Display Device Driver types                                */
/* include Display Device Driver trace                                */
/*                                                                    */
/**********************************************************************/


#define INCL_DDIFONTSTRUCS
#define INCL_DDIMISC
#define INCL_GRE_FONTS

#include <eddinclt.h>
#include <edddtypt.h>
#include <eddttypt.h>
#include <eddtextf.h>
#include <eddacone.h>
#include <eddtcone.h>

extern DDTType          DDT;
extern PVOID            pDefaultFont;

extern USHORT              usVersion;

/**********************************************************************/
/* Locate whether current font is a FOCAFONT or an AI font and set up */
/* value and pointers in the DC instance data appropriately.          */
/**********************************************************************/

USHORT eddt_LocateFont (VOID)

{
#define TFUNC "eddt_LocateFont"

    /******************************************************************/
    /* Local variables.                                               */
    /******************************************************************/
    USHORT                      usCodepage;
    PFOCAFONT                   pFocaFont;
    PFOCAFONT                   pFontInfo;
    PAIFONT                     pAIFont;
    USHORT                      usTableIndex;

    /******************************************************************/
    /* This is a standard FOCAFONT. (We do not support AA fonts now). */
    /******************************************************************/

    /******************************************************************/
    /* See if the font is "our" default font.                         */
    /******************************************************************/
    if (pdc->DCICurTxtAts.cdef.defSet == 0)
    {
        /**************************************************************/
        /* This is the default font.  Set up a pointer to it.         */
        /**************************************************************/
        pFocaFont = (PFOCAFONT)pDefaultFont;
    }
    else
    {
        /**************************************************************/
        /* This is not the default font.  Take the pointer to the     */
        /* font from the current text attributes.                     */
        /**************************************************************/
        pFocaFont = (PFOCAFONT)pdc->DCICurTxtAts.cdef.defSet;
    }

    /******************************************************************/
    /* See if the font is a default font (ie. LCID value of zero).    */
    /******************************************************************/
    if (pdc->DCICurTxtAts.cbnd.usSet == 0)
    {
        /**************************************************************/
        /* Take the codepage from the DC instance data.               */
        /**************************************************************/
        usCodepage = (USHORT)pdc->DCICodePage;
    }
    else
    {
        /**************************************************************/
        /* Take the codepage from the attribute bundle.               */
        /**************************************************************/
        usCodepage = pdc->DCICurTxtAts.cdef.CodePage;
    }

    pdc->CurrentFont.pFocaFont = pFocaFont;

    /******************************************************************/
    /* Now try to get a codepage vector for the necessary codepage.   */
    /* we can only get a codepage mapping vector (which maps into     */
    /* codepage 850 if the font is actually designed to codepage 850) */
    /******************************************************************/
    if ( usCodepage &&
         pFocaFont->fmMetrics.usCodePage == 850 )
    {
        /**************************************************************/
        /* The codepage is non-zero, so we need a vector.             */
        /**************************************************************/
        if (pdc->CurrentFont.usCodePage != usCodepage)
        {
            /**********************************************************/
            /* Call the engine to get a pointer to the vector.        */
            /**********************************************************/
            pdc->CurrentFont.pCodePageVector =
                      (PUSHORT)(GreQueryCodePageVector(usCodepage));
            if (pdc->CurrentFont.pCodePageVector == GPI_ERROR)
            {
                DebugOutput("GreQueryCodePageVector failed\n\r");
                return (ERROR_ZERO);
            }
        }
    }
    else
    {
        /**************************************************************/
        /* The codepage is zero so we don't need a codepage vector.   */
        /**************************************************************/
        pdc->CurrentFont.pCodePageVector = FNULL;
    }
    pdc->CurrentFont.usCodePage = usCodepage;

    /******************************************************************/
    /* Store the spacing type.                                        */
    /******************************************************************/
    if ( pFocaFont->fdDefinitions.fsFontdef == FONTDEFFONT1)
    {
        pdc->DCISpacingType = FIXED_PITCH;
    }
    else if (pFocaFont->fdDefinitions.fsChardef == FONTDEFCHAR3)
    {
        pdc->DCISpacingType = A_B_C_SPACED;
    }
    else
    {
        pdc->DCISpacingType = PROPORTIONAL_SPACED;
    }

    /******************************************************************/
    /* The test on version number means we DO locate fonts which only */
    /* contain one character at 1.3+.  This is because we may be      */
    /* passed IFI fonts that only have one character.                 */
    /******************************************************************/
//  if ( (usVersion >= 0x0A1E) ||
    if (pdc->CurrentFont.pFocaFont->fmMetrics.usLastChar > 0)
    {
        eddt_LocateCachedFont( &pdc->CurrentFont );
    }
    return(OK);
}
#undef TFUNC
