/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDMDEAD                                       */
/*                                                                    */
/*   Description     = Display Device Driver functions                */
/*                     Death and Resurrection                         */
/*                                                                    */
/*   Function        = Death announces a screen group switch from the */
/*                     driver.                                        */
/*                     Resurrection announces a screen group switch   */
/*                     back into the driver.                          */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/* CHANGE ACTIVITY =                                                  */
/*   DATE      FLAG        APAR   CHANGE DESCRIPTION                  */
/*   --------  ----------  -----  ------------------------------------*/
/*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx                             */
/*   04/03/93              ?????  Added new function to give VVideo   */
/*                                access to VGA memory.               */
/*   04/04/93              65649  Invalidate seamless cache when      */
/*                                returning from full-screen session. */
/**********************************************************************/
#define INCL_DDIMISC
#define INCL_DOSDEVICES
#define INCL_DOSMVDM
#include <eddinclt.h>

#include <edddtypt.h>
#include <eddetypt.h>

#include <eddcextf.h>
#include <eddtextf.h>
#include <eddgextf.h>
#include <eddmextf.h>
#include <eddeextf.h>

#include <eddhcone.h>
#include <eddhmacr.h>

#include <eddfcone.h>
#include <eddftype.h>

#include <hwaccess.h>
#include <seamless.h>

#ifdef VRAMPTR
#include <eddncach.h>
#endif /* VRAMPTR */

#ifdef VVGA
#include "vvga.h"
#endif /* VVGA */

#ifdef ENDIVE
#include "vramman.h"
#endif

#ifdef _8514
  #include <8514.h>
  #define INCL_NONE
  #define INCL_VIDEOHW
  #define INCL_VIDEOSYSREQ
  #include <vvd.h>

  extern  VVDRQ  vvdrq;
  extern  PVOID  pWindowsSharedData;

  extern  BOOL        SwitchToVGAMode(VOID);
  extern  BOOL PASCAL SwitchToExtendedGraphicsMode(VOID);
#endif

#ifdef S3
  extern  BOOL PASCAL fNeedExtraModeSwitch;
#endif


extern DDTType         DDT;

extern RGB2             HWPalette[HW_PAL_SIZE];
extern RGB2             RealizedLCTPalette[HW_PAL_SIZE];
extern USHORT           SizeOfHWPalette;
extern USHORT           VioSetModeRes;

extern SHORT            softDrawInUse;
extern SHORT            useSD;
extern ULONG            saveAddresses[];
extern ULONG            LinePatternPhys;
extern ULONG            MarkerPhys;

extern PBYTE            pSysCacheStart;
extern ULONG            pSysCacheStartPhy;
extern ULONG            pVRAMCacheStart;
extern ULONG            pCurCacheBasePhy;
extern ULONG            charCacheLength;


extern ULONG            offNextFree11Pos;
extern ULONG            offLastFree81Pos;

#ifndef   _8514
extern MMReg            ShadowXGARegs;
extern pMMReg           pRealXGARegs;
extern pMMReg           pXGARegs;
#else
extern MM8514Reg        Shadow8514Regs;
extern pMM8514Reg       p8514Regs;
extern PFONTCACHEINFO   pFontCacheInfo;
#endif

extern drawFunctionsTable   softDrawTable;
extern drawFunctionsTable   hardDrawTable;
extern pDrawFunctionsTable  pDrawFunctions;

#ifdef SDBM20
extern ULONG                LinePatternCur;
extern ULONG                LinePatternSys;
extern ULONG                MarkerCur;
extern ULONG                MarkerSys;
extern SHORT                foregroundSession;
#endif /* SDBM20 */

extern BOOL                 fXgaDead;
extern HDC                  ColorTableRealized;
extern BOOL                 fRealizeSupported;

#ifdef SEAMLESS
extern ULONG                fSeamlessActive;
extern ULONG                fSeamlessCCConflict;
#endif

extern BOOL           fVVGA;

#ifdef _8514

#ifdef ENDIVE
BOOL fFlag;
#endif

/**********************************************************************/
/* Notify the VVideo driver whether or not it can access VGA memory   */
/* This entire function was added under                               */
/**********************************************************************/

VOID Notify_VDD( BOOL fAllowAccess )
{
    HVDD    hVideoVDD;

    if (fAllowAccess == TRUE)
    {
        vvdrq.vvd_pPhysVRAM    = (PBYTE)EGAVGAMEM_START;  /* Start of VRAM = 0xA0000 */
        vvdrq.vvd_nbReserved   = 1L;   /* No. of VRAM bytes we use */
    }
    else
    {
        vvdrq.vvd_pPhysVRAM    = (PBYTE) NULL;
        vvdrq.vvd_nbReserved   = -1L;   /* No. of VRAM bytes we use */
    }

    if ( DosOpenVDD( VVD_NAME1, &hVideoVDD) == 0)
    {
        DosRequestVDD( hVideoVDD,
                       0,                   /* sgId     */
                       VVDSYSREQ_SETDRQ,
                       sizeof(VVDRQ),       /* cbInput  */
                       &vvdrq,              /* pInput   */
                       0L,                  /* cbOutput */
                       0L );                /* pOutput  */

       DosCloseVDD( hVideoVDD );
    }
}

#endif /* _8514 */

/**********************************************************************/
/* Death announces a screen group switch from the driver. All further */
/* use of the XGA hardware is prohibited.                             */
/**********************************************************************/

DSPENTRY eddm_Death (HDC        hdc,
                     PDC        pdcArg,
                     ULONG      FunN)

{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD);


#ifdef  VVGA
    /******************************************************************/
    /* If VGA Virtualisation is in operation then shut it down        */
    /******************************************************************/
    if (fVVGA)
    {
         StopVirtualVGA();
         DeactivatePlanarVGA();
    }
#endif  /* VVGA */

#ifdef _8514
#ifndef   S3
    /******************************************************************/
    /* If VGA Virtualisation is in operation then shut it down        */
    /******************************************************************/
    Notify_VDD( FALSE );                           /*            */
#endif
#endif

#ifdef ENDIVE
    fFlag = TRUE;
    HWCallIOPL(ENDIVEDeath, (PVOID)&fFlag, (PVOID)NULL);
#endif

#ifdef SEAMLESS
    /******************************************************************/
    /* Disable any seamless Window VDM device drivers.                */
    /******************************************************************/
    SeamlessDeath();
#endif /* SEAMLESS */

    /******************************************************************/
    /* Don't do this for S3.  It cooks European monitors like crazy.  */
    /* Oops!  Lacuna machines DO NEED THIS!  The PMI file will tell   */
    /* us if we're configured for a lacuna.                           */
    /******************************************************************/
#ifdef S3
    if (fNeedExtraModeSwitch)
#endif
    {
        if ( !SwitchToVGAMode() )
        {
           /* Defect 55864. Release semaphore before returning */
           ExitDriver(pdcArg, FunN, EDF_STANDARD);
           return(FALSE);
        }
    }


    /******************************************************************/
    /* Change the flag                                                */
    /******************************************************************/

#ifdef SDBM20
    foregroundSession = FALSE;
#else /* SDBM20 */
    softDrawInUse = TRUE;
#endif /* SDBM20 */

    /******************************************************************/
    /* Change pointer to draw functions index table                   */
    /******************************************************************/
    pDrawFunctions = (pDrawFunctionsTable)softDrawTable;

    /******************************************************************/
    /* Change the XGA register pointer to point to the shadow copy    */
    /* of the memory mapped registers.                                */
    /******************************************************************/
#ifndef   _8514
    pXGARegs = (pMMReg)&ShadowXGARegs;

    /******************************************************************/
    /* Need this to be zero for our MESSDoPlotStep                    */
    /******************************************************************/
    ShadowXGARegs.bFifthStep = 0;

#endif

    MarkerCur = MarkerSys;
    LinePatternCur = LinePatternSys;

    /******************************************************************/
    /* Set flag to indicate that we are dead                          */
    /******************************************************************/
    fXgaDead = TRUE;

    /******************************************************************/
    /* Make sure that we only use the system memory character cache.  */
    /******************************************************************/
    pCurCacheBasePhy = pSysCacheStartPhy;

#ifdef VRAMPTR
    /******************************************************************/
    /* Mark the bitmap cache inactive.                                */
    /******************************************************************/
    shutdown_bm_cache();
#endif /* VRAMPTR */

#ifdef S3
    if (DDT.fScreenFlags & USE_8BIT_DAC)
    {
        UCHAR  regvalue;

        if (DDT.fScreenFlags & USE_BROOKDAC)
        {
            outp( 0x3d4, 0x55 );
            outp( 0x3d5, (( inp( 0x3d5 ) & 0xFC ) | 1 ));
            outp( 0x3c6,  ( inp( 0x3c6 ) & 0xFD ));
            outp( 0x3d5,  ( inp( 0x3d5 ) & 0xFC ));
        }
        else if (DDT.fScreenFlags & USE_ATTDAC)
             {
                 inp( 0x3c8 );
                 inp( 0x3c6 );
                 inp( 0x3c6 );
                 inp( 0x3c6 );
                 inp( 0x3c6 );

                 regvalue = (UCHAR)inp( 0x3c6 );
                 regvalue &= 0xFD;

                 inp( 0x3c8 );
                 inp( 0x3c6 );
                 inp( 0x3c6 );
                 inp( 0x3c6 );
                 inp( 0x3c6 );

                 outp( 0x3c6, regvalue );
             }
    }
#endif

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
    return(OK);

} /* eddm_Death */






/**********************************************************************/
/* Resurrection announces a screen group switch back into the driver. */
/**********************************************************************/

DSPENTRY eddm_Resurrection (HDC         hdc,
                            ULONG       UnDocumented1,
                            ULONG       UnDocumented2,
                            PDC         pdcArg,
                            ULONG       FunN)

{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(UnDocumented1);
    IgnoreParam(UnDocumented2);

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD);

    if ( !SwitchToExtendedGraphicsMode() )
    {
       /* Defect 55864. Release semaphore before returning */
       ExitDriver(pdcArg, FunN, EDF_STANDARD);
       return(0);
    }

#ifdef SEAMLESS
    /******************************************************************/
    /* Enable any seamless Window VDM device drivers.                 */
    /******************************************************************/
    SeamlessResurection();

#ifdef ENDIVE
    fFlag = FALSE;
    HWCallIOPL(ENDIVEDeath, (PVOID)&fFlag, (PVOID)NULL);
#endif

#ifdef  S3
    // @DMS rewrite in C !!!
    _asm
    {
       push     ax
       push     dx

       mov      dx,03D4h
       mov      al,058h
       out      dx,al
       inc      dx
       in       al,dx
       and      al,0EFh
       out      dx,al

       pop      dx
       pop      ax
    }
#endif /* S3 */
#endif /* SEAMLESS */

    /******************************************************************/
    /* Change the flag                                                */
    /******************************************************************/
    foregroundSession = TRUE;

    /******************************************************************/
    /* restore the last palette we loaded                             */
    /******************************************************************/
    #ifdef   BPP24
    if ( (DDT.BitCount == 16) || (DDT.BitCount == 24) )
    #else
    if ( DDT.BitCount == 16 )
    #endif
    {
#ifdef MATROX
        if (RunningOnXGA())
        {
#endif /* MATROX */
            /**********************************************************/
            /* Load the values required for 16bpp in the XGA palette. */
            /**********************************************************/
            #ifndef   _8514
            LoadDirectPalette();
            #else
            #ifndef   CNT481
            // bvh does all the work for s3
            Load8514DirectPalette();
            #endif
            #endif
#ifdef MATROX
        }
#endif /* MATROX */
    }
    else
    {
        /**************************************************************/
        /* We are running 4 or 8 bpp and have a true palette.         */
        /**************************************************************/
        if (ColorTableRealized)
        {
            /**********************************************************/
            /* We have a realized LCT to restore.                     */
            /**********************************************************/
            #ifndef _8514
            LoadPaletteEntries(0,
            #else
            Load8514PaletteEntries(0,
            #endif
                                   SizeOfHWPalette,
                                   RealizedLCTPalette);
        }
        else
        {
            /**********************************************************/
            /* We have the palette thet palette manager uses.         */
            /**********************************************************/
            #ifndef _8514
            LoadPaletteEntries(0,
            #else
            Load8514PaletteEntries(0,
            #endif
                                   SizeOfHWPalette,
                                   HWPalette);
        }
    }


    /******************************************************************/
    /* Change pointer to draw functions index table                   */
    /******************************************************************/
    pDrawFunctions = (pDrawFunctionsTable)hardDrawTable;

    /******************************************************************/
    /* Change the XGA register pointer to point to the real XGA       */
    /* hardware registers.                                            */
    /******************************************************************/
    #ifndef   _8514
    pXGARegs = pRealXGARegs;
    #else
    p8514Regs = &Shadow8514Regs;
    #endif

    MarkerCur = MarkerPhys;
    LinePatternCur = LinePatternPhys;


#ifndef _8514
    /******************************************************************/
    /* If the VRAM cache address is the same as the system memory     */
    /* cache address then there was insufficient off-screen VRAM to   */
    /* make a text cache in VRAM. If no VRAM cache, don't try to copy */
    /* to it.                                                         */
    /******************************************************************/
    if ( pVRAMCacheStart != pSysCacheStartPhy )
    {

#ifdef SEAMLESS
    /******************************************************************/
    /* We only use the VRAM character cache if there are no seamless  */
    /*         VDMs running or there is no VRAM conflict with the     */
    /*         driver.                                                */
    /******************************************************************/
    if (!(fSeamlessActive && fSeamlessCCConflict))
    {
        CopyCCToVRAM();
        pCurCacheBasePhy = pVRAMCacheStart;
    }

#else
    /******************************************************************/
    /* Copy the character cache from system memory to VRAM.           */
    /******************************************************************/
    CopyCCToVRAM();
    pCurCacheBasePhy = pVRAMCacheStart;

#endif /* ifdef SEAMLESS else */
    }
#endif /* ifndef _8514 */

#ifdef _8514

    /******************************************************************/
    /* Invalidate cache entries to all free                           */
    /******************************************************************/
    eddt_InvalidateCache();

    /******************************************************************/
    /* Same for the seamless cache, if we're coming back from a       */
    /* full-screen session, all bets are off.                         */
    /******************************************************************/
    memset(pWindowsSharedData, 0, WINDOWS_PRIVATE_AREA_SIZE);
#endif

    /******************************************************************/
    /* Restore our VRAM patterns, markers, etc.                       */
    /******************************************************************/
    InitialiseVRAM();

    /******************************************************************/
    /* Clear flag indicating that we are dead.                        */
    /******************************************************************/
    fXgaDead = FALSE;

#ifdef VVGA
    /******************************************************************/
    /* If VGA Virtualisation is in operation then restart it.         */
    /******************************************************************/
    if (fVVGA)
    {
         ActivatePlanarVGA();
         StartVirtualVGA();
    }
#endif /* VVGA */

#ifdef _8514
#ifndef   S3
    /******************************************************************/
    /* If VGA Virtualisation is in operation then restart it.         */
    /******************************************************************/
    Notify_VDD( TRUE );                            /*            */
#endif
#endif

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD);

    /******************************************************************/
    /* We have now successfully risen from the dead. We return the    */
    /* value 2 to the engine, which asks it to redraw the screen.     */
    /******************************************************************/
    return(2);

} /* eddm_Resurrection */


#ifndef _8514

/**********************************************************************/
/* This function copies the character cache from system memory to     */
/* VRAM.  NEEDED FOR XGA ONLY!                                        */
/**********************************************************************/
VOID CopyCCToVRAM(VOID)
{
    /******************************************************************/
    /* Local Variables.                                               */
    /******************************************************************/
    SHORT   BltHeight;
    ULONG   strayOffset;

    /******************************************************************/
    /* Now blt the character cache from system memory to VRAM         */
    /* Because the amount of data here may be quite big we need to do */
    /* it as a rectangle.  We will copy the 1,1 chunk (rounded up to  */
    /* the next 256 bytes) and then copy the 8,1 chunk exactly (this  */
    /* will usually require two blts).  The exact copy of the 8,1     */
    /* data may overwrite some of the data copied in the first        */
    /* (approximate) copy if the cache is nearly full - this is       */
    /* correct as the 1,1 copy will reverse the bit order and we      */
    /* need the 8,1 data to be in the same bit order.                 */
    /******************************************************************/

    /******************************************************************/
    /* Set the drawing mode so that we do not try to do any blts      */
    /* using software.                                                */
    /******************************************************************/
    softDrawInUse = FALSE;

    /******************************************************************/
    /* Set up the hardware mixes.                                     */
    /******************************************************************/
    ShadowXGARegs.FgMix = HWMIX_SOURCE;
    ShadowXGARegs.BgMix = HWMIX_SOURCE;
    ShadowXGARegs.ColCompCond = COLCOMP_ALWAYS;


    /******************************************************************/
    /* Work out how many chunks of 256 bytes we have (rounded up)     */
    /* NB this assumes that the cache is always a multiple of 256     */
    /* bytes long.                                                    */
    /******************************************************************/
    BltHeight = (USHORT)(((offNextFree11Pos + 255) / 256) - 1);
#define BLTWIDTH 256*8-1

    if (BltHeight >= 0)
    {
        /******************************************************************/
        /* Set up source pixmap details.                                  */
        /******************************************************************/
        ShadowXGARegs.PixMapBaseB   = pSysCacheStartPhy;
        ShadowXGARegs.PixMapWidthB  = BLTWIDTH;
        ShadowXGARegs.PixMapHeightB = BltHeight;
        ShadowXGARegs.PixMapFormatB = ONE_BPP | MOTOROLA;

        /******************************************************************/
        /* Set up destination pixmap details.                             */
        /******************************************************************/
        ShadowXGARegs.PixMapBaseA   = pVRAMCacheStart;
        ShadowXGARegs.PixMapWidthA  = BLTWIDTH;
        ShadowXGARegs.PixMapHeightA = BltHeight;
        ShadowXGARegs.PixMapFormatA = ONE_BPP;

        ShadowXGARegs.SrcXAddr =
         ShadowXGARegs.SrcYAddr =
          ShadowXGARegs.DstXAddr =
           ShadowXGARegs.DstYAddr = 0;

        ShadowXGARegs.OpDim1 = BLTWIDTH;
        ShadowXGARegs.OpDim2 = BltHeight;

        /******************************************************************/
        /* Set the pixel op up ready to do the blt.                       */
        /******************************************************************/
        ShadowXGARegs.PixOp = BACK_SRC_SRC_PIX_MAP |
                              FORE_SRC_SRC_PIX_MAP |
                              STEP_PXBLT |
                              SRC_PIX_MAP_B |
                              DST_PIX_MAP_A |
                              PAT_PIX_MAP_FORE |
                              MASK_PIX_MAP_OFF |
                              DRAW_MODE_DONTCARE |
                              DIR_OCTANT_LRTB;

        /**************************************************************/
        /* Do the blt.                                                */
        /**************************************************************/
        TransferShadowRegisters( TSR_MAP_A |
                                 TSR_MAP_B |
                                 TSR_COLOUR_MIX |
                                 TSR_COORDINATES |
                                 TSR_PIXELOP );
    }

    /******************************************************************/
    /* Now do the first bit of the 8,1 data                           */
    /******************************************************************/

    /******************************************************************/
    /* Work out how many chunks of 256 bytes we have (rounded down)   */
    /******************************************************************/
    BltHeight = (SHORT)(((charCacheLength - offLastFree81Pos) / 256) - 1);
#undef BLTWIDTH
#define BLTWIDTH 256-1

    /******************************************************************/
    /* And keep this number for doing the left-overs                  */
    /******************************************************************/
    strayOffset = (BltHeight+1)*256;

    if (BltHeight >= 0)
    {
        /******************************************************************/
        /* Set up source pixmap details.                                  */
        /******************************************************************/
        ShadowXGARegs.PixMapBaseB   = pSysCacheStartPhy + offLastFree81Pos;
        ShadowXGARegs.PixMapWidthB  = BLTWIDTH;
        ShadowXGARegs.PixMapHeightB = BltHeight;
        ShadowXGARegs.PixMapFormatB = EIGHT_BPP;

        /******************************************************************/
        /* Set up destination pixmap details.                             */
        /******************************************************************/
        ShadowXGARegs.PixMapBaseA   = pVRAMCacheStart + offLastFree81Pos;
        ShadowXGARegs.PixMapWidthA  = BLTWIDTH;
        ShadowXGARegs.PixMapHeightA = BltHeight;
        ShadowXGARegs.PixMapFormatA = EIGHT_BPP;

        ShadowXGARegs.SrcXAddr =
         ShadowXGARegs.SrcYAddr =
          ShadowXGARegs.DstXAddr =
           ShadowXGARegs.DstYAddr = 0;

        ShadowXGARegs.OpDim1 = BLTWIDTH;
        ShadowXGARegs.OpDim2 = BltHeight;

        /******************************************************************/
        /* Set the pixel op read to do the blt.                           */
        /******************************************************************/
        ShadowXGARegs.PixOp = BACK_SRC_SRC_PIX_MAP |
                              FORE_SRC_SRC_PIX_MAP |
                              STEP_PXBLT |
                              SRC_PIX_MAP_B |
                              DST_PIX_MAP_A |
                              PAT_PIX_MAP_FORE |
                              MASK_PIX_MAP_OFF |
                              DRAW_MODE_DONTCARE |
                              DIR_OCTANT_LRTB;

        /**************************************************************/
        /* Do the blt.                                                */
        /**************************************************************/
        TransferShadowRegisters( TSR_MAP_A |
                                 TSR_MAP_B |
                                 TSR_COLOUR_MIX |
                                 TSR_COORDINATES |
                                 TSR_PIXELOP );
    }

    /******************************************************************/
    /* Now do the final bit of the 8,1 data                           */
    /******************************************************************/

    /******************************************************************/
    /* Work out how many bytes are left                               */
    /******************************************************************/
    BltHeight = (USHORT)(((charCacheLength - offLastFree81Pos) % 256) - 1);
    if (BltHeight >= 0)
    {
        /******************************************************************/
        /* Set up source pixmap details.                                  */
        /******************************************************************/
        ShadowXGARegs.PixMapBaseB   = pSysCacheStartPhy +
                                        offLastFree81Pos + strayOffset;
        ShadowXGARegs.PixMapWidthB  = BltHeight;
        ShadowXGARegs.PixMapHeightB = 0;
        ShadowXGARegs.PixMapFormatB = EIGHT_BPP;

        /******************************************************************/
        /* Set up destination pixmap details.                             */
        /******************************************************************/
        ShadowXGARegs.PixMapBaseA   = pVRAMCacheStart +
                                        offLastFree81Pos + strayOffset;
        ShadowXGARegs.PixMapWidthA  = BltHeight;
        ShadowXGARegs.PixMapHeightA = 0;
        ShadowXGARegs.PixMapFormatA = EIGHT_BPP;

        ShadowXGARegs.SrcXAddr =
         ShadowXGARegs.SrcYAddr =
          ShadowXGARegs.DstXAddr =
           ShadowXGARegs.DstYAddr = 0;

        ShadowXGARegs.OpDim1 = BltHeight;
        ShadowXGARegs.OpDim2 = 0;

        /******************************************************************/
        /* Set up the blt for the last  chunk of 8,1 data                 */
        /******************************************************************/
        ShadowXGARegs.PixOp = BACK_SRC_SRC_PIX_MAP |
                              FORE_SRC_SRC_PIX_MAP |
                              STEP_PXBLT |
                              SRC_PIX_MAP_B |
                              DST_PIX_MAP_A |
                              PAT_PIX_MAP_FORE |
                              MASK_PIX_MAP_OFF |
                              DRAW_MODE_DONTCARE |
                              DIR_OCTANT_LRTB;

        /**************************************************************/
        /* Do the blt.                                                */
        /**************************************************************/
        TransferShadowRegisters( TSR_MAP_A |
                                 TSR_MAP_B |
                                 TSR_COLOUR_MIX |
                                 TSR_COORDINATES |
                                 TSR_PIXELOP );
    }
}

#endif  /* ifndef _8514 */
