/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDMBITS                                       */
/*                                                                    */
/*   Function        = SaveScreenBits saves a rectangle of bits from  */
/*                     the screen.                                    */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#include <eddinclt.h>

#include <eddgextf.h>
#include <eddmextf.h>

/**********************************************************************/
/* We chose not to do anything here (an optimization which could be   */
/* made given sufficient VRAM is to save the rectangle in off screen  */
/* VRAM)                                                              */
/*                                                                    */
/* Instead we return FALSE to indicate we did not do the save.        */
/**********************************************************************/
DDIENTRY eddm_SaveScreenBits (HDC       hdc,
                              PRECTL    ArgRectangle,
                              PDC       pdcArg,
                              ULONG     FunN)
{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(ArgRectangle);

#ifdef FIREWALLS
    /******************************************************************/
    /* We still enter and exit driver so that we know this call has   */
    /* been made while debugging / timing etc.                        */
    /*                                                                */
    /* We dont want to have this overhead in retail builds.           */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD);
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
#else /* FIREWALLS */
    /******************************************************************/
    /* Prevent compiler warnings in the retail builds.                */
    /******************************************************************/
    IgnoreParam(pdcArg);
    IgnoreParam(FunN);
#endif /* FIREWALLS */

    /******************************************************************/
    /* we don't handle this function ourselves, so we return FALSE    */
    /* which forces the engine to simulate it.                        */
    /******************************************************************/
    return(FALSE);
}
