/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDLSHRT                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function handler   */
/*                     PolyShortLine                                  */
/*                                                                    */
/*   Function        = Draws a set of shortlines. A shortline is a    */
/*                     discrete representation of a curve             */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_DDICOMFLAGS
#include <eddinclt.h>

#include <edddtypt.h>
#include <eddbextf.h>
#include <eddgextf.h>
#include <eddlextf.h>
#include <eddmextf.h>
#ifdef DCAF                                                               //DCAF
#include <dcafextf.h>                                                     //DCAF
#endif                                                                    //DCAF

#include <eddmcone.h>
#include <eddhcone.h>
#include <eddhtype.h>
#include <eddhmacr.h>

#include <eddfcone.h>
#include <eddftype.h>

#include <cursor.h>
#include <hwaccess.h>

#ifdef VRAMPTR
#include <eddncach.h>
#endif /* VRAMPTR */

#ifdef _8514
#include <8514.h>
#endif

/**********************************************************************/
/* For performance code                                               */
/**********************************************************************/
extern BYTE             WinToXway[];
extern SHORTLINESPB     AIxfer;
extern ShortLinesSP     SPad;
#ifndef   _8514
extern MMReg            ShadowXGARegs;
extern pMMReg           pXGARegs;
extern pMMReg           pRealXGARegs;
extern pMMReg           pXGARegsA;
extern pMMReg           pXGARegsB;
extern pMMReg           pXGARegsC;
#else
extern MM8514Reg        Shadow8514Regs;
extern pMM8514Reg       p8514Regs;
extern pMM8514Reg       pXGARegsA;
extern pMM8514Reg       pXGARegsB;
extern pMM8514Reg       pXGARegsC;
#endif
extern SHORT            softDrawInUse;
extern BYTE             LinePatStep;
extern CURSORDATA       cursor_data;

extern SHORT                    softDrawInUse;
extern ULONG                    LinePatternCur;
extern ULONG                    LinePatternPhys;
extern ULONG                    LinePatternSys;
extern ULONG                    MarkerCur;
extern ULONG                    MarkerPhys;
extern ULONG                    MarkerSys;
extern ULONG                    pCurCacheBasePhy;
extern ULONG                    pSysCacheStartPhy;
extern drawFunctionsTable       softDrawTable;
extern drawFunctionsTable       hardDrawTable;
extern SHORT                    foregroundSession;

extern pDrawFunctionsTable      pDrawFunctions;

/**********************************************************************/
/* default pixel op is                                                */
/*      bg source - bg color                                          */
/*      fg source - fg color                                          */
/*      step      - draw and step write                               */
/*      src       - map A (src is ignored)                            */
/*      dest      - map A                                             */
/*      pattern   - fore (sometimes changed by .asm if pattern)       */
/*      mask      - disabled                                          */
/*      drawing   - draw last pel null                                */
/*      octant    - 0                                                 */
/**********************************************************************/
#define POLYSHORTLINE_DEFAULT 0x04118020L

/**********************************************************************/
/* PolyShortLine will draw shortlines taken from a linked list of line*/
/* definitions. The first parameter is a pointer to a linked list of  */
/* shortline definitions. Each shortline has a startpoint, x0,y0, and */
/* an end point, x1,y1. For each y1-y0+1 rows of the shortline there  */
/* is exactly one x value, contained in an array specified in the     */
/* shortline definition.                                              */
/*                                                                    */
/* Note: Each shortline has already been completely clipped by the    */
/* engine and is in screen coordinates.                               */
/**********************************************************************/

DSPENTRY eddl_PolyShortLine(HDC         hdc,
                            PSHORTLINE  ArgpShortLines,
                            PDC         pdcArg,
                            ULONG       FunN)
{
#define TFUNC "eddl_PolyShortLine"
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    ULONG               Result;       /* Return value                */
    USHORT              i;            /* loop counter                */
    USHORT              j;            /* loop counter                */
    DevRect             CoordRect;    /* rectangle to pass to bounds */
    PSHORTLINE          CorrShortLines; /* saved initial pointer to s/l*/
    SHORT               YDirection;     /* Y Direction of shortline    */
    SHORT               XDirection;     /* X Direction of shortline    */
    USHORT              Numsteps;       /* number of steps in line     */
    SHORT               CurrX;          /* X position in shortline     */
    SHORT               CurrY;          /* Y position in shortline     */
    PUSHORT             Steps;          /* pointer to input steps      */
#ifdef DCAF                                                               //DCAF
    RECTL               rclDCAF;                                          //DCAF
#endif                                                                    //DCAF


    /******************************************************************/
    /* We do not need exclusive access as a LockDevice call will      */
    /* always be made before a PolyShortLine call.  BUT we do it just */
    /* in case (because we have been loosing semaphor protection in   */
    /* stress tests and this is one of the potential holes).          */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD);

    /******************************************************************/
    /* Apply the DC command mask to the command bits                  */
    /******************************************************************/
    COMMANDBITS(FunN) &= pdc->DCICommandMask;

    /******************************************************************/
    /* Reset bit 0 of the style high word, to indicate figure not     */
    /* starting                                                       */
    /******************************************************************/
/*  pdc->StyleNumber &= 0xFFFEFFFF; */

    /******************************************************************/
    /* Is there a currently selected bitmap..                         */
    /******************************************************************/
    if ((pdc->DCIBitmapType == BITMAP_NOT_SELECTED) &&
        (FunNTest(COM_DRAW)))
    {
        /**************************************************************/
        /* No bitmap selected AND COM_DRAW is set so log and return   */
        /* an error                                                  */
        /**************************************************************/
        LOGERR(TFUNC, "no selected bitmap", FNULL, 0,
                                              PMERR_NO_BITMAP_SELECTED);
        goto POLYSHORTLINE_ERR_EXIT;
    }

    if (FunNTest(COM_CORRELATE))
    {
        /**************************************************************/
        /* Store shortline pointer for use in correlation             */
        /**************************************************************/
        CorrShortLines = ArgpShortLines;

        /**************************************************************/
        /* Will be doing correlation so get the correlation rectangles*/
        /* up to date                                                 */
        /**************************************************************/
        if (pdc->DCICorrInvalid)
        {
            if (! eddg_ClipPickWindow())
            {
                goto POLYSHORTLINE_ERR_EXIT;
            }
        }
    }

    /******************************************************************/
    /* If draw bit is set then set up the AI                          */
    /******************************************************************/
    if (FunNTest(COM_DRAW))
    {

        /**************************************************************/
        /* Now it is time to set the drawing mode correctly..         */
        /**************************************************************/
        if (pdc->DCIBitmapType == BITMAP_IS_SCREEN)
        {
            SetDrawModeHard;
        }
        else
        {
            SetDrawModeSoft;
        }

        /**************************************************************/
        /* Set the pixel op to the default value.                     */
        /**************************************************************/
        AIxfer.ulPixelOp = POLYSHORTLINE_DEFAULT;

        /**************************************************************/
        /* if cursor is software then updates must be disabled before */
        /* using the hardware. If the dc is direct we also need to    */
        /* test for exclusion. This has to be done in a way which     */
        /* minimises the impact on the 'normal' (mono cursor) case.   */
        /* We are about to set the mixes in the h/w so must disable   */
        /* cursor updates but do not yet have the bounds so cannot    */
        /* do exclusion. This means we cannot disable updates via the */
        /* exclusion function as would normally be done (without      */
        /* restructuring to the detriment of the normal case).        */
        /* Therefore, just disable the cursor now and do the          */
        /* exclusion as the bounds become available.                  */
        /**************************************************************/
        if ( cursor_data.cursor_status & CURSOR_SOFTWARE )
        {
            disable_cursor();
        }

        /**************************************************************/
        /* Set the AI to the approprate state for colour              */
        /**************************************************************/
#ifndef _8514
        ShadowXGARegs.FgCol = (USHORT)pdc->DCILineColatts.ForeColor;
#ifdef LINESBG
        ShadowXGARegs.BgCol = (USHORT)pdc->DCILineColatts.BackColor;
#endif /* LINESBG */

        /**************************************************************/
        /* Set the AI to the approprate state for mixes               */
        /**************************************************************/
        ShadowXGARegs.FgMix =
                   (BYTE)WinToXway[pdc->DCICurLinAts.lbnd.usMixMode];
#ifdef LINESBG
        ShadowXGARegs.BgMix =
               (BYTE)WinToXway[pdc->DCICurLinAts.lbnd.usBackMixMode];
#else /* LINESBG */
        ShadowXGARegs.BgMix = HWMIX_DEST;
#endif /* LINESBG */

#else /* _8514 */

        #ifndef   BPP24
        Shadow8514Regs.Color_1 = (USHORT)pdc->DCILineColatts.ForeColor;
        #else
        Shadow8514Regs.Color_1 = pdc->DCILineColatts.ForeColor;
        #endif
#ifdef LINESBG
        #ifndef   BPP24
        Shadow8514Regs.Color_0 = (USHORT)pdc->DCILineColatts.BackColor;
        #else
        Shadow8514Regs.Color_0 = pdc->DCILineColatts.BackColor;
        #endif
#endif /* LINESBG */

        /**************************************************************/
        /* Set the AI to the approprate state for mixes               */
        /**************************************************************/
        Shadow8514Regs.Function_1.Mix =
                   (BYTE)WinToXway[pdc->DCICurLinAts.lbnd.usMixMode];
#ifdef LINESBG
        Shadow8514Regs.Function_0.Mix =
               (BYTE)WinToXway[pdc->DCICurLinAts.lbnd.usBackMixMode];
#else /* LINESBG */
        Shadow8514Regs.Function_0.Mix = HWMIX_DEST;
#endif /* LINESBG */

#endif

        /**************************************************************/
        /* Set up pattern information                                 */
        /**************************************************************/
        AIxfer.usPatType = pdc->DCICurLinAts.lbnd.usType;
    }

    /******************************************************************/
    /* Traverse the linked list of shortline definitions              */
    /******************************************************************/
    for(;
        ArgpShortLines != FNULL;
        ArgpShortLines = (PSHORTLINE)ArgpShortLines->slh.pslhNext)
    {
        /**************************************************************/
        /* If bounds determination required then accumulate bounds.   */
        /* Convert the coords passed as parameter.                    */
        /* ShortLine coordinates are in screen coordinates and the    */
        /* bounds are accumulated in device coordinates so adjust     */
        /* the coordinates for the DC origin before accumulating the  */
        /* bounds.                                                    */
        /**************************************************************/
        if ( (FunNTest(COM_BOUND | COM_ALT_BOUND)) ||
#ifdef DCAF                                                               //DCAF
             DCAFBoundsRequired(FunN) ||                                  //DCAF
#endif                                                                    //DCAF
             (cursor_data.cursor_status & CURSOR_SOFTWARE ) )
        {
            CoordRect[0].X = (USHORT)ArgpShortLines->slh.lxLeft -
                                                   pdc->DCIOrigin.X;
            CoordRect[1].X = (USHORT)ArgpShortLines->slh.lxRight -
                                                   pdc->DCIOrigin.X;

            /**********************************************************/
            /* Allow for shortlines going up or down..                */
            /**********************************************************/
            if ((SHORT)(ArgpShortLines->slh.ptlStart.y) <
                                (SHORT)(ArgpShortLines->slh.ptlStop.y))
            {
                CoordRect[0].Y = (USHORT)ArgpShortLines->slh.ptlStart.y -
                                                   pdc->DCIOrigin.Y;
                CoordRect[1].Y = (USHORT)ArgpShortLines->slh.ptlStop.y -
                                                   pdc->DCIOrigin.Y;
            }
            else
            {
                CoordRect[0].Y = (USHORT)ArgpShortLines->slh.ptlStop.y -
                                                   pdc->DCIOrigin.Y;
                CoordRect[1].Y = (USHORT)ArgpShortLines->slh.ptlStart.y -
                                                   pdc->DCIOrigin.Y;
            }

            if (FunNTest(COM_BOUND | COM_ALT_BOUND))
            {
                eddg_AddBounds ((pDevRect)CoordRect,
                                FunN,
                                COORD_DEVICE_WORD);
            }
#ifdef DCAF                                                               //DCAF
            /**********************************************************/  //DCAF
            /* Accumulate DCAF screen bounds if required              */  //DCAF
            /**********************************************************/  //DCAF
            if (DCAFBoundsRequired(FunN))                                 //DCAF
            {                                                             //DCAF
                /******************************************************/  //DCAF
                /* We know shortlines are pre-clipped, so pass them   */  //DCAF
                /* directly into the DCAF bounds accumulation         */  //DCAF
                /* routine.                                           */  //DCAF
                /* This routine requires coords in a 32-bit exclusive */  //DCAF
                /* RECTL.                                             */  //DCAF
                /******************************************************/  //DCAF
                rclDCAF.xLeft = CoordRect[0].X + pdc->DCIOrigin.X;        //DCAF
                rclDCAF.xRight = CoordRect[1].X + pdc->DCIOrigin.X + 1;   //DCAF
                rclDCAF.yBottom = CoordRect[0].Y + pdc->DCIOrigin.Y;      //DCAF
                rclDCAF.yTop = CoordRect[1].Y + pdc->DCIOrigin.Y + 1;     //DCAF
                                                                          //DCAF
                AccumulateScreenBounds(&rclDCAF);                         //DCAF
            }                                                             //DCAF
#endif                                                                    //DCAF
        }

        /**************************************************************/
        /* If draw bit is set                                         */
        /**************************************************************/
        if (FunNTest(COM_DRAW))
        {
            /**********************************************************/
            /* Set up parameters for PMSHORTL                         */
            /**********************************************************/
            AIxfer.usXStart = (USHORT)ArgpShortLines->slh.ptlStart.x;
            AIxfer.usYStart = pdc->DCISelListEntry->Info.HWHeight -
                                (USHORT)ArgpShortLines->slh.ptlStart.y;
            AIxfer.usYStop = pdc->DCISelListEntry->Info.HWHeight -
                                 (USHORT)ArgpShortLines->slh.ptlStop.y;
            AIxfer.pSteps = ArgpShortLines->ax;

            /**********************************************************/
            /* Set the line pattern count using the value in the      */
            /* shortline structure.                                   */
            /**********************************************************/
            AIxfer.usPatPos =
                (USHORT)((ArgpShortLines->slh.ulStyle & 0x7FF) /
                         (ULONG)LinePatStep);

            /**********************************************************/
            /* Wind the line pattern count back by 1 to compensate    */
            /* for the hardware output routine                        */
            /**********************************************************/
            AIxfer.usPatPos = (USHORT)(((ULONG)AIxfer.usPatPos - 1) & 0x0F);

            /**********************************************************/
            /* if a software cursor is active we must check if the    */
            /* cursor needs excluding (updates already disabled)      */
            /**********************************************************/
#ifndef   _8514
            if ( cursor_data.cursor_status & CURSOR_SOFTWARE )
            {
                if ( eddm_ExcludeCursor(CoordRect, COORD_DEVICE_WORD) )
                {
                    /**************************************************/
                    /* cursor was excluded: this entailed using the   */
                    /* h\w to remove the cursor so now we need to     */
                    /* wait for the h/w to finish and then set up the */
                    /* colour and mixes again (if no exclusion was    */
                    /* done then these values are set once only       */
                    /* outside the loop)                              */
                    /**************************************************/
                    ShadowXGARegs.FgCol = (USHORT)pdc->DCILineColatts.ForeColor;
                    ShadowXGARegs.FgMix = WinToXway[
                                  pdc->DCICurLinAts.lbnd.usMixMode];
#ifdef LINESBG
                    ShadowXGARegs.BgCol = (USHORT)pdc->DCILineColatts.BackColor;
                    ShadowXGARegs.BgMix = WinToXway[
                               pdc->DCICurLinAts.lbnd.usBackMixMode];
#else /* LINESBG */
                    ShadowXGARegs.BgMix = HWMIX_DEST;
#endif /* LINESBG */
                }

            }
            /**********************************************************/
            /* Set the colour compare register to its default value   */
            /**********************************************************/
            ShadowXGARegs.ColCompCond = COLCOMP_ALWAYS;

            /**********************************************************/
            /* Set up the hardware to access the destination          */
            /**********************************************************/
            if (softDrawInUse)
            {
                ShadowXGARegs.PixMapBaseA =
                           (ULONG) pdc->DCISelListEntry->Bitmap;
            }
            else
            {
                ShadowXGARegs.PixMapBaseA =
                                   pdc->DCISelListEntry->BMPhys;
            }
            ShadowXGARegs.PixMapWidthA =
                             pdc->DCISelListEntry->Info.HWWidth;
            ShadowXGARegs.PixMapHeightA =
                            pdc->DCISelListEntry->Info.HWHeight;
            ShadowXGARegs.PixMapFormatA =
                      (BYTE)pdc->DCISelListEntry->Info.HWFormat;

#else    // 8514
            if ( cursor_data.cursor_status & CURSOR_SOFTWARE )
            {
                if ( eddm_ExcludeCursor(CoordRect, COORD_DEVICE_WORD) )
                {
                    /**************************************************/
                    /* cursor was excluded: this entailed using the   */
                    /* h\w to remove the cursor so now we need to     */
                    /* wait for the h/w to finish and then set up the */
                    /* colour and mixes again (if no exclusion was    */
                    /* done then these values are set once only       */
                    /* outside the loop)                              */
                    /**************************************************/
                    #ifndef   BPP24
                    Shadow8514Regs.Color_1 = (USHORT)pdc->DCILineColatts.ForeColor;
                    #else
                    Shadow8514Regs.Color_1 = pdc->DCILineColatts.ForeColor;
                    #endif
                    Shadow8514Regs.Function_1.Mix = WinToXway[
                                  pdc->DCICurLinAts.lbnd.usMixMode];
                    Shadow8514Regs.Function_1.SrcSelect = FUNC_2OP_COL1;
#ifdef LINESBG
                    #ifndef BPP24
                    Shadow8514Regs.Color_0 = (USHORT)pdc->DCILineColatts.BackColor;
                    #else
                    Shadow8514Regs.Color_0 = pdc->DCILineColatts.BackColor;
                    #endif
                    Shadow8514Regs.Function_0.Mix = WinToXway[
                               pdc->DCICurLinAts.lbnd.usBackMixMode];
                    Shadow8514Regs.Function_0.SrcSelect = FUNC_2OP_COL0;
#else /* LINESBG */
                    Shadow8514Regs.Function_0.Mix = FUNC_D;
                    Shadow8514Regs.Function_0.SrcSelect = FUNC_2OP_COL0;
#endif /* LINESBG */
                }

            }
            /**********************************************************/
            /* Set the colour compare register to its default value   */
            /**********************************************************/
            Shadow8514Regs.Mode.UnderPaint = MD_UP_FALSE;

            /**********************************************************/
            /* Set up the hardware to access the destination          */
            /**********************************************************/
            if (softDrawInUse)
            {
                Shadow8514Regs.PixMapBaseA =
                           (ULONG) pdc->DCISelListEntry->Bitmap;
            }
            else
            {
                Shadow8514Regs.PixMapBaseA =
                                   pdc->DCISelListEntry->BMPhys;
            }
            Shadow8514Regs.PixMapWidthA =
                             pdc->DCISelListEntry->Info.HWWidth;
            Shadow8514Regs.PixMapHeightA =
                            pdc->DCISelListEntry->Info.HWHeight;
            Shadow8514Regs.PixMapFormatA =
                      (BYTE)pdc->DCISelListEntry->Info.HWFormat;
#endif   // 8514
            /**********************************************************/
            /* Transfer the values we have set in the shadow          */
            /* registers to the real hw registers if needed.          */
            /**********************************************************/
            TransferShadowRegisters( TSR_COLOUR_MIX | TSR_MAP_A );

            /**********************************************************/
            /* Do the lines for a single bitmap                       */
            /**********************************************************/
            (*(*pDrawFunctions)[index_PMSHORTLINES])();

            /**********************************************************/
            /* Update line pattern count                              */
            /**********************************************************/
            pdc->DCILinePatCnt = AIxfer.usPatEnd;


        } /* COM_DRAW set */

    } /* for each shortline */

    /******************************************************************/
    /* exclusion is done once per shortline (to minimise impact on    */
    /* mono cursor performance) but we can only reenable updates      */
    /* once all shortlines are output since the mixes are set in the  */
    /* hardware only once per PolyShortLine call.                     */
    /******************************************************************/
    reenable_cursor();

#ifdef VRAMPTR
    /******************************************************************/
    /* If the target bitmap is cached then evict it since it has      */
    /* been drawn to.                                                 */
    /******************************************************************/
    if ( BITMAP_IS_CACHED(pdc->DCISelListEntry) )
    {
      evict_cached_bitmap(pdc->DCISelListEntry->bm_cache_slot);
    }
#endif /* VRAMPTR */

    /******************************************************************/
    /* Set Result to OK. If a correlation hit occurs then this will   */
    /* be changed to OK_CORR.                                         */
    /******************************************************************/
    Result = OK;

    /******************************************************************/
    /* If the COM_CORRELATE bit is set and the number or correlation  */
    /* rectangles is non-zero then correlate on the markers.          */
    /******************************************************************/
    if (FunNTest(COM_CORRELATE) && (pdc->DCICorrNum))
    {
        /**************************************************************/
        /* Traverse the linked list of shortline definitions          */
        /**************************************************************/
        for(;
            CorrShortLines != FNULL;
            CorrShortLines = (PSHORTLINE)CorrShortLines->slh.pslhNext)
        {
            /**********************************************************/
            /* Get bounding rectangle and correlate against it. No    */
            /* need to worry about well-ordered rects here.           */
            /* The coordinates are in screen coordinates so flip them */
            /* to hardware coordinates which is what we correlate     */
            /* on.                                                    */
            /**********************************************************/
            CoordRect[0].X = (USHORT)CorrShortLines->slh.lxLeft;
            CoordRect[1].X = (USHORT)CorrShortLines->slh.lxRight;
            CoordRect[0].Y = pdc->DCISelListEntry->Info.Height -
                                (USHORT)1 -
                                (USHORT)CorrShortLines->slh.ptlStart.y;
            CoordRect[1].Y = pdc->DCISelListEntry->Info.Height -
                                (USHORT)1 -
                                (USHORT)CorrShortLines->slh.ptlStop.y;

            /**********************************************************/
            /* Only do further correlation checks if there is a       */
            /* correlation. Although the last point is not drawn still*/
            /* correlate because it is easier than correcting for it. */
            /* At the moment result is OK indicating no hit.          */
            /**********************************************************/
            if (eddg_CheckRectCorrelation((pDevRect)CoordRect)
                                                             == OK_CORR)
            {
                /******************************************************/
                /* Set up y increment in hardware space. Assumes start*/
                /* and stop positions screen coordinates (ie the y    */
                /* coordinates go in the other direction from hardware*/
                /* coordinates.                                       */
                /******************************************************/
                if ((SHORT)(CorrShortLines->slh.ptlStart.y) <
                    (SHORT)(CorrShortLines->slh.ptlStop.y))
                {
                    YDirection = -1;
                }
                else
                {
                    YDirection = 1;
                }

                /******************************************************/
                /* Set up x increment.                                */
                /******************************************************/
                if ((SHORT)(CorrShortLines->slh.ptlStart.x) <
                    (SHORT)(CorrShortLines->slh.ptlStop.x))
                {
                    XDirection = 1;
                }
                else
                {
                    XDirection = -1;
                }

                /******************************************************/
                /* Set up the number of steps.                        */
                /******************************************************/
                Numsteps = abs((SHORT)(CorrShortLines->slh.ptlStart.y) -
                               (SHORT)(CorrShortLines->slh.ptlStop.y));

                /******************************************************/
                /* Set up the initial position in hardware coords     */
                /******************************************************/
                Steps = (PUSHORT)CorrShortLines->ax;
                CurrX = (SHORT)CorrShortLines->ax[0];
                CurrY = (SHORT)pdc->DCISelListEntry->Info.Height -
                        (SHORT)1 -
                        (SHORT)CorrShortLines->slh.ptlStart.y;

                /******************************************************/
                /* correlate aginst each step                         */
                /******************************************************/
                for (i = 1; i < Numsteps; i++)
                {
                    /**************************************************/
                    /* Step is in fact a point                        */
                    /**************************************************/
                    if (CurrX == Steps[i])
                    {
                        for (j = 0; j < pdc->DCICorrNum; j ++)
                        {
                            if ((pdc->DCICorrRects[j][0].X <=
                                                               CurrX) &&
                                (pdc->DCICorrRects[j][1].X >=
                                                               CurrX) &&
                                (pdc->DCICorrRects[j][0].Y <=
                                                               CurrY) &&
                                (pdc->DCICorrRects[j][1].Y >=
                                                                 CurrY))
                            {
                                Result = OK_CORR;
                                goto POLYSHORTLINE_OK_EXIT;
                            }
                        }
                    }

                    /**************************************************/
                    /* Step is a horizontal line with a length > 1    */
                    /* Treat this as a rectangle.                     */
                    /**************************************************/
                    else
                    {
                        CoordRect[0].X = CurrX;
                        CoordRect[0].Y = CurrY;
                        CoordRect[1].X = Steps[i] - XDirection;
                        CoordRect[1].Y = CurrY;
                        if (eddg_CheckRectCorrelation(
                                  (pDevRect)CoordRect) == OK_CORR)
                        {
                            Result = OK_CORR;
                            goto POLYSHORTLINE_OK_EXIT;
                        }
                    }

                    /**************************************************/
                    /* Mov to next x and y position                   */
                    /**************************************************/
                    CurrY = CurrY + YDirection;
                    CurrX = Steps[i];
                }
            }
        }
    }

POLYSHORTLINE_OK_EXIT:
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
    return(Result);


POLYSHORTLINE_ERR_EXIT:
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
    return(ERROR_ZERO);
}
#undef TFUNC
